(*************************************************************************)
(*                                                                       *)
(*                       FastGEO Graphical Interface                     *)
(*                         Release Version 0.0.1                         *)
(*                                                                       *)
(* Author: Arash Partow 1997-2004                                        *)
(* Copyright notice:                                                     *)
(*                                                                       *)
(* Free use of the FastGEO Ordered Polygon is permitted under the        *)
(* guidelines and in accordance with the most current version of the     *)
(* Common Public License.                                                *)
(* http://www.opensource.org/licenses/cpl.php                            *)
(*                                                                       *)
(* Description:                                                          *)
(* This is a simple interface into the Delphi graphical interface for    *)
(* FastGEO base objects and primitives.                                  *)
(*************************************************************************)

Unit FastGEOGraphics;

Interface

Uses Graphics,FastGEO;

Type TFastGEOGraphics = Class
      Private
       Canvas : TCanvas;

      Public
       Constructor Create(Can:TCanvas);

       Procedure DrawPoint(x,y:Double);                      OverLoad;
       Procedure DrawPoint(Pnt:TPoint2D);                    OverLoad;

       Procedure DrawLine(x1,y1,x2,y2:Double);               OverLoad;
       Procedure DrawLine(Pnt1,Pnt2:TPoint2D);               OverLoad;
       Procedure DrawLine(Ln:TLine2D);                       OverLoad;

       Procedure DrawSegment(x1,y1,x2,y2:Double);            OverLoad;
       Procedure DrawSegment(Pnt1,Pnt2:TPoint2D);            OverLoad;
       Procedure DrawSegment(Seg:TSegment2D);                OverLoad;

       Procedure DrawTriangle(x1,y1,x2,y2,x3,y3:Double);     OverLoad;
       Procedure DrawTriangle(Pnt1,Pnt2,Pnt3:TPoint2D);      OverLoad;
       Procedure DrawTriangle(Ln1,Ln2,Ln3:TLine2D);          OverLoad;
       Procedure DrawTriangle(Tri:TTriangle2D);              OverLoad;

       Procedure DrawRectangle(x1,y1,x2,y2:Double);          OverLoad;
       Procedure DrawRectangle(Pnt1,Pnt2:TPoint2D);          OverLoad;
       Procedure DrawRectangle(Rec:TRectangle);              OverLoad;

       Procedure DrawQuadix(x1,y1,x2,y2,x3,y3,x4,y4:Double); OverLoad;
       Procedure DrawQuadix(Pnt1,Pnt2,Pnt3,Pnt4:TPoint2D);   OverLoad;
       Procedure DrawQuadix(Quad:TQuadix2D);                 OverLoad;

       Procedure DrawCircle(x,y,radius:Double);              OverLoad;
       Procedure DrawCircle(Pnt:TPoint2D;radius:Double);     OverLoad;
       Procedure DrawCircle(Cir:TCircle);                    OverLoad;

       Procedure DrawPolygon(Point:Array Of TPoint2D);       OverLoad;
       Procedure DrawPolygon(Polygon:TPolygon2D);            OverLoad;

End;

Implementation

Constructor TFastGEOGraphics.Create(Can:TCanvas);
Begin
 Canvas := Can;
End;
(* End Of Create *)

Procedure TFastGEOGraphics.DrawPoint(x,y:Double);
Begin
 Canvas.MoveTo(Round(x),Round(y));
 Canvas.LineTo(Round(x),Round(y));
End;
(* End Of DrawPoint *)


Procedure TFastGEOGraphics.DrawPoint(Pnt:TPoint2D);
Begin
 DrawPoint(Pnt.x,Pnt.y);
End;
(* End Of DrawPoint *)


Procedure TFastGEOGraphics.DrawLine(x1,y1,x2,y2:Double);
Begin
 Canvas.MoveTo(Round(x1),Round(y1));
 Canvas.LineTo(Round(x2),Round(y2));
End;
(* End Of DrawLine *)


Procedure TFastGEOGraphics.DrawLine(Pnt1,Pnt2:TPoint2D);
Begin
 DrawLine(Pnt1.x,Pnt1.y,Pnt2.x,Pnt2.y);
End;
(* End Of DrawLine *)


Procedure TFastGEOGraphics.DrawLine(Ln:TLine2D);
Begin
 DrawLine(Ln[1],Ln[2]);
End;
(* End Of DrawLine *)


Procedure TFastGEOGraphics.DrawSegment(x1,y1,x2,y2:Double);
Begin
 DrawLine(x1,y1,x2,y2);
End;
(* End Of DrawSegment *)


Procedure TFastGEOGraphics.DrawSegment(Pnt1,Pnt2:TPoint2D);
Begin
 DrawLine(Pnt1,Pnt2);
End;
(* End Of Draw Segment *)


Procedure TFastGEOGraphics.DrawSegment(Seg:TSegment2D);
Begin
 DrawLine(Seg[1],Seg[2]);
End;
(* End Of Draw Segment *)


Procedure TFastGEOGraphics.DrawTriangle(x1,y1,x2,y2,x3,y3:Double);
Begin
 DrawLine(x1,y1,x2,y2);
 DrawLine(x1,y1,x3,y3);
 DrawLine(x2,y2,x3,y3);
End;
(* End Of Draw Triangle *)


Procedure TFastGEOGraphics.DrawTriangle(Pnt1,Pnt2,Pnt3:TPoint2D);
Begin
 DrawLine(Pnt1,Pnt2);
 DrawLine(Pnt1,Pnt3);
 DrawLine(Pnt2,Pnt3);
End;
(* End Of Draw Triangle *)


Procedure TFastGEOGraphics.DrawTriangle(Ln1,Ln2,Ln3:TLine2D);
Begin
 DrawLine(Ln1);
 DrawLine(Ln2);
 DrawLine(Ln3);
End;
(* End Of Draw Triangle *)

Procedure TFastGEOGraphics.DrawTriangle(Tri:TTriangle2D);
Begin
 DrawLine(Tri[1],Tri[2]);
 DrawLine(Tri[2],Tri[3]);
 DrawLine(Tri[3],Tri[1]);
End;
(* End Of Draw Triangle *)

Procedure TFastGEOGraphics.DrawRectangle(x1,y1,x2,y2:Double);
Begin
 DrawLine(x1,y1,x2,y1);
 DrawLine(x2,y1,x2,y2);
 DrawLine(x2,y2,x1,y2);
 DrawLine(x1,y2,x1,y1);
End;
(* End Of Draw Rectangle *)


Procedure TFastGEOGraphics.DrawRectangle(Pnt1,Pnt2:TPoint2D);
Begin
 DrawRectangle(Pnt1.x,Pnt1.y,Pnt2.x,Pnt2.y);
End;
(* End Of Draw Rectangle *)


Procedure TFastGEOGraphics.DrawRectangle(Rec:TRectangle);
Begin
 DrawRectangle(Rec[1],Rec[2]);
End;
(* End Of Draw Rectangle *)


Procedure TFastGEOGraphics.DrawQuadix(x1,y1,x2,y2,x3,y3,x4,y4:Double);
Begin
 DrawLine(x1,y1,x2,y2);
 DrawLine(x2,y2,x3,y3);
 DrawLine(x3,y3,x4,y4);
 DrawLine(x4,y4,x1,y1);
End;
(* End Of Draw Quadix *)


Procedure TFastGEOGraphics.DrawQuadix(Pnt1,Pnt2,Pnt3,Pnt4:TPoint2D);
Begin
 DrawLine(Pnt1,Pnt2);
 DrawLine(Pnt2,Pnt3);
 DrawLine(Pnt3,Pnt4);
 DrawLine(Pnt4,Pnt1);
End;
(* End Of Draw Quadix *)


Procedure TFastGEOGraphics.DrawQuadix(Quad:TQuadix2D);
Begin
 DrawQuadix(Quad[1],Quad[2],Quad[3],Quad[4]);
End;
(* End Of Draw Quadix *)


Procedure TFastGEOGraphics.DrawCircle(x,y,Radius:Double);
Begin
 Canvas.Ellipse(Round(x-Radius),Round(y-Radius),Round(x+Radius),Round(y+Radius));
End;
(* End Of Draw Circle *)


Procedure TFastGEOGraphics.DrawCircle(Pnt:TPoint2D;Radius:Double);
Begin
 Canvas.Ellipse(Round(Pnt.x-Radius),Round(Pnt.y-Radius),Round(Pnt.x+Radius),Round(Pnt.y+Radius));
End;
(* End Of Draw Circle *)


Procedure TFastGEOGraphics.DrawCircle(Cir:TCircle);
Begin
 DrawCircle(Cir.x,Cir.y,Cir.Radius);
End;
(* End Of Draw Circle *)


Procedure TFastGEOGraphics.DrawPolygon(Point:Array Of TPoint2D);
Var I:Integer;
    Len:Integer;
Begin
 Len := Length(Point);
 For I:= 0 To Len Do
  DrawLine(Point[I],Point[(I+1) Mod Len]);
End;
(* End Of Draw Polygon *)

Procedure TFastGEOGraphics.DrawPolygon(Polygon:TPolygon2D);
Var I:Integer;
    Len:Integer;
Begin
 Len := Length(Polygon);
 For I:= 0 To Len Do
  DrawLine(Polygon[I],Polygon[(I+1) Mod Len]);
End;
(* End Of Draw Polygon *)

End.
