(*************************************************************************)
(*                                                                       *)
(*                        FastGEO Convex Hull Unit                       *)
(*                         Release Version 0.0.1                         *)
(*                                                                       *)
(* Author: Arash Partow 1997-2004                                        *)
(* Copyright notice:                                                     *)
(*                                                                       *)
(* Free use of the FastGEO Convex Hull is permitted under the guidelines *)
(* and in accordance with the most current version of the Common Public  *)
(* License.                                                              *)
(* http://www.opensource.org/licenses/cpl.php                            *)
(*                                                                       *)
(* Description:                                                          *)
(* This is an implementation of the Graham-scan convex hull algorithm    *)
(* using FastGEO as the base for geometric primitives.                   *)
(*************************************************************************)

unit ConvexHullUnit;

interface

Uses FastGEO;

Type TCHullPoint2D = Record
                      x   : Double;
                      y   : Double;
                      ang : Double;
                     End;


Type TConvexHull2D = Class

     private

      Point   : Array Of TCHUllPoint2D;

      Stack   : Array Of TCHUllPoint2D;
      HeadPos : Integer;


     public
      Function ConvexHull(Var Pnt: Array Of TPoint2D):Integer;

     private

      Procedure Swap(I,J:LongInt);
      Procedure RQSort(Left,Right:LongInt);
      Function  Partition(Left,Right:LongInt):LongInt;

      Procedure Push(Pnt: TCHullPoint2D);
      Function  Pop:TCHullPoint2D;
      Function  Head:TCHullPoint2D;
      Function  PreHead:TCHullPoint2D;
      Function  CHOrientation(P1,P2,P3:TCHUllPoint2D):Double;

End;


implementation

Function TConvexHull2D.ConvexHull(Var Pnt: Array Of TPoint2D):Integer;
Var LargestX  : Double;
    Len       : LongInt;
    I         : Integer;
Begin
 HeadPos := -1;
 Point   := Nil;
 Stack   := Nil;

 Len := Length(Pnt);

 Setlength(Stack,Len);
 SetLength(Point,Len);

 LargestX := 0;

 For I:=  0 to Len-1 Do
  Begin
   Point[I].x   := Pnt[I].x;
   Point[I].y   := Pnt[I].y;
   Point[I].Ang := 0.0;
   If Point[I].y < Point[0].y Then Swap(0,I);
   If Point[I].x > LargestX   Then LargestX := Point[i].x;
  End;


 For I:=  1 to Len-1 Do Point[I].Ang := VertexAngle(LargestX,Point[0].y,Point[0].x,Point[0].y,Point[i].x,Point[i].y);

 Point[0].Ang := 0;

 RQSort(1,Len-1);

 Push(Point[0]);
 Push(Point[1]);

 I := 2;
 While i < Len Do
  Begin
   If CHOrientation(PreHead,Head,Point[i]) = LeftHand  Then
    Begin
     Push(Point[i]);
     Inc(i);
    End
    Else
     Pop;
  End;

 For I:=  0 to HeadPos Do
  Begin
   Pnt[I].x := Stack[I].x;
   Pnt[I].y := Stack[I].y;
  End;

 Result := HeadPos+1;
End;



Procedure TConvexHull2D.Push(Pnt: TCHullPoint2D);
Begin
 Inc(HeadPos);
 Stack[HeadPos] := Pnt;
End;


Function TConvexHull2D.Pop:TCHullPoint2D;
Begin
 If HeadPos < 0 then Exit;
 Result := Stack[HeadPos];
 Dec(HeadPos);
End;


Function TConvexHull2D.Head:TCHullPoint2D;
Begin
 Result := Stack[HeadPos];
End;

Function TConvexHull2D.PreHead:TCHullPoint2D;
Begin
 Result := Stack[HeadPos-1];
End;

Function TConvexHull2D.CHOrientation(P1,P2,P3:TCHUllPoint2D):Double;
Begin
 Result := Orientation(P1.x,P1.y,P2.x,P2.y,P3.x,P3.y);
End;

Procedure TConvexHull2D.Swap(I,J:LongInt);
Var Temp: TCHUllPoint2D;
Begin
 Temp     := Point[I];
 Point[I] := Point[J];
 Point[J] := Temp;
End;


(* Quick sorts main block *)
Procedure TConvexHull2D.RQSort(Left,Right:LongInt);
Var I:Integer;
Begin
 (* ends have crossed over pivot *)
 If Right <= Left Then Exit;

 (* paritition array *)
 i := Partition(Left,Right);

 (*
    apply quick-sort to both left
    and right sides of pivoting
 *)

 RQSort(Left,i-1);
 RQSort(i+1,Right);
End;


(* paritition method for quick-sort *)
Function TConvexHull2D.Partition(Left,Right:LongInt):LongInt;
Var
 I,J,Middle:Integer;
 Pivot     :TCHUllPoint2D;
Begin
 i      := Left;
 j      := Right;
 Middle := (Left+Right) Div 2;

 { Median of 3 Pivot Selection }
 If Point[Middle].Ang < Point[Left].Ang   Then Swap(Left, Middle);
 If Point[Right].Ang  < Point[Middle].Ang Then Swap(Right,Middle);
 If Point[Middle].Ang < Point[Left].Ang   Then Swap(Left, Middle);

 Pivot.Ang := Point[Right].Ang;

 Repeat

  While (Pivot.Ang >= Point[i].Ang) And (i < Right) Do Inc(i);
  While  Pivot.Ang <= Point[j].Ang Do
   Begin
    Dec(j);
    If J-1 < 0 then Break;
   End;
  If i < j Then  Swap(i, j);

 Until i >= j;

 Swap(i,Right);
 Result:=i;
End;

end.
