(*************************************************************************)
(*                                                                       *)
(*                          FastGEO Convex Hull                          *)
(*                         Release Version 0.0.1                         *)
(*                                                                       *)
(* Author: Arash Partow 1997-2004                                        *)
(* Copyright notice:                                                     *)
(*                                                                       *)
(* Free use of the FastGEO Convex Hull is permitted under the guidelines *)
(* and in accordance with the most current version of the Common Public  *)
(* License.                                                              *)
(* http://www.opensource.org/licenses/cpl.php                            *)
(*                                                                       *)
(* Description:                                                          *)
(* This is an implementation of the Graham-scan convex hull algorithm    *)
(* using FastGEO as the base for geometric primitives.                   *)
(*************************************************************************)

unit ConvexHullFrm;

interface

uses
  Windows, Messages, SysUtils, Variants,
  Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  FastGEO, FastGEOGraphics, ConvexHullUnit;


type
  TConvexHullForm = Class(TForm)
    Splitter1       : TSplitter;
    StatusBar1      : TStatusBar;
    Panel1          : TPanel;
    Panel2          : TPanel;
    GenRandPntsBtn  : TButton;
    DisplayCHullBtn : TButton;
    Surface         : TPaintBox;
    ComboBox1       : TComboBox;
    Procedure GenRandPntsBtnClick(Sender: TObject);
    Procedure DisplayCHullBtnClick(Sender: TObject);
    Procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
   Procedure DrawPoints;


  end;


Var
 ConvexHullForm  : TConvexHullForm;
 MAX_POINTS      : LongInt;
 PointsGenerated : Boolean;
 Point           : Array Of TPoint2D;
 TempPoint           : Array Of TPoint2D;

Implementation

{$R *.dfm}

Procedure TConvexHullForm.DrawPoints;
Var I   : Integer;
    FGr : TFastGeoGraphics;
Begin
 Surface.Canvas.Brush.Style := bsSolid;
 Surface.Canvas.Brush.Color := clWhite;
 Surface.Canvas.FillRect(Rect(0,0,Surface.Width,Surface.Height));
 Surface.Canvas.Brush.Color := clBlack;
 Surface.Canvas.Pen.Color   := clRed;
 Surface.Canvas.Pen.Width   := 8;
 FGr := TFastGeoGraphics.Create(Surface.Canvas);
 For I:= 0 To MAX_POINTS-1 Do
  Begin
   FGr.DrawPoint(Point[I]);
  End;
End;


Procedure TConvexHullForm.GenRandPntsBtnClick(Sender: TObject);
Begin
 Point := Nil;
 SetLength(Point,MAX_POINTS);
 GenerateRandomPoints(10,10,Surface.Width-10,Surface.Height-10,Point);
 DrawPoints;
 PointsGenerated := True;
End;


Procedure TConvexHullForm.DisplayCHullBtnClick(Sender: TObject);
Var CHull     : TConvexHull2D;
    Len       : LongInt;
    FGr       : TFastGeoGraphics;
    I         : Integer;
Begin
 If Not PointsGenerated Then Exit;

 SetLength(TempPoint,MAX_POINTS);
 For I:= 0 To MAX_POINTS-1 Do TempPoint[i] := Point[i];

 CHull := TConvexHull2D.Create;
 Len   := CHull.ConvexHull(TempPoint);
 FGr   := TFastGeoGraphics.Create(Surface.Canvas);
 Surface.Canvas.Pen.Width := 5;
 For I:= 0 To Len-1 Do
  Begin
   FGr.DrawLine(TempPoint[I], TempPoint[(I+1) Mod Len]);
  End;
 Finalize(TempPoint);
End;


Procedure TConvexHullForm.ComboBox1Change(Sender: TObject);
Begin
 MAX_POINTS := StrToInt(ComboBox1.Items[ComboBox1.ItemIndex]);
 GenRandPntsBtnClick(Sender);
End;


 Initialization
  MAX_POINTS      := 50;
  PointsGenerated := False;

End.
