                                                                        {         09.12.00
E:\Source\Comps\TestDhCheckFolder1.pas

The program do test the component DhCheckFolder11.                                       }



unit TestDhCheckFolder1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DhCheckFolder11, CommCtrl, Menus, ShellApi, StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Men1: TMenuItem;
    mnuCreateList: TMenuItem;
    mnuCancel: TMenuItem;
    StatusBar1: TStatusBar;
    mnuSaveCheckes: TMenuItem;
    mnuLoadCheckesFromDisk: TMenuItem;
    N1: TMenuItem;
    Tools1: TMenuItem;
    Reset1: TMenuItem;
    mnuShowDirectory: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure mnuCreateListClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure mnuSaveCheckesClick(Sender: TObject);
    procedure mnuLoadCheckesFromDiskClick(Sender: TObject);
    procedure Reset1Click(Sender: TObject);
    procedure mnuShowDirectoryClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    DhCheckFolder1 : TDhCheckFolder;
    ListBox1 : tListBox;
    procedure CreateComponent;
    procedure CreateListBox;
    procedure DhCheckFolder1ChangeFolder ( path : string );
  end;

var
  Form1: TForm1;


implementation

{$R *.DFM}


const
  BACKUP_FILE = 'BackupSet.dat';
var
  DriveList : tStringList;



procedure TForm1.mnuSaveCheckesClick(Sender: TObject);
begin
  DhCheckFolder1.SaveCheckedFolder ( BACKUP_FILE )
end;


procedure TForm1.mnuLoadCheckesFromDiskClick(Sender: TObject);
var
  count : integer;
begin
  ListBox1.items.clear;
  if not FileExists ( GetCurrentDir + '\' + BACKUP_FILE ) then
   exit;
  DhCheckFolder1.LoadCheckedFolder ( BACKUP_FILE );
  count := DhCheckFolder1.CountCheckedFolder;
  //ListBox1.items.LoadFromFile ( BACKUP_FILE );
  StatusBar1.panels.items[1].text := ' Checked Folder(recursiv) = ' + IntToStr ( count );
end;


procedure TForm1.mnuCreateListClick(Sender: TObject);
var
  list : tStringList;
  summe : integer;

begin
  ListBox1.items.clear;
  ListBox1.refresh;
  screen.cursor := crHourGlass;
  list := DhCheckFolder1.ListCheckedFolder;
  list.sort;
  ListBox1.items.AddStrings ( list );
  screen.cursor := crDefault;
  summe := ListBox1.items.count;
  StatusBar1.panels.items[1].text := ' SUM = ' + IntToStr ( summe );
end;


procedure tForm1.DhCheckFolder1ChangeFolder ( path : string );
Begin
  StatusBar1.panels.items[0].text := ' ' + path;
End;


procedure TForm1.FormCreate(Sender: TObject);
Begin
  CreateComponent;
  CreateListBox;
  DriveList := tStringList.create;
End;


procedure TForm1.FormDestroy(Sender: TObject);
begin
  DriveList.free;
end;


procedure tForm1.CreateComponent;
Begin
  DhCheckFolder1 := TDhCheckFolder.create ( self );
  with DhCheckFolder1 do
   begin
    parent := self;
    top := 15;
    left := 10;
    width := form1.width div 2;
    height := form1.height - 90;
    //CheckBoxes := false;
    //SetInitialDir ( 'C:\Windows' );
   end;
   DhCheckFolder1.OnChangeFolder := DhCheckFolder1ChangeFolder;
End;


procedure tForm1.CreateListBox;
Begin
  ListBox1 := tListBox.create ( self );
  with ListBox1 do
   begin
    parent := self;
    top := 15;
    left := DhCheckFolder1.width  + 20;
    width := round ( form1.width / 2.2 );
    height := form1.height - 90;
   end;
End;


procedure TForm1.Reset1Click(Sender: TObject);
begin
  DhCheckFolder1.ClearAllChecks;
  StatusBar1.panels.items[1].text := ' ';
end;


procedure TForm1.mnuShowDirectoryClick(Sender: TObject);
begin
  //DhCheckFolder1.SetInitialDir ('\\server\C' );
  DhCheckFolder1.SetInitialDir ('C:\Windows' );
end;


END.
