{$INCLUDE cHeader.inc}
unit cDataStructs;

{                                                                              }
{           Implementations of the base classes in cType v0.09 (L0)            }
{                                                                              }
{        This unit is copyright  2000 by David Butler (david@e.co.za)         }
{                                                                              }
{                  This unit is part of Delphi Fundamentals.                   }
{                 It's original file name is cDataStructs.pas                  }
{                      It was generated 5 Jul 2000 02:10.                      }
{                                                                              }
{                I invite you to use this unit, free of charge.                }
{        I invite you to distibute this unit, but it must be for free.         }
{             I also invite you to contribute to its development,              }
{             but do not distribute a modified copy of this file.              }
{       Send modifications, suggestions and bug reports to david@e.co.za       }
{                                                                              }
{                                                                              }
{ Revision history:                                                            }
{   2000/02/08  v0.01  Initial version. AArray, TArray and TStreamArray.       }
{   2000/04/01  v0.02  Moved ASet from cMaths.                                 }
{                      Added Find methods to ASet.                             }
{                      Changed TFlatSet implementation to store to AArray      }
{                      instead of in memory only (TBits).                      }
{   2000/06/03  v0.03  Added AArray, AIntegerArray, AExtendedArray,            }
{                      AStringArray and ABitArray (formerly ASet) with some    }
{                      implementations.                                        }
{   2000/06/06  v0.04  TFlatBitArray implementation.                           }
{                      Added AInt64Array.                                      }
{   2000/06/07  v0.05  Moved base classes to cType.                            }
{                      Added TVarSizeAllocator.                                }
{   2000/06/08  v0.06  Added TObjectArray.                                     }
{   2000/06/09  v0.07  Added Stack implementations.                            }
{   2000/06/14  v0.08  Converted to template.                                  }
{                      Added linked list stored in memory.                     }
{                      Templ: 418 lines interface. 1278 lines implementation.  }
{                      Src: 1470 lines interface. 3763 lines implementation.   }
{   2000/06/16  v0.09  Added dictionaries stored in AArrays.                   }
{                      Added queues stored in Linked lists.                    }
{                      Templ: 509 lines interface. 1449 lines implementation.  }
{                      Src: 1892 lines interface. 4754 lines implementation.   }
{                                                                              }

interface

uses
  // Delphi units
  Classes,
  SysUtils,

  // Delphi Fundamentals (L0)
  cUtils,
  cStreams,
  cTypes;



{                                                                              }
{ TIntegerArray                                                                }
{   TIntegerArray stores the values in memory using a dynamic array.           }
{                                                                              }
type
  TIntegerArray = class (AIntegerArray)
    protected
    FData : IntegerArray;

    Procedure SetItem (const Idx : Integer; const Value : Integer); override;
    Function  GetItem (const Idx : Integer) : Integer; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRange (const LoIdx, HiIdx : Integer) : IntegerArray; override;
    Procedure SetRange (const LoIdx, HiIdx : Integer; const V : IntegerArray); override;

    public
    Constructor Create (const V : IntegerArray = nil);
    class Function CreateInstance : AType; override;
    Function  DuplicateRange (const LoIdx, HiIdx : Integer) : AArray; override;
    Procedure Assign (const V : AType); reintroduce; overload; override;
    Procedure Assign (const V : IntegerArray); reintroduce; overload;
    Procedure Assign (const V : array of Integer); reintroduce; overload;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TInt64Array                                                                  }
{   TInt64Array stores the values in memory using a dynamic array.             }
{                                                                              }
type
  TInt64Array = class (AInt64Array)
    protected
    FData : Int64Array;

    Procedure SetItem (const Idx : Integer; const Value : Int64); override;
    Function  GetItem (const Idx : Integer) : Int64; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRange (const LoIdx, HiIdx : Integer) : Int64Array; override;
    Procedure SetRange (const LoIdx, HiIdx : Integer; const V : Int64Array); override;

    public
    Constructor Create (const V : Int64Array = nil);
    class Function CreateInstance : AType; override;
    Function  DuplicateRange (const LoIdx, HiIdx : Integer) : AArray; override;
    Procedure Assign (const V : AType); reintroduce; overload; override;
    Procedure Assign (const V : Int64Array); reintroduce; overload;
    Procedure Assign (const V : array of Int64); reintroduce; overload;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TSingleArray                                                                 }
{   TSingleArray stores the values in memory using a dynamic array.            }
{                                                                              }
type
  TSingleArray = class (ASingleArray)
    protected
    FData : SingleArray;

    Procedure SetItem (const Idx : Integer; const Value : Single); override;
    Function  GetItem (const Idx : Integer) : Single; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRange (const LoIdx, HiIdx : Integer) : SingleArray; override;
    Procedure SetRange (const LoIdx, HiIdx : Integer; const V : SingleArray); override;

    public
    Constructor Create (const V : SingleArray = nil);
    class Function CreateInstance : AType; override;
    Function  DuplicateRange (const LoIdx, HiIdx : Integer) : AArray; override;
    Procedure Assign (const V : AType); reintroduce; overload; override;
    Procedure Assign (const V : SingleArray); reintroduce; overload;
    Procedure Assign (const V : array of Single); reintroduce; overload;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TDoubleArray                                                                 }
{   TDoubleArray stores the values in memory using a dynamic array.            }
{                                                                              }
type
  TDoubleArray = class (ADoubleArray)
    protected
    FData : DoubleArray;

    Procedure SetItem (const Idx : Integer; const Value : Double); override;
    Function  GetItem (const Idx : Integer) : Double; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRange (const LoIdx, HiIdx : Integer) : DoubleArray; override;
    Procedure SetRange (const LoIdx, HiIdx : Integer; const V : DoubleArray); override;

    public
    Constructor Create (const V : DoubleArray = nil);
    class Function CreateInstance : AType; override;
    Function  DuplicateRange (const LoIdx, HiIdx : Integer) : AArray; override;
    Procedure Assign (const V : AType); reintroduce; overload; override;
    Procedure Assign (const V : DoubleArray); reintroduce; overload;
    Procedure Assign (const V : array of Double); reintroduce; overload;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TExtendedArray                                                               }
{   TExtendedArray stores the values in memory using a dynamic array.          }
{                                                                              }
type
  TExtendedArray = class (AExtendedArray)
    protected
    FData : ExtendedArray;

    Procedure SetItem (const Idx : Integer; const Value : Extended); override;
    Function  GetItem (const Idx : Integer) : Extended; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRange (const LoIdx, HiIdx : Integer) : ExtendedArray; override;
    Procedure SetRange (const LoIdx, HiIdx : Integer; const V : ExtendedArray); override;

    public
    Constructor Create (const V : ExtendedArray = nil);
    class Function CreateInstance : AType; override;
    Function  DuplicateRange (const LoIdx, HiIdx : Integer) : AArray; override;
    Procedure Assign (const V : AType); reintroduce; overload; override;
    Procedure Assign (const V : ExtendedArray); reintroduce; overload;
    Procedure Assign (const V : array of Extended); reintroduce; overload;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TStringArray                                                                 }
{   TStringArray stores the values in memory using a dynamic array.            }
{                                                                              }
type
  TStringArray = class (AStringArray)
    protected
    FData : StringArray;

    Procedure SetItem (const Idx : Integer; const Value : String); override;
    Function  GetItem (const Idx : Integer) : String; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRange (const LoIdx, HiIdx : Integer) : StringArray; override;
    Procedure SetRange (const LoIdx, HiIdx : Integer; const V : StringArray); override;

    public
    Constructor Create (const V : StringArray = nil);
    class Function CreateInstance : AType; override;
    Function  DuplicateRange (const LoIdx, HiIdx : Integer) : AArray; override;
    Procedure Assign (const V : AType); reintroduce; overload; override;
    Procedure Assign (const V : StringArray); reintroduce; overload;
    Procedure Assign (const V : array of String); reintroduce; overload;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;




{                                                                              }
{ TFlatBitArray                                                                }
{   TFlatBitArray stores the array in memory as an array of Cardinals.         }
{   Pros: Fast allocation/deallocation, 1 bit of memory for each entry.        }
{   Cons: Bad memory usage if bits are sparsely distributed.                   }
{                                                                              }
type
  TFlatBitArray = class (ABitArray)
    protected
    FData  : CardinalArray;
    FCount : Integer;

    Function  GetBit (const Idx : Integer) : Boolean; override;
    Procedure SetBit (const Idx : Integer; const Value : Boolean); override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRangeAsCardinal (const Idx : Integer) : Cardinal; override;
    Procedure SetRangeAsCardinal (const Idx : Integer; const Value : Cardinal); override;

    public
    Procedure Fill (const LoIdx, HiIdx : Integer; const Value : Boolean); override;
    Function  CompareRange (const LoIdx, HiIdx : Integer; const Value : Boolean) : Boolean; override;
  end;



{                                                                              }
{ TVarSizeAllocator                                                            }
{   Allocates variables sized blocks in a stream.                              }
{                                                                              }
type
  EVarSizeAllocator = class (Exception);
  TVarSizeAllocator = class (AAllocator)
    protected
    FFreeList : AInt64Array;

    public
    { AAllocator implementations                                               }
    Function  BlockSize (const Offset : Int64) : Integer; override;
    Function  Get (const Size : Integer) : Int64; override;
    Procedure Release (const Offset : Int64); override;
    Procedure Resize (var Offset : Int64; const NewSize : Integer); override;
    Procedure Read (const Offset : Int64; var Buf); overload; override;
    Procedure Write (const Offset : Int64; const Buf); override;
    Procedure Pack; override;

    { TVarSizeAllocator interface                                              }
    Constructor Create (const Stream : TExStream);
    Constructor CreateEx (const Stream : TExStream; const FreeList : AInt64Array);
    Destructor Destroy; override;
    Function  ReadString (const Offset : Int64) : String;
    Procedure WriteString (const Offset : Int64; const S : String);
    Procedure RebuildFreeList;
  end;



{                                                                              }
{ TFixedSizeAllocator                                                          }
{                                                                              }
type
  TFixedSizeAllocator = class (AAllocator)
  end;



{                                                                              }
{ TIntegerStreamArray                                                          }
{   TIntegerStreamArray stores the values in a stream using a                  }
{   TIntegerArrayStreamer.                                                     }
{                                                                              }
type
  TIntegerStreamArray = class (AIntegerArray)
    protected
    FStreamer : TIntegerArrayStreamer;

    Procedure SetItem (const Idx : Integer; const Value : Integer); override;
    Function  GetItem (const Idx : Integer) : Integer; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream);
    Destructor Destroy; override;

    Function  Duplicate : AType; override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TInt64StreamArray                                                            }
{   TInt64StreamArray stores the values in a stream using a                    }
{   TInt64ArrayStreamer.                                                       }
{                                                                              }
type
  TInt64StreamArray = class (AInt64Array)
    protected
    FStreamer : TInt64ArrayStreamer;

    Procedure SetItem (const Idx : Integer; const Value : Int64); override;
    Function  GetItem (const Idx : Integer) : Int64; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream);
    Destructor Destroy; override;

    Function  Duplicate : AType; override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TSingleStreamArray                                                           }
{   TSingleStreamArray stores the values in a stream using a                   }
{   TSingleArrayStreamer.                                                      }
{                                                                              }
type
  TSingleStreamArray = class (ASingleArray)
    protected
    FStreamer : TSingleArrayStreamer;

    Procedure SetItem (const Idx : Integer; const Value : Single); override;
    Function  GetItem (const Idx : Integer) : Single; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream);
    Destructor Destroy; override;

    Function  Duplicate : AType; override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TDoubleStreamArray                                                           }
{   TDoubleStreamArray stores the values in a stream using a                   }
{   TDoubleArrayStreamer.                                                      }
{                                                                              }
type
  TDoubleStreamArray = class (ADoubleArray)
    protected
    FStreamer : TDoubleArrayStreamer;

    Procedure SetItem (const Idx : Integer; const Value : Double); override;
    Function  GetItem (const Idx : Integer) : Double; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream);
    Destructor Destroy; override;

    Function  Duplicate : AType; override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TExtendedStreamArray                                                         }
{   TExtendedStreamArray stores the values in a stream using a                 }
{   TExtendedArrayStreamer.                                                    }
{                                                                              }
type
  TExtendedStreamArray = class (AExtendedArray)
    protected
    FStreamer : TExtendedArrayStreamer;

    Procedure SetItem (const Idx : Integer; const Value : Extended); override;
    Function  GetItem (const Idx : Integer) : Extended; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream);
    Destructor Destroy; override;

    Function  Duplicate : AType; override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TShortStringStreamArray                                                      }
{   TShortStringStreamArray stores the values in a stream using a              }
{   TShortStringArrayStreamer.                                                 }
{                                                                              }
type
  TShortStringStreamArray = class (AStringArray)
    protected
    FStreamer : TShortStringArrayStreamer;

    Procedure SetItem (const Idx : Integer; const Value : String); override;
    Function  GetItem (const Idx : Integer) : String; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream; const StringLen : Byte);
    Destructor Destroy; override;

    Function  Duplicate : AType; override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;




{                                                                              }
{ TBitStreamArray                                                              }
{   TBitStreamArray stores an array of bits in a stream using a                }
{   TBitArrayStreamer.                                                         }
{                                                                              }
type
  TBitStreamArray = class (ABitArray)
    protected
    FStreamer : TBitArrayStreamer;

    Procedure SetBit (const Idx : Integer; const Value : Boolean); override;
    Function  GetBit (const Idx : Integer) : Boolean; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream);
    Destructor Destroy; override;

    Procedure Fill (const LoIdx, HiIdx : Integer; const Value : Boolean); override;
    Function  Duplicate : AType; override;
    Procedure Invert; override;
    Function  CompareRange (const LoIdx, HiIdx : Integer; const Value : Boolean) : Boolean; override;
    Function  Find (const Value : Boolean = False; const Start : Integer = 0;
              const FindForward : Boolean = True) : Integer; override;
    Function  FindRange (const Value : Boolean = False; const Start : Integer = 0;
              const Count : Integer = 1; const FindForward : Boolean = True) : Integer; override;
  end;



{                                                                              }
{ TLongStringStreamArray                                                       }
{   TLongStringStreamArray stores an array of long strings in a stream using   }
{   a TVarSizeAllocator.                                                       }
{   The default constructor store the indexes in memory.                       }
{   The constructor CreateFile uses TFileStream to store the data and indexes. }
{   The constructor CreateFileIndexesInMemory creates the data in a            }
{   TFileStream and the indexes in memory.                                     }
{                                                                              }
type
  TLongStringStreamArray = class (AStringArray)
    protected
    FStreamer : TVarSizeAllocator;
    FIndex    : AInt64Array;

    Procedure SetItem (const Idx : Integer; const Value : String); override;
    Function  GetItem (const Idx : Integer) : String; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;

    public
    Constructor Create (const Stream : TExStream);
    Constructor CreateEx (const Stream : TExStream; const IndexList : AInt64Array;
                const AllocatorFreeList : AInt64Array);
    Constructor CreateFile (const BaseFile : String; const FileMode : TFileStreamMode);
    Constructor CreateFileIndexesInMemory (const BaseFile : String; const FileMode : TFileStreamMode);
    Destructor Destroy; override;

    Function  Duplicate : AType; override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
  end;



{                                                                              }
{ TObjectArray                                                                 }
{                                                                              }
type
  TObjectArray = class (AObjectArray)
    protected
    FData : ObjectArray;

    Procedure SetItem (const Idx : Integer; const Value : TObject); override;
    Function  GetItem (const Idx : Integer) : TObject; override;
    Function  GetCount : Integer; override;
    Procedure SetCount (const NewCount : Integer); override;
    Function  GetRange (const LoIdx, HiIdx : Integer) : ObjectArray; override;
    Procedure SetRange (const LoIdx, HiIdx : Integer; const V : ObjectArray); override;

    public
    class Function CreateInstance : AType; override;
    Constructor Create (const V : ObjectArray = nil);
    Function  DuplicateRange (const LoIdx, HiIdx : Integer) : AArray; override;
    Procedure Assign (const V : AType); override;
    Procedure Delete (const Idx : Integer; const Count : Integer = 1); override;
    Procedure Insert (const Idx : Integer; const Count : Integer = 1); override;
    Procedure FreeItems;
  end;



{                                                                              }
{ TIntegerDictionary                                                           }
{   Implements AIntegerDictionary using AStringArray to store the keys and     }
{   AIntegerArray to store the values.                                         }
{                                                                              }
type
  TIntegerDictionary = class; // forward
  EIntegerDictionaryIterator = class (Exception);
  TIntegerDictionaryIterator = class (AIntegerDictionaryIterator)
    protected
    FDictionary : TIntegerDictionary;
    FIndex      : Integer;

    Procedure CurrentValid;

    { ADictionaryIterator implementations                                      }
    Function  GetKey : String; override;
    Procedure SetKey (const Key : String); override;

    { AIntegerDictionaryIterator implementations                              }
    Function  GetValue : Integer; override;
    Procedure SetValue (const Value : Integer); override;

    public
    Constructor Create (const Dictionary : TIntegerDictionary);

    { AIterator implementations                                                }
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Function  Duplicate : AIterator; override;
  end;
  EIntegerDictionary = class (Exception);
  TIntegerDictionary = class (AIntegerDictionary)
    protected
    FKeys        : AStringArray;
    FValues      : AIntegerArray;
    FCreateOnGet : Boolean;
    FCreateOnSet : Boolean;

    Function KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;

    { ADictionary implementations                                              }
    Function  GetCreateOnGet : Boolean; override;
    Procedure SetCreateOnGet (const CreateOnGet : Boolean); override;
    Function  GetCreateOnSet : Boolean; override;
    Procedure SetCreateOnSet (const CreateOnSet : Boolean); override;

    { AIntegerDictionary implementations                                    }
    Function  GetItem (const Key : String) : Integer; override;
    Procedure SetItem (const Key : String; const Value : Integer); override;

    public
    Constructor Create;
    Constructor CreateEx (const Keys : AStringArray; const Values : AIntegerArray);

    { ACollection implementations                                              }
    Function  Iterate : AIterator; override;

    { ADictionary implementations                                              }
    Procedure Delete (const Key : String); override;
    Function  HasKey (const Key : String) : Boolean; override;

    { AIntegerDictionary implementations                                    }
    Procedure Add (const Key : String; const Value : Integer); override;
  end;



{                                                                              }
{ TInt64Dictionary                                                             }
{   Implements AInt64Dictionary using AStringArray to store the keys and       }
{   AInt64Array to store the values.                                           }
{                                                                              }
type
  TInt64Dictionary = class; // forward
  EInt64DictionaryIterator = class (Exception);
  TInt64DictionaryIterator = class (AInt64DictionaryIterator)
    protected
    FDictionary : TInt64Dictionary;
    FIndex      : Integer;

    Procedure CurrentValid;

    { ADictionaryIterator implementations                                      }
    Function  GetKey : String; override;
    Procedure SetKey (const Key : String); override;

    { AInt64DictionaryIterator implementations                              }
    Function  GetValue : Int64; override;
    Procedure SetValue (const Value : Int64); override;

    public
    Constructor Create (const Dictionary : TInt64Dictionary);

    { AIterator implementations                                                }
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Function  Duplicate : AIterator; override;
  end;
  EInt64Dictionary = class (Exception);
  TInt64Dictionary = class (AInt64Dictionary)
    protected
    FKeys        : AStringArray;
    FValues      : AInt64Array;
    FCreateOnGet : Boolean;
    FCreateOnSet : Boolean;

    Function KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;

    { ADictionary implementations                                              }
    Function  GetCreateOnGet : Boolean; override;
    Procedure SetCreateOnGet (const CreateOnGet : Boolean); override;
    Function  GetCreateOnSet : Boolean; override;
    Procedure SetCreateOnSet (const CreateOnSet : Boolean); override;

    { AInt64Dictionary implementations                                    }
    Function  GetItem (const Key : String) : Int64; override;
    Procedure SetItem (const Key : String; const Value : Int64); override;

    public
    Constructor Create;
    Constructor CreateEx (const Keys : AStringArray; const Values : AInt64Array);

    { ACollection implementations                                              }
    Function  Iterate : AIterator; override;

    { ADictionary implementations                                              }
    Procedure Delete (const Key : String); override;
    Function  HasKey (const Key : String) : Boolean; override;

    { AInt64Dictionary implementations                                    }
    Procedure Add (const Key : String; const Value : Int64); override;
  end;



{                                                                              }
{ TSingleDictionary                                                            }
{   Implements ASingleDictionary using AStringArray to store the keys and      }
{   ASingleArray to store the values.                                          }
{                                                                              }
type
  TSingleDictionary = class; // forward
  ESingleDictionaryIterator = class (Exception);
  TSingleDictionaryIterator = class (ASingleDictionaryIterator)
    protected
    FDictionary : TSingleDictionary;
    FIndex      : Integer;

    Procedure CurrentValid;

    { ADictionaryIterator implementations                                      }
    Function  GetKey : String; override;
    Procedure SetKey (const Key : String); override;

    { ASingleDictionaryIterator implementations                              }
    Function  GetValue : Single; override;
    Procedure SetValue (const Value : Single); override;

    public
    Constructor Create (const Dictionary : TSingleDictionary);

    { AIterator implementations                                                }
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Function  Duplicate : AIterator; override;
  end;
  ESingleDictionary = class (Exception);
  TSingleDictionary = class (ASingleDictionary)
    protected
    FKeys        : AStringArray;
    FValues      : ASingleArray;
    FCreateOnGet : Boolean;
    FCreateOnSet : Boolean;

    Function KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;

    { ADictionary implementations                                              }
    Function  GetCreateOnGet : Boolean; override;
    Procedure SetCreateOnGet (const CreateOnGet : Boolean); override;
    Function  GetCreateOnSet : Boolean; override;
    Procedure SetCreateOnSet (const CreateOnSet : Boolean); override;

    { ASingleDictionary implementations                                    }
    Function  GetItem (const Key : String) : Single; override;
    Procedure SetItem (const Key : String; const Value : Single); override;

    public
    Constructor Create;
    Constructor CreateEx (const Keys : AStringArray; const Values : ASingleArray);

    { ACollection implementations                                              }
    Function  Iterate : AIterator; override;

    { ADictionary implementations                                              }
    Procedure Delete (const Key : String); override;
    Function  HasKey (const Key : String) : Boolean; override;

    { ASingleDictionary implementations                                    }
    Procedure Add (const Key : String; const Value : Single); override;
  end;



{                                                                              }
{ TDoubleDictionary                                                            }
{   Implements ADoubleDictionary using AStringArray to store the keys and      }
{   ADoubleArray to store the values.                                          }
{                                                                              }
type
  TDoubleDictionary = class; // forward
  EDoubleDictionaryIterator = class (Exception);
  TDoubleDictionaryIterator = class (ADoubleDictionaryIterator)
    protected
    FDictionary : TDoubleDictionary;
    FIndex      : Integer;

    Procedure CurrentValid;

    { ADictionaryIterator implementations                                      }
    Function  GetKey : String; override;
    Procedure SetKey (const Key : String); override;

    { ADoubleDictionaryIterator implementations                              }
    Function  GetValue : Double; override;
    Procedure SetValue (const Value : Double); override;

    public
    Constructor Create (const Dictionary : TDoubleDictionary);

    { AIterator implementations                                                }
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Function  Duplicate : AIterator; override;
  end;
  EDoubleDictionary = class (Exception);
  TDoubleDictionary = class (ADoubleDictionary)
    protected
    FKeys        : AStringArray;
    FValues      : ADoubleArray;
    FCreateOnGet : Boolean;
    FCreateOnSet : Boolean;

    Function KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;

    { ADictionary implementations                                              }
    Function  GetCreateOnGet : Boolean; override;
    Procedure SetCreateOnGet (const CreateOnGet : Boolean); override;
    Function  GetCreateOnSet : Boolean; override;
    Procedure SetCreateOnSet (const CreateOnSet : Boolean); override;

    { ADoubleDictionary implementations                                    }
    Function  GetItem (const Key : String) : Double; override;
    Procedure SetItem (const Key : String; const Value : Double); override;

    public
    Constructor Create;
    Constructor CreateEx (const Keys : AStringArray; const Values : ADoubleArray);

    { ACollection implementations                                              }
    Function  Iterate : AIterator; override;

    { ADictionary implementations                                              }
    Procedure Delete (const Key : String); override;
    Function  HasKey (const Key : String) : Boolean; override;

    { ADoubleDictionary implementations                                    }
    Procedure Add (const Key : String; const Value : Double); override;
  end;



{                                                                              }
{ TExtendedDictionary                                                          }
{   Implements AExtendedDictionary using AStringArray to store the keys and    }
{   AExtendedArray to store the values.                                        }
{                                                                              }
type
  TExtendedDictionary = class; // forward
  EExtendedDictionaryIterator = class (Exception);
  TExtendedDictionaryIterator = class (AExtendedDictionaryIterator)
    protected
    FDictionary : TExtendedDictionary;
    FIndex      : Integer;

    Procedure CurrentValid;

    { ADictionaryIterator implementations                                      }
    Function  GetKey : String; override;
    Procedure SetKey (const Key : String); override;

    { AExtendedDictionaryIterator implementations                              }
    Function  GetValue : Extended; override;
    Procedure SetValue (const Value : Extended); override;

    public
    Constructor Create (const Dictionary : TExtendedDictionary);

    { AIterator implementations                                                }
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Function  Duplicate : AIterator; override;
  end;
  EExtendedDictionary = class (Exception);
  TExtendedDictionary = class (AExtendedDictionary)
    protected
    FKeys        : AStringArray;
    FValues      : AExtendedArray;
    FCreateOnGet : Boolean;
    FCreateOnSet : Boolean;

    Function KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;

    { ADictionary implementations                                              }
    Function  GetCreateOnGet : Boolean; override;
    Procedure SetCreateOnGet (const CreateOnGet : Boolean); override;
    Function  GetCreateOnSet : Boolean; override;
    Procedure SetCreateOnSet (const CreateOnSet : Boolean); override;

    { AExtendedDictionary implementations                                    }
    Function  GetItem (const Key : String) : Extended; override;
    Procedure SetItem (const Key : String; const Value : Extended); override;

    public
    Constructor Create;
    Constructor CreateEx (const Keys : AStringArray; const Values : AExtendedArray);

    { ACollection implementations                                              }
    Function  Iterate : AIterator; override;

    { ADictionary implementations                                              }
    Procedure Delete (const Key : String); override;
    Function  HasKey (const Key : String) : Boolean; override;

    { AExtendedDictionary implementations                                    }
    Procedure Add (const Key : String; const Value : Extended); override;
  end;



{                                                                              }
{ TStringDictionary                                                            }
{   Implements AStringDictionary using AStringArray to store the keys and      }
{   AStringArray to store the values.                                          }
{                                                                              }
type
  TStringDictionary = class; // forward
  EStringDictionaryIterator = class (Exception);
  TStringDictionaryIterator = class (AStringDictionaryIterator)
    protected
    FDictionary : TStringDictionary;
    FIndex      : Integer;

    Procedure CurrentValid;

    { ADictionaryIterator implementations                                      }
    Function  GetKey : String; override;
    Procedure SetKey (const Key : String); override;

    { AStringDictionaryIterator implementations                              }
    Function  GetValue : String; override;
    Procedure SetValue (const Value : String); override;

    public
    Constructor Create (const Dictionary : TStringDictionary);

    { AIterator implementations                                                }
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Function  Duplicate : AIterator; override;
  end;
  EStringDictionary = class (Exception);
  TStringDictionary = class (AStringDictionary)
    protected
    FKeys        : AStringArray;
    FValues      : AStringArray;
    FCreateOnGet : Boolean;
    FCreateOnSet : Boolean;

    Function KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;

    { ADictionary implementations                                              }
    Function  GetCreateOnGet : Boolean; override;
    Procedure SetCreateOnGet (const CreateOnGet : Boolean); override;
    Function  GetCreateOnSet : Boolean; override;
    Procedure SetCreateOnSet (const CreateOnSet : Boolean); override;

    { AStringDictionary implementations                                    }
    Function  GetItem (const Key : String) : String; override;
    Procedure SetItem (const Key : String; const Value : String); override;

    public
    Constructor Create;
    Constructor CreateEx (const Keys : AStringArray; const Values : AStringArray);

    { ACollection implementations                                              }
    Function  Iterate : AIterator; override;

    { ADictionary implementations                                              }
    Procedure Delete (const Key : String); override;
    Function  HasKey (const Key : String) : Boolean; override;

    { AStringDictionary implementations                                    }
    Procedure Add (const Key : String; const Value : String); override;
  end;






{                                                                              }
{ TIntegerStack                                                                }
{   TIntegerStack implements a stack of Integers using AIntegerArray.          }
{                                                                              }
type
  TIntegerStack = class (AIntegerStack)
    protected
    FStore : AIntegerArray;

    Function  GetCount : Integer; override;
    Function  GetAsString : String; override;
    Procedure SetAsString (const S : String); override;

    public
    { AType implementations                                                    }
    class Function CreateInstance : AType; override;
    Function  Duplicate : AType; override;
    Procedure Assign (const V : AType); override;
    Function  IsEqual (const V : AType) : Boolean; override;
    Function  Compare (const V : AType) : TCompareResult; override;

    { AIntegerStack implementations                                            }
    Procedure Push (const V : Integer); override;
    Procedure Push (const V : IntegerArray); override;
    Function  Pop : Integer; override;
    Function  Pop (const N : Integer) : IntegerArray; override;

    { TIntegerStack interface                                                  }
    Constructor Create;
    Constructor CreateEx (const Store : AIntegerArray);
    Destructor Destroy; override;
  end;



{                                                                              }
{ TInt64Stack                                                                  }
{   TInt64Stack implements a stack of Int64s using AInt64Array.                }
{                                                                              }
type
  TInt64Stack = class (AInt64Stack)
    protected
    FStore : AInt64Array;

    Function  GetCount : Integer; override;
    Function  GetAsString : String; override;
    Procedure SetAsString (const S : String); override;

    public
    { AType implementations                                                    }
    class Function CreateInstance : AType; override;
    Function  Duplicate : AType; override;
    Procedure Assign (const V : AType); override;
    Function  IsEqual (const V : AType) : Boolean; override;
    Function  Compare (const V : AType) : TCompareResult; override;

    { AInt64Stack implementations                                            }
    Procedure Push (const V : Int64); override;
    Procedure Push (const V : Int64Array); override;
    Function  Pop : Int64; override;
    Function  Pop (const N : Integer) : Int64Array; override;

    { TInt64Stack interface                                                  }
    Constructor Create;
    Constructor CreateEx (const Store : AInt64Array);
    Destructor Destroy; override;
  end;



{                                                                              }
{ TSingleStack                                                                 }
{   TSingleStack implements a stack of Singles using ASingleArray.             }
{                                                                              }
type
  TSingleStack = class (ASingleStack)
    protected
    FStore : ASingleArray;

    Function  GetCount : Integer; override;
    Function  GetAsString : String; override;
    Procedure SetAsString (const S : String); override;

    public
    { AType implementations                                                    }
    class Function CreateInstance : AType; override;
    Function  Duplicate : AType; override;
    Procedure Assign (const V : AType); override;
    Function  IsEqual (const V : AType) : Boolean; override;
    Function  Compare (const V : AType) : TCompareResult; override;

    { ASingleStack implementations                                            }
    Procedure Push (const V : Single); override;
    Procedure Push (const V : SingleArray); override;
    Function  Pop : Single; override;
    Function  Pop (const N : Integer) : SingleArray; override;

    { TSingleStack interface                                                  }
    Constructor Create;
    Constructor CreateEx (const Store : ASingleArray);
    Destructor Destroy; override;
  end;



{                                                                              }
{ TDoubleStack                                                                 }
{   TDoubleStack implements a stack of Doubles using ADoubleArray.             }
{                                                                              }
type
  TDoubleStack = class (ADoubleStack)
    protected
    FStore : ADoubleArray;

    Function  GetCount : Integer; override;
    Function  GetAsString : String; override;
    Procedure SetAsString (const S : String); override;

    public
    { AType implementations                                                    }
    class Function CreateInstance : AType; override;
    Function  Duplicate : AType; override;
    Procedure Assign (const V : AType); override;
    Function  IsEqual (const V : AType) : Boolean; override;
    Function  Compare (const V : AType) : TCompareResult; override;

    { ADoubleStack implementations                                            }
    Procedure Push (const V : Double); override;
    Procedure Push (const V : DoubleArray); override;
    Function  Pop : Double; override;
    Function  Pop (const N : Integer) : DoubleArray; override;

    { TDoubleStack interface                                                  }
    Constructor Create;
    Constructor CreateEx (const Store : ADoubleArray);
    Destructor Destroy; override;
  end;



{                                                                              }
{ TExtendedStack                                                               }
{   TExtendedStack implements a stack of Extendeds using AExtendedArray.       }
{                                                                              }
type
  TExtendedStack = class (AExtendedStack)
    protected
    FStore : AExtendedArray;

    Function  GetCount : Integer; override;
    Function  GetAsString : String; override;
    Procedure SetAsString (const S : String); override;

    public
    { AType implementations                                                    }
    class Function CreateInstance : AType; override;
    Function  Duplicate : AType; override;
    Procedure Assign (const V : AType); override;
    Function  IsEqual (const V : AType) : Boolean; override;
    Function  Compare (const V : AType) : TCompareResult; override;

    { AExtendedStack implementations                                            }
    Procedure Push (const V : Extended); override;
    Procedure Push (const V : ExtendedArray); override;
    Function  Pop : Extended; override;
    Function  Pop (const N : Integer) : ExtendedArray; override;

    { TExtendedStack interface                                                  }
    Constructor Create;
    Constructor CreateEx (const Store : AExtendedArray);
    Destructor Destroy; override;
  end;



{                                                                              }
{ TStringStack                                                                 }
{   TStringStack implements a stack of Strings using AStringArray.             }
{                                                                              }
type
  TStringStack = class (AStringStack)
    protected
    FStore : AStringArray;

    Function  GetCount : Integer; override;
    Function  GetAsString : String; override;
    Procedure SetAsString (const S : String); override;

    public
    { AType implementations                                                    }
    class Function CreateInstance : AType; override;
    Function  Duplicate : AType; override;
    Procedure Assign (const V : AType); override;
    Function  IsEqual (const V : AType) : Boolean; override;
    Function  Compare (const V : AType) : TCompareResult; override;

    { AStringStack implementations                                            }
    Procedure Push (const V : String); override;
    Procedure Push (const V : StringArray); override;
    Function  Pop : String; override;
    Function  Pop (const N : Integer) : StringArray; override;

    { TStringStack interface                                                  }
    Constructor Create;
    Constructor CreateEx (const Store : AStringArray);
    Destructor Destroy; override;
  end;



{                                                                              }
{ TObjectStack                                                                 }
{   TObjectStack implements a stack of TObjects using AObjectArray.            }
{                                                                              }
type
  TObjectStack = class (AObjectStack)
    protected
    FStore : AObjectArray;

    Function  GetCount : Integer; override;
    Function  GetAsString : String; override;
    Procedure SetAsString (const S : String); override;

    public
    { AType implementations                                                    }
    class Function CreateInstance : AType; override;
    Function  Duplicate : AType; override;
    Procedure Assign (const V : AType); override;
    Function  IsEqual (const V : AType) : Boolean; override;
    Function  Compare (const V : AType) : TCompareResult; override;

    { AObjectStack implementations                                            }
    Procedure Push (const V : TObject); override;
    Procedure Push (const V : ObjectArray); override;
    Function  Pop : TObject; override;
    Function  Pop (const N : Integer) : ObjectArray; override;

    { TObjectStack interface                                                  }
    Constructor Create;
    Constructor CreateEx (const Store : AObjectArray);
    Destructor Destroy; override;
  end;






{                                                                              }
{ TLinkedIntegerList                                                           }
{                                                                              }
type
  ELinkedIntegerList = class (Exception);
  TLinkedIntegerList = class (ALinkedIntegerList)
    protected
    FFirst : PLinkedInteger;
    FLast  : PLinkedInteger;

    public
    // ALinkedList
    Function  First : ALinkedListIterator; override;
    Function  Last : ALinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ALinkedIntegerlist
    Procedure AddInFront (const Value : Integer); override;
    Procedure AddToBack (const Value : Integer); override;
    Procedure DeleteFirst; override;
    
    // TLinkedIntegerList
    Constructor Create;
    Constructor CreateEx (const First : PLinkedInteger);
    Destructor Destroy; override;
  end;
  ELinkedIntegerListIterator = class (Exception);
  TLinkedIntegerListIterator = class (ALinkedIntegerListIterator)
    protected
    FList    : TLinkedIntegerList;
    FCurrent : PLinkedInteger;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ALinkedIntegerListIterator
    Function  GetValue : Integer; override;
    Procedure SetValue (const Value : Integer); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Integer); override;
    Procedure InsertAfter (const Value : Integer); override;

    // TLinkedIntegerListIterator
    Constructor Create (const Current : PLinkedInteger; const List : TLinkedIntegerList);
  end;


{                                                                              }
{ TLinkedInt64List                                                             }
{                                                                              }
type
  ELinkedInt64List = class (Exception);
  TLinkedInt64List = class (ALinkedInt64List)
    protected
    FFirst : PLinkedInt64;
    FLast  : PLinkedInt64;

    public
    // ALinkedList
    Function  First : ALinkedListIterator; override;
    Function  Last : ALinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ALinkedInt64list
    Procedure AddInFront (const Value : Int64); override;
    Procedure AddToBack (const Value : Int64); override;
    Procedure DeleteFirst; override;
    
    // TLinkedInt64List
    Constructor Create;
    Constructor CreateEx (const First : PLinkedInt64);
    Destructor Destroy; override;
  end;
  ELinkedInt64ListIterator = class (Exception);
  TLinkedInt64ListIterator = class (ALinkedInt64ListIterator)
    protected
    FList    : TLinkedInt64List;
    FCurrent : PLinkedInt64;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ALinkedInt64ListIterator
    Function  GetValue : Int64; override;
    Procedure SetValue (const Value : Int64); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Int64); override;
    Procedure InsertAfter (const Value : Int64); override;

    // TLinkedInt64ListIterator
    Constructor Create (const Current : PLinkedInt64; const List : TLinkedInt64List);
  end;


{                                                                              }
{ TLinkedSingleList                                                            }
{                                                                              }
type
  ELinkedSingleList = class (Exception);
  TLinkedSingleList = class (ALinkedSingleList)
    protected
    FFirst : PLinkedSingle;
    FLast  : PLinkedSingle;

    public
    // ALinkedList
    Function  First : ALinkedListIterator; override;
    Function  Last : ALinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ALinkedSinglelist
    Procedure AddInFront (const Value : Single); override;
    Procedure AddToBack (const Value : Single); override;
    Procedure DeleteFirst; override;
    
    // TLinkedSingleList
    Constructor Create;
    Constructor CreateEx (const First : PLinkedSingle);
    Destructor Destroy; override;
  end;
  ELinkedSingleListIterator = class (Exception);
  TLinkedSingleListIterator = class (ALinkedSingleListIterator)
    protected
    FList    : TLinkedSingleList;
    FCurrent : PLinkedSingle;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ALinkedSingleListIterator
    Function  GetValue : Single; override;
    Procedure SetValue (const Value : Single); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Single); override;
    Procedure InsertAfter (const Value : Single); override;

    // TLinkedSingleListIterator
    Constructor Create (const Current : PLinkedSingle; const List : TLinkedSingleList);
  end;


{                                                                              }
{ TLinkedDoubleList                                                            }
{                                                                              }
type
  ELinkedDoubleList = class (Exception);
  TLinkedDoubleList = class (ALinkedDoubleList)
    protected
    FFirst : PLinkedDouble;
    FLast  : PLinkedDouble;

    public
    // ALinkedList
    Function  First : ALinkedListIterator; override;
    Function  Last : ALinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ALinkedDoublelist
    Procedure AddInFront (const Value : Double); override;
    Procedure AddToBack (const Value : Double); override;
    Procedure DeleteFirst; override;
    
    // TLinkedDoubleList
    Constructor Create;
    Constructor CreateEx (const First : PLinkedDouble);
    Destructor Destroy; override;
  end;
  ELinkedDoubleListIterator = class (Exception);
  TLinkedDoubleListIterator = class (ALinkedDoubleListIterator)
    protected
    FList    : TLinkedDoubleList;
    FCurrent : PLinkedDouble;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ALinkedDoubleListIterator
    Function  GetValue : Double; override;
    Procedure SetValue (const Value : Double); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Double); override;
    Procedure InsertAfter (const Value : Double); override;

    // TLinkedDoubleListIterator
    Constructor Create (const Current : PLinkedDouble; const List : TLinkedDoubleList);
  end;


{                                                                              }
{ TLinkedExtendedList                                                          }
{                                                                              }
type
  ELinkedExtendedList = class (Exception);
  TLinkedExtendedList = class (ALinkedExtendedList)
    protected
    FFirst : PLinkedExtended;
    FLast  : PLinkedExtended;

    public
    // ALinkedList
    Function  First : ALinkedListIterator; override;
    Function  Last : ALinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ALinkedExtendedlist
    Procedure AddInFront (const Value : Extended); override;
    Procedure AddToBack (const Value : Extended); override;
    Procedure DeleteFirst; override;
    
    // TLinkedExtendedList
    Constructor Create;
    Constructor CreateEx (const First : PLinkedExtended);
    Destructor Destroy; override;
  end;
  ELinkedExtendedListIterator = class (Exception);
  TLinkedExtendedListIterator = class (ALinkedExtendedListIterator)
    protected
    FList    : TLinkedExtendedList;
    FCurrent : PLinkedExtended;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ALinkedExtendedListIterator
    Function  GetValue : Extended; override;
    Procedure SetValue (const Value : Extended); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Extended); override;
    Procedure InsertAfter (const Value : Extended); override;

    // TLinkedExtendedListIterator
    Constructor Create (const Current : PLinkedExtended; const List : TLinkedExtendedList);
  end;


{                                                                              }
{ TLinkedStringList                                                            }
{                                                                              }
type
  ELinkedStringList = class (Exception);
  TLinkedStringList = class (ALinkedStringList)
    protected
    FFirst : PLinkedString;
    FLast  : PLinkedString;

    public
    // ALinkedList
    Function  First : ALinkedListIterator; override;
    Function  Last : ALinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ALinkedStringlist
    Procedure AddInFront (const Value : String); override;
    Procedure AddToBack (const Value : String); override;
    Procedure DeleteFirst; override;
    
    // TLinkedStringList
    Constructor Create;
    Constructor CreateEx (const First : PLinkedString);
    Destructor Destroy; override;
  end;
  ELinkedStringListIterator = class (Exception);
  TLinkedStringListIterator = class (ALinkedStringListIterator)
    protected
    FList    : TLinkedStringList;
    FCurrent : PLinkedString;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ALinkedStringListIterator
    Function  GetValue : String; override;
    Procedure SetValue (const Value : String); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : String); override;
    Procedure InsertAfter (const Value : String); override;

    // TLinkedStringListIterator
    Constructor Create (const Current : PLinkedString; const List : TLinkedStringList);
  end;


{                                                                              }
{ TDoublyLinkedIntegerList                                                     }
{                                                                              }
type
  EDoublyLinkedIntegerList = class (Exception);
  TDoublyLinkedIntegerList = class (ADoublyLinkedIntegerList)
    protected
    FFirst : PDoublyLinkedInteger;
    FLast  : PDoublyLinkedInteger;

    public
    // ALinkedList
    Function  First : ADoublyLinkedListIterator; override;
    Function  Last : ADoublyLinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ADoublyLinkedIntegerlist
    Procedure AddInFront (const Value : Integer); override;
    Procedure AddToBack (const Value : Integer); override;
    Procedure DeleteFirst; override;
    Procedure DeleteLast; override;
    
    // TDoublyLinkedIntegerList
    Constructor Create;
    Constructor CreateEx (const First : PDoublyLinkedInteger);
    Destructor Destroy; override;
  end;
  EDoublyLinkedIntegerListIterator = class (Exception);
  TDoublyLinkedIntegerListIterator = class (ADoublyLinkedIntegerListIterator)
    protected
    FList    : TDoublyLinkedIntegerList;
    FCurrent : PDoublyLinkedInteger;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ADoublyLinkedIntegerListIterator
    Function  GetValue : Integer; override;
    Procedure SetValue (const Value : Integer); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Integer); override;
    Procedure InsertAfter (const Value : Integer); override;

    // TDoublyLinkedIntegerListIterator
    Constructor Create (const Current : PDoublyLinkedInteger; const List : TDoublyLinkedIntegerList);
  end;


{                                                                              }
{ TDoublyLinkedInt64List                                                       }
{                                                                              }
type
  EDoublyLinkedInt64List = class (Exception);
  TDoublyLinkedInt64List = class (ADoublyLinkedInt64List)
    protected
    FFirst : PDoublyLinkedInt64;
    FLast  : PDoublyLinkedInt64;

    public
    // ALinkedList
    Function  First : ADoublyLinkedListIterator; override;
    Function  Last : ADoublyLinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ADoublyLinkedInt64list
    Procedure AddInFront (const Value : Int64); override;
    Procedure AddToBack (const Value : Int64); override;
    Procedure DeleteFirst; override;
    Procedure DeleteLast; override;
    
    // TDoublyLinkedInt64List
    Constructor Create;
    Constructor CreateEx (const First : PDoublyLinkedInt64);
    Destructor Destroy; override;
  end;
  EDoublyLinkedInt64ListIterator = class (Exception);
  TDoublyLinkedInt64ListIterator = class (ADoublyLinkedInt64ListIterator)
    protected
    FList    : TDoublyLinkedInt64List;
    FCurrent : PDoublyLinkedInt64;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ADoublyLinkedInt64ListIterator
    Function  GetValue : Int64; override;
    Procedure SetValue (const Value : Int64); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Int64); override;
    Procedure InsertAfter (const Value : Int64); override;

    // TDoublyLinkedInt64ListIterator
    Constructor Create (const Current : PDoublyLinkedInt64; const List : TDoublyLinkedInt64List);
  end;


{                                                                              }
{ TDoublyLinkedSingleList                                                      }
{                                                                              }
type
  EDoublyLinkedSingleList = class (Exception);
  TDoublyLinkedSingleList = class (ADoublyLinkedSingleList)
    protected
    FFirst : PDoublyLinkedSingle;
    FLast  : PDoublyLinkedSingle;

    public
    // ALinkedList
    Function  First : ADoublyLinkedListIterator; override;
    Function  Last : ADoublyLinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ADoublyLinkedSinglelist
    Procedure AddInFront (const Value : Single); override;
    Procedure AddToBack (const Value : Single); override;
    Procedure DeleteFirst; override;
    Procedure DeleteLast; override;
    
    // TDoublyLinkedSingleList
    Constructor Create;
    Constructor CreateEx (const First : PDoublyLinkedSingle);
    Destructor Destroy; override;
  end;
  EDoublyLinkedSingleListIterator = class (Exception);
  TDoublyLinkedSingleListIterator = class (ADoublyLinkedSingleListIterator)
    protected
    FList    : TDoublyLinkedSingleList;
    FCurrent : PDoublyLinkedSingle;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ADoublyLinkedSingleListIterator
    Function  GetValue : Single; override;
    Procedure SetValue (const Value : Single); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Single); override;
    Procedure InsertAfter (const Value : Single); override;

    // TDoublyLinkedSingleListIterator
    Constructor Create (const Current : PDoublyLinkedSingle; const List : TDoublyLinkedSingleList);
  end;


{                                                                              }
{ TDoublyLinkedDoubleList                                                      }
{                                                                              }
type
  EDoublyLinkedDoubleList = class (Exception);
  TDoublyLinkedDoubleList = class (ADoublyLinkedDoubleList)
    protected
    FFirst : PDoublyLinkedDouble;
    FLast  : PDoublyLinkedDouble;

    public
    // ALinkedList
    Function  First : ADoublyLinkedListIterator; override;
    Function  Last : ADoublyLinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ADoublyLinkedDoublelist
    Procedure AddInFront (const Value : Double); override;
    Procedure AddToBack (const Value : Double); override;
    Procedure DeleteFirst; override;
    Procedure DeleteLast; override;
    
    // TDoublyLinkedDoubleList
    Constructor Create;
    Constructor CreateEx (const First : PDoublyLinkedDouble);
    Destructor Destroy; override;
  end;
  EDoublyLinkedDoubleListIterator = class (Exception);
  TDoublyLinkedDoubleListIterator = class (ADoublyLinkedDoubleListIterator)
    protected
    FList    : TDoublyLinkedDoubleList;
    FCurrent : PDoublyLinkedDouble;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ADoublyLinkedDoubleListIterator
    Function  GetValue : Double; override;
    Procedure SetValue (const Value : Double); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Double); override;
    Procedure InsertAfter (const Value : Double); override;

    // TDoublyLinkedDoubleListIterator
    Constructor Create (const Current : PDoublyLinkedDouble; const List : TDoublyLinkedDoubleList);
  end;


{                                                                              }
{ TDoublyLinkedExtendedList                                                    }
{                                                                              }
type
  EDoublyLinkedExtendedList = class (Exception);
  TDoublyLinkedExtendedList = class (ADoublyLinkedExtendedList)
    protected
    FFirst : PDoublyLinkedExtended;
    FLast  : PDoublyLinkedExtended;

    public
    // ALinkedList
    Function  First : ADoublyLinkedListIterator; override;
    Function  Last : ADoublyLinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ADoublyLinkedExtendedlist
    Procedure AddInFront (const Value : Extended); override;
    Procedure AddToBack (const Value : Extended); override;
    Procedure DeleteFirst; override;
    Procedure DeleteLast; override;
    
    // TDoublyLinkedExtendedList
    Constructor Create;
    Constructor CreateEx (const First : PDoublyLinkedExtended);
    Destructor Destroy; override;
  end;
  EDoublyLinkedExtendedListIterator = class (Exception);
  TDoublyLinkedExtendedListIterator = class (ADoublyLinkedExtendedListIterator)
    protected
    FList    : TDoublyLinkedExtendedList;
    FCurrent : PDoublyLinkedExtended;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ADoublyLinkedExtendedListIterator
    Function  GetValue : Extended; override;
    Procedure SetValue (const Value : Extended); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : Extended); override;
    Procedure InsertAfter (const Value : Extended); override;

    // TDoublyLinkedExtendedListIterator
    Constructor Create (const Current : PDoublyLinkedExtended; const List : TDoublyLinkedExtendedList);
  end;


{                                                                              }
{ TDoublyLinkedStringList                                                      }
{                                                                              }
type
  EDoublyLinkedStringList = class (Exception);
  TDoublyLinkedStringList = class (ADoublyLinkedStringList)
    protected
    FFirst : PDoublyLinkedString;
    FLast  : PDoublyLinkedString;

    public
    // ALinkedList
    Function  First : ADoublyLinkedListIterator; override;
    Function  Last : ADoublyLinkedListIterator; override;
    Procedure AddInFront; override;
    Procedure AddToBack; override;

    // ADoublyLinkedStringlist
    Procedure AddInFront (const Value : String); override;
    Procedure AddToBack (const Value : String); override;
    Procedure DeleteFirst; override;
    Procedure DeleteLast; override;
    
    // TDoublyLinkedStringList
    Constructor Create;
    Constructor CreateEx (const First : PDoublyLinkedString);
    Destructor Destroy; override;
  end;
  EDoublyLinkedStringListIterator = class (Exception);
  TDoublyLinkedStringListIterator = class (ADoublyLinkedStringListIterator)
    protected
    FList    : TDoublyLinkedStringList;
    FCurrent : PDoublyLinkedString;
    FDeleted : Boolean;

    Procedure CurrentValid;

    // ADoublyLinkedStringListIterator
    Function  GetValue : String; override;
    Procedure SetValue (const Value : String); override;

    public
    // ALinkedlistIterator
    Procedure Next; override;
    Function  EOF : Boolean; override;
    Procedure Delete; override;
    Procedure InsertBefore; override;
    Procedure InsertAfter; override;

    Procedure InsertBefore (const Value : String); override;
    Procedure InsertAfter (const Value : String); override;

    // TDoublyLinkedStringListIterator
    Constructor Create (const Current : PDoublyLinkedString; const List : TDoublyLinkedStringList);
  end;




{                                                                              }
{ TIntegerQueue                                                                }
{   Implements a queue using a Linked list.                                    }
{                                                                              }
type
  TIntegerQueue = class (AIntegerQueue)
    FList : ALinkedIntegerList;

    Constructor Create;
    Constructor CreateEx (const List : ALinkedIntegerList);
    Procedure Add (const V : Integer); override;
    Function  Remove : Integer; override;
  end;


{                                                                              }
{ TInt64Queue                                                                  }
{   Implements a queue using a Linked list.                                    }
{                                                                              }
type
  TInt64Queue = class (AInt64Queue)
    FList : ALinkedInt64List;

    Constructor Create;
    Constructor CreateEx (const List : ALinkedInt64List);
    Procedure Add (const V : Int64); override;
    Function  Remove : Int64; override;
  end;


{                                                                              }
{ TSingleQueue                                                                 }
{   Implements a queue using a Linked list.                                    }
{                                                                              }
type
  TSingleQueue = class (ASingleQueue)
    FList : ALinkedSingleList;

    Constructor Create;
    Constructor CreateEx (const List : ALinkedSingleList);
    Procedure Add (const V : Single); override;
    Function  Remove : Single; override;
  end;


{                                                                              }
{ TDoubleQueue                                                                 }
{   Implements a queue using a Linked list.                                    }
{                                                                              }
type
  TDoubleQueue = class (ADoubleQueue)
    FList : ALinkedDoubleList;

    Constructor Create;
    Constructor CreateEx (const List : ALinkedDoubleList);
    Procedure Add (const V : Double); override;
    Function  Remove : Double; override;
  end;


{                                                                              }
{ TExtendedQueue                                                               }
{   Implements a queue using a Linked list.                                    }
{                                                                              }
type
  TExtendedQueue = class (AExtendedQueue)
    FList : ALinkedExtendedList;

    Constructor Create;
    Constructor CreateEx (const List : ALinkedExtendedList);
    Procedure Add (const V : Extended); override;
    Function  Remove : Extended; override;
  end;


{                                                                              }
{ TStringQueue                                                                 }
{   Implements a queue using a Linked list.                                    }
{                                                                              }
type
  TStringQueue = class (AStringQueue)
    FList : ALinkedStringList;

    Constructor Create;
    Constructor CreateEx (const List : ALinkedStringList);
    Procedure Add (const V : String); override;
    Function  Remove : String; override;
  end;





implementation

uses
  // Delphi units
  Math,

  // Delphi Fundamentals (L0)
  cStrings;



{ To-do: * The other bit array implementations (see after end.)                }



{                                                                              }
{ TVarSizeAllocator                                                            }
{   Implementation keeps a list of free blocks in an array.                    }
{   Array can be rebuilt from stream.                                          }
{   Blocks are merged on freeing/resizing.                                     }
{   Fillers are used for free pieces of memory < size of a block header.       }
{                                                                              }
type
  TVarSizeBlockHeader = packed record
    ID   : Byte;
    Size : Integer;
  end;

const
  VarSizeBlockHeaderSize = Sizeof (TVarSizeBlockHeader);

const
  id_Free      = $01;
  id_Allocated = $02;
  id_Filler    = $FF;

  id_ValidID    = [id_Free, id_Allocated, id_Filler];
  id_ValidBlock = [id_Free, id_Allocated];
  id_FreeID     = [id_Free, id_Filler];

Function GetVarSizeBlockHeader (const Stream : TExStream; const Offset : Integer;
         const ValidID : ByteSet = id_ValidBlock) : TVarSizeBlockHeader;
  Begin
    Stream.Position := Offset - VarSizeBlockHeaderSize;
    Stream.Read (Result, VarSizeBlockHeaderSize);
    if not (Result.ID in ValidID) then
      raise EVarSizeAllocator.Create ('Invalid block');
  End;

Procedure SetVarSizeBlockHeader (const Stream : TExStream; const Offset : Integer; const Hdr : TVarSizeBlockHeader);
  Begin
    Stream.Position := Offset - VarSizeBlockHeaderSize;
    Stream.Write (Hdr, VarSizeBlockHeaderSize);
  End;

Constructor TVarSizeAllocator.CreateEx (const Stream : TExStream; const FreeList : AInt64Array);
  Begin
    inherited Create (Stream);
    FFreeList := FreeList;
  End;

Constructor TVarSizeAllocator.Create (const Stream : TExStream);
  Begin
    inherited Create (Stream);
    FFreeList := TInt64Array.Create;
  End;

Destructor TVarSizeAllocator.Destroy;
  Begin
    FreeAndNil (FFreeList);
    inherited Destroy;
  End;

Function TVarSizeAllocator.BlockSize (const Offset : Int64) : Integer;
var Hdr : TVarSizeBlockHeader;
  Begin
    Hdr := GetVarSizeBlockHeader (FStream, Offset);
    Result := Hdr.Size;
  End;

Procedure ShrinkBlock (const Stream : TExStream; const Offset : Int64;
          var Hdr : TVarSizeBlockHeader; const NewSize : Integer;
          var NewBlock : Int64);
var NHdr : TVarSizeBlockHeader;
  Begin
    NHdr.Size := Hdr.Size - NewSize - VarSizeBlockHeaderSize;
    if NHdr.Size < 0 then
      begin
        Stream.Position := Offset + NewSize;
        Stream.Write (Dup (Char (id_Filler), -NHdr.Size));
        NewBlock := -1;
      end else
      begin
        NHdr.ID := id_Free;
        NewBlock := Offset + NewSize + VarSizeBlockHeaderSize;
        SetVarSizeBlockHeader (Stream, NewBlock, NHdr);
      end;

    Hdr.Size := NewSize;
    SetVarSizeBlockHeader (Stream, Offset, Hdr);
  End;

Function TVarSizeAllocator.Get (const Size : Integer) : Int64;
var I    : Integer;
    O, N : Int64;
    Hdr  : TVarSizeBlockHeader;
  Begin
    For I := FFreeList.Count - 1 downto 0 do
      begin
        O := FFreeList [I];
        Hdr := GetVarSizeBlockHeader (FStream, O, [id_Free]);
        if Hdr.Size >= Size then
          begin
            Hdr.ID := id_Allocated;
            ShrinkBlock (FStream, O, Hdr, Size, N);
            if N = -1 then
              FFreeList.Delete (I) else
              FFreeList [I] := N;
            Result := O;
            exit;
          end;
      end;

    Result := FStream.Size + VarSizeBlockHeaderSize;
    FStream.Size := Result + Size;
    Hdr.ID := id_Allocated;
    Hdr.Size := Size;
    SetVarSizeBlockHeader (FStream, Result, Hdr);
  End;

Function MergeBlocks (const Stream : TExStream; const Offset : Int64;
         var Hdr : TVarSizeBlockHeader) : Boolean;
var P, L : Int64;
    Size : Integer;
    ID   : Byte;
  Begin
    P := Offset + Hdr.Size;
    L := Stream.Size;
    While P < L do
      begin
        Stream.Position := P;
        ID := Stream.Read;
        Case ID of
          id_Filler    : Inc (P);
          id_Allocated : break;
          id_Free      :
            begin
              Stream.Read (Size, Sizeof (Integer));
              Inc (P, Size + VarSizeBlockHeaderSize);
            end;
          else raise EVarSizeAllocator.Create ('Invalid block encountered');
        end;
      end;

    Size := P - Offset;
    if Size <> Hdr.Size then
      begin
        Hdr.Size := Size;
        Result := True;
      end else
      Result := False;
  End;

Procedure TVarSizeAllocator.Release (const Offset : Int64);
var Hdr  : TVarSizeBlockHeader;
  Begin
    Hdr := GetVarSizeBlockHeader (FStream, Offset, [id_Allocated]);

    MergeBlocks (FStream, Offset, Hdr);
    if Hdr.Size = FStream.Size - Offset then
      begin
        FStream.Size := Offset - VarSizeBlockHeaderSize;
        exit;
      end;

    Hdr.ID := id_Free;
    SetVarSizeBlockHeader (Stream, Offset, Hdr);
    FFreeList.Add (Offset);
  End;

Procedure TVarSizeAllocator.Resize (var Offset : Int64; const NewSize : Integer);
var Hdr   : TVarSizeBlockHeader;
    SSize : Int64;

  Function CheckBlock : Boolean;
  var L : Int64;
    Begin
      if Hdr.Size = NewSize then
        Result := True else
      if Hdr.Size > NewSize then
        begin
          ShrinkBlock (FStream, Offset, Hdr, NewSize, L);
          if L <> -1 then
            FFreeList.Add (L);
          Result := True;
        end else
      if Hdr.Size = SSize - Offset then
        begin
          FStream.Size := Offset + NewSize;
          Hdr.Size := NewSize;
          SetVarSizeBlockHeader (FStream, Offset, Hdr);
          Result := True;
        end else
        Result := False;
    End;

  Begin
    Hdr := GetVarSizeBlockHeader (FStream, Offset, [id_Allocated]);
    SSize := FStream.Size;
    if CheckBlock then
      exit;
    if MergeBlocks (FStream, Offset, Hdr) then
      if CheckBlock then
        exit;
    Release (Offset);
    Offset := Get (NewSize);
  End;

Procedure TVarSizeAllocator.Read (const Offset : Int64; var Buf);
var Hdr : TVarSizeBlockHeader;
  Begin
    Hdr := GetVarSizeBlockHeader (FStream, Offset);
    FStream.Position := Offset;
    FStream.Read (Buf, Hdr.Size)
  End;

Procedure TVarSizeAllocator.Write (const Offset : Int64; const Buf);
var Hdr : TVarSizeBlockHeader;
  Begin
    Hdr := GetVarSizeBlockHeader (FStream, Offset);
    FStream.Position := Offset;
    FStream.Write (Buf, Hdr.Size)
  End;

Function TVarSizeAllocator.ReadString (const Offset : Int64) : String;
var Hdr : TVarSizeBlockHeader;
  Begin
    Hdr := GetVarSizeBlockHeader (FStream, Offset);
    FStream.Position := Offset;
    SetLength (Result, Hdr.Size);
    FStream.Read (Result [1], Hdr.Size)
  End;

Procedure TVarSizeAllocator.WriteString (const Offset : Int64; const S : String);
  Begin
    FStream.Position := Offset;
    FStream.Write (S);
  End;

Procedure TVarSizeAllocator.RebuildFreeList;
var P, L : Int64;
    ID   : Byte;
    Size : Integer;
  Begin
    FFreeList.Clear;
    P := 0;
    L := Stream.Size;
    While P < L do
      begin
        Stream.Position := P;
        ID := Stream.Read;
        Case ID of
          id_Filler    : Inc (P);
          id_Free,
          id_Allocated :
            begin
              if ID = id_Free then
                FFreeList.Add (P + VarSizeBlockHeaderSize);
              Stream.Read (Size, Sizeof (Integer));
              Inc (P, Size + VarSizeBlockHeaderSize);
            end;
          else raise EVarSizeAllocator.Create ('Invalid block encountered');
        end;
      end;
  End;

Procedure TVarSizeAllocator.Pack;
var I   : Integer;
    Hdr : TVarSizeBlockHeader;
    O   : Int64;
  Begin
    FFreeList.Sort;
    For I := FFreeList.Count - 1 downto 0 do
      begin
        O := FFreeList [I];
        Hdr := GetVarSizeBlockHeader (FStream, O);
        FStream.Position := O - VarSizeBlockHeaderSize;
        FStream.Delete (Hdr.Size + VarSizeBlockHeaderSize);
      end;
    FFreeList.Clear;
  End;


{                                                                              }
{ TIntegerArray                                                                }
{                                                                              }
Procedure TIntegerArray.SetItem (const Idx : Integer; const Value : Integer);
  Begin
    FData [Idx] := Value;
  End;

Function TIntegerArray.GetItem (const Idx : Integer) : Integer;
  Begin
    Result := FData [Idx];
  End;

Function TIntegerArray.GetCount : Integer;
  Begin
    Result := Length (FData);
  End;

Procedure TIntegerArray.SetCount (const NewCount : Integer);
  Begin
    SetLength (FData, NewCount);
  End;

Function TIntegerArray.GetRange (const LoIdx, HiIdx : Integer) : IntegerArray;
  Begin
    Result := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TIntegerArray.SetRange (const LoIdx, HiIdx : Integer; const V : IntegerArray);
  Begin
    if Length (V) > 0 then
      Move (V [0], FData [LoIdx], (HiIdx - LoIdx + 1) * Sizeof (Integer));
  End;

Constructor TIntegerArray.Create (const V : IntegerArray);
  Begin
    inherited Create;
    FData := V;
  End;

class Function TIntegerArray.CreateInstance : AType;
  Begin
    Result := TIntegerArray.Create;
  End;

Function TIntegerArray.DuplicateRange (const LoIdx, HiIdx : Integer) : AArray;
  Begin
    Result := CreateInstance as TIntegerArray;
    TIntegerArray (Result).FData := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TIntegerArray.Assign (const V : AType);
  Begin
    if V is TIntegerArray then
      FData := Copy (TIntegerArray (V).FData) else
      inherited Assign (V);
  End;

Procedure TIntegerArray.Assign (const V : IntegerArray);
  Begin
    FData := Copy (V);
  End;

Procedure TIntegerArray.Assign (const V : array of Integer);
  Begin
    FData := AsIntegerArray (V);
  End;

Procedure TIntegerArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    Remove (FData, Idx, Count);
  End;

Procedure TIntegerArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    ArrayInsert (FData, Idx, Count);
  End;

{                                                                              }
{ TInt64Array                                                                  }
{                                                                              }
Procedure TInt64Array.SetItem (const Idx : Integer; const Value : Int64);
  Begin
    FData [Idx] := Value;
  End;

Function TInt64Array.GetItem (const Idx : Integer) : Int64;
  Begin
    Result := FData [Idx];
  End;

Function TInt64Array.GetCount : Integer;
  Begin
    Result := Length (FData);
  End;

Procedure TInt64Array.SetCount (const NewCount : Integer);
  Begin
    SetLength (FData, NewCount);
  End;

Function TInt64Array.GetRange (const LoIdx, HiIdx : Integer) : Int64Array;
  Begin
    Result := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TInt64Array.SetRange (const LoIdx, HiIdx : Integer; const V : Int64Array);
  Begin
    if Length (V) > 0 then
      Move (V [0], FData [LoIdx], (HiIdx - LoIdx + 1) * Sizeof (Int64));
  End;

Constructor TInt64Array.Create (const V : Int64Array);
  Begin
    inherited Create;
    FData := V;
  End;

class Function TInt64Array.CreateInstance : AType;
  Begin
    Result := TInt64Array.Create;
  End;

Function TInt64Array.DuplicateRange (const LoIdx, HiIdx : Integer) : AArray;
  Begin
    Result := CreateInstance as TInt64Array;
    TInt64Array (Result).FData := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TInt64Array.Assign (const V : AType);
  Begin
    if V is TInt64Array then
      FData := Copy (TInt64Array (V).FData) else
      inherited Assign (V);
  End;

Procedure TInt64Array.Assign (const V : Int64Array);
  Begin
    FData := Copy (V);
  End;

Procedure TInt64Array.Assign (const V : array of Int64);
  Begin
    FData := AsInt64Array (V);
  End;

Procedure TInt64Array.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    Remove (FData, Idx, Count);
  End;

Procedure TInt64Array.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    ArrayInsert (FData, Idx, Count);
  End;

{                                                                              }
{ TSingleArray                                                                 }
{                                                                              }
Procedure TSingleArray.SetItem (const Idx : Integer; const Value : Single);
  Begin
    FData [Idx] := Value;
  End;

Function TSingleArray.GetItem (const Idx : Integer) : Single;
  Begin
    Result := FData [Idx];
  End;

Function TSingleArray.GetCount : Integer;
  Begin
    Result := Length (FData);
  End;

Procedure TSingleArray.SetCount (const NewCount : Integer);
  Begin
    SetLength (FData, NewCount);
  End;

Function TSingleArray.GetRange (const LoIdx, HiIdx : Integer) : SingleArray;
  Begin
    Result := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TSingleArray.SetRange (const LoIdx, HiIdx : Integer; const V : SingleArray);
  Begin
    if Length (V) > 0 then
      Move (V [0], FData [LoIdx], (HiIdx - LoIdx + 1) * Sizeof (Single));
  End;

Constructor TSingleArray.Create (const V : SingleArray);
  Begin
    inherited Create;
    FData := V;
  End;

class Function TSingleArray.CreateInstance : AType;
  Begin
    Result := TSingleArray.Create;
  End;

Function TSingleArray.DuplicateRange (const LoIdx, HiIdx : Integer) : AArray;
  Begin
    Result := CreateInstance as TSingleArray;
    TSingleArray (Result).FData := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TSingleArray.Assign (const V : AType);
  Begin
    if V is TSingleArray then
      FData := Copy (TSingleArray (V).FData) else
      inherited Assign (V);
  End;

Procedure TSingleArray.Assign (const V : SingleArray);
  Begin
    FData := Copy (V);
  End;

Procedure TSingleArray.Assign (const V : array of Single);
  Begin
    FData := AsSingleArray (V);
  End;

Procedure TSingleArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    Remove (FData, Idx, Count);
  End;

Procedure TSingleArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    ArrayInsert (FData, Idx, Count);
  End;

{                                                                              }
{ TDoubleArray                                                                 }
{                                                                              }
Procedure TDoubleArray.SetItem (const Idx : Integer; const Value : Double);
  Begin
    FData [Idx] := Value;
  End;

Function TDoubleArray.GetItem (const Idx : Integer) : Double;
  Begin
    Result := FData [Idx];
  End;

Function TDoubleArray.GetCount : Integer;
  Begin
    Result := Length (FData);
  End;

Procedure TDoubleArray.SetCount (const NewCount : Integer);
  Begin
    SetLength (FData, NewCount);
  End;

Function TDoubleArray.GetRange (const LoIdx, HiIdx : Integer) : DoubleArray;
  Begin
    Result := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TDoubleArray.SetRange (const LoIdx, HiIdx : Integer; const V : DoubleArray);
  Begin
    if Length (V) > 0 then
      Move (V [0], FData [LoIdx], (HiIdx - LoIdx + 1) * Sizeof (Double));
  End;

Constructor TDoubleArray.Create (const V : DoubleArray);
  Begin
    inherited Create;
    FData := V;
  End;

class Function TDoubleArray.CreateInstance : AType;
  Begin
    Result := TDoubleArray.Create;
  End;

Function TDoubleArray.DuplicateRange (const LoIdx, HiIdx : Integer) : AArray;
  Begin
    Result := CreateInstance as TDoubleArray;
    TDoubleArray (Result).FData := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TDoubleArray.Assign (const V : AType);
  Begin
    if V is TDoubleArray then
      FData := Copy (TDoubleArray (V).FData) else
      inherited Assign (V);
  End;

Procedure TDoubleArray.Assign (const V : DoubleArray);
  Begin
    FData := Copy (V);
  End;

Procedure TDoubleArray.Assign (const V : array of Double);
  Begin
    FData := AsDoubleArray (V);
  End;

Procedure TDoubleArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    Remove (FData, Idx, Count);
  End;

Procedure TDoubleArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    ArrayInsert (FData, Idx, Count);
  End;

{                                                                              }
{ TExtendedArray                                                               }
{                                                                              }
Procedure TExtendedArray.SetItem (const Idx : Integer; const Value : Extended);
  Begin
    FData [Idx] := Value;
  End;

Function TExtendedArray.GetItem (const Idx : Integer) : Extended;
  Begin
    Result := FData [Idx];
  End;

Function TExtendedArray.GetCount : Integer;
  Begin
    Result := Length (FData);
  End;

Procedure TExtendedArray.SetCount (const NewCount : Integer);
  Begin
    SetLength (FData, NewCount);
  End;

Function TExtendedArray.GetRange (const LoIdx, HiIdx : Integer) : ExtendedArray;
  Begin
    Result := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TExtendedArray.SetRange (const LoIdx, HiIdx : Integer; const V : ExtendedArray);
  Begin
    if Length (V) > 0 then
      Move (V [0], FData [LoIdx], (HiIdx - LoIdx + 1) * Sizeof (Extended));
  End;

Constructor TExtendedArray.Create (const V : ExtendedArray);
  Begin
    inherited Create;
    FData := V;
  End;

class Function TExtendedArray.CreateInstance : AType;
  Begin
    Result := TExtendedArray.Create;
  End;

Function TExtendedArray.DuplicateRange (const LoIdx, HiIdx : Integer) : AArray;
  Begin
    Result := CreateInstance as TExtendedArray;
    TExtendedArray (Result).FData := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TExtendedArray.Assign (const V : AType);
  Begin
    if V is TExtendedArray then
      FData := Copy (TExtendedArray (V).FData) else
      inherited Assign (V);
  End;

Procedure TExtendedArray.Assign (const V : ExtendedArray);
  Begin
    FData := Copy (V);
  End;

Procedure TExtendedArray.Assign (const V : array of Extended);
  Begin
    FData := AsExtendedArray (V);
  End;

Procedure TExtendedArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    Remove (FData, Idx, Count);
  End;

Procedure TExtendedArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    ArrayInsert (FData, Idx, Count);
  End;

{                                                                              }
{ TStringArray                                                                 }
{                                                                              }
Procedure TStringArray.SetItem (const Idx : Integer; const Value : String);
  Begin
    FData [Idx] := Value;
  End;

Function TStringArray.GetItem (const Idx : Integer) : String;
  Begin
    Result := FData [Idx];
  End;

Function TStringArray.GetCount : Integer;
  Begin
    Result := Length (FData);
  End;

Procedure TStringArray.SetCount (const NewCount : Integer);
  Begin
    SetLength (FData, NewCount);
  End;

Function TStringArray.GetRange (const LoIdx, HiIdx : Integer) : StringArray;
  Begin
    Result := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TStringArray.SetRange (const LoIdx, HiIdx : Integer; const V : StringArray);
  Begin
    if Length (V) > 0 then
      Move (V [0], FData [LoIdx], (HiIdx - LoIdx + 1) * Sizeof (String));
  End;

Constructor TStringArray.Create (const V : StringArray);
  Begin
    inherited Create;
    FData := V;
  End;

class Function TStringArray.CreateInstance : AType;
  Begin
    Result := TStringArray.Create;
  End;

Function TStringArray.DuplicateRange (const LoIdx, HiIdx : Integer) : AArray;
  Begin
    Result := CreateInstance as TStringArray;
    TStringArray (Result).FData := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TStringArray.Assign (const V : AType);
  Begin
    if V is TStringArray then
      FData := Copy (TStringArray (V).FData) else
      inherited Assign (V);
  End;

Procedure TStringArray.Assign (const V : StringArray);
  Begin
    FData := Copy (V);
  End;

Procedure TStringArray.Assign (const V : array of String);
  Begin
    FData := AsStringArray (V);
  End;

Procedure TStringArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    Remove (FData, Idx, Count);
  End;

Procedure TStringArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    ArrayInsert (FData, Idx, Count);
  End;



{                                                                              }
{ TIntegerStreamArray                                                          }
{                                                                              }
Constructor TIntegerStreamArray.Create (const Stream : TExStream);
  Begin
    inherited Create;
    FStreamer := TIntegerArrayStreamer.Create (Stream);
  End;

Destructor TIntegerStreamArray.Destroy;
  Begin
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Procedure TIntegerStreamArray.SetItem (const Idx : Integer; const Value : Integer);
  Begin
    FStreamer [Idx] := Value;
  End;

Function TIntegerStreamArray.GetItem (const Idx : Integer) : Integer;
  Begin
    Result := FStreamer [Idx];
  End;

Function TIntegerStreamArray.GetCount : Integer;
  Begin
    Result := FStreamer.Count;
  End;

Procedure TIntegerStreamArray.SetCount (const NewCount : Integer);
  Begin
    FStreamer.Count := NewCount;
  End;

Function TIntegerStreamArray.Duplicate : AType;
  Begin
    Result := TIntegerStreamArray.Create (FStreamer.Stream.Duplicate);
  End;

Procedure TIntegerStreamArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Delete (Idx, Count);
  End;

Procedure TIntegerStreamArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Insert (Idx, Count);
    FStreamer.Clear (Idx, Count);
  End;



{                                                                              }
{ TInt64StreamArray                                                            }
{                                                                              }
Constructor TInt64StreamArray.Create (const Stream : TExStream);
  Begin
    inherited Create;
    FStreamer := TInt64ArrayStreamer.Create (Stream);
  End;

Destructor TInt64StreamArray.Destroy;
  Begin
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Procedure TInt64StreamArray.SetItem (const Idx : Integer; const Value : Int64);
  Begin
    FStreamer [Idx] := Value;
  End;

Function TInt64StreamArray.GetItem (const Idx : Integer) : Int64;
  Begin
    Result := FStreamer [Idx];
  End;

Function TInt64StreamArray.GetCount : Integer;
  Begin
    Result := FStreamer.Count;
  End;

Procedure TInt64StreamArray.SetCount (const NewCount : Integer);
  Begin
    FStreamer.Count := NewCount;
  End;

Function TInt64StreamArray.Duplicate : AType;
  Begin
    Result := TInt64StreamArray.Create (FStreamer.Stream.Duplicate);
  End;

Procedure TInt64StreamArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Delete (Idx, Count);
  End;

Procedure TInt64StreamArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Insert (Idx, Count);
    FStreamer.Clear (Idx, Count);
  End;



{                                                                              }
{ TSingleStreamArray                                                           }
{                                                                              }
Constructor TSingleStreamArray.Create (const Stream : TExStream);
  Begin
    inherited Create;
    FStreamer := TSingleArrayStreamer.Create (Stream);
  End;

Destructor TSingleStreamArray.Destroy;
  Begin
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Procedure TSingleStreamArray.SetItem (const Idx : Integer; const Value : Single);
  Begin
    FStreamer [Idx] := Value;
  End;

Function TSingleStreamArray.GetItem (const Idx : Integer) : Single;
  Begin
    Result := FStreamer [Idx];
  End;

Function TSingleStreamArray.GetCount : Integer;
  Begin
    Result := FStreamer.Count;
  End;

Procedure TSingleStreamArray.SetCount (const NewCount : Integer);
  Begin
    FStreamer.Count := NewCount;
  End;

Function TSingleStreamArray.Duplicate : AType;
  Begin
    Result := TSingleStreamArray.Create (FStreamer.Stream.Duplicate);
  End;

Procedure TSingleStreamArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Delete (Idx, Count);
  End;

Procedure TSingleStreamArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Insert (Idx, Count);
    FStreamer.Clear (Idx, Count);
  End;



{                                                                              }
{ TDoubleStreamArray                                                           }
{                                                                              }
Constructor TDoubleStreamArray.Create (const Stream : TExStream);
  Begin
    inherited Create;
    FStreamer := TDoubleArrayStreamer.Create (Stream);
  End;

Destructor TDoubleStreamArray.Destroy;
  Begin
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Procedure TDoubleStreamArray.SetItem (const Idx : Integer; const Value : Double);
  Begin
    FStreamer [Idx] := Value;
  End;

Function TDoubleStreamArray.GetItem (const Idx : Integer) : Double;
  Begin
    Result := FStreamer [Idx];
  End;

Function TDoubleStreamArray.GetCount : Integer;
  Begin
    Result := FStreamer.Count;
  End;

Procedure TDoubleStreamArray.SetCount (const NewCount : Integer);
  Begin
    FStreamer.Count := NewCount;
  End;

Function TDoubleStreamArray.Duplicate : AType;
  Begin
    Result := TDoubleStreamArray.Create (FStreamer.Stream.Duplicate);
  End;

Procedure TDoubleStreamArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Delete (Idx, Count);
  End;

Procedure TDoubleStreamArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Insert (Idx, Count);
    FStreamer.Clear (Idx, Count);
  End;



{                                                                              }
{ TExtendedStreamArray                                                         }
{                                                                              }
Constructor TExtendedStreamArray.Create (const Stream : TExStream);
  Begin
    inherited Create;
    FStreamer := TExtendedArrayStreamer.Create (Stream);
  End;

Destructor TExtendedStreamArray.Destroy;
  Begin
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Procedure TExtendedStreamArray.SetItem (const Idx : Integer; const Value : Extended);
  Begin
    FStreamer [Idx] := Value;
  End;

Function TExtendedStreamArray.GetItem (const Idx : Integer) : Extended;
  Begin
    Result := FStreamer [Idx];
  End;

Function TExtendedStreamArray.GetCount : Integer;
  Begin
    Result := FStreamer.Count;
  End;

Procedure TExtendedStreamArray.SetCount (const NewCount : Integer);
  Begin
    FStreamer.Count := NewCount;
  End;

Function TExtendedStreamArray.Duplicate : AType;
  Begin
    Result := TExtendedStreamArray.Create (FStreamer.Stream.Duplicate);
  End;

Procedure TExtendedStreamArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Delete (Idx, Count);
  End;

Procedure TExtendedStreamArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Insert (Idx, Count);
    FStreamer.Clear (Idx, Count);
  End;





{                                                                              }
{ TBitStreamArray                                                              }
{                                                                              }
Constructor TBitStreamArray.Create (const Stream : TExStream);
  Begin
    inherited Create;
    FStreamer := TBitArrayStreamer.Create (Stream);
  End;

Destructor TBitStreamArray.Destroy;
  Begin
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Procedure TBitStreamArray.SetBit (const Idx : Integer; const Value : Boolean);
  Begin
    FStreamer [Idx] := Value;
  End;

Function TBitStreamArray.GetBit (const Idx : Integer) : Boolean;
  Begin
    Result := FStreamer [Idx];
  End;

Function TBitStreamArray.GetCount : Integer;
  Begin
    Result := FStreamer.Count;
  End;

Procedure TBitStreamArray.SetCount (const NewCount : Integer);
  Begin
    FStreamer.Count := NewCount;
  End;

Function TBitStreamArray.Duplicate : AType;
  Begin
    Result := TBitStreamArray.Create (FStreamer.Stream.Duplicate);
  End;

Procedure TBitStreamArray.Fill (const LoIdx, HiIdx : Integer; const Value : Boolean);
  Begin
    FStreamer.FillRange (LoIdx, HiIdx, Value);
  End;

Procedure TBitStreamArray.Invert;
  Begin
    FStreamer.Invert;
  End;

Function TBitStreamArray.CompareRange (const LoIdx, HiIdx : Integer; const Value : Boolean) : Boolean;
  Begin
    Result := FStreamer.CompareRange (LoIdx, HiIdx, Value);
  End;

Function TBitStreamArray.Find (const Value : Boolean; const Start : Integer; const FindForward : Boolean) : Integer;
  Begin
    Result := FStreamer.Find (Value, Start, FindForward);
  End;

Function TBitStreamArray.FindRange (const Value : Boolean; const Start : Integer; const Count : Integer; const FindForward : Boolean) : Integer;
  Begin
    Result := FStreamer.FindRange (Value, Start, Count, FindForward);
  End;



{                                                                              }
{ TFlatBitArray                                                                }
{                                                                              }
const
  TrueCardinal  : Cardinal = $FFFFFFFF;
  FalseCardinal : Cardinal = $00000000;

Function TFlatBitArray.GetBit (const Idx : Integer) : Boolean;
  Begin
    if Idx > FCount then
      raise EBitArray.Create ('Index out of range.');

    Result := (FData [Idx div BitsPerCardinal] shr (Idx mod BitsPerCardinal)) and 1 = 1;
  End;

Procedure TFlatBitArray.SetBit (const Idx : Integer; const Value : Boolean);
var I, B : Integer;
  Begin
    if Idx > FCount then
      raise EBitArray.Create ('Index out of range.');

    I := Idx div BitsPerCardinal;
    B := 1 shl (Idx mod BitsPerCardinal);
    if Value then
      FData [I] := FData [I] or B else
      FData [I] := FData [I] and not B;
  End;

Function TFlatBitArray.GetCount : Integer;
  Begin
    Result := FCount;
  End;

Procedure TFlatBitArray.SetCount (const NewCount : Integer);
var F : Byte;
  Begin
    if NewCount = FCount then
      exit;
    SetLength (FData, (NewCount + BitsPerCardinal - 1) div BitsPerCardinal);
    // clear possible left-over bits in the last array entry
    if NewCount > FCount then
      begin
        F := FCount mod BitsPerCardinal;
        if F > 0 then
          FData [FCount] := FData [FCount] and not MSBitsMask (BitsPerCardinal - F);
      end;
    FCount := NewCount;
  End;

Function TFlatBitArray.GetRangeAsCardinal (const Idx : Integer) : Cardinal;
var F : Byte;
    I : Integer;
  Begin
    if Idx > FCount then
      raise EBitArray.Create ('Index out of range.');

    F := Idx mod BitsPerCardinal;
    I := Idx div BitsPerCardinal;
    if F = 0 then
      Result := FData [I] else
      begin
        Result := FData [I] shr F;
        if I + 1 < Length (FData) then
          Result := Result or (FData [I + 1] shl (BitsPerCardinal - F));
      end;
  End;

Procedure TFlatBitArray.SetRangeAsCardinal (const Idx : Integer; const Value : Cardinal);
var F : Byte;
    I : Integer;
  Begin
    if Idx > FCount then
      raise EBitArray.Create ('Index out of range.');

    F := Idx mod BitsPerCardinal;
    I := Idx div BitsPerCardinal;
    if F = 0 then
      FData [I] := Value else
      begin
        FData [I] := (FData [I] and LSBitsMask (F))
                  or (Value shl F);
        if I + 1 < Length (FData) then
          FData [I + 1] := (FData [I + 1] and MSBitsMask (BitsPerCardinal - F))
                        or (Value shr (BitsPerCardinal - F));
      end;
  End;

Function TFlatBitArray.CompareRange (const LoIdx, HiIdx : Integer; const Value : Boolean) : Boolean;
var B, I   : Cardinal;
    IL, IH : Integer;
  Begin
    if (LoIdx > HiIdx) or (HiIdx > FCount) then
      raise EBitArray.Create ('Index out of range.');

    // Check bits in FData [IL]
    IL := LoIdx div BitsPerCardinal;
    IH := HiIdx div BitsPerCardinal;
    B := MSBitsMask (BitsPerCardinal - (LoIdx mod BitsPerCardinal));
    I := FData [IL];
    if Value then
      Result := I or B = I else
      Result := I and not B = I;
    if not Result or (IL = IH) then
      exit;

    // Check bits in FData [IH]
    B := LSBitsMask (HiIdx mod BitsPerCardinal);
    I := FData [IH];
    if Value then
      Result := I or B = I else
      Result := I and not B = I;
    if not Result or (IH = IL + 1) then
      exit;

    // Check bits in FStore [IL + 1..IR - 1]
    For I := IL + 1 to IH - 1 do
      if (Value and (FData [I] <> TrueCardinal)) or
         (not Value and (FData [I] <> FalseCardinal)) then
        begin
          Result := False;
          exit;
        end;

    Result := True;
  End;

Procedure TFlatBitArray.Fill (const LoIdx, HiIdx : Integer; const Value : Boolean);
var B, I   : Cardinal;
    IL, IH : Integer;
  Begin
    if (LoIdx > HiIdx) or (HiIdx > FCount) then
      raise EBitArray.Create ('Index out of range.');

    IL := LoIdx div BitsPerCardinal;
    IH := HiIdx div BitsPerCardinal;

    // Set bits in FData [IL]
    if IH = IL then
      B := BitRangeMask (LoIdx mod BitsPerCardinal, HiIdx mod BitsPerCardinal) else
      B := MSBitsMask (BitsPerCardinal - (LoIdx mod BitsPerCardinal));
    I := FData [IL];
    if Value then
      FData [IL] := I or B else
      FData [IL] := I and not B;
    if IH = IL then
      exit;

    // Set bits in FData [IH]
    B := LSBitsMask (HiIdx mod BitsPerCardinal);
    I := FData [IH];
    if Value then
      FData [IH] := I or B else
      FData [IH] := I and not B;
    if IH = IL + 1 then
      exit;

    // Set bits in FData [IL + 1..IR - 1]
    For I := IL + 1 to IH - 1 do
      if Value then
        FData [I] := TrueCardinal else
        FData [I] := FalseCardinal;
  End;



{                                                                              }
{ TShortStringStreamArray                                                      }
{                                                                              }
Constructor TShortStringStreamArray.Create (const Stream : TExStream; const StringLen : Byte);
  Begin
    inherited Create;
    FStreamer := TShortStringArrayStreamer.Create (Stream, StringLen);
  End;

Destructor TShortStringStreamArray.Destroy;
  Begin
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Procedure TShortStringStreamArray.SetItem (const Idx : Integer; const Value : String);
  Begin
    FStreamer [Idx] := Value;
  End;

Function TShortStringStreamArray.GetItem (const Idx : Integer) : String;
  Begin
    Result := FStreamer [Idx];
  End;

Function TShortStringStreamArray.GetCount : Integer;
  Begin
    Result := FStreamer.Count;
  End;

Procedure TShortStringStreamArray.SetCount (const NewCount : Integer);
  Begin
    FStreamer.Count := NewCount;
  End;

Function TShortStringStreamArray.Duplicate : AType;
  Begin
    Result := TShortStringStreamArray.Create (FStreamer.Stream.Duplicate, FStreamer.StringLen);
  End;

Procedure TShortStringStreamArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Delete (Idx, Count);
  End;

Procedure TShortStringStreamArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    FStreamer.Insert (Idx, Count);
    FStreamer.Clear (Idx, Count);
  End;



{                                                                              }
{ TLongStringStreamArray                                                       }
{                                                                              }
Constructor TLongStringStreamArray.CreateEx (const Stream : TExStream; const IndexList : AInt64Array; const AllocatorFreeList : AInt64Array);
  Begin
    inherited Create;
    FStreamer := TVarSizeAllocator.CreateEx (Stream, AllocatorFreeList);
    FIndex := IndexList;
  End;

Constructor TLongStringStreamArray.Create;
  Begin
    inherited Create;
    FStreamer := TVarSizeAllocator.CreateEx (Stream, TInt64Array.Create);
    FIndex := TInt64Array.Create;
  End;

Constructor TLongStringStreamArray.CreateFile (const BaseFile : String; const FileMode : TFileStreamMode);
  Begin
    inherited Create;
    FStreamer := TVarSizeAllocator.CreateEx (TFileStream.Create (BaseFile, FileMode),
                 TInt64StreamArray.Create (TFileStream.Create (BaseFile + '.free', FileMode)));
    FIndex := TInt64StreamArray.Create (TFileStream.Create (BaseFile + '.index', FileMode));
  End;

Constructor TLongStringStreamArray.CreateFileIndexesInMemory (const BaseFile : String; const FileMode : TFileStreamMode);
  Begin
    inherited Create;
    FStreamer := TVarSizeAllocator.CreateEx (TFileStream.Create (BaseFile, FileMode), TInt64Array.Create);
    FIndex := TInt64Array.Create;
  End;

Destructor TLongStringStreamArray.Destroy;
  Begin
    FreeAndNil (FIndex);
    FreeAndNil (FStreamer);
    inherited Destroy;
  End;

Function TLongStringStreamArray.GetCount : Integer;
  Begin
    Result := FIndex.Count;
  End;

Procedure TLongStringStreamArray.SetCount (const NewCount : Integer);
var I, L : Integer;
    P    : Int64;
  Begin
    L := FIndex.Count;
    if NewCount < L then
      For I := NewCount to L - 1 do
        begin
          P := FIndex [I];
          if P <> -1 then
            FStreamer.Release (P);
        end;
    FIndex.Count := NewCount;
    if NewCount > L then
      FIndex.Fill (L, NewCount - L, -1);
  End;

Function TLongStringStreamArray.GetItem (const Idx : Integer) : String;
var O : Int64;
    L : Integer;
  Begin
    O := FIndex [Idx];
    if O = -1 then
      Result := '' else
      Result := FStreamer.ReadString (O);
  End;

Procedure TLongStringStreamArray.SetItem (const Idx : Integer; const Value : String);
var O, P : Int64;
  Begin
    O := FIndex [Idx];
    if O = -1 then
      begin
        O := FStreamer.Get (Length (Value));
        FIndex [Idx] := O;
      end else
      begin
        P := O;
        FStreamer.Resize (O, Length (Value));
        if O <> P then
          FIndex [Idx] := O;
      end;
    FStreamer.WriteString (O, Value);
  End;

Function TLongStringStreamArray.Duplicate : AType;
  Begin
    Result := TLongStringStreamArray.CreateEx (FStreamer.Stream.Duplicate,
           FIndex.Duplicate as AInt64Array, FStreamer.FFreeList.Duplicate as AInt64Array);
  End;

Procedure TLongStringStreamArray.Delete (const Idx : Integer; const Count : Integer = 1);
var I : Integer;
    P : Int64;
  Begin
    For I := Idx to Idx + Count - 1 do
      begin
        P := FIndex [I];
        if P <> -1 then
          FStreamer.Release (P);
      end;
    FIndex.Delete (Idx, Count);
  End;

Procedure TLongStringStreamArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    FIndex.Insert (Idx, Count);
    FIndex.Fill (Idx, Count, -1);
  End;



{                                                                              }
{ TObjectArray                                                                 }
{                                                                              }
Procedure TObjectArray.FreeItems;
  Begin
    FreeObjectArray (FData);
    FData := nil;
  End;

Procedure TObjectArray.SetItem (const Idx : Integer; const Value : TObject);
  Begin
    FreeAndNil (FData [Idx]);
    FData [Idx] := Value;
  End;

Function TObjectArray.GetItem (const Idx : Integer) : TObject;
  Begin
    Result := AType (FData [Idx]);
  End;

Function TObjectArray.GetCount : Integer;
  Begin
    Result := Length (FData);
  End;

Procedure TObjectArray.SetCount (const NewCount : Integer);
var L : Integer;
  Begin
    L := Length (FData);
    if NewCount < L then
      FreeObjectArray (FData, NewCount, L - 1);
    SetLength (FData, NewCount);
  End;

Function TObjectArray.GetRange (const LoIdx, HiIdx : Integer) : ObjectArray;
  Begin
    Result := Copy (FData, LoIdx, HiIdx - LoIdx + 1);
  End;

Procedure TObjectArray.SetRange (const LoIdx, HiIdx : Integer; const V : ObjectArray);
  Begin
    if Length (V) > 0 then
      Move (V [0], FData [LoIdx], (HiIdx - LoIdx + 1) * Sizeof (Integer));
  End;

Constructor TObjectArray.Create (const V : ObjectArray);
  Begin
    inherited Create;
    FData := V;
  End;

class Function TObjectArray.CreateInstance : AType;
  Begin
    Result := TObjectArray.Create;
  End;

Function TObjectArray.DuplicateRange (const LoIdx, HiIdx : Integer) : AArray;
var I : Integer;
    V : AType;
  Begin
    Result := CreateInstance as TObjectArray;
    For I := LoIdx to HiIdx do
      begin
        V := AType (FData [I]);
        if not Assigned (V) then
          TObjectArray (Result).Add (AType (nil)) else
          TObjectArray (Result).Add (V.Duplicate);
      end;
  End;

Procedure TObjectArray.Delete (const Idx : Integer; const Count : Integer = 1);
  Begin
    Remove (FData, Idx, Count, True);
  End;

Procedure TObjectArray.Insert (const Idx : Integer; const Count : Integer = 1);
  Begin
    ArrayInsert (FData, Idx, Count);
  End;

Procedure TObjectArray.Assign (const V : AType);
var I, L : Integer;
  Begin
    if V is TObjectArray then
      begin
        L := TObjectArray (V).Count;
        Count := L;
        For I := 0 to L - 1 do
          Item [I] := TObjectArray (V) [I];
      end else
      raise EObjectArray.Create ('TObjectArray can not assign from ' + V.ClassName);
  End;


{                                                                              }
{ TIntegerDictionary                                                           }
{                                                                              }
Constructor TIntegerDictionaryIterator.Create (const Dictionary : TIntegerDictionary);
  Begin
    inherited Create;
    FDictionary := Dictionary;
    FIndex := 0;
  End;

Function TIntegerDictionaryIterator.EOF : Boolean;
  Begin
    Result := FIndex >= FDictionary.FKeys.Count;
  End;

Procedure TIntegerDictionaryIterator.CurrentValid;
  Begin
    if EOF then
      raise EIntegerDictionaryIterator.Create ('No current item.');
  End;

Procedure TIntegerDictionaryIterator.Next;
  Begin
    CurrentValid;
    Inc (FIndex);
  End;

Function TIntegerDictionaryIterator.GetKey : String;
  Begin
    CurrentValid;
    Result := FDictionary.FKeys [FIndex];
  End;

Procedure TIntegerDictionaryIterator.SetKey (const Key : String);
  Begin
    CurrentValid;
    FDictionary.FKeys [FIndex] := Key;
  End;

Function TIntegerDictionaryIterator.GetValue : Integer;
  Begin
    CurrentValid;
    Result := FDictionary.FValues [FIndex];
  End;

Procedure TIntegerDictionaryIterator.SetValue (const Value : Integer);
  Begin
    CurrentValid;
    FDictionary.FValues [FIndex] := Value;
  End;

Procedure TIntegerDictionaryIterator.Delete;
  Begin
    CurrentValid;
    FDictionary.FKeys.Delete (FIndex);
    FDictionary.FValues.Delete (FIndex);
  End;

Function TIntegerDictionaryIterator.Duplicate : AIterator;
  Begin
    Result := TIntegerDictionaryIterator.Create (FDictionary);
    TIntegerDictionaryIterator (Result).FIndex := FIndex;
  End;

Constructor TIntegerDictionary.Create;
  Begin
    inherited Create;
    FKeys := TStringArray.Create;
    FValues := TIntegerArray.Create;
  End;

Constructor TIntegerDictionary.CreateEx (const Keys : AStringArray; const Values : AIntegerArray);
  Begin
    inherited Create;
    FKeys := Keys;
    FValues := Values;
  End;

Function TIntegerDictionary.KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;
  Begin
    Result := FKeys.PosNext (Key);
    if ErrorIfNotFound and (Result = -1) then
      raise EIntegerDictionary.Create ('Key not found');
  End;

Procedure TIntegerDictionary.Add (const Key : String; const Value : Integer);
  Begin
    FKeys.Add (Key);
    FValues.Add (Value);
  End;

Function TIntegerDictionary.GetCreateOnGet : Boolean;
  Begin
    Result := FCreateOnGet;
  End;

Procedure TIntegerDictionary.SetCreateOnGet (const CreateOnGet : Boolean);
  Begin
    FCreateOnGet := CreateOnGet;
  End;

Function TIntegerDictionary.GetCreateOnSet : Boolean;
  Begin
    Result := FCreateOnSet;
  End;

Procedure TIntegerDictionary.SetCreateOnSet (const CreateOnSet : Boolean);
  Begin
    FCreateOnSet := CreateOnSet;
  End;

Function TIntegerDictionary.GetItem (const Key : String) : Integer;
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    if I = -1 then
      begin
        Add (Key, 0);
        Result := 0;
      end else
      Result := FValues [I];
  End;

Procedure TIntegerDictionary.SetItem (const Key : String; const Value : Integer);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnSet);
    if I = -1 then
      Add (Key, Value) else
      FValues [I] := Value;
  End;

Procedure TIntegerDictionary.Delete (const Key : String);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    FKeys.Delete (I);
    FValues.Delete (I);
  End;

Function TIntegerDictionary.HasKey (const Key : String) : Boolean;
  Begin
    Result := FKeys.PosNext (Key) >= 0;
  End;

Function TIntegerDictionary.Iterate : AIterator;
  Begin
    Result := TIntegerDictionaryIterator.Create (self);
  End;


{                                                                              }
{ TInt64Dictionary                                                             }
{                                                                              }
Constructor TInt64DictionaryIterator.Create (const Dictionary : TInt64Dictionary);
  Begin
    inherited Create;
    FDictionary := Dictionary;
    FIndex := 0;
  End;

Function TInt64DictionaryIterator.EOF : Boolean;
  Begin
    Result := FIndex >= FDictionary.FKeys.Count;
  End;

Procedure TInt64DictionaryIterator.CurrentValid;
  Begin
    if EOF then
      raise EInt64DictionaryIterator.Create ('No current item.');
  End;

Procedure TInt64DictionaryIterator.Next;
  Begin
    CurrentValid;
    Inc (FIndex);
  End;

Function TInt64DictionaryIterator.GetKey : String;
  Begin
    CurrentValid;
    Result := FDictionary.FKeys [FIndex];
  End;

Procedure TInt64DictionaryIterator.SetKey (const Key : String);
  Begin
    CurrentValid;
    FDictionary.FKeys [FIndex] := Key;
  End;

Function TInt64DictionaryIterator.GetValue : Int64;
  Begin
    CurrentValid;
    Result := FDictionary.FValues [FIndex];
  End;

Procedure TInt64DictionaryIterator.SetValue (const Value : Int64);
  Begin
    CurrentValid;
    FDictionary.FValues [FIndex] := Value;
  End;

Procedure TInt64DictionaryIterator.Delete;
  Begin
    CurrentValid;
    FDictionary.FKeys.Delete (FIndex);
    FDictionary.FValues.Delete (FIndex);
  End;

Function TInt64DictionaryIterator.Duplicate : AIterator;
  Begin
    Result := TInt64DictionaryIterator.Create (FDictionary);
    TInt64DictionaryIterator (Result).FIndex := FIndex;
  End;

Constructor TInt64Dictionary.Create;
  Begin
    inherited Create;
    FKeys := TStringArray.Create;
    FValues := TInt64Array.Create;
  End;

Constructor TInt64Dictionary.CreateEx (const Keys : AStringArray; const Values : AInt64Array);
  Begin
    inherited Create;
    FKeys := Keys;
    FValues := Values;
  End;

Function TInt64Dictionary.KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;
  Begin
    Result := FKeys.PosNext (Key);
    if ErrorIfNotFound and (Result = -1) then
      raise EInt64Dictionary.Create ('Key not found');
  End;

Procedure TInt64Dictionary.Add (const Key : String; const Value : Int64);
  Begin
    FKeys.Add (Key);
    FValues.Add (Value);
  End;

Function TInt64Dictionary.GetCreateOnGet : Boolean;
  Begin
    Result := FCreateOnGet;
  End;

Procedure TInt64Dictionary.SetCreateOnGet (const CreateOnGet : Boolean);
  Begin
    FCreateOnGet := CreateOnGet;
  End;

Function TInt64Dictionary.GetCreateOnSet : Boolean;
  Begin
    Result := FCreateOnSet;
  End;

Procedure TInt64Dictionary.SetCreateOnSet (const CreateOnSet : Boolean);
  Begin
    FCreateOnSet := CreateOnSet;
  End;

Function TInt64Dictionary.GetItem (const Key : String) : Int64;
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    if I = -1 then
      begin
        Add (Key, 0);
        Result := 0;
      end else
      Result := FValues [I];
  End;

Procedure TInt64Dictionary.SetItem (const Key : String; const Value : Int64);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnSet);
    if I = -1 then
      Add (Key, Value) else
      FValues [I] := Value;
  End;

Procedure TInt64Dictionary.Delete (const Key : String);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    FKeys.Delete (I);
    FValues.Delete (I);
  End;

Function TInt64Dictionary.HasKey (const Key : String) : Boolean;
  Begin
    Result := FKeys.PosNext (Key) >= 0;
  End;

Function TInt64Dictionary.Iterate : AIterator;
  Begin
    Result := TInt64DictionaryIterator.Create (self);
  End;


{                                                                              }
{ TSingleDictionary                                                            }
{                                                                              }
Constructor TSingleDictionaryIterator.Create (const Dictionary : TSingleDictionary);
  Begin
    inherited Create;
    FDictionary := Dictionary;
    FIndex := 0;
  End;

Function TSingleDictionaryIterator.EOF : Boolean;
  Begin
    Result := FIndex >= FDictionary.FKeys.Count;
  End;

Procedure TSingleDictionaryIterator.CurrentValid;
  Begin
    if EOF then
      raise ESingleDictionaryIterator.Create ('No current item.');
  End;

Procedure TSingleDictionaryIterator.Next;
  Begin
    CurrentValid;
    Inc (FIndex);
  End;

Function TSingleDictionaryIterator.GetKey : String;
  Begin
    CurrentValid;
    Result := FDictionary.FKeys [FIndex];
  End;

Procedure TSingleDictionaryIterator.SetKey (const Key : String);
  Begin
    CurrentValid;
    FDictionary.FKeys [FIndex] := Key;
  End;

Function TSingleDictionaryIterator.GetValue : Single;
  Begin
    CurrentValid;
    Result := FDictionary.FValues [FIndex];
  End;

Procedure TSingleDictionaryIterator.SetValue (const Value : Single);
  Begin
    CurrentValid;
    FDictionary.FValues [FIndex] := Value;
  End;

Procedure TSingleDictionaryIterator.Delete;
  Begin
    CurrentValid;
    FDictionary.FKeys.Delete (FIndex);
    FDictionary.FValues.Delete (FIndex);
  End;

Function TSingleDictionaryIterator.Duplicate : AIterator;
  Begin
    Result := TSingleDictionaryIterator.Create (FDictionary);
    TSingleDictionaryIterator (Result).FIndex := FIndex;
  End;

Constructor TSingleDictionary.Create;
  Begin
    inherited Create;
    FKeys := TStringArray.Create;
    FValues := TSingleArray.Create;
  End;

Constructor TSingleDictionary.CreateEx (const Keys : AStringArray; const Values : ASingleArray);
  Begin
    inherited Create;
    FKeys := Keys;
    FValues := Values;
  End;

Function TSingleDictionary.KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;
  Begin
    Result := FKeys.PosNext (Key);
    if ErrorIfNotFound and (Result = -1) then
      raise ESingleDictionary.Create ('Key not found');
  End;

Procedure TSingleDictionary.Add (const Key : String; const Value : Single);
  Begin
    FKeys.Add (Key);
    FValues.Add (Value);
  End;

Function TSingleDictionary.GetCreateOnGet : Boolean;
  Begin
    Result := FCreateOnGet;
  End;

Procedure TSingleDictionary.SetCreateOnGet (const CreateOnGet : Boolean);
  Begin
    FCreateOnGet := CreateOnGet;
  End;

Function TSingleDictionary.GetCreateOnSet : Boolean;
  Begin
    Result := FCreateOnSet;
  End;

Procedure TSingleDictionary.SetCreateOnSet (const CreateOnSet : Boolean);
  Begin
    FCreateOnSet := CreateOnSet;
  End;

Function TSingleDictionary.GetItem (const Key : String) : Single;
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    if I = -1 then
      begin
        Add (Key, 0.0);
        Result := 0.0;
      end else
      Result := FValues [I];
  End;

Procedure TSingleDictionary.SetItem (const Key : String; const Value : Single);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnSet);
    if I = -1 then
      Add (Key, Value) else
      FValues [I] := Value;
  End;

Procedure TSingleDictionary.Delete (const Key : String);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    FKeys.Delete (I);
    FValues.Delete (I);
  End;

Function TSingleDictionary.HasKey (const Key : String) : Boolean;
  Begin
    Result := FKeys.PosNext (Key) >= 0;
  End;

Function TSingleDictionary.Iterate : AIterator;
  Begin
    Result := TSingleDictionaryIterator.Create (self);
  End;


{                                                                              }
{ TDoubleDictionary                                                            }
{                                                                              }
Constructor TDoubleDictionaryIterator.Create (const Dictionary : TDoubleDictionary);
  Begin
    inherited Create;
    FDictionary := Dictionary;
    FIndex := 0;
  End;

Function TDoubleDictionaryIterator.EOF : Boolean;
  Begin
    Result := FIndex >= FDictionary.FKeys.Count;
  End;

Procedure TDoubleDictionaryIterator.CurrentValid;
  Begin
    if EOF then
      raise EDoubleDictionaryIterator.Create ('No current item.');
  End;

Procedure TDoubleDictionaryIterator.Next;
  Begin
    CurrentValid;
    Inc (FIndex);
  End;

Function TDoubleDictionaryIterator.GetKey : String;
  Begin
    CurrentValid;
    Result := FDictionary.FKeys [FIndex];
  End;

Procedure TDoubleDictionaryIterator.SetKey (const Key : String);
  Begin
    CurrentValid;
    FDictionary.FKeys [FIndex] := Key;
  End;

Function TDoubleDictionaryIterator.GetValue : Double;
  Begin
    CurrentValid;
    Result := FDictionary.FValues [FIndex];
  End;

Procedure TDoubleDictionaryIterator.SetValue (const Value : Double);
  Begin
    CurrentValid;
    FDictionary.FValues [FIndex] := Value;
  End;

Procedure TDoubleDictionaryIterator.Delete;
  Begin
    CurrentValid;
    FDictionary.FKeys.Delete (FIndex);
    FDictionary.FValues.Delete (FIndex);
  End;

Function TDoubleDictionaryIterator.Duplicate : AIterator;
  Begin
    Result := TDoubleDictionaryIterator.Create (FDictionary);
    TDoubleDictionaryIterator (Result).FIndex := FIndex;
  End;

Constructor TDoubleDictionary.Create;
  Begin
    inherited Create;
    FKeys := TStringArray.Create;
    FValues := TDoubleArray.Create;
  End;

Constructor TDoubleDictionary.CreateEx (const Keys : AStringArray; const Values : ADoubleArray);
  Begin
    inherited Create;
    FKeys := Keys;
    FValues := Values;
  End;

Function TDoubleDictionary.KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;
  Begin
    Result := FKeys.PosNext (Key);
    if ErrorIfNotFound and (Result = -1) then
      raise EDoubleDictionary.Create ('Key not found');
  End;

Procedure TDoubleDictionary.Add (const Key : String; const Value : Double);
  Begin
    FKeys.Add (Key);
    FValues.Add (Value);
  End;

Function TDoubleDictionary.GetCreateOnGet : Boolean;
  Begin
    Result := FCreateOnGet;
  End;

Procedure TDoubleDictionary.SetCreateOnGet (const CreateOnGet : Boolean);
  Begin
    FCreateOnGet := CreateOnGet;
  End;

Function TDoubleDictionary.GetCreateOnSet : Boolean;
  Begin
    Result := FCreateOnSet;
  End;

Procedure TDoubleDictionary.SetCreateOnSet (const CreateOnSet : Boolean);
  Begin
    FCreateOnSet := CreateOnSet;
  End;

Function TDoubleDictionary.GetItem (const Key : String) : Double;
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    if I = -1 then
      begin
        Add (Key, 0.0);
        Result := 0.0;
      end else
      Result := FValues [I];
  End;

Procedure TDoubleDictionary.SetItem (const Key : String; const Value : Double);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnSet);
    if I = -1 then
      Add (Key, Value) else
      FValues [I] := Value;
  End;

Procedure TDoubleDictionary.Delete (const Key : String);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    FKeys.Delete (I);
    FValues.Delete (I);
  End;

Function TDoubleDictionary.HasKey (const Key : String) : Boolean;
  Begin
    Result := FKeys.PosNext (Key) >= 0;
  End;

Function TDoubleDictionary.Iterate : AIterator;
  Begin
    Result := TDoubleDictionaryIterator.Create (self);
  End;


{                                                                              }
{ TExtendedDictionary                                                          }
{                                                                              }
Constructor TExtendedDictionaryIterator.Create (const Dictionary : TExtendedDictionary);
  Begin
    inherited Create;
    FDictionary := Dictionary;
    FIndex := 0;
  End;

Function TExtendedDictionaryIterator.EOF : Boolean;
  Begin
    Result := FIndex >= FDictionary.FKeys.Count;
  End;

Procedure TExtendedDictionaryIterator.CurrentValid;
  Begin
    if EOF then
      raise EExtendedDictionaryIterator.Create ('No current item.');
  End;

Procedure TExtendedDictionaryIterator.Next;
  Begin
    CurrentValid;
    Inc (FIndex);
  End;

Function TExtendedDictionaryIterator.GetKey : String;
  Begin
    CurrentValid;
    Result := FDictionary.FKeys [FIndex];
  End;

Procedure TExtendedDictionaryIterator.SetKey (const Key : String);
  Begin
    CurrentValid;
    FDictionary.FKeys [FIndex] := Key;
  End;

Function TExtendedDictionaryIterator.GetValue : Extended;
  Begin
    CurrentValid;
    Result := FDictionary.FValues [FIndex];
  End;

Procedure TExtendedDictionaryIterator.SetValue (const Value : Extended);
  Begin
    CurrentValid;
    FDictionary.FValues [FIndex] := Value;
  End;

Procedure TExtendedDictionaryIterator.Delete;
  Begin
    CurrentValid;
    FDictionary.FKeys.Delete (FIndex);
    FDictionary.FValues.Delete (FIndex);
  End;

Function TExtendedDictionaryIterator.Duplicate : AIterator;
  Begin
    Result := TExtendedDictionaryIterator.Create (FDictionary);
    TExtendedDictionaryIterator (Result).FIndex := FIndex;
  End;

Constructor TExtendedDictionary.Create;
  Begin
    inherited Create;
    FKeys := TStringArray.Create;
    FValues := TExtendedArray.Create;
  End;

Constructor TExtendedDictionary.CreateEx (const Keys : AStringArray; const Values : AExtendedArray);
  Begin
    inherited Create;
    FKeys := Keys;
    FValues := Values;
  End;

Function TExtendedDictionary.KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;
  Begin
    Result := FKeys.PosNext (Key);
    if ErrorIfNotFound and (Result = -1) then
      raise EExtendedDictionary.Create ('Key not found');
  End;

Procedure TExtendedDictionary.Add (const Key : String; const Value : Extended);
  Begin
    FKeys.Add (Key);
    FValues.Add (Value);
  End;

Function TExtendedDictionary.GetCreateOnGet : Boolean;
  Begin
    Result := FCreateOnGet;
  End;

Procedure TExtendedDictionary.SetCreateOnGet (const CreateOnGet : Boolean);
  Begin
    FCreateOnGet := CreateOnGet;
  End;

Function TExtendedDictionary.GetCreateOnSet : Boolean;
  Begin
    Result := FCreateOnSet;
  End;

Procedure TExtendedDictionary.SetCreateOnSet (const CreateOnSet : Boolean);
  Begin
    FCreateOnSet := CreateOnSet;
  End;

Function TExtendedDictionary.GetItem (const Key : String) : Extended;
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    if I = -1 then
      begin
        Add (Key, 0.0);
        Result := 0.0;
      end else
      Result := FValues [I];
  End;

Procedure TExtendedDictionary.SetItem (const Key : String; const Value : Extended);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnSet);
    if I = -1 then
      Add (Key, Value) else
      FValues [I] := Value;
  End;

Procedure TExtendedDictionary.Delete (const Key : String);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    FKeys.Delete (I);
    FValues.Delete (I);
  End;

Function TExtendedDictionary.HasKey (const Key : String) : Boolean;
  Begin
    Result := FKeys.PosNext (Key) >= 0;
  End;

Function TExtendedDictionary.Iterate : AIterator;
  Begin
    Result := TExtendedDictionaryIterator.Create (self);
  End;


{                                                                              }
{ TStringDictionary                                                            }
{                                                                              }
Constructor TStringDictionaryIterator.Create (const Dictionary : TStringDictionary);
  Begin
    inherited Create;
    FDictionary := Dictionary;
    FIndex := 0;
  End;

Function TStringDictionaryIterator.EOF : Boolean;
  Begin
    Result := FIndex >= FDictionary.FKeys.Count;
  End;

Procedure TStringDictionaryIterator.CurrentValid;
  Begin
    if EOF then
      raise EStringDictionaryIterator.Create ('No current item.');
  End;

Procedure TStringDictionaryIterator.Next;
  Begin
    CurrentValid;
    Inc (FIndex);
  End;

Function TStringDictionaryIterator.GetKey : String;
  Begin
    CurrentValid;
    Result := FDictionary.FKeys [FIndex];
  End;

Procedure TStringDictionaryIterator.SetKey (const Key : String);
  Begin
    CurrentValid;
    FDictionary.FKeys [FIndex] := Key;
  End;

Function TStringDictionaryIterator.GetValue : String;
  Begin
    CurrentValid;
    Result := FDictionary.FValues [FIndex];
  End;

Procedure TStringDictionaryIterator.SetValue (const Value : String);
  Begin
    CurrentValid;
    FDictionary.FValues [FIndex] := Value;
  End;

Procedure TStringDictionaryIterator.Delete;
  Begin
    CurrentValid;
    FDictionary.FKeys.Delete (FIndex);
    FDictionary.FValues.Delete (FIndex);
  End;

Function TStringDictionaryIterator.Duplicate : AIterator;
  Begin
    Result := TStringDictionaryIterator.Create (FDictionary);
    TStringDictionaryIterator (Result).FIndex := FIndex;
  End;

Constructor TStringDictionary.Create;
  Begin
    inherited Create;
    FKeys := TStringArray.Create;
    FValues := TStringArray.Create;
  End;

Constructor TStringDictionary.CreateEx (const Keys : AStringArray; const Values : AStringArray);
  Begin
    inherited Create;
    FKeys := Keys;
    FValues := Values;
  End;

Function TStringDictionary.KeyIndex (const Key : String; const ErrorIfNotFound : Boolean) : Integer;
  Begin
    Result := FKeys.PosNext (Key);
    if ErrorIfNotFound and (Result = -1) then
      raise EStringDictionary.Create ('Key not found');
  End;

Procedure TStringDictionary.Add (const Key : String; const Value : String);
  Begin
    FKeys.Add (Key);
    FValues.Add (Value);
  End;

Function TStringDictionary.GetCreateOnGet : Boolean;
  Begin
    Result := FCreateOnGet;
  End;

Procedure TStringDictionary.SetCreateOnGet (const CreateOnGet : Boolean);
  Begin
    FCreateOnGet := CreateOnGet;
  End;

Function TStringDictionary.GetCreateOnSet : Boolean;
  Begin
    Result := FCreateOnSet;
  End;

Procedure TStringDictionary.SetCreateOnSet (const CreateOnSet : Boolean);
  Begin
    FCreateOnSet := CreateOnSet;
  End;

Function TStringDictionary.GetItem (const Key : String) : String;
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    if I = -1 then
      begin
        Add (Key, '');
        Result := '';
      end else
      Result := FValues [I];
  End;

Procedure TStringDictionary.SetItem (const Key : String; const Value : String);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnSet);
    if I = -1 then
      Add (Key, Value) else
      FValues [I] := Value;
  End;

Procedure TStringDictionary.Delete (const Key : String);
var I : Integer;
  Begin
    I := KeyIndex (Key, not FCreateOnGet);
    FKeys.Delete (I);
    FValues.Delete (I);
  End;

Function TStringDictionary.HasKey (const Key : String) : Boolean;
  Begin
    Result := FKeys.PosNext (Key) >= 0;
  End;

Function TStringDictionary.Iterate : AIterator;
  Begin
    Result := TStringDictionaryIterator.Create (self);
  End;



{                                                                              }
{ TIntegerStack                                                                }
{   TIntegerStack implements a stack of Integers using AIntegerArray.          }
{                                                                              }
Constructor TIntegerStack.Create;
  Begin
    inherited Create;
    FStore := TIntegerArray.Create;
  End;

Constructor TIntegerStack.CreateEx (const Store : AIntegerArray);
  Begin
    inherited Create;
    FStore := Store;
  End;

Destructor TIntegerStack.Destroy;
  Begin
    FreeAndNil (FStore);
    inherited Destroy;
  End;

Function TIntegerStack.GetAsString : String;
  Begin
    Result := FStore.AsString;
  End;

Procedure TIntegerStack.SetAsString (const S : String);
  Begin
    FStore.AsString := S;
  End;

class Function TIntegerStack.CreateInstance : AType;
  Begin
    Result := TIntegerStack.Create;
  End;

Function TIntegerStack.Duplicate : AType;
  Begin
    Result := TIntegerStack.CreateEx (FStore.Duplicate as AIntegerArray);
  End;

Procedure TIntegerStack.Assign (const V : AType);
  Begin
    FStore.Assign (V);
  End;

Function TIntegerStack.IsEqual (const V : AType) : Boolean;
  Begin
    Result := FStore.IsEqual (V);
  End;

Function TIntegerStack.Compare (const V : AType) : TCompareResult;
  Begin
    Result := FStore.Compare (V);
  End;

Function TIntegerStack.GetCount : Integer;
  Begin
    Result := FStore.Count;
  End;

Procedure TIntegerStack.Push (const V : Integer);
  Begin
    FStore.Add (V);
  End;

Function TIntegerStack.Pop : Integer;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore [L - 1];
    FStore.Count := L - 1;
  End;

Procedure TIntegerStack.Push (const V : IntegerArray);
  Begin
    FStore.Add (V);
  End;

Function TIntegerStack.Pop (const N : Integer) : IntegerArray;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore.Range [L - N, L - 1];
    FStore.Count := L - N;
  End;



{                                                                              }
{ TInt64Stack                                                                  }
{   TInt64Stack implements a stack of Int64s using AInt64Array.                }
{                                                                              }
Constructor TInt64Stack.Create;
  Begin
    inherited Create;
    FStore := TInt64Array.Create;
  End;

Constructor TInt64Stack.CreateEx (const Store : AInt64Array);
  Begin
    inherited Create;
    FStore := Store;
  End;

Destructor TInt64Stack.Destroy;
  Begin
    FreeAndNil (FStore);
    inherited Destroy;
  End;

Function TInt64Stack.GetAsString : String;
  Begin
    Result := FStore.AsString;
  End;

Procedure TInt64Stack.SetAsString (const S : String);
  Begin
    FStore.AsString := S;
  End;

class Function TInt64Stack.CreateInstance : AType;
  Begin
    Result := TInt64Stack.Create;
  End;

Function TInt64Stack.Duplicate : AType;
  Begin
    Result := TInt64Stack.CreateEx (FStore.Duplicate as AInt64Array);
  End;

Procedure TInt64Stack.Assign (const V : AType);
  Begin
    FStore.Assign (V);
  End;

Function TInt64Stack.IsEqual (const V : AType) : Boolean;
  Begin
    Result := FStore.IsEqual (V);
  End;

Function TInt64Stack.Compare (const V : AType) : TCompareResult;
  Begin
    Result := FStore.Compare (V);
  End;

Function TInt64Stack.GetCount : Integer;
  Begin
    Result := FStore.Count;
  End;

Procedure TInt64Stack.Push (const V : Int64);
  Begin
    FStore.Add (V);
  End;

Function TInt64Stack.Pop : Int64;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore [L - 1];
    FStore.Count := L - 1;
  End;

Procedure TInt64Stack.Push (const V : Int64Array);
  Begin
    FStore.Add (V);
  End;

Function TInt64Stack.Pop (const N : Integer) : Int64Array;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore.Range [L - N, L - 1];
    FStore.Count := L - N;
  End;



{                                                                              }
{ TSingleStack                                                                 }
{   TSingleStack implements a stack of Singles using ASingleArray.             }
{                                                                              }
Constructor TSingleStack.Create;
  Begin
    inherited Create;
    FStore := TSingleArray.Create;
  End;

Constructor TSingleStack.CreateEx (const Store : ASingleArray);
  Begin
    inherited Create;
    FStore := Store;
  End;

Destructor TSingleStack.Destroy;
  Begin
    FreeAndNil (FStore);
    inherited Destroy;
  End;

Function TSingleStack.GetAsString : String;
  Begin
    Result := FStore.AsString;
  End;

Procedure TSingleStack.SetAsString (const S : String);
  Begin
    FStore.AsString := S;
  End;

class Function TSingleStack.CreateInstance : AType;
  Begin
    Result := TSingleStack.Create;
  End;

Function TSingleStack.Duplicate : AType;
  Begin
    Result := TSingleStack.CreateEx (FStore.Duplicate as ASingleArray);
  End;

Procedure TSingleStack.Assign (const V : AType);
  Begin
    FStore.Assign (V);
  End;

Function TSingleStack.IsEqual (const V : AType) : Boolean;
  Begin
    Result := FStore.IsEqual (V);
  End;

Function TSingleStack.Compare (const V : AType) : TCompareResult;
  Begin
    Result := FStore.Compare (V);
  End;

Function TSingleStack.GetCount : Integer;
  Begin
    Result := FStore.Count;
  End;

Procedure TSingleStack.Push (const V : Single);
  Begin
    FStore.Add (V);
  End;

Function TSingleStack.Pop : Single;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore [L - 1];
    FStore.Count := L - 1;
  End;

Procedure TSingleStack.Push (const V : SingleArray);
  Begin
    FStore.Add (V);
  End;

Function TSingleStack.Pop (const N : Integer) : SingleArray;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore.Range [L - N, L - 1];
    FStore.Count := L - N;
  End;



{                                                                              }
{ TDoubleStack                                                                 }
{   TDoubleStack implements a stack of Doubles using ADoubleArray.             }
{                                                                              }
Constructor TDoubleStack.Create;
  Begin
    inherited Create;
    FStore := TDoubleArray.Create;
  End;

Constructor TDoubleStack.CreateEx (const Store : ADoubleArray);
  Begin
    inherited Create;
    FStore := Store;
  End;

Destructor TDoubleStack.Destroy;
  Begin
    FreeAndNil (FStore);
    inherited Destroy;
  End;

Function TDoubleStack.GetAsString : String;
  Begin
    Result := FStore.AsString;
  End;

Procedure TDoubleStack.SetAsString (const S : String);
  Begin
    FStore.AsString := S;
  End;

class Function TDoubleStack.CreateInstance : AType;
  Begin
    Result := TDoubleStack.Create;
  End;

Function TDoubleStack.Duplicate : AType;
  Begin
    Result := TDoubleStack.CreateEx (FStore.Duplicate as ADoubleArray);
  End;

Procedure TDoubleStack.Assign (const V : AType);
  Begin
    FStore.Assign (V);
  End;

Function TDoubleStack.IsEqual (const V : AType) : Boolean;
  Begin
    Result := FStore.IsEqual (V);
  End;

Function TDoubleStack.Compare (const V : AType) : TCompareResult;
  Begin
    Result := FStore.Compare (V);
  End;

Function TDoubleStack.GetCount : Integer;
  Begin
    Result := FStore.Count;
  End;

Procedure TDoubleStack.Push (const V : Double);
  Begin
    FStore.Add (V);
  End;

Function TDoubleStack.Pop : Double;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore [L - 1];
    FStore.Count := L - 1;
  End;

Procedure TDoubleStack.Push (const V : DoubleArray);
  Begin
    FStore.Add (V);
  End;

Function TDoubleStack.Pop (const N : Integer) : DoubleArray;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore.Range [L - N, L - 1];
    FStore.Count := L - N;
  End;



{                                                                              }
{ TExtendedStack                                                               }
{   TExtendedStack implements a stack of Extendeds using AExtendedArray.       }
{                                                                              }
Constructor TExtendedStack.Create;
  Begin
    inherited Create;
    FStore := TExtendedArray.Create;
  End;

Constructor TExtendedStack.CreateEx (const Store : AExtendedArray);
  Begin
    inherited Create;
    FStore := Store;
  End;

Destructor TExtendedStack.Destroy;
  Begin
    FreeAndNil (FStore);
    inherited Destroy;
  End;

Function TExtendedStack.GetAsString : String;
  Begin
    Result := FStore.AsString;
  End;

Procedure TExtendedStack.SetAsString (const S : String);
  Begin
    FStore.AsString := S;
  End;

class Function TExtendedStack.CreateInstance : AType;
  Begin
    Result := TExtendedStack.Create;
  End;

Function TExtendedStack.Duplicate : AType;
  Begin
    Result := TExtendedStack.CreateEx (FStore.Duplicate as AExtendedArray);
  End;

Procedure TExtendedStack.Assign (const V : AType);
  Begin
    FStore.Assign (V);
  End;

Function TExtendedStack.IsEqual (const V : AType) : Boolean;
  Begin
    Result := FStore.IsEqual (V);
  End;

Function TExtendedStack.Compare (const V : AType) : TCompareResult;
  Begin
    Result := FStore.Compare (V);
  End;

Function TExtendedStack.GetCount : Integer;
  Begin
    Result := FStore.Count;
  End;

Procedure TExtendedStack.Push (const V : Extended);
  Begin
    FStore.Add (V);
  End;

Function TExtendedStack.Pop : Extended;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore [L - 1];
    FStore.Count := L - 1;
  End;

Procedure TExtendedStack.Push (const V : ExtendedArray);
  Begin
    FStore.Add (V);
  End;

Function TExtendedStack.Pop (const N : Integer) : ExtendedArray;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore.Range [L - N, L - 1];
    FStore.Count := L - N;
  End;



{                                                                              }
{ TStringStack                                                                 }
{   TStringStack implements a stack of Strings using AStringArray.             }
{                                                                              }
Constructor TStringStack.Create;
  Begin
    inherited Create;
    FStore := TStringArray.Create;
  End;

Constructor TStringStack.CreateEx (const Store : AStringArray);
  Begin
    inherited Create;
    FStore := Store;
  End;

Destructor TStringStack.Destroy;
  Begin
    FreeAndNil (FStore);
    inherited Destroy;
  End;

Function TStringStack.GetAsString : String;
  Begin
    Result := FStore.AsString;
  End;

Procedure TStringStack.SetAsString (const S : String);
  Begin
    FStore.AsString := S;
  End;

class Function TStringStack.CreateInstance : AType;
  Begin
    Result := TStringStack.Create;
  End;

Function TStringStack.Duplicate : AType;
  Begin
    Result := TStringStack.CreateEx (FStore.Duplicate as AStringArray);
  End;

Procedure TStringStack.Assign (const V : AType);
  Begin
    FStore.Assign (V);
  End;

Function TStringStack.IsEqual (const V : AType) : Boolean;
  Begin
    Result := FStore.IsEqual (V);
  End;

Function TStringStack.Compare (const V : AType) : TCompareResult;
  Begin
    Result := FStore.Compare (V);
  End;

Function TStringStack.GetCount : Integer;
  Begin
    Result := FStore.Count;
  End;

Procedure TStringStack.Push (const V : String);
  Begin
    FStore.Add (V);
  End;

Function TStringStack.Pop : String;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore [L - 1];
    FStore.Count := L - 1;
  End;

Procedure TStringStack.Push (const V : StringArray);
  Begin
    FStore.Add (V);
  End;

Function TStringStack.Pop (const N : Integer) : StringArray;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore.Range [L - N, L - 1];
    FStore.Count := L - N;
  End;



{                                                                              }
{ TObjectStack                                                                 }
{   TObjectStack implements a stack of Objects using AObjectArray.             }
{                                                                              }
Constructor TObjectStack.Create;
  Begin
    inherited Create;
    FStore := TObjectArray.Create;
  End;

Constructor TObjectStack.CreateEx (const Store : AObjectArray);
  Begin
    inherited Create;
    FStore := Store;
  End;

Destructor TObjectStack.Destroy;
  Begin
    FreeAndNil (FStore);
    inherited Destroy;
  End;

Function TObjectStack.GetAsString : String;
  Begin
    Result := FStore.AsString;
  End;

Procedure TObjectStack.SetAsString (const S : String);
  Begin
    FStore.AsString := S;
  End;

class Function TObjectStack.CreateInstance : AType;
  Begin
    Result := TObjectStack.Create;
  End;

Function TObjectStack.Duplicate : AType;
  Begin
    Result := TObjectStack.CreateEx (FStore.Duplicate as AObjectArray);
  End;

Procedure TObjectStack.Assign (const V : AType);
  Begin
    FStore.Assign (V);
  End;

Function TObjectStack.IsEqual (const V : AType) : Boolean;
  Begin
    Result := FStore.IsEqual (V);
  End;

Function TObjectStack.Compare (const V : AType) : TCompareResult;
  Begin
    Result := FStore.Compare (V);
  End;

Function TObjectStack.GetCount : Integer;
  Begin
    Result := FStore.Count;
  End;

Procedure TObjectStack.Push (const V : TObject);
  Begin
    FStore.Add (V);
  End;

Function TObjectStack.Pop : TObject;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore [L - 1];
    FStore.Count := L - 1;
  End;

Procedure TObjectStack.Push (const V : ObjectArray);
  Begin
    FStore.Add (V);
  End;

Function TObjectStack.Pop (const N : Integer) : ObjectArray;
var L : Integer;
  Begin
    L := FStore.Count;
    Result := FStore.Range [L - N, L - 1];
    FStore.Count := L - N;
  End;





{                                                                              }
{ TLinkedIntegerList / TLinkedIntegerListIterator                              }
{                                                                              }
Constructor TLinkedIntegerList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TLinkedIntegerList.CreateEx (const First : PLinkedInteger);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PLinkedInteger (FFirst.Last);
  End;

Destructor TLinkedIntegerList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TLinkedIntegerList.AddInFront;
var P : PLinkedInteger;
  Begin
    P := CreateLinkedInteger;
    P.Next := FFirst;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TLinkedIntegerList.AddToBack;
var P : PLinkedInteger;
  Begin
    P := CreateLinkedInteger;
    P.Next := nil;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TLinkedIntegerList.AddInFront (const Value : Integer);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TLinkedIntegerList.AddToBack (const Value : Integer);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TLinkedIntegerList.First : ALinkedListIterator;
  Begin
    Result := TLinkedIntegerListIterator.Create (FFirst, self);
  End;

Function TLinkedIntegerList.Last : ALinkedListIterator;
  Begin
    Result := TLinkedIntegerListIterator.Create (FLast, self);
  End;

Procedure TLinkedIntegerList.DeleteFirst;
var P : PLinkedInteger;
  Begin
    if not Assigned (FFirst) then
      raise ELinkedIntegerList.Create ('No items in list');

    P := FFirst;
    FFirst := PLinkedInteger (FFirst.Next);
    
    Release (P);
  End;



Constructor TLinkedIntegerListIterator.Create (const Current : PLinkedInteger; const List : TLinkedIntegerList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TLinkedIntegerListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TLinkedIntegerListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise ELinkedIntegerListIterator.Create ('No current item');
  End;

Procedure TLinkedIntegerListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PLinkedInteger (FCurrent.Next);
  End;

Function TLinkedIntegerListIterator.GetValue : Integer;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TLinkedIntegerListIterator.SetValue (const Value : Integer);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TLinkedIntegerListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TLinkedIntegerListIterator.InsertBefore (const Value : Integer);
  Begin
  End;

Procedure TLinkedIntegerListIterator.InsertAfter (const Value : Integer);
  Begin
  End;

Procedure TLinkedIntegerListIterator.InsertBefore;
  Begin
  End;

Procedure TLinkedIntegerListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TLinkedInt64List / TLinkedInt64ListIterator                                  }
{                                                                              }
Constructor TLinkedInt64List.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TLinkedInt64List.CreateEx (const First : PLinkedInt64);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PLinkedInt64 (FFirst.Last);
  End;

Destructor TLinkedInt64List.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TLinkedInt64List.AddInFront;
var P : PLinkedInt64;
  Begin
    P := CreateLinkedInt64;
    P.Next := FFirst;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TLinkedInt64List.AddToBack;
var P : PLinkedInt64;
  Begin
    P := CreateLinkedInt64;
    P.Next := nil;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TLinkedInt64List.AddInFront (const Value : Int64);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TLinkedInt64List.AddToBack (const Value : Int64);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TLinkedInt64List.First : ALinkedListIterator;
  Begin
    Result := TLinkedInt64ListIterator.Create (FFirst, self);
  End;

Function TLinkedInt64List.Last : ALinkedListIterator;
  Begin
    Result := TLinkedInt64ListIterator.Create (FLast, self);
  End;

Procedure TLinkedInt64List.DeleteFirst;
var P : PLinkedInt64;
  Begin
    if not Assigned (FFirst) then
      raise ELinkedInt64List.Create ('No items in list');

    P := FFirst;
    FFirst := PLinkedInt64 (FFirst.Next);
    
    Release (P);
  End;



Constructor TLinkedInt64ListIterator.Create (const Current : PLinkedInt64; const List : TLinkedInt64List);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TLinkedInt64ListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TLinkedInt64ListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise ELinkedInt64ListIterator.Create ('No current item');
  End;

Procedure TLinkedInt64ListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PLinkedInt64 (FCurrent.Next);
  End;

Function TLinkedInt64ListIterator.GetValue : Int64;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TLinkedInt64ListIterator.SetValue (const Value : Int64);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TLinkedInt64ListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TLinkedInt64ListIterator.InsertBefore (const Value : Int64);
  Begin
  End;

Procedure TLinkedInt64ListIterator.InsertAfter (const Value : Int64);
  Begin
  End;

Procedure TLinkedInt64ListIterator.InsertBefore;
  Begin
  End;

Procedure TLinkedInt64ListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TLinkedSingleList / TLinkedSingleListIterator                                }
{                                                                              }
Constructor TLinkedSingleList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TLinkedSingleList.CreateEx (const First : PLinkedSingle);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PLinkedSingle (FFirst.Last);
  End;

Destructor TLinkedSingleList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TLinkedSingleList.AddInFront;
var P : PLinkedSingle;
  Begin
    P := CreateLinkedSingle;
    P.Next := FFirst;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TLinkedSingleList.AddToBack;
var P : PLinkedSingle;
  Begin
    P := CreateLinkedSingle;
    P.Next := nil;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TLinkedSingleList.AddInFront (const Value : Single);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TLinkedSingleList.AddToBack (const Value : Single);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TLinkedSingleList.First : ALinkedListIterator;
  Begin
    Result := TLinkedSingleListIterator.Create (FFirst, self);
  End;

Function TLinkedSingleList.Last : ALinkedListIterator;
  Begin
    Result := TLinkedSingleListIterator.Create (FLast, self);
  End;

Procedure TLinkedSingleList.DeleteFirst;
var P : PLinkedSingle;
  Begin
    if not Assigned (FFirst) then
      raise ELinkedSingleList.Create ('No items in list');

    P := FFirst;
    FFirst := PLinkedSingle (FFirst.Next);
    
    Release (P);
  End;



Constructor TLinkedSingleListIterator.Create (const Current : PLinkedSingle; const List : TLinkedSingleList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TLinkedSingleListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TLinkedSingleListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise ELinkedSingleListIterator.Create ('No current item');
  End;

Procedure TLinkedSingleListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PLinkedSingle (FCurrent.Next);
  End;

Function TLinkedSingleListIterator.GetValue : Single;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TLinkedSingleListIterator.SetValue (const Value : Single);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TLinkedSingleListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TLinkedSingleListIterator.InsertBefore (const Value : Single);
  Begin
  End;

Procedure TLinkedSingleListIterator.InsertAfter (const Value : Single);
  Begin
  End;

Procedure TLinkedSingleListIterator.InsertBefore;
  Begin
  End;

Procedure TLinkedSingleListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TLinkedDoubleList / TLinkedDoubleListIterator                                }
{                                                                              }
Constructor TLinkedDoubleList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TLinkedDoubleList.CreateEx (const First : PLinkedDouble);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PLinkedDouble (FFirst.Last);
  End;

Destructor TLinkedDoubleList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TLinkedDoubleList.AddInFront;
var P : PLinkedDouble;
  Begin
    P := CreateLinkedDouble;
    P.Next := FFirst;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TLinkedDoubleList.AddToBack;
var P : PLinkedDouble;
  Begin
    P := CreateLinkedDouble;
    P.Next := nil;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TLinkedDoubleList.AddInFront (const Value : Double);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TLinkedDoubleList.AddToBack (const Value : Double);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TLinkedDoubleList.First : ALinkedListIterator;
  Begin
    Result := TLinkedDoubleListIterator.Create (FFirst, self);
  End;

Function TLinkedDoubleList.Last : ALinkedListIterator;
  Begin
    Result := TLinkedDoubleListIterator.Create (FLast, self);
  End;

Procedure TLinkedDoubleList.DeleteFirst;
var P : PLinkedDouble;
  Begin
    if not Assigned (FFirst) then
      raise ELinkedDoubleList.Create ('No items in list');

    P := FFirst;
    FFirst := PLinkedDouble (FFirst.Next);
    
    Release (P);
  End;



Constructor TLinkedDoubleListIterator.Create (const Current : PLinkedDouble; const List : TLinkedDoubleList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TLinkedDoubleListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TLinkedDoubleListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise ELinkedDoubleListIterator.Create ('No current item');
  End;

Procedure TLinkedDoubleListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PLinkedDouble (FCurrent.Next);
  End;

Function TLinkedDoubleListIterator.GetValue : Double;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TLinkedDoubleListIterator.SetValue (const Value : Double);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TLinkedDoubleListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TLinkedDoubleListIterator.InsertBefore (const Value : Double);
  Begin
  End;

Procedure TLinkedDoubleListIterator.InsertAfter (const Value : Double);
  Begin
  End;

Procedure TLinkedDoubleListIterator.InsertBefore;
  Begin
  End;

Procedure TLinkedDoubleListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TLinkedExtendedList / TLinkedExtendedListIterator                            }
{                                                                              }
Constructor TLinkedExtendedList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TLinkedExtendedList.CreateEx (const First : PLinkedExtended);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PLinkedExtended (FFirst.Last);
  End;

Destructor TLinkedExtendedList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TLinkedExtendedList.AddInFront;
var P : PLinkedExtended;
  Begin
    P := CreateLinkedExtended;
    P.Next := FFirst;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TLinkedExtendedList.AddToBack;
var P : PLinkedExtended;
  Begin
    P := CreateLinkedExtended;
    P.Next := nil;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TLinkedExtendedList.AddInFront (const Value : Extended);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TLinkedExtendedList.AddToBack (const Value : Extended);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TLinkedExtendedList.First : ALinkedListIterator;
  Begin
    Result := TLinkedExtendedListIterator.Create (FFirst, self);
  End;

Function TLinkedExtendedList.Last : ALinkedListIterator;
  Begin
    Result := TLinkedExtendedListIterator.Create (FLast, self);
  End;

Procedure TLinkedExtendedList.DeleteFirst;
var P : PLinkedExtended;
  Begin
    if not Assigned (FFirst) then
      raise ELinkedExtendedList.Create ('No items in list');

    P := FFirst;
    FFirst := PLinkedExtended (FFirst.Next);
    
    Release (P);
  End;



Constructor TLinkedExtendedListIterator.Create (const Current : PLinkedExtended; const List : TLinkedExtendedList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TLinkedExtendedListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TLinkedExtendedListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise ELinkedExtendedListIterator.Create ('No current item');
  End;

Procedure TLinkedExtendedListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PLinkedExtended (FCurrent.Next);
  End;

Function TLinkedExtendedListIterator.GetValue : Extended;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TLinkedExtendedListIterator.SetValue (const Value : Extended);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TLinkedExtendedListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TLinkedExtendedListIterator.InsertBefore (const Value : Extended);
  Begin
  End;

Procedure TLinkedExtendedListIterator.InsertAfter (const Value : Extended);
  Begin
  End;

Procedure TLinkedExtendedListIterator.InsertBefore;
  Begin
  End;

Procedure TLinkedExtendedListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TLinkedStringList / TLinkedStringListIterator                                }
{                                                                              }
Constructor TLinkedStringList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TLinkedStringList.CreateEx (const First : PLinkedString);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PLinkedString (FFirst.Last);
  End;

Destructor TLinkedStringList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TLinkedStringList.AddInFront;
var P : PLinkedString;
  Begin
    P := CreateLinkedString;
    P.Next := FFirst;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TLinkedStringList.AddToBack;
var P : PLinkedString;
  Begin
    P := CreateLinkedString;
    P.Next := nil;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TLinkedStringList.AddInFront (const Value : String);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TLinkedStringList.AddToBack (const Value : String);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TLinkedStringList.First : ALinkedListIterator;
  Begin
    Result := TLinkedStringListIterator.Create (FFirst, self);
  End;

Function TLinkedStringList.Last : ALinkedListIterator;
  Begin
    Result := TLinkedStringListIterator.Create (FLast, self);
  End;

Procedure TLinkedStringList.DeleteFirst;
var P : PLinkedString;
  Begin
    if not Assigned (FFirst) then
      raise ELinkedStringList.Create ('No items in list');

    P := FFirst;
    FFirst := PLinkedString (FFirst.Next);
    
    Release (P);
  End;



Constructor TLinkedStringListIterator.Create (const Current : PLinkedString; const List : TLinkedStringList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TLinkedStringListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TLinkedStringListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise ELinkedStringListIterator.Create ('No current item');
  End;

Procedure TLinkedStringListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PLinkedString (FCurrent.Next);
  End;

Function TLinkedStringListIterator.GetValue : String;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TLinkedStringListIterator.SetValue (const Value : String);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TLinkedStringListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TLinkedStringListIterator.InsertBefore (const Value : String);
  Begin
  End;

Procedure TLinkedStringListIterator.InsertAfter (const Value : String);
  Begin
  End;

Procedure TLinkedStringListIterator.InsertBefore;
  Begin
  End;

Procedure TLinkedStringListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TDoublyLinkedIntegerList / TDoublyLinkedIntegerListIterator                  }
{                                                                              }
Constructor TDoublyLinkedIntegerList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TDoublyLinkedIntegerList.CreateEx (const First : PDoublyLinkedInteger);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PDoublyLinkedInteger (FFirst.Last);
  End;

Destructor TDoublyLinkedIntegerList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TDoublyLinkedIntegerList.AddInFront;
var P : PDoublyLinkedInteger;
  Begin
    P := CreateDoublyLinkedInteger;
    P.Next := FFirst;
    P.Prev := nil;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TDoublyLinkedIntegerList.AddToBack;
var P : PDoublyLinkedInteger;
  Begin
    P := CreateDoublyLinkedInteger;
    P.Next := nil;
    P.Prev := FLast;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TDoublyLinkedIntegerList.AddInFront (const Value : Integer);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TDoublyLinkedIntegerList.AddToBack (const Value : Integer);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TDoublyLinkedIntegerList.First : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedIntegerListIterator.Create (FFirst, self);
  End;

Function TDoublyLinkedIntegerList.Last : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedIntegerListIterator.Create (FLast, self);
  End;

Procedure TDoublyLinkedIntegerList.DeleteFirst;
var P : PDoublyLinkedInteger;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedIntegerList.Create ('No items in list');

    P := FFirst;
    FFirst := PDoublyLinkedInteger (FFirst.Next);
    if Assigned (FFirst) then
      FFirst.Prev := nil else
      FLast := nil;
    Release (P);
  End;

Procedure TDoublyLinkedIntegerList.DeleteLast;
var P : PDoublyLinkedInteger;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedIntegerList.Create ('No items in list');

    P := FLast;
    FLast := PDoublyLinkedInteger (FLast.Prev);
    if Assigned (FLast) then
      FLast.Next := nil else
      FFirst := nil;
    Release (P);
  End;


Constructor TDoublyLinkedIntegerListIterator.Create (const Current : PDoublyLinkedInteger; const List : TDoublyLinkedIntegerList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TDoublyLinkedIntegerListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TDoublyLinkedIntegerListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise EDoublyLinkedIntegerListIterator.Create ('No current item');
  End;

Procedure TDoublyLinkedIntegerListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PDoublyLinkedInteger (FCurrent.Next);
  End;

Function TDoublyLinkedIntegerListIterator.GetValue : Integer;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TDoublyLinkedIntegerListIterator.SetValue (const Value : Integer);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TDoublyLinkedIntegerListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TDoublyLinkedIntegerListIterator.InsertBefore (const Value : Integer);
  Begin
  End;

Procedure TDoublyLinkedIntegerListIterator.InsertAfter (const Value : Integer);
  Begin
  End;

Procedure TDoublyLinkedIntegerListIterator.InsertBefore;
  Begin
  End;

Procedure TDoublyLinkedIntegerListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TDoublyLinkedInt64List / TDoublyLinkedInt64ListIterator                      }
{                                                                              }
Constructor TDoublyLinkedInt64List.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TDoublyLinkedInt64List.CreateEx (const First : PDoublyLinkedInt64);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PDoublyLinkedInt64 (FFirst.Last);
  End;

Destructor TDoublyLinkedInt64List.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TDoublyLinkedInt64List.AddInFront;
var P : PDoublyLinkedInt64;
  Begin
    P := CreateDoublyLinkedInt64;
    P.Next := FFirst;
    P.Prev := nil;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TDoublyLinkedInt64List.AddToBack;
var P : PDoublyLinkedInt64;
  Begin
    P := CreateDoublyLinkedInt64;
    P.Next := nil;
    P.Prev := FLast;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TDoublyLinkedInt64List.AddInFront (const Value : Int64);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TDoublyLinkedInt64List.AddToBack (const Value : Int64);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TDoublyLinkedInt64List.First : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedInt64ListIterator.Create (FFirst, self);
  End;

Function TDoublyLinkedInt64List.Last : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedInt64ListIterator.Create (FLast, self);
  End;

Procedure TDoublyLinkedInt64List.DeleteFirst;
var P : PDoublyLinkedInt64;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedInt64List.Create ('No items in list');

    P := FFirst;
    FFirst := PDoublyLinkedInt64 (FFirst.Next);
    if Assigned (FFirst) then
      FFirst.Prev := nil else
      FLast := nil;
    Release (P);
  End;

Procedure TDoublyLinkedInt64List.DeleteLast;
var P : PDoublyLinkedInt64;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedInt64List.Create ('No items in list');

    P := FLast;
    FLast := PDoublyLinkedInt64 (FLast.Prev);
    if Assigned (FLast) then
      FLast.Next := nil else
      FFirst := nil;
    Release (P);
  End;


Constructor TDoublyLinkedInt64ListIterator.Create (const Current : PDoublyLinkedInt64; const List : TDoublyLinkedInt64List);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TDoublyLinkedInt64ListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TDoublyLinkedInt64ListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise EDoublyLinkedInt64ListIterator.Create ('No current item');
  End;

Procedure TDoublyLinkedInt64ListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PDoublyLinkedInt64 (FCurrent.Next);
  End;

Function TDoublyLinkedInt64ListIterator.GetValue : Int64;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TDoublyLinkedInt64ListIterator.SetValue (const Value : Int64);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TDoublyLinkedInt64ListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TDoublyLinkedInt64ListIterator.InsertBefore (const Value : Int64);
  Begin
  End;

Procedure TDoublyLinkedInt64ListIterator.InsertAfter (const Value : Int64);
  Begin
  End;

Procedure TDoublyLinkedInt64ListIterator.InsertBefore;
  Begin
  End;

Procedure TDoublyLinkedInt64ListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TDoublyLinkedSingleList / TDoublyLinkedSingleListIterator                    }
{                                                                              }
Constructor TDoublyLinkedSingleList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TDoublyLinkedSingleList.CreateEx (const First : PDoublyLinkedSingle);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PDoublyLinkedSingle (FFirst.Last);
  End;

Destructor TDoublyLinkedSingleList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TDoublyLinkedSingleList.AddInFront;
var P : PDoublyLinkedSingle;
  Begin
    P := CreateDoublyLinkedSingle;
    P.Next := FFirst;
    P.Prev := nil;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TDoublyLinkedSingleList.AddToBack;
var P : PDoublyLinkedSingle;
  Begin
    P := CreateDoublyLinkedSingle;
    P.Next := nil;
    P.Prev := FLast;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TDoublyLinkedSingleList.AddInFront (const Value : Single);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TDoublyLinkedSingleList.AddToBack (const Value : Single);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TDoublyLinkedSingleList.First : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedSingleListIterator.Create (FFirst, self);
  End;

Function TDoublyLinkedSingleList.Last : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedSingleListIterator.Create (FLast, self);
  End;

Procedure TDoublyLinkedSingleList.DeleteFirst;
var P : PDoublyLinkedSingle;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedSingleList.Create ('No items in list');

    P := FFirst;
    FFirst := PDoublyLinkedSingle (FFirst.Next);
    if Assigned (FFirst) then
      FFirst.Prev := nil else
      FLast := nil;
    Release (P);
  End;

Procedure TDoublyLinkedSingleList.DeleteLast;
var P : PDoublyLinkedSingle;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedSingleList.Create ('No items in list');

    P := FLast;
    FLast := PDoublyLinkedSingle (FLast.Prev);
    if Assigned (FLast) then
      FLast.Next := nil else
      FFirst := nil;
    Release (P);
  End;


Constructor TDoublyLinkedSingleListIterator.Create (const Current : PDoublyLinkedSingle; const List : TDoublyLinkedSingleList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TDoublyLinkedSingleListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TDoublyLinkedSingleListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise EDoublyLinkedSingleListIterator.Create ('No current item');
  End;

Procedure TDoublyLinkedSingleListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PDoublyLinkedSingle (FCurrent.Next);
  End;

Function TDoublyLinkedSingleListIterator.GetValue : Single;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TDoublyLinkedSingleListIterator.SetValue (const Value : Single);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TDoublyLinkedSingleListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TDoublyLinkedSingleListIterator.InsertBefore (const Value : Single);
  Begin
  End;

Procedure TDoublyLinkedSingleListIterator.InsertAfter (const Value : Single);
  Begin
  End;

Procedure TDoublyLinkedSingleListIterator.InsertBefore;
  Begin
  End;

Procedure TDoublyLinkedSingleListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TDoublyLinkedDoubleList / TDoublyLinkedDoubleListIterator                    }
{                                                                              }
Constructor TDoublyLinkedDoubleList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TDoublyLinkedDoubleList.CreateEx (const First : PDoublyLinkedDouble);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PDoublyLinkedDouble (FFirst.Last);
  End;

Destructor TDoublyLinkedDoubleList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TDoublyLinkedDoubleList.AddInFront;
var P : PDoublyLinkedDouble;
  Begin
    P := CreateDoublyLinkedDouble;
    P.Next := FFirst;
    P.Prev := nil;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TDoublyLinkedDoubleList.AddToBack;
var P : PDoublyLinkedDouble;
  Begin
    P := CreateDoublyLinkedDouble;
    P.Next := nil;
    P.Prev := FLast;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TDoublyLinkedDoubleList.AddInFront (const Value : Double);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TDoublyLinkedDoubleList.AddToBack (const Value : Double);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TDoublyLinkedDoubleList.First : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedDoubleListIterator.Create (FFirst, self);
  End;

Function TDoublyLinkedDoubleList.Last : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedDoubleListIterator.Create (FLast, self);
  End;

Procedure TDoublyLinkedDoubleList.DeleteFirst;
var P : PDoublyLinkedDouble;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedDoubleList.Create ('No items in list');

    P := FFirst;
    FFirst := PDoublyLinkedDouble (FFirst.Next);
    if Assigned (FFirst) then
      FFirst.Prev := nil else
      FLast := nil;
    Release (P);
  End;

Procedure TDoublyLinkedDoubleList.DeleteLast;
var P : PDoublyLinkedDouble;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedDoubleList.Create ('No items in list');

    P := FLast;
    FLast := PDoublyLinkedDouble (FLast.Prev);
    if Assigned (FLast) then
      FLast.Next := nil else
      FFirst := nil;
    Release (P);
  End;


Constructor TDoublyLinkedDoubleListIterator.Create (const Current : PDoublyLinkedDouble; const List : TDoublyLinkedDoubleList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TDoublyLinkedDoubleListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TDoublyLinkedDoubleListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise EDoublyLinkedDoubleListIterator.Create ('No current item');
  End;

Procedure TDoublyLinkedDoubleListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PDoublyLinkedDouble (FCurrent.Next);
  End;

Function TDoublyLinkedDoubleListIterator.GetValue : Double;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TDoublyLinkedDoubleListIterator.SetValue (const Value : Double);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TDoublyLinkedDoubleListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TDoublyLinkedDoubleListIterator.InsertBefore (const Value : Double);
  Begin
  End;

Procedure TDoublyLinkedDoubleListIterator.InsertAfter (const Value : Double);
  Begin
  End;

Procedure TDoublyLinkedDoubleListIterator.InsertBefore;
  Begin
  End;

Procedure TDoublyLinkedDoubleListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TDoublyLinkedExtendedList / TDoublyLinkedExtendedListIterator                }
{                                                                              }
Constructor TDoublyLinkedExtendedList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TDoublyLinkedExtendedList.CreateEx (const First : PDoublyLinkedExtended);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PDoublyLinkedExtended (FFirst.Last);
  End;

Destructor TDoublyLinkedExtendedList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TDoublyLinkedExtendedList.AddInFront;
var P : PDoublyLinkedExtended;
  Begin
    P := CreateDoublyLinkedExtended;
    P.Next := FFirst;
    P.Prev := nil;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TDoublyLinkedExtendedList.AddToBack;
var P : PDoublyLinkedExtended;
  Begin
    P := CreateDoublyLinkedExtended;
    P.Next := nil;
    P.Prev := FLast;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TDoublyLinkedExtendedList.AddInFront (const Value : Extended);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TDoublyLinkedExtendedList.AddToBack (const Value : Extended);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TDoublyLinkedExtendedList.First : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedExtendedListIterator.Create (FFirst, self);
  End;

Function TDoublyLinkedExtendedList.Last : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedExtendedListIterator.Create (FLast, self);
  End;

Procedure TDoublyLinkedExtendedList.DeleteFirst;
var P : PDoublyLinkedExtended;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedExtendedList.Create ('No items in list');

    P := FFirst;
    FFirst := PDoublyLinkedExtended (FFirst.Next);
    if Assigned (FFirst) then
      FFirst.Prev := nil else
      FLast := nil;
    Release (P);
  End;

Procedure TDoublyLinkedExtendedList.DeleteLast;
var P : PDoublyLinkedExtended;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedExtendedList.Create ('No items in list');

    P := FLast;
    FLast := PDoublyLinkedExtended (FLast.Prev);
    if Assigned (FLast) then
      FLast.Next := nil else
      FFirst := nil;
    Release (P);
  End;


Constructor TDoublyLinkedExtendedListIterator.Create (const Current : PDoublyLinkedExtended; const List : TDoublyLinkedExtendedList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TDoublyLinkedExtendedListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TDoublyLinkedExtendedListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise EDoublyLinkedExtendedListIterator.Create ('No current item');
  End;

Procedure TDoublyLinkedExtendedListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PDoublyLinkedExtended (FCurrent.Next);
  End;

Function TDoublyLinkedExtendedListIterator.GetValue : Extended;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TDoublyLinkedExtendedListIterator.SetValue (const Value : Extended);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TDoublyLinkedExtendedListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TDoublyLinkedExtendedListIterator.InsertBefore (const Value : Extended);
  Begin
  End;

Procedure TDoublyLinkedExtendedListIterator.InsertAfter (const Value : Extended);
  Begin
  End;

Procedure TDoublyLinkedExtendedListIterator.InsertBefore;
  Begin
  End;

Procedure TDoublyLinkedExtendedListIterator.InsertAfter;
  Begin
  End;

{                                                                              }
{ TDoublyLinkedStringList / TDoublyLinkedStringListIterator                    }
{                                                                              }
Constructor TDoublyLinkedStringList.Create;
  Begin
    inherited Create;
    FFirst := nil;
    FLast := nil;
  End;

Constructor TDoublyLinkedStringList.CreateEx (const First : PDoublyLinkedString);
  Begin
    inherited Create;
    FFirst := First;
    FLast := PDoublyLinkedString (FFirst.Last);
  End;

Destructor TDoublyLinkedStringList.Destroy;
  Begin
    FreeLinkedList (FFirst);
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Procedure TDoublyLinkedStringList.AddInFront;
var P : PDoublyLinkedString;
  Begin
    P := CreateDoublyLinkedString;
    P.Next := FFirst;
    P.Prev := nil;
    
    FFirst := P;
    if not Assigned (FLast) then
      FLast := P;
  End;

Procedure TDoublyLinkedStringList.AddToBack;
var P : PDoublyLinkedString;
  Begin
    P := CreateDoublyLinkedString;
    P.Next := nil;
    P.Prev := FLast;
    
    FLast := P;
    if not Assigned (FFirst) then
      FFirst := P;
  End;

Procedure TDoublyLinkedStringList.AddInFront (const Value : String);
  Begin
    AddInFront;
    FFirst.Value := Value;
  End;

Procedure TDoublyLinkedStringList.AddToBack (const Value : String);
  Begin
    AddToBack;
    FLast.Value := Value;
  End;

Function TDoublyLinkedStringList.First : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedStringListIterator.Create (FFirst, self);
  End;

Function TDoublyLinkedStringList.Last : ADoublyLinkedListIterator;
  Begin
    Result := TDoublyLinkedStringListIterator.Create (FLast, self);
  End;

Procedure TDoublyLinkedStringList.DeleteFirst;
var P : PDoublyLinkedString;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedStringList.Create ('No items in list');

    P := FFirst;
    FFirst := PDoublyLinkedString (FFirst.Next);
    if Assigned (FFirst) then
      FFirst.Prev := nil else
      FLast := nil;
    Release (P);
  End;

Procedure TDoublyLinkedStringList.DeleteLast;
var P : PDoublyLinkedString;
  Begin
    if not Assigned (FFirst) then
      raise EDoublyLinkedStringList.Create ('No items in list');

    P := FLast;
    FLast := PDoublyLinkedString (FLast.Prev);
    if Assigned (FLast) then
      FLast.Next := nil else
      FFirst := nil;
    Release (P);
  End;


Constructor TDoublyLinkedStringListIterator.Create (const Current : PDoublyLinkedString; const List : TDoublyLinkedStringList);
  Begin
    inherited Create;
    FCurrent := Current;
    FList := List;
  End;

Function TDoublyLinkedStringListIterator.EOF : Boolean;
  Begin
    Result := not Assigned (FCurrent);
  End;

Procedure TDoublyLinkedStringListIterator.CurrentValid;
  Begin
    if not Assigned (FCurrent) then
      raise EDoublyLinkedStringListIterator.Create ('No current item');
  End;

Procedure TDoublyLinkedStringListIterator.Next;
  Begin
    CurrentValid;
    FCurrent := PDoublyLinkedString (FCurrent.Next);
  End;

Function TDoublyLinkedStringListIterator.GetValue : String;
  Begin
    CurrentValid;
    Result := FCurrent.Value;
  End;

Procedure TDoublyLinkedStringListIterator.SetValue (const Value : String);
  Begin
    CurrentValid;
    FCurrent.Value := Value;
  End;

Procedure TDoublyLinkedStringListIterator.Delete;
  Begin
    CurrentValid;
  End;

Procedure TDoublyLinkedStringListIterator.InsertBefore (const Value : String);
  Begin
  End;

Procedure TDoublyLinkedStringListIterator.InsertAfter (const Value : String);
  Begin
  End;

Procedure TDoublyLinkedStringListIterator.InsertBefore;
  Begin
  End;

Procedure TDoublyLinkedStringListIterator.InsertAfter;
  Begin
  End;



{                                                                              }
{ TIntegerQueue                                                                }
{                                                                              }
Constructor TIntegerQueue.Create;
  Begin
    inherited Create;
    FList := TLinkedIntegerList.Create;
  End;

Constructor TIntegerQueue.CreateEx (const List : ALinkedIntegerList);
  Begin
    inherited Create;
    FList := List;
  End;

Procedure TIntegerQueue.Add (const V : Integer);
  Begin
    FList.AddToBack (V);
  End;

Function TIntegerQueue.Remove : Integer;
var I : AIterator;
  Begin
    I := FList.First;
    Result := ALinkedIntegerListIterator (I).Value;
    FreeAndNil (I);
    FList.DeleteFirst;
  End;



{                                                                              }
{ TInt64Queue                                                                  }
{                                                                              }
Constructor TInt64Queue.Create;
  Begin
    inherited Create;
    FList := TLinkedInt64List.Create;
  End;

Constructor TInt64Queue.CreateEx (const List : ALinkedInt64List);
  Begin
    inherited Create;
    FList := List;
  End;

Procedure TInt64Queue.Add (const V : Int64);
  Begin
    FList.AddToBack (V);
  End;

Function TInt64Queue.Remove : Int64;
var I : AIterator;
  Begin
    I := FList.First;
    Result := ALinkedInt64ListIterator (I).Value;
    FreeAndNil (I);
    FList.DeleteFirst;
  End;



{                                                                              }
{ TSingleQueue                                                                 }
{                                                                              }
Constructor TSingleQueue.Create;
  Begin
    inherited Create;
    FList := TLinkedSingleList.Create;
  End;

Constructor TSingleQueue.CreateEx (const List : ALinkedSingleList);
  Begin
    inherited Create;
    FList := List;
  End;

Procedure TSingleQueue.Add (const V : Single);
  Begin
    FList.AddToBack (V);
  End;

Function TSingleQueue.Remove : Single;
var I : AIterator;
  Begin
    I := FList.First;
    Result := ALinkedSingleListIterator (I).Value;
    FreeAndNil (I);
    FList.DeleteFirst;
  End;



{                                                                              }
{ TDoubleQueue                                                                 }
{                                                                              }
Constructor TDoubleQueue.Create;
  Begin
    inherited Create;
    FList := TLinkedDoubleList.Create;
  End;

Constructor TDoubleQueue.CreateEx (const List : ALinkedDoubleList);
  Begin
    inherited Create;
    FList := List;
  End;

Procedure TDoubleQueue.Add (const V : Double);
  Begin
    FList.AddToBack (V);
  End;

Function TDoubleQueue.Remove : Double;
var I : AIterator;
  Begin
    I := FList.First;
    Result := ALinkedDoubleListIterator (I).Value;
    FreeAndNil (I);
    FList.DeleteFirst;
  End;



{                                                                              }
{ TExtendedQueue                                                               }
{                                                                              }
Constructor TExtendedQueue.Create;
  Begin
    inherited Create;
    FList := TLinkedExtendedList.Create;
  End;

Constructor TExtendedQueue.CreateEx (const List : ALinkedExtendedList);
  Begin
    inherited Create;
    FList := List;
  End;

Procedure TExtendedQueue.Add (const V : Extended);
  Begin
    FList.AddToBack (V);
  End;

Function TExtendedQueue.Remove : Extended;
var I : AIterator;
  Begin
    I := FList.First;
    Result := ALinkedExtendedListIterator (I).Value;
    FreeAndNil (I);
    FList.DeleteFirst;
  End;



{                                                                              }
{ TStringQueue                                                                 }
{                                                                              }
Constructor TStringQueue.Create;
  Begin
    inherited Create;
    FList := TLinkedStringList.Create;
  End;

Constructor TStringQueue.CreateEx (const List : ALinkedStringList);
  Begin
    inherited Create;
    FList := List;
  End;

Procedure TStringQueue.Add (const V : String);
  Begin
    FList.AddToBack (V);
  End;

Function TStringQueue.Remove : String;
var I : AIterator;
  Begin
    I := FList.First;
    Result := ALinkedStringListIterator (I).Value;
    FreeAndNil (I);
    FList.DeleteFirst;
  End;





end.






















{                                                                              }
{ TRange                                                                       }
{   Store Low..High value.                                                     }
{   HasElement returns True if I in Low..High.                                 }
{   Overlap returns True if overlapping ranges.                                }
{   Touch returns True if touching (adjacent) range.                           }
{   Inside returns True if inside (contained) range.                           }
{   Merge merges adjacent/overlapping ranges. It raises an exception if the    }
{     ranges are not adjacent/overlapping.                                     }
{                                                                              }
type
  ERange = class (Exception);
  TRange = class
    protected
    FLow, FHigh : Integer;

    public
    Constructor Create (const Low, High : Integer);

    Function  HasElement (const I : Integer) : Boolean;
    Function  Overlap (const Low, High : Integer) : Boolean;
    Function  Touch (const Low, High : Integer) : Boolean;
    Function  Inside (const Low, High : Integer) : Boolean;
    Procedure Merge (const Low, High : Integer);
  end;



{                                                                              }
{ TRangeSet                                                                    }
{   A set (stored as a list of ranges)                                         }
{   Pros: Good memory usage if consequetive set bits occur sparsely.           }
{   Cons: Bad memory usage if bits are not consequetive.                       }
{                                                                              }
type
  TRangeSet = class (ASet)
    FRanges : TList;

    Constructor Create;
    Destructor Destroy; override;
    Procedure Clear; override;
    Procedure Invert; override;
    Procedure SetRange (const Low, High : Integer; const Value : Boolean); override;
    Function  GetBit (const Idx : Integer) : Boolean; override;
    Function  GetRange (const Low, High : Integer; const Value : Boolean) : Boolean; override;
    Procedure SetBit (const Idx : Integer; const Value : Boolean); override;
  end;



{                                                                              }
{ TSparseFlatSet                                                               }
{   A flat set (stored as a array of pointers to sets of Byte).                }
{   Each ByteSet store 256 bits (32 bytes)                                     }
{   Pros: Good performance for randomly distributed bits, especially if they   }
{   appear in little clumps.                                                   }
{   Cons: Bad performance for ranges.                                          }
{                                                                              }
type
  TPointerArray = Array [0..MaxLongInt div 256] of Pointer;
  PPointerArray = ^TPointerArray;

const
  EmptyByteSet : ByteSet = [];
  CompleteByteSet : ByteSet = [0..255];

type
  TSparseFlatSet = class (ASet)
    FSetList        : PPointerArray;
    FSetListEntries : Integer;

    Destructor Destroy; override;
    Procedure Clear; override;
    Procedure Invert; override;
    Function  GetBit (const Idx : Integer) : Boolean; override;
    Procedure SetBit (const Idx : Integer; const Value : Boolean); override;
    Procedure SetRange (const Low, High : Integer; const Value : Boolean); override;
  end;







{                                                                              }
{ TRange                                                                       }
{                                                                              }
Constructor TRange.Create (const Low, High : Integer);
  Begin
    inherited Create;
    FLow := Low;
    FHigh := High;
  End;

Function TRange.Overlap (const Low, High : Integer) : Boolean;
  Begin
    Result := (High >= FLow) xor (Low <= FHigh);
  End;

Function TRange.Touch (const Low, High : Integer) : Boolean;
  Begin
    Result := (High >= FLow - 1) xor (Low <= FHigh + 1);
  End;

Function TRange.Inside (const Low, High : Integer) : Boolean;
  Begin
    Result := (FLow >= Low) and (FHigh <= High);
  End;

Function TRange.HasElement (const I : Integer) : Boolean;
  Begin
    Result := (I >= FLow) and (I <= FHigh);
  End;

Procedure TRange.Merge (const Low, High : Integer);
  Begin
    if (High >= FLow - 1) xor (Low <= FHigh + 1) then // Touch
      begin
        if Low < FLow then
          FLow := Low;
        if High > FHigh then
          FHigh := High;
      end else
      raise ERange.Create ('Can not merge range');
  End;





{                                                                              }
{ TRangeSet                                                                    }
{                                                                              }
Constructor TRangeSet.Create;
  Begin
    inherited Create;
    FRanges := TList.Create;
  End;

Destructor TRangeSet.Destroy;
  Begin
    Clear;
    FRanges.Free;
    FRanges := nil;
    inherited Destroy;
  End;

Procedure TRangeSet.Clear;
var I : Integer;
  Begin
    For I := 0 to FRanges.Count - 1 do
      TRange (FRanges [I]).Free;
    FRanges.Clear;
  End;

Procedure TRangeSet.Invert;
var I      : Integer;
    R, Pre : TRange;
  Begin
    if (FRanges.Count > 0) and (TRange (FRanges [0]).FLow > 0) then
      Pre := TRange.Create (0, TRange (FRanges [0]).FLow - 1) else
      Pre := nil;
    For I := 0 to FRanges.Count - 2 do
      begin
        R := TRange (FRanges [I]);
        R.FLow := R.FHigh + 1;
        R.FHigh := TRange (FRanges [I + 1]).FLow - 1;
      end;
    if FRanges.Count > 0 then
      if TRange (FRanges [FRanges.Count - 1]).FHigh = MaxInt then
      begin
        TRange (FRanges [FRanges.Count - 1]).Free;
        FRanges.Delete (FRanges.Count - 1);
      end else
      begin
        TRange (FRanges [FRanges.Count - 1]).FLow := TRange (FRanges [FRanges.Count - 1]).FHigh + 1;
        TRange (FRanges [FRanges.Count - 1]).FHigh := MaxInt;
      end;
    if Assigned (Pre) then
      FRanges.Insert (0, Pre);
  End;

Procedure TRangeSet.SetRange (const Low, High : Integer; const Value : Boolean);
var I, J, K : Integer;
    R : TRange;
  Begin
    I := 0;
    K := FRanges.Count;
    While (I <= K - 1) and (Low > TRange (FRanges [I]).FHigh) do
      Inc (I);
    if (I = K) or  // append
       ((Low < TRange (FRanges [I]).FLow) and (High < TRange (FRanges [I]).FLow)) then // insert
      begin
        if Value then
          FRanges.Insert (I, TRange.Create (Low, High));
        exit;
      end;
    // I = first block that overlaps

    J := I;
    While (J < K - 1) and (TRange (FRanges [J + 1]).FLow <= High) do
      Inc (J);
    // J = last block that overlaps

    if not Value then // clear range
      begin
      end else // set range
      begin
        R := FRanges [I];
        if I = J then
          begin
            if Low < R.FLow then
              R.FLow := Low;
            if High > R.FHigh then
              R.FHigh := High;
          end else
          begin
            R.FLow := Low;
            R.FHigh := High;
            For K := I + 1 to J do
              begin
                TRange (FRanges [I + 1]).Free;
                FRanges.Delete (I + 1);
              end;
          end;
      end;
  End;

Function TRangeSet.GetBit (const Idx : Integer) : Boolean;
var I, J : Integer;
  Begin
    I := 0;
    J := FRanges.Count - 1;
    While (I <= J) and (Idx > TRange (FRanges [I]).FHigh) do
      Inc (I);
    Result := (I <= J) and (Idx >= TRange (FRanges [I]).FLow);
  End;

Function TRangeSet.GetRange (const Low, High : Integer; const Value : Boolean) : Boolean;
var I, J : Integer;
  Begin
    I := 0;
    J := FRanges.Count - 1;
    While (I <= J) and (Low > TRange (FRanges [I]).FHigh) do
      Inc (I);
    Result := (I <= J) and (Low >= TRange (FRanges [I]).FLow) and (High <= TRange (FRanges [I]).FHigh);
  End;

Procedure TRangeSet.SetBit (const Idx : Integer; const Value : Boolean);
  Begin
    SetRange (Idx, Idx, Value);
  End;



{                                                                              }
{ TSparseFlatSet                                                               }
{                                                                              }
Destructor TSparseFlatSet.Destroy;
  Begin
    Clear;
    inherited Destroy;
  End;

Procedure TSparseFlatSet.Clear;
var F : Integer;
  Begin
    if Assigned (FSetList) then
      begin
        For F := 0 to FSetListEntries - 1 do
          if Assigned (FSetList^ [F]) then
            Release (PDelphiSet (FSetList^ [F]));
        FreeMem (FSetList, FSetListEntries * Sizeof (Pointer));
        FSetList := nil;
        FSetListEntries := 0;
      end;
  End;

Procedure TSparseFlatSet.Invert;
var F : Integer;
  Begin
    For F := 0 to FSetListEntries - 1 do
      if Assigned (FSetList^ [F]) then
        PDelphiSet (FSetList^ [F])^ := CompleteDelphiSet - PDelphiSet (FSetList^ [F])^;
  End;

Function TSparseFlatSet.GetBit (const Idx : Integer) : Boolean;
var SetIdx : Integer;
  Begin
    SetIdx := Idx shr 8;
    Result := (SetIdx < FSetListEntries) and
              Assigned (FSetList^ [SetIdx]) and
              (Byte (Idx and $FF) in PDelphiSet (FSetList^ [SetIdx])^);
  End;

Procedure TSparseFlatSet.SetBit (const Idx : Integer; const Value : Boolean);
var I,
    SetIdx : Integer;
    S      : PDelphiSet;
  Begin
    SetIdx := Idx shr 8;
    if SetIdx >= FSetListEntries then
      if Value then
        begin
          I := FSetListEntries;
          FSetListEntries := SetIdx + 1;
          ReallocMem (FSetList, FSetListEntries * Sizeof (Pointer));
          FillChar (FSetList^ [I], (FSetListEntries - I) * Sizeof (Pointer), #0);
        end else
        exit;
    S := FSetList^ [SetIdx];
    if not Assigned (S) then
      if Value then
        begin
          New (S);
          S^ := [];
          FSetList^ [SetIdx] := S;
        end else
        exit;
    Include (S^, Byte (Idx and $FF));
  End;

Procedure TSparseFlatSet.SetRange (const Low, High : Integer; const Value : Boolean);

  Procedure SetValue (const S : ByteSet; const SetIdx : Integer);
  var D : PDelphiSet;
    Begin
      D := FSetList^ [SetIdx];
      if not Assigned (D) then
        begin
          if Value then
            begin
              New (D);
              D^ := S;
              FSetList^ [SetIdx] := D;
            end;
        end else
      if Value then
        D^ := D^ + S else
        D^ := D^ - S;
    End;

var I, LowSet,
    HighSet : Integer;

  Begin
    LowSet := Low shr 8;
    HighSet := High shr 8;
    if HighSet >= FSetListEntries then
      begin
        I := FSetListEntries;
        FSetListEntries := HighSet + 1;
        ReallocMem (FSetList, FSetListEntries * Sizeof (Pointer));
        FillChar (FSetList^ [I], (FSetListEntries - I) * Sizeof (Pointer), #0);
      end;
    if LowSet = HighSet then
      SetValue ([Byte (Low and $FF)..Byte (High and $FF)], LowSet) else
      begin
        SetValue ([Byte (Low and $FF)..$FF], LowSet);
        SetValue ([0..Byte (High and $FF)], HighSet);
        For I := LowSet + 1 to HighSet - 1 do
          SetValue (CompleteDelphiSet, I);
      end;
  End;

