{## class : TDBGridOD ###################################
  2002.10.22
  created by Arturas Damasevicius
  e-mail arturas@one.lt

  Descendent class of TDBGrid with mouse wheel support.

  If you use it and have a time, notify me.

#########################################################}

unit DBGridOD;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids;

type
  TDBGridOD = class(TDBGrid)
  private
    { Private declarations }
  protected
    { Protected declarations }
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
  public
    { Public declarations }
  published
    { Published declarations }
    property OnMouseWheelDown;
    property OnMouseWheelUp;
  end;

procedure Register;

implementation

function TDBGridOD.DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean;
begin
  if Assigned(OnMouseWheelDown) then
  begin
    OnMouseWheelDown(Self, Shift, MousePos, Result)
  end
  else
  begin
    try
      TDBGridOD(Self).DataSource.DataSet.Next ;
    except
    end ;
    Result := True ;
  end ;
end;

function TDBGridOD.DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean;
begin
  if Assigned(OnMouseWheelUp) then
     OnMouseWheelUp(Self, Shift, MousePos, Result)
  else
  begin
    try
      TDBGridOD(Self).DataSource.DataSet.Prior ;
    except
    end ;
    Result := True ;
  end ;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TDBGridOD]);
end;

end.
