//------------------------------------------------------------------------------
//  TAboutBox Version: 1.0 
//  Copyright (c) 2000 Digital Accuracy
//  Created            : 08-09-2000
//  Last Modification  : 19-09-2000
//  Description        : About Form Unit
//------------------------------------------------------------------------------

unit AboutFormU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, AboutBox;

type
  TAboutWnd = class(TForm)
    bvlLicensed: TBevel;
    bvlSep: TBevel;
    bvlOuter: TBevel;

    lblVersionInfo: TLabel;
    lblVersion: TLabel;
    lblLicensedDisc: TLabel;
    lblUserNameInfo: TLabel;
    lblProductIDInfo: TLabel;

    lblAppName: TLabel;
    lblCopyright: TLabel;
    lblWarning: TLabel;
    lblUserName: TLabel;
    lblSerial: TLabel;
    lblUrl: TLabel;

    btnOk: TButton;
    btnSysInfo: TButton;
    imgApp: TImage;
    procedure FormCreate(Sender: TObject);
    procedure btnSysInfoClick(Sender: TObject);
    procedure lblUrlClick(Sender: TObject);
  private
    { Private declarations }
  public
    constructor CreateAboutBox(AOwner: TAboutBox); virtual;
  end;

implementation

{$R *.DFM}

uses ShellApi;

function GetFileVersion: string;
var
  Size: Cardinal;
  Handle: Cardinal;
  RezBuffer: string;
  FixedFileInfoBuf  : PVSFixedFileInfo;
begin
  Result := '';
  Size := GetFileVersionInfoSize(PChar(Application.ExeName), Handle);
  if Size > 0 then
  begin
    SetLength(RezBuffer, Size);
    if GetFileVersionInfo(PChar(Application.ExeName), Handle, Size,
             PChar(RezBuffer)) then
       if VerQueryValue(PChar(RezBuffer), '\', pointer(FixedFileInfoBuf), Size) then
          if Size >= SizeOf(TVSFixedFileInfo) then
            with FixedFileInfoBuf^ do
              Result := Format('%d.%d (%s: %d.%d)', [HIWORD(dwFileVersionMS),
                          LOWORD(dwFileVersionMS), sAboutBuildNo,
                          HIWORD(dwFileVersionLS), LOWORD(dwFileVersionLS)]);
  end;
end;

{ TAboutWnd }

constructor TAboutWnd.CreateAboutBox(AOwner: TAboutBox);
var
  imgWidth, imgHeight: integer;
begin
  inherited Create(AOwner);
  with AOwner do
  begin
    Caption := Format(Caption, [AppName]);
    lblAppName.Caption := Format(lblAppName.Caption, [AppName]);
    lblCopyright.Caption := Copyright;
    lblWarning.Caption := Warning;
    lblUserName.Caption := UserName;
    lblSerial.Caption := SerialNo;
    lblUrl.Caption := Url;
    lblUrl.Hint := Url;

    // Setting license Visibility
    bvlLicensed.Visible := Showlicense;
    lblLicensedDisc.Visible := Showlicense;
    lblUserNameInfo.Visible := Showlicense;
    lblProductIDInfo.Visible := Showlicense;
    lblUserName.Visible := Showlicense;
    lblSerial.Visible := Showlicense;

    // Adjusting Controls Bounds
    imgWidth := imgApp.Width;
    imgHeight := imgApp.Height;
    if Assigned(Picture.Graphic) then
    begin
      imgApp.Picture.Assign(Picture);
      imgApp.Width := Picture.Width;
      if imgApp.Height < Picture.Height then
        imgApp.Height := Picture.Height;
    end
    else
    begin
      imgApp.Width := 0;
      imgApp.Height := 0;
      imgWidth := 0;
      imgHeight := 0;
      bvlOuter.Visible := False;
    end;
    // Setting Form Boundries
    Width := Width + (imgApp.Width - imgWidth);
    Height := Height + (imgApp.Height - imgHeight);
    bvlOuter.Width := imgApp.Width + 2;
  end;
end;

procedure TAboutWnd.FormCreate(Sender: TObject);
begin
  lblVersion.Caption := GetFileVersion;
  lblVersionInfo.Visible := lblVersion.Caption <> '';
end;

procedure TAboutWnd.btnSysInfoClick(Sender: TObject);
var
  Result: Integer;
begin
  Result := ShellExecute(Handle, 'open', 'MSInfo32.EXE', '', '', SW_SHOW);
  if Result <= 32 then
    MessageDlg(SErrorOpenSysInfo, mtError, [mbOk], 0);
end;

procedure TAboutWnd.lblUrlClick(Sender: TObject);
var
  S: string;
begin
  Screen.Cursor := crHourGlass;
  S := lblUrl.Hint;
  ShellExecute(Handle, 'open', PChar(S), nil, nil, SW_MAXIMIZE);
  Screen.Cursor := crDefault;
end;

end.

