//------------------------------------------------------------------------------
//  TAboutBox Version: 1.0 
//  Copyright (c) 2000 Digital Accuracy
//  Created            : 08-09-2000
//  Last Modification  : 19-09-2000
//  Description        : AboutBox Component
//------------------------------------------------------------------------------

unit AboutBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

resourcestring
  SWarning = 'Warning: This computer product is protected by ' +
             'copyright low and international treaties. Unauthorized reproduction or ' +
             'distribution of this product, or any portion of it, may result in severe ' +
             'civil and criminal penalties, and will be prosecuted to the maximum ' +
             'extent possible under the law.';
  SErrorOpenSysInfo = 'Could not execute system information!';
  SAboutBuildNo = 'Build';
  SCopyright = 'Copyright  2000 < Company Name > All rights reserved.';

const
  SDefaultUrl = 'http://www.< Your Company >.com';

type
  TAboutBox = class(TComponent)
  private
    FUrl: string;
    FSerialNo: string;
    FCopyright: string;
    FAppName: string;
    FUserName: string;
    FWarning: string;
    FPicture: TPicture;
    FShowlicense: Boolean;
    procedure SetPicture(const Value: TPicture);
    function IsCopyrightStored: Boolean;
    function IsUrlStored: Boolean;
    function IsWarningStored: Boolean;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Execute;
  published
    property AppName: string read FAppName write FAppName;
    property Copyright: string read FCopyright write FCopyright
      stored IsCopyrightStored;
    property Picture: TPicture read FPicture write SetPicture;
    property SerialNo: string read FSerialNo write FSerialNo;
    property Showlicense: Boolean read FShowlicense write FShowlicense
      default True;
    property Url: string read FUrl write FUrl
      stored IsUrlStored;
    property UserName: string read FUserName write FUserName;
    property Warning: string read FWarning write FWarning
      stored IsWarningStored;
  end;

procedure Register;

implementation

uses AboutFormU;

procedure Register;
begin
  RegisterComponents('Matrix', [TAboutBox]);
end;

{ TAboutBox }

constructor TAboutBox.Create(AOwner: TComponent);
begin
  inherited;
  FPicture := TPicture.Create;
  FCopyright := SCopyright;
  FShowlicense := True;
  FUrl := SDefaultUrl;
  FWarning := SWarning;
end;

destructor TAboutBox.Destroy;
begin
  FPicture.Free;
  FPicture := nil;
  inherited;
end;

procedure TAboutBox.SetPicture(const Value: TPicture);
begin
  FPicture.Assign(Value);
end;

function TAboutBox.IsCopyrightStored: Boolean;
begin
  Result := FCopyright <> SCopyright;
end;

function TAboutBox.IsUrlStored: Boolean;
begin
  Result := FUrl <> SDefaultUrl;
end;

function TAboutBox.IsWarningStored: Boolean;
begin
  Result := FWarning <> SWarning;
end;

procedure TAboutBox.Execute;
begin
  with TAboutWnd.CreateAboutBox(Self) do
    try
      ShowModal;
    finally
      Free;
    end;
end;

end.
