unit U0001;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AboutBox, jpeg, ExtCtrls;

type
  TAboutBoxDemoWnd = class(TForm)
    AboutBox: TAboutBox;
    btnAbout: TButton;
    imgTheMatrix: TImage;
    lblInfo: TLabel;
    bvlImg: TBevel;
    bvlContainer: TBevel;
    Label1: TLabel;
    procedure btnAboutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBoxDemoWnd: TAboutBoxDemoWnd;

implementation

{$R *.DFM}

uses Registry;

procedure TAboutBoxDemoWnd.btnAboutClick(Sender: TObject);
var
  User, ID: string;
begin
  // Getting User Informations
  User := 'Demo Copy';
  ID := 'xxxxx-xxx-xxxxxxx-xxxxx';
  with TRegistry.Create do
    try
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKey('\Software\Microsoft\Windows\CurrentVersion', True) then
      begin
        ID := ReadString('ProductId');
        User := ReadString('RegisteredOwner');
      end;
    finally
      CloseKey;
      Free;
    end;
  // Opening About Box
  with AboutBox do
  begin
    UserName := User;
    SerialNo := Id;
    Execute;
  end;
end;

end.
