unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, YearCalendar, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    calYear: TxYearCalendar;
    grpOptions: TGroupBox;
    chkShowDays: TCheckBox;
    chkShowMonths: TCheckBox;
    chkShowWeekends: TCheckBox;
    chkShowDayNumbers: TCheckBox;
    chkShowToday: TCheckBox;
    chkRangeSelect: TCheckBox;
    chkClickYear: TCheckBox;
    imgLogo: TImage;
    btnExit: TButton;
    dlgSelectColour: TColorDialog;
    grpDay: TGroupBox;
    btnSelectColour: TButton;
    btnBDiagonal: TButton;
    btnDiagCross: TButton;
    btnSolid: TButton;
    btnPicture1: TBitBtn;
    btnPicture2: TBitBtn;
    imgPicture2: TImage;
    imgPicture1: TImage;
    procedure chkShowDaysClick(Sender: TObject);
    procedure chkShowMonthsClick(Sender: TObject);
    procedure chkShowWeekendsClick(Sender: TObject);
    procedure chkShowDayNumbersClick(Sender: TObject);
    procedure chkShowTodayClick(Sender: TObject);
    procedure chkRangeSelectClick(Sender: TObject);
    procedure chkClickYearClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnPicture1Click(Sender: TObject);
    procedure btnPicture2Click(Sender: TObject);
    procedure btnBDiagonalClick(Sender: TObject);
    procedure btnDiagCrossClick(Sender: TObject);
    procedure btnSolidClick(Sender: TObject);
    procedure btnSelectColourClick(Sender: TObject);
  private
    procedure SetCalendarOption (Value: Boolean; Option: TYearCalOption);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SetCalendarOption (Value: Boolean; Option: TYearCalOption);
begin
  if Value then begin
    calYear.Options := calYear.Options + [Option];
  end else begin
    calYear.Options := calYear.Options - [Option];
  end;
end;

procedure TForm1.chkShowDaysClick(Sender: TObject);
begin
  SetCalendarOption (chkShowDays.Checked, ycShowDays);
end;

procedure TForm1.chkShowMonthsClick(Sender: TObject);
begin
  SetCalendarOption (chkShowMonths.Checked, ycShowMonths);
end;

procedure TForm1.chkShowWeekendsClick(Sender: TObject);
begin
  SetCalendarOption (chkShowWeekends.Checked, ycShowWeekends);
end;

procedure TForm1.chkShowDayNumbersClick(Sender: TObject);
begin
  SetCalendarOption (chkShowDayNumbers.Checked, ycShowDayNumbers);
end;

procedure TForm1.chkShowTodayClick(Sender: TObject);
begin
  SetCalendarOption (chkShowToday.Checked, ycShowToday);
end;

procedure TForm1.chkRangeSelectClick(Sender: TObject);
begin
  SetCalendarOption (chkRangeSelect.Checked, ycRangeSelect);
end;

procedure TForm1.chkClickYearClick(Sender: TObject);
begin
  SetCalendarOption (chkClickYear.Checked, ycClickYear);
end;

procedure TForm1.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.btnPicture1Click(Sender: TObject);
var
  ThisDay: Integer;
begin
  for ThisDay := 0 to calYear.SelectedDays.Count - 1 do begin
    calYear.Dates[calYear.SelectedDays[ThisDay]].Picture := imgPicture1.Picture;
  end;
end;

procedure TForm1.btnPicture2Click(Sender: TObject);
var
  ThisDay: Integer;
begin
  for ThisDay := 0 to calYear.SelectedDays.Count - 1 do begin
    calYear.Dates[calYear.SelectedDays[ThisDay]].Picture := imgPicture2.Picture;
  end;
end;

procedure TForm1.btnBDiagonalClick(Sender: TObject);
var
  ThisDay: Integer;
begin
  for ThisDay := 0 to calYear.SelectedDays.Count - 1 do begin
    calYear.Dates[calYear.SelectedDays[ThisDay]].Style := bsBDiagonal;
  end;
end;

procedure TForm1.btnDiagCrossClick(Sender: TObject);
var
  ThisDay: Integer;
begin
  for ThisDay := 0 to calYear.SelectedDays.Count - 1 do begin
    calYear.Dates[calYear.SelectedDays[ThisDay]].Style := bsDiagCross;
  end;
end;

procedure TForm1.btnSolidClick(Sender: TObject);
var
  ThisDay: Integer;
begin
  for ThisDay := 0 to calYear.SelectedDays.Count - 1 do begin
    calYear.Dates[calYear.SelectedDays[ThisDay]].Style := bsSolid;
  end;
end;

procedure TForm1.btnSelectColourClick(Sender: TObject);
var
  ThisDay: Integer;
begin
  if dlgSelectColour.Execute then begin
    for ThisDay := 0 to calYear.SelectedDays.Count - 1 do begin
      calYear.Dates[calYear.SelectedDays[ThisDay]].Color := dlgSelectColour.Color;
    end;
  end;
end;

end.
