//---------------------------------------------------------------------------

#ifndef XSpeakH
#define XSpeakH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
#include "xvtlb.h"

enum TXEnumQuality {QF_48kHz16BitStereo,QF_44kHz16BitStereo,QF_12kHz16BitStereo,
                    QF_8kHz8BitMono};

//---------------------------------------------------------------------------
class PACKAGE TXSpeak : public TComponent
{
  private:
   IXTTS* FIXTTS;
   TXEnumQuality FQuality;

   int __fastcall GetVolume();
   void __fastcall SetVolume(int Value);

   int __fastcall GetRate();
   void __fastcall SetRate(int Value);

   TXEnumQuality __fastcall GetQuality();
   void __fastcall SetQuality(TXEnumQuality Value);

   bool __fastcall GetPause();
   void __fastcall SetPause(bool Value);

   int __fastcall GetVoice();
   void __fastcall SetVoice(int Value);

   bool __fastcall GetSaveToFile();
   void __fastcall SetSaveToFile(bool Value);

   AnsiString __fastcall GetFileName();
   void __fastcall SetFileName(AnsiString Value);

  protected:

  public:
    __fastcall TXSpeak(TComponent* Owner);
    __fastcall ~TXSpeak();

    __fastcall void Speak(AnsiString Value);
    __fastcall void SpeakFile(AnsiString Value);

  __published:
    __property int Volume = {read=GetVolume, write=SetVolume};
    __property int Rate = {read=GetRate, write=SetRate};
    __property bool Pause = {read=GetPause, write=SetPause};
    __property int Voice = {read=GetVoice, write=SetVoice};
    __property bool SaveToFile = {read=GetSaveToFile, write=SetSaveToFile};
    __property TXEnumQuality Quality = {read=GetQuality, write=SetQuality};
    __property AnsiString FileName = {read=GetFileName, write=SetFileName};
};
//---------------------------------------------------------------------------
#endif
