unit xqreg;

{$I XQ_FLAG.INC}
interface
{Thanks to : Steve Garland who created most of this unit
 Date: Ene 3, 2000}

{$R xqresour.dcr}

procedure Register;

implementation

uses
   Classes, DsgnIntf, xquery, db, sysutils, syntaxhi, xqbase
{$IFDEF LEVEL3}
   , DBTables
{$ENDIF}
   ;

type
  TDataSetsPropEditor = class(TComponentProperty)
  private
    FProc : TGetStrProc;
    procedure getProc(const s : string);
  public
    procedure GetValues(Proc : TGetStrProc); override;
  end;

  TExFunctionsPropEditor = class(TComponentProperty)
  private
    FProc : TGetStrProc;
    procedure getProc(const s : string);
  public
    procedure GetValues(Proc : TGetStrProc); override;
  end;

{$IFNDEF LEVEL3}
  TParamPropEditor = class(TComponentProperty)
  private
    FProc : TGetStrProc;
    procedure getProc(const s : string);
  public
    procedure GetValues(Proc : TGetStrProc); override;
  end;
{$ENDIF}

procedure Register;
begin
   RegisterComponents('Data Access', [TxQuery, TSyntaxHighlighter]);
   RegisterPropertyEditor(TypeInfo(TComponent), TxDataSetItem,
      'DataSets', TDataSetsPropEditor);
   RegisterPropertyEditor(TypeInfo(TComponent), TExFunctionItem,
      'ExFunctions', TExFunctionsPropEditor);
{$IFNDEF LEVEL3}
   RegisterPropertyEditor(TypeInfo(TComponent), TParam,
      'Params', TParamPropEditor);
{$ENDIF}
end;

{TDataSetsPropEditor - class implementation}
procedure TDataSetsPropEditor.getProc(const s : string);
var
  i    : integer;
  item : TxDataSetItem;
begin
  item := TxDataSetItem(GetComponent(0));
  with item, Collection do
    for i := 0 to Count - 1 do
      if Assigned(TxDataSetItem(Items[i]).DataSet) and
         (CompareText(s, TxDataSetItem(Items[i]).DataSet.Name) = 0) then
        exit;

  FProc(s);
end;

procedure TDataSetsPropEditor.GetValues(Proc : TGetStrProc);
begin
  FProc := Proc;
  inherited GetValues(getProc);
end;

{TExFunctionsPropEditor - class implementation}
procedure TExFunctionsPropEditor.getProc(const s : string);
var
  i    : integer;
  item : TExFunctionItem;
begin
  item := TExFunctionItem(GetComponent(0));
  with item, Collection do
    for i := 0 to Count - 1 do
      if CompareText(s, TExFunctionItem(Items[i]).Name) = 0 then
        exit;

  FProc(s);
end;

procedure TExFunctionsPropEditor.GetValues(Proc : TGetStrProc);
begin
  FProc := Proc;
  inherited GetValues(getProc);
end;

{TParamPropEditor - class implementation}
{$IFNDEF LEVEL3}
procedure TParamPropEditor.getProc(const s : string);
var
  i    : integer;
  item : TParam;
begin
  item := TParam(GetComponent(0));
  with item, Collection do
    for i := 0 to Count - 1 do
      if CompareText(s, TParam(Items[i]).Name) = 0 then
        exit;

  FProc(s);
end;

procedure TParamPropEditor.GetValues(Proc : TGetStrProc);
begin
  FProc := Proc;
  inherited GetValues(getProc);
end;
{$ENDIF}

end.
