unit HTMLqry;

{$I XQ_FLAG.INC}
interface

Uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Controls,
  Forms,
  Dialogs,
  Graphics,
  Db
  ;

{ this unit is for exporting a dataset to HTML }

type
  THTMLExport = class(TComponent)
  private
    FFooter: TStrings;
    FHeader: TStrings;
    FTitle : TStrings;
    FDataSet: TDataSet;
    FBodyColor: TColor;
    FTableHeaderColor: TColor;
    FTableBodyColor: TColor;
    FTableOddRowColor: TColor;
    procedure SetDataSet(Value: TDataSet);
    procedure SetFooter(Value: TStrings);
    procedure SetHeader(Value: TStrings);
    procedure SetTitle(Value: TStrings);
  protected
    procedure Notification(AComponent: TComponent; Operation: toperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; Override;
    procedure SaveToFile(const FileName: String);
  published
    property Footer: TStrings read FFooter;
    property Header: TStrings read FHeader;
    property Title : TStrings read FTitle;
    property DataSet: TDataSet read FDataSet write SetDataSet;
    property BodyColor: TColor read FBodyColor write FBodyColor;
    property TableHeaderColor: TColor read FTableHeaderColor write FTableHeaderColor;
    property TableBodyColor: TColor read FTableBodyColor write FTableBodyColor;
    property TableOddRowColor: TColor read FTableOddRowColor write FTableOddRowColor;
  end;

implementation

uses xquery;

constructor THTMLExport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FFooter:= TStringList.Create;
  FHeader:= TStringList.Create;
  FTitle := TStringList.Create;
  FBodyColor:= 16777194;
  FTableHeaderColor:= 3394815;
  FTableBodyColor:= 16777194;
  FTableOddRowColor:= 3394764;
end;

destructor THTMLExport.Destroy;
begin
  FFooter.Free;
  FHeader.Free;
  FTitle.Free;
  inherited Destroy;
end;

procedure THTMLExport.SetDataSet(Value: TDataSet);
begin
  if Value <> FDataSet then begin
     FDataSet := Value;
     Value.FreeNotification(Self);
  end;
end;

procedure THTMLExport.Notification(AComponent: TComponent; Operation: toperation);
begin
   inherited Notification(AComponent, Operation);
   if (Operation = opRemove) and (Acomponent=FDataSet) then
      FDataSet := nil;
end;

procedure THTMLExport.SetFooter(Value: TStrings);
begin
  FFooter.Assign(Value);
end;

procedure THTMLExport.SetHeader(Value: TStrings);
begin
  FHeader.Assign(Value);
end;

procedure THTMLExport.SetTitle(Value: TStrings);
begin
  FTitle.Assign(Value);
end;

procedure THTMLExport.SaveToFile(const FileName: String);
var
  f: TextFile;
  i, Count: Integer;
  s,Align: String;
begin
  if not Assigned(FDataSet) or not FDataSet.Active then Exit;
  AssignFile(f,FileName);
  Rewrite(f);
  try
     WriteLn(f,'<HTML>');
     if (Length(FHeader.Text)>0) or (Length(FTitle.Text)>0) then begin
        WriteLn(f,'<HEAD>');
        if Length(FTitle.Text) > 0 then begin
          Write(f,'<TITLE>');
          for i:= 0 to FTitle.Count - 1 do
             WriteLn(f,FTitle[i]);
          WriteLn(f,'</TITLE>');
        end;
        WriteLn(f,'<H3>');
        for i:= 0 to FHeader.Count - 1 do
          WriteLn(f,FHeader[i],'<BR>');
        WriteLn(f,'</H3>');
        WriteLn(f,'</HEAD>');
        WriteLn(f,'<HR>');
     end;
     WriteLn(f,Format('<BODY BGCOLOR="#%s">',[IntToHex(FBodyColor,6)]));
     WriteLn(f,Format('<TABLE BGCOLOR="#%s" BORDER>',[IntToHex(FTableBodyColor,6)]));
     { The title }
     WriteLn(f,Format('<TR BGCOLOR="#%s" NOWRAP>',[IntToHex(FTableHeaderColor,6)]));
     for i := 0 to FDataSet.FieldCount - 1 do
       WriteLn(f,Format('  <TH NOWRAP>%s</TH>',[FDataSet.Fields[i].FieldName]));
     WriteLn(f,'</TR>');
     { now write all the rows }
     FDataSet.First; Count := 0;
     while not FDataSet.EOF do begin
       Inc(Count);
       { write all this row }
       if (Count Mod 2) = 0 then begin
         WriteLn(f,Format('<TR BGCOLOR ="#%s">',[IntToHex(FTableOddRowColor,6)]));
       end else
         WriteLn(f,'<TR>');
       ;
       for i := 0 to FDataSet.FieldCount - 1 do begin
         if FDataSet.Fields[i].DataType in ftNonTextTypes then begin
            s:='(Blob/Memo)';
         end else begin
            Align:= '';
            case FDataSet.Fields[i].DataType of
               ftFloat,ftCurrency,ftBCD,
               ftAutoInc,ftSmallInt,ftInteger,ftWord
               {$ifndef LEVEL3},ftLargeInt{$endif}
                 : Align:=' ALIGN=RIGHT';
            end;
            s:= FDataSet.Fields[i].AsString;
         end;
         Write(f,Format('  <TD NOWRAP%s>%s',[Align,s]));
         if Length(s) = 0 then WriteLn(f,'<BR></TD>') else WriteLn(f,'</TD>')
       end;
       WriteLn(f,'</TR>');
       FDataSet.Next;
     end;
     WriteLn(f,'</TABLE>');
     if Length(FFooter.Text)>0 then begin
        WriteLn(f,'<HR>');
        Write(f,'<P>');
        for i:= 0 to FFooter.Count - 1 do
           WriteLn(f,FFooter[i],'<BR>');
        WriteLn(f,'</P>');
     end;
     WriteLn(f,'</BODY>');
     WriteLn(f,'</HTML>');
  finally
     CloseFile(f);
  end;
end;

end.
