unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Grids, DBGrids,XmsDBGrid, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    all: TButton;
    Table1: TTable;
    none: TButton;
    DataSource1: TDataSource;
    Button1: TButton;
    Label3: TLabel;
    Label1: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Label2: TLabel;
    Bevel2: TBevel;
    Label6: TLabel;
    Edit1: TEdit;
    Label7: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    Label8: TLabel;
    Label5: TLabel;
    Totalcolwidths: TButton;
    Panel2: TPanel;
    XmsDBGrid1: TXmsDBGrid;
    CheckBox1: TCheckBox;
    Label9: TLabel;
    chkstretch: TCheckBox;
    tbookmarks: TButton;
    Table1Name: TStringField;
    Table1Capital: TStringField;
    Table1Continent: TStringField;
    Table1Area: TFloatField;
    Table1Population: TFloatField;
    procedure allClick(Sender: TObject);
    procedure noneClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TotalcolwidthsClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Panel2Resize(Sender: TObject);
    procedure chkstretchClick(Sender: TObject);
    procedure tbookmarksClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.allClick(Sender: TObject);
begin
XmsDBGrid1.selectall;
end;

procedure TForm1.noneClick(Sender: TObject);
begin
XmsDBGrid1.resetall
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
label1.caption:=  inttostr(XmsDBGrid1.currentrow);
label2.caption:=  inttostr(XmsDBGrid1.currentcol);
end;

procedure TForm1.TotalcolwidthsClick(Sender: TObject);
begin
  label5.caption:=inttostr(xmsdbgrid1.TotalColWidths);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
with XmsDBGrid1 do begin
  edit1.text:=inttostr(resizecol);
  edit2.text:=inttostr(resizecolmin);
  edit3.text:=inttostr(resizecolmax);
end;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
try
  XmsDBGrid1.resizecol:=strtoint(edit1.text);
except
  showmessage('Error!  You need to input a valid integer value');
end;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
try
  XmsDBGrid1.resizecolmin:=strtoint(edit2.text);
except
  showmessage('Error!  You need to input a valid integer value');
end;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
try
    XmsDBGrid1.resizecolmax:=strtoint(edit3.text);
except
  showmessage('Error!  You need to input a valid integer value');
end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  xmsdbgrid1.selectonmove:=CheckBox1.checked;
end;

procedure TForm1.Panel2Resize(Sender: TObject);
begin
  if chkstretch.checked then   xmsdbgrid1.resizeToFit;
end;

procedure TForm1.chkstretchClick(Sender: TObject);
begin
  if chkstretch.checked  then   Panel2Resize(nil);
end;

procedure TForm1.tbookmarksClick(Sender: TObject);
var
  strcountries:string;
  f:integer;
begin
  with xmsdbGrid1.SelectedRows do
    begin
      if count=0 then showmessage('No files are selected')
        else
          begin
            strcountries:='There are '+inttostr(count)+' items selected.  They are:';
            for f:= 0 to Count -1 do
              begin
                // set db grid position to the that of the item #f
                xmsdbGrid1.dataSource.DataSet.bookMark:= Items[f];
                // add the name field of Table1 to our string
                strcountries:=strcountries+' '+Table1Name.asstring+',';
              end;
            strcountries[length(strcountries)]:='.';
            showmessage (strcountries);
          end;
    end;

end;

end.
