// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ExcelGrid.pas' rev: 4.00

#ifndef ExcelGridHPP
#define ExcelGridHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Ddeml.hpp>	// Pascal unit
#include <DBGrids.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <DdeMan.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Excelgrid
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EExcelDDE;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION EExcelDDE : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EExcelDDE(const AnsiString Msg) : Sysutils::Exception(Msg)
		 { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EExcelDDE(const AnsiString Msg, const System::TVarRec * 
		Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EExcelDDE(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EExcelDDE(int Ident, const System::TVarRec * Args, const 
		int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EExcelDDE(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(
		Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EExcelDDE(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EExcelDDE(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EExcelDDE(int Ident, const System::TVarRec * Args
		, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EExcelDDE(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TCustomExcelDDE;
class DELPHICLASS TxlDdeClientConv;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TxlDdeClientConv : public Ddeman::TDdeClientConv 
{
	typedef Ddeman::TDdeClientConv inherited;
	
private:
	bool FCalculated;
	int FWaitStatOffset;
	bool __fastcall GetXlWaitStat(void);
	void __fastcall SetXlWaitStat(bool Value);
	int __fastcall GetWaitStatOffset(void);
	
public:
	HIDESBASE bool __fastcall ExecuteMacroLines(Classes::TStrings* Cmd, bool waitFlg);
	HIDESBASE bool __fastcall ExecuteMacro(char * Cmd, bool waitFlg);
	__property bool xlWaitStat = {read=GetXlWaitStat, write=SetXlWaitStat, nodefault};
public:
	#pragma option push -w-inl
	/* TDdeClientConv.Create */ inline __fastcall virtual TxlDdeClientConv(Classes::TComponent* AOwner)
		 : Ddeman::TDdeClientConv(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TDdeClientConv.Destroy */ inline __fastcall virtual ~TxlDdeClientConv(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCustomExcelDDE : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TxlDdeClientConv* FDDEConv;
	AnsiString FServerName;
	bool FActive;
	Classes::TNotifyEvent FOnConnect;
	Classes::TNotifyEvent FOnDisconnect;
	Classes::TNotifyEvent FOnWait;
	void __fastcall SetServerName(const AnsiString Value);
	void __fastcall Connecting(System::TObject* Sender);
	void __fastcall Disconnecting(System::TObject* Sender);
	void __fastcall SetActive(const bool Value);
	bool __fastcall GetReady(void);
	void __fastcall Waiting(void);
	
public:
	__fastcall virtual TCustomExcelDDE(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomExcelDDE(void);
	void __fastcall Open(void);
	void __fastcall Close(void);
	virtual void __fastcall FindServerApplication(void);
	void __fastcall Execute(const AnsiString Command);
	AnsiString __fastcall Request(const AnsiString Item);
	__property Classes::TNotifyEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property Classes::TNotifyEvent OnDisconnect = {read=FOnDisconnect, write=FOnDisconnect};
	__property AnsiString ServerName = {read=FServerName, write=SetServerName};
	__property TxlDdeClientConv* DDEConv = {read=FDDEConv};
	__property bool Active = {read=FActive, write=SetActive, nodefault};
	__property bool Ready = {read=GetReady, nodefault};
	__property Classes::TNotifyEvent OnWait = {read=FOnWait, write=FOnWait};
};

#pragma pack(pop)

class DELPHICLASS TExcelDDE;
class DELPHICLASS TExcelCell;
class DELPHICLASS TCustomExcelCell;
class DELPHICLASS TExcelBorder;
#pragma option push -b-
enum TExcelBorderLine { xblNone, xblThin, xblMedium, xblDash, xblDot, xblThick, xblDouble, xblVeryThin 
	};
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelBorder : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TExcelBorderLine FOutline;
	TExcelBorderLine FLeft;
	TExcelBorderLine FRight;
	TExcelBorderLine FTop;
	TExcelBorderLine FBottom;
	Classes::TNotifyEvent FOnChange;
	int FDisableCount;
	bool FAssigned;
	
protected:
	void __fastcall SetOutline(TExcelBorderLine Value);
	void __fastcall SetLeft(TExcelBorderLine Value);
	void __fastcall SetRight(TExcelBorderLine Value);
	void __fastcall SetTop(TExcelBorderLine Value);
	void __fastcall SetBottom(TExcelBorderLine Value);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall DisableControls(void);
	void __fastcall EnableControls(void);
	
__published:
	__property TExcelBorderLine Outline = {read=FOutline, write=SetOutline, nodefault};
	__property TExcelBorderLine Left = {read=FLeft, write=SetLeft, nodefault};
	__property TExcelBorderLine Right = {read=FRight, write=SetRight, nodefault};
	__property TExcelBorderLine Top = {read=FTop, write=SetTop, nodefault};
	__property TExcelBorderLine Bottom = {read=FBottom, write=SetBottom, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TExcelBorder(Classes::TComponent* AOwner) : Classes::TComponent(
		AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TExcelBorder(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCustomExcelCell : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FRow;
	int FCol;
	TExcelDDE* FExcel;
	Classes::TAlignment FAlignment;
	Graphics::TFont* FFont;
	TExcelBorder* FBorder;
	void __fastcall SetFont(const Graphics::TFont* Font);
	
protected:
	virtual void __fastcall SetAlignment(Classes::TAlignment Value);
	virtual void __fastcall SetBorder(TExcelBorder* Value);
	virtual void __fastcall UpdateFont(System::TObject* Sender);
	virtual void __fastcall UpdateBorder(System::TObject* Sender);
	
public:
	__fastcall TCustomExcelCell(TExcelDDE* AExcelDDE);
	__fastcall virtual ~TCustomExcelCell(void);
	virtual void __fastcall Select(void) = 0 ;
	__property Classes::TAlignment Alignment = {write=SetAlignment, nodefault};
	__property int Row = {read=FRow, write=FRow, nodefault};
	__property int Col = {read=FCol, write=FCol, nodefault};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property TExcelBorder* Border = {read=FBorder, write=SetBorder};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelCell : public TCustomExcelCell 
{
	typedef TCustomExcelCell inherited;
	
protected:
	virtual bool __fastcall GetAsBoolean(void);
	virtual System::TDateTime __fastcall GetAsDateTime(void);
	virtual double __fastcall GetAsFloat(void);
	virtual int __fastcall GetAsInteger(void);
	virtual AnsiString __fastcall GetAsString(void);
	virtual Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsBoolean(bool Value);
	virtual void __fastcall SetAsDateTime(System::TDateTime Value);
	virtual void __fastcall SetAsFloat(double Value);
	virtual void __fastcall SetAsInteger(int Value);
	virtual void __fastcall SetAsString(const AnsiString Value);
	virtual void __fastcall SetAsVariant(const Variant &Value);
	
public:
	virtual void __fastcall Select(void);
	__property bool AsBoolean = {read=GetAsBoolean, write=SetAsBoolean, nodefault};
	__property System::TDateTime AsDateTime = {read=GetAsDateTime, write=SetAsDateTime};
	__property double AsFloat = {read=GetAsFloat, write=SetAsFloat};
	__property int AsInteger = {read=GetAsInteger, write=SetAsInteger, nodefault};
	__property AnsiString AsString = {read=GetAsString, write=SetAsString};
	__property Variant AsVariant = {read=GetAsVariant, write=SetAsVariant};
public:
	#pragma option push -w-inl
	/* TCustomExcelCell.Create */ inline __fastcall TExcelCell(TExcelDDE* AExcelDDE) : TCustomExcelCell(
		AExcelDDE) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomExcelCell.Destroy */ inline __fastcall virtual ~TExcelCell(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TExcelColumn;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelColumn : public TCustomExcelCell 
{
	typedef TCustomExcelCell inherited;
	
private:
	int FWidth;
	
protected:
	virtual void __fastcall SetWidth(int Value);
	
public:
	virtual void __fastcall Select(void);
	__property int Width = {write=SetWidth, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomExcelCell.Create */ inline __fastcall TExcelColumn(TExcelDDE* AExcelDDE) : TCustomExcelCell(
		AExcelDDE) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomExcelCell.Destroy */ inline __fastcall virtual ~TExcelColumn(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TExcelRow;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelRow : public TCustomExcelCell 
{
	typedef TCustomExcelCell inherited;
	
private:
	int FHeight;
	
protected:
	virtual void __fastcall SetHeight(int Value);
	
public:
	virtual void __fastcall Select(void);
	__property int Height = {write=SetHeight, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomExcelCell.Create */ inline __fastcall TExcelRow(TExcelDDE* AExcelDDE) : TCustomExcelCell(
		AExcelDDE) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomExcelCell.Destroy */ inline __fastcall virtual ~TExcelRow(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TExcelSelection;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelSelection : public TCustomExcelCell 
{
	typedef TCustomExcelCell inherited;
	
private:
	int FRowEnd;
	int FColEnd;
	int FWidth;
	int FHeight;
	
protected:
	virtual void __fastcall SetWidth(int Value);
	virtual void __fastcall SetHeight(int Value);
	
public:
	virtual void __fastcall Select(void);
	__property int Width = {read=FWidth, write=SetWidth, nodefault};
	__property int Height = {read=FHeight, write=SetHeight, nodefault};
	__property int RowEnd = {read=FRowEnd, write=FRowEnd, nodefault};
	__property int ColEnd = {read=FColEnd, write=FColEnd, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomExcelCell.Create */ inline __fastcall TExcelSelection(TExcelDDE* AExcelDDE) : TCustomExcelCell(
		AExcelDDE) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomExcelCell.Destroy */ inline __fastcall virtual ~TExcelSelection(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelDDE : public TCustomExcelDDE 
{
	typedef TCustomExcelDDE inherited;
	
private:
	TExcelCell* FCell;
	TExcelColumn* FColumn;
	TExcelRow* FRow;
	TExcelSelection* FSelection;
	int FDisableCount;
	int FDisableInputCount;
	bool FUseFontCharset;
	TExcelCell* __fastcall GetCell(int Row, int Col);
	TExcelRow* __fastcall GetRow(int Row);
	TExcelColumn* __fastcall GetColumn(int Col);
	TExcelSelection* __fastcall GetSelection(int R1, int C1, int R2, int C2);
	
public:
	__fastcall virtual TExcelDDE(Classes::TComponent* AOwner);
	__fastcall virtual ~TExcelDDE(void);
	void __fastcall NewTable(void);
	void __fastcall CloseTable(void);
	void __fastcall Print(void);
	void __fastcall SaveAs(const AnsiString FileName);
	void __fastcall Save(void);
	void __fastcall Load(const AnsiString FileName);
	void __fastcall Minimize(void);
	void __fastcall Restore(void);
	void __fastcall DisableControls(void);
	void __fastcall EnableControls(void);
	void __fastcall DisableInput(void);
	void __fastcall EnableInput(void);
	__property TExcelCell* Cells[int Row][int Col] = {read=GetCell};
	__property TExcelRow* Rows[int Row] = {read=GetRow};
	__property TExcelColumn* Columns[int Col] = {read=GetColumn};
	__property TExcelSelection* Selection[int R1][int C1][int R2][int C2] = {read=GetSelection};
	
__published:
	__property OnConnect ;
	__property OnDisconnect ;
	__property ServerName ;
	__property bool UseFontCharset = {read=FUseFontCharset, write=FUseFontCharset, nodefault};
	__property OnWait ;
};

#pragma pack(pop)

class DELPHICLASS TExcelDataSet;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelDataSet : public TExcelDDE 
{
	typedef TExcelDDE inherited;
	
private:
	Db::TDataSet* FDataSet;
	int FLeftOrigin;
	int FTopOrigin;
	Graphics::TFont* FFont;
	Graphics::TFont* FTitleFont;
	bool FSilent;
	Classes::TNotifyEvent FBeforeFill;
	Classes::TNotifyEvent FAfterFill;
	
protected:
	virtual void __fastcall SetFont(Graphics::TFont* Value);
	virtual void __fastcall SetTitleFont(Graphics::TFont* Value);
	virtual void __fastcall SetDataSet(Db::TDataSet* Value);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	__fastcall virtual TExcelDataSet(Classes::TComponent* AOwner);
	__fastcall virtual ~TExcelDataSet(void);
	void __fastcall Fill(void);
	
__published:
	__property Db::TDataSet* DataSet = {read=FDataSet, write=SetDataSet};
	__property int LeftOrigin = {read=FLeftOrigin, write=FLeftOrigin, nodefault};
	__property int TopOrigin = {read=FTopOrigin, write=FTopOrigin, nodefault};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property Graphics::TFont* TitleFont = {read=FTitleFont, write=SetTitleFont};
	__property bool Silent = {read=FSilent, write=FSilent, nodefault};
	__property Classes::TNotifyEvent BeforeFill = {read=FBeforeFill, write=FBeforeFill};
	__property Classes::TNotifyEvent AfterFill = {read=FAfterFill, write=FAfterFill};
};

#pragma pack(pop)

class DELPHICLASS TExcelGrid;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExcelGrid : public TExcelDDE 
{
	typedef TExcelDDE inherited;
	
private:
	Dbgrids::TDBGrid* FDBGrid;
	int FLeftOrigin;
	int FTopOrigin;
	Graphics::TFont* FFont;
	Graphics::TFont* FTitleFont;
	bool FSilent;
	Classes::TNotifyEvent FBeforeFill;
	Classes::TNotifyEvent FAfterFill;
	bool FUseGridFont;
	bool FUseGridTitleFont;
	bool FUseGridSelection;
	
protected:
	virtual void __fastcall SetFont(Graphics::TFont* Value);
	virtual void __fastcall SetTitleFont(Graphics::TFont* Value);
	virtual void __fastcall SetDBGrid(Dbgrids::TDBGrid* Value);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	__fastcall virtual TExcelGrid(Classes::TComponent* AOwner);
	__fastcall virtual ~TExcelGrid(void);
	void __fastcall Fill(void);
	
__published:
	__property Dbgrids::TDBGrid* DBGrid = {read=FDBGrid, write=SetDBGrid};
	__property int LeftOrigin = {read=FLeftOrigin, write=FLeftOrigin, nodefault};
	__property int TopOrigin = {read=FTopOrigin, write=FTopOrigin, nodefault};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property Graphics::TFont* TitleFont = {read=FTitleFont, write=SetTitleFont};
	__property bool Silent = {read=FSilent, write=FSilent, nodefault};
	__property Classes::TNotifyEvent BeforeFill = {read=FBeforeFill, write=FBeforeFill};
	__property Classes::TNotifyEvent AfterFill = {read=FAfterFill, write=FAfterFill};
	__property bool UseGridFont = {read=FUseGridFont, write=FUseGridFont, nodefault};
	__property bool UseGridTitleFont = {read=FUseGridTitleFont, write=FUseGridTitleFont, nodefault};
	__property bool UseGridSelection = {read=FUseGridSelection, write=FUseGridSelection, nodefault};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);
extern PACKAGE void __fastcall NavigateURL(wchar_t * Target);

}	/* namespace Excelgrid */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Excelgrid;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ExcelGrid
