unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Grids, DBGrids, Db, DBTables, ExcelGrid, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    ExcelDataSet1: TExcelDataSet;
    ExcelDDE1: TExcelDDE;
    ExcelGrid1: TExcelGrid;
    Table1: TTable;
    DataSource1: TDataSource;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1City: TStringField;
    Table1State: TStringField;
    Table1Zip: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1TaxRate: TFloatField;
    Table1Contact: TStringField;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    btnConnect: TButton;
    btnDisconnect: TButton;
    cbUseFontCharset1: TCheckBox;
    Bevel1: TBevel;
    btnMinimize: TButton;
    btnRestore: TButton;
    Bevel3: TBevel;
    btnNewTable: TButton;
    btnCloseTable: TButton;
    btnPrint: TButton;
    btnSave: TButton;
    btnLoad: TButton;
    btnSaveAs: TButton;
    btnFill2: TButton;
    btnFill3: TButton;
    cbSilent1: TCheckBox;
    cbUser1: TCheckBox;
    cbCharset2: TCheckBox;
    cbSilent2: TCheckBox;
    cbUser2: TCheckBox;
    cbCharset3: TCheckBox;
    cbSilent3: TCheckBox;
    cbUser3: TCheckBox;
    cbSelection: TCheckBox;
    cbTitleFont: TCheckBox;
    cbFont: TCheckBox;
    Bevel4: TBevel;
    Bevel5: TBevel;
    Button1: TButton;
    PageControl2: TPageControl;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    btnFill: TButton;
    btnRows: TButton;
    btnColumns: TButton;
    btnSelection: TButton;
    btnBorder: TButton;
    edtRow1: TEdit;
    edtCol1: TEdit;
    btnFont: TButton;
    edtRow2: TEdit;
    edtCol2: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    edtR1: TEdit;
    edtC1: TEdit;
    edtR2: TEdit;
    edtC2: TEdit;
    btnGet: TButton;
    StringGrid1: TStringGrid;
    procedure btnConnectClick(Sender: TObject);
    procedure ExcelDDE1Connect(Sender: TObject);
    procedure btnDisconnectClick(Sender: TObject);
    procedure ExcelDDE1Disconnect(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnMinimizeClick(Sender: TObject);
    procedure btnRestoreClick(Sender: TObject);
    procedure btnNewTableClick(Sender: TObject);
    procedure btnCloseTableClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnSaveAsClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure btnFillClick(Sender: TObject);
    procedure cbUseFontCharset1Click(Sender: TObject);
    procedure btnRowsClick(Sender: TObject);
    procedure btnFill2Click(Sender: TObject);
    procedure btnFill3Click(Sender: TObject);
    procedure btnColumnsClick(Sender: TObject);
    procedure btnSelectionClick(Sender: TObject);
    procedure btnBorderClick(Sender: TObject);
    procedure btnFontClick(Sender: TObject);
    procedure cbSilent1Click(Sender: TObject);
    procedure cbUser1Click(Sender: TObject);
    procedure cbCharset2Click(Sender: TObject);
    procedure cbSilent2Click(Sender: TObject);
    procedure cbUser2Click(Sender: TObject);
    procedure cbCharset3Click(Sender: TObject);
    procedure cbSilent3Click(Sender: TObject);
    procedure cbUser3Click(Sender: TObject);
    procedure cbSelectionClick(Sender: TObject);
    procedure cbTitleFontClick(Sender: TObject);
    procedure cbFontClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure btnGetClick(Sender: TObject);
  private
    { Private declarations }
    procedure EnableButtons(Value : Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function GetEditValue(E : TEdit) : integer;
begin
  try
    Result := StrToInt(E.Text);
  except
    Result := 0;
  end;
end;

procedure TForm1.EnableButtons(Value : Boolean);
var
  i : integer;
begin
  for i:=0 to ComponentCount-1 do
  begin
    if Components[i] is TButton then
    with Components[i] as TButton do
    begin
      if Tag=1 then Enabled := Value;
    end;
  end;
end;

procedure TForm1.btnConnectClick(Sender: TObject);
begin
  ExcelDDE1.Open;
end;

procedure TForm1.ExcelDDE1Connect(Sender: TObject);
begin
  EnableButtons(True);
  btnConnect.Enabled := False;
  btnDisconnect.Enabled := True;
end;

procedure TForm1.btnDisconnectClick(Sender: TObject);
begin
  ExcelDDE1.Close;
end;

procedure TForm1.ExcelDDE1Disconnect(Sender: TObject);
begin
  EnableButtons(False);
  btnConnect.Enabled := True;
  btnDisconnect.Enabled := False;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ExcelDDE1.Close;
end;

procedure TForm1.btnMinimizeClick(Sender: TObject);
begin
  ExcelDDE1.Minimize;
end;

procedure TForm1.btnRestoreClick(Sender: TObject);
begin
  ExcelDDE1.Restore;
end;

procedure TForm1.btnNewTableClick(Sender: TObject);
begin
  ExcelDDE1.NewTable;
end;

procedure TForm1.btnCloseTableClick(Sender: TObject);
begin
  ExcelDDE1.CloseTable;
end;

procedure TForm1.btnPrintClick(Sender: TObject);
begin
  ExcelDDE1.Print;
end;

procedure TForm1.btnSaveClick(Sender: TObject);
begin
  ExcelDDE1.Save;
end;

procedure TForm1.btnSaveAsClick(Sender: TObject);
begin
  with TSaveDialog.Create(Self) do
  try
    DefaultExt := 'xls';
    if Execute then
    begin
      ExcelDDE1.SaveAs(FileName);
    end;
  finally
    Free;
  end;
end;

procedure TForm1.btnLoadClick(Sender: TObject);
begin
  with TOpenDialog.Create(Self) do
  try
    DefaultExt := 'xls';
    if Execute then
    begin
      ExcelDDE1.Load(FileName);
    end;
  finally
    Free;
  end;
end;

procedure TForm1.btnFillClick(Sender: TObject);
var
  i, j : integer;
begin
  EnableButtons(False);

  btnFill2.Enabled := False;
  btnFill3.Enabled := False;

  for i:=GetEditValue(edtRow1) to GetEditValue(edtRow2) do
   for j:=GetEditValue(edtCol1) to GetEditValue(edtCol2) do
    ExcelDDE1.Cells[i, j].AsString := Edit1.Text;

  EnableButtons(True);

  btnFill2.Enabled := True;
  btnFill3.Enabled := True;
end;

procedure TForm1.cbUseFontCharset1Click(Sender: TObject);
begin
  ExcelDDE1.UseFontCharset := cbUseFontCharset1.Checked;
end;

procedure TForm1.btnRowsClick(Sender: TObject);
var
  R : integer;
begin
  R := GetEditValue(edtRow1);
  ExcelDDE1.Rows[R].Alignment := taCenter;
  ExcelDDE1.Rows[R].Height := 14;
end;

procedure TForm1.btnColumnsClick(Sender: TObject);
var
  C : integer;
begin
  C := GetEditValue(edtCol1);
  ExcelDDE1.Columns[C].Font.Style := [fsBold];
  ExcelDDE1.Columns[C].Font.Name := 'Arial';
  ExcelDDE1.Columns[C].Width := 20;
end;

procedure TForm1.btnSelectionClick(Sender: TObject);
var
  R1, C1, R2, C2 : integer;
begin
  R1 := GetEditValue(edtRow1);
  C1 := GetEditValue(edtCol1);
  R2 := GetEditValue(edtRow2);
  C2 := GetEditValue(edtCol2);
  ExcelDDE1.Selection[R1, C1, R2, C2].Select;
end;

procedure TForm1.btnBorderClick(Sender: TObject);
var
  R1, C1, R2, C2 : integer;
begin
  R1 := GetEditValue(edtRow1);
  C1 := GetEditValue(edtCol1);
  R2 := GetEditValue(edtRow2);
  C2 := GetEditValue(edtCol2);
  with ExcelDDE1.Selection[R1, C1, R2, C2].Border do
  begin
    DisableControls;
    Outline := xblMedium;
    Left := xblThin;
    Right := xblThin;
    Bottom := xblThin;
    Top := xblThin;
    EnableControls;
  end;
end;

procedure TForm1.btnFontClick(Sender: TObject);
var
  R1, C1, R2, C2 : integer;
begin
  R1 := GetEditValue(edtRow1);
  C1 := GetEditValue(edtCol1);
  R2 := GetEditValue(edtRow2);
  C2 := GetEditValue(edtCol2);
  ExcelDDE1.Selection[R1, C1, R2, C2].Font.Name := 'Times New Roman';
  ExcelDDE1.Selection[R1, C1, R2, C2].Font.Size := 12;
end;

procedure TForm1.btnFill2Click(Sender: TObject);
begin
  ExcelDataSet1.Open;
  try
    ExcelDataSet1.NewTable;
    ExcelDataSet1.Fill;
    ExcelDataSet1.Restore;
  finally
    ExcelDataSet1.Close;
  end;
end;

procedure TForm1.btnFill3Click(Sender: TObject);
begin
  ExcelGrid1.Open;
  try
    ExcelGrid1.NewTable;
    ExcelGrid1.Fill;
    ExcelGrid1.Restore;
  finally
    ExcelGrid1.Close;
  end;
end;

procedure TForm1.cbSilent1Click(Sender: TObject);
begin
  if cbSilent1.Checked then ExcelDDE1.DisableControls
                       else ExcelDDE1.EnableControls;
end;

procedure TForm1.cbUser1Click(Sender: TObject);
begin
  if cbUser1.Checked then ExcelDDE1.DisableInput
                     else ExcelDDE1.EnableInput;
end;

procedure TForm1.cbCharset2Click(Sender: TObject);
begin
  ExcelDataSet1.UseFontCharset := cbCharset2.Checked;
end;

procedure TForm1.cbSilent2Click(Sender: TObject);
begin
  if cbSilent2.Checked then ExcelDataSet1.DisableControls
                       else ExcelDataSet1.EnableControls;
end;

procedure TForm1.cbUser2Click(Sender: TObject);
begin
  if cbUser2.Checked then ExcelDataSet1.DisableInput
                     else ExcelDataSet1.EnableInput;
end;

procedure TForm1.cbCharset3Click(Sender: TObject);
begin
  ExcelGrid1.UseFontCharset := cbCharset3.Checked;
end;

procedure TForm1.cbSilent3Click(Sender: TObject);
begin
  if cbSilent3.Checked then ExcelGrid1.DisableControls
                       else ExcelGrid1.EnableControls;
end;

procedure TForm1.cbUser3Click(Sender: TObject);
begin
  if cbUser3.Checked then ExcelGrid1.DisableInput
                     else ExcelGrid1.EnableInput;
end;

procedure TForm1.cbSelectionClick(Sender: TObject);
begin
  ExcelGrid1.UseGridSelection := cbSelection.Checked;
end;

procedure TForm1.cbTitleFontClick(Sender: TObject);
begin
  ExcelGrid1.UseGridTitleFont := cbTitleFont.Checked;
end;

procedure TForm1.cbFontClick(Sender: TObject);
begin
  ExcelGrid1.UseGridFont := cbFont.Checked;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  NavigateURL('http://www.smart.ru/igo/excelgrid.htm');
end;

procedure TForm1.btnGetClick(Sender: TObject);
var
  i, j, r1, r2, c1, c2 : integer;
begin
  EnableButtons(False);

  btnFill2.Enabled := False;
  btnFill3.Enabled := False;

  R1 := GetEditValue(edtR1);
  R2 := GetEditValue(edtR2);
  if (r2-r1)>0 then StringGrid1.RowCount := r2-r1+1;
  c1 := GetEditValue(edtC1);
  c2 := GetEditValue(edtC2);
  if (c2-c1)>0 then StringGrid1.ColCount := c2-c1+1;
  for i:=r1 to r2 do
  begin
    for j:=c1 to c2 do
    begin
      StringGrid1.Cells[j-c1, i-r1] := ExcelDDE1.Cells[i, j].AsString;
    end;
  end;

  EnableButtons(True);

  btnFill2.Enabled := True;
  btnFill3.Enabled := True;
end;

end.

