unit XFilesUnit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Grids, XDBGrids, StdCtrls, ExtCtrls, ComCtrls, Mask,
  XQRGrids, Menus;

type
  TXFilesForm2 = class(TForm)
    SaveDialog: TSaveDialog;
    OrdersPanel: TPanel;
      XDBGrid1: TXDBGrid;
        DataSource1: TDataSource;
          Table1: TTable;
          Query1: TQuery;
          UpdateSQL1: TUpdateSQL;
          Database1: TDatabase;
      XQRGrid1: TXQRGrid;
      XDBGrid2: TXDBGrid;
        DataSource2: TDataSource;
          Query2: TQuery;
    OperatePanel: TPanel;
      CommentsPanel: TPanel;
        Label1: TLabel;
        Label2: TLabel;
        Label3: TLabel;
        Label4: TLabel;
        Bevel1: TBevel;
        Bevel2: TBevel;
        Bevel3: TBevel;
        Bevel4: TBevel;
        Label5: TLabel;
        Label6: TLabel;
        Label7: TLabel;
        Label8: TLabel;
        Label9: TLabel;
        Label10: TLabel;
        Label11: TLabel;
        Label12: TLabel;
        CheckBox1: TCheckBox;
        CheckBox2: TCheckBox;
        CheckBox3: TCheckBox;
        CheckBox4: TCheckBox;
      ReportPanel: TPanel;
        ReportLabel: TLabel;
        PrintButton: TButton;
        PrintAllButton: TButton;
        PreviewButton: TButton;
        ShowReportButton: TButton;
        SaveReportButton: TButton;
        ByPaymentCheckBox: TCheckBox;
        OnNewPageCheckBox: TCheckBox;
        AlignLabel: TLabel;
        AlignComboBox: TComboBox;
        PartLabel: TLabel;
        PartMaskEdit: TMaskEdit;
        PartUpDown: TUpDown;
    FillerPopupMenu: TPopupMenu;
      AutoUnselectOff: TMenuItem;
      ExtendedSelect: TMenuItem;
      Break1: TMenuItem;
      SelectAll: TMenuItem;
      InvertAll: TMenuItem;
      UnselectAll: TMenuItem;
      Break2: TMenuItem;
      InvertRow: TMenuItem;
      SelectRows: TMenuItem;
      InvertRows: TMenuItem;
      Break3: TMenuItem;
      SetSelectionAnchor: TMenuItem;
      ClearSelectionAnchor: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Table1AfterChange(DataSet: TDataSet);
    procedure Query1AfterChange(DataSet: TDataSet);
    procedure XDBGrid1PaintColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TXColumn; Highlight: Boolean; Selections: TSelections;
      var Color: TColor; Font: TFont; var Image: TPersistent);
    procedure XDBGrid1ColumnMoving(Sender: TObject; FromIndex, ToIndex: Integer; var Accept: Boolean);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    {Extended selection}
    procedure XDBGrid1FillerClick(Sender: TObject);
    procedure AutoUnselectOffClick(Sender: TObject);
    procedure ExtendedSelectClick(Sender: TObject);
    procedure SelectAllClick(Sender: TObject);
    procedure InvertAllClick(Sender: TObject);
    procedure UnselectAllClick(Sender: TObject);
    procedure InvertRowClick(Sender: TObject);
    procedure SelectRowsClick(Sender: TObject);
    procedure InvertRowsClick(Sender: TObject);
    procedure SetSelectionAnchorClick(Sender: TObject);
    procedure ClearSelectionAnchorClick(Sender: TObject);
    {Print & Preview}
    procedure PrintButtonClick(Sender: TObject);
    procedure PrintAllButtonClick(Sender: TObject);
    procedure PreviewButtonClick(Sender: TObject);
    procedure ShowReportButtonClick(Sender: TObject);
    procedure SaveReportButtonClick(Sender: TObject);
    procedure ReportChange(Sender: TObject);
    procedure ByPaymentCheckBoxClick(Sender: TObject);
    procedure OnNewPageCheckBoxClick(Sender: TObject);
  end;

var
  XFilesForm2: TXFilesForm2;

implementation

{$R *.DFM}

{This demo ilustrate using MasterGrid property to obtain XDBGrid summarization.}
{Additional, many new properties are defined into XDBGrid1 columns. Check it.  }

procedure TXFilesForm2.FormCreate(Sender: TObject);
begin
  ClientWidth := ClientWidth + (GetSystemMetrics(SM_CXVSCROLL) - 16);
  ClientHeight := ClientHeight + (GetSystemMetrics(SM_CYHSCROLL) - 16);
  AlignComboBox.ItemIndex := Ord(XQRGrid1.ReportAlign);
  PartUpDown.Position := XQRGrid1.ReportPart;
end;

procedure TXFilesForm2.Table1AfterChange(DataSet: TDataSet);
begin
  Query2.DisableControls;
  try
    Query2.Close;
    Query2.Open;
  finally
    Query2.EnableControls;
  end;
end;

procedure TXFilesForm2.Query1AfterChange(DataSet: TDataSet);
begin
  Database1.ApplyUpdates([Query1]);
  Query2.DisableControls;
  try
    Query2.Close;
    Query2.Open;
  finally
    Query2.EnableControls;
  end;
end;

procedure TXFilesForm2.XDBGrid1PaintColumnCell(Sender: TObject;
  const Rect: TRect; DataCol: Integer; Column: TXColumn; Highlight: Boolean;
  Selections: TSelections; var Color: TColor; Font: TFont; var Image: TPersistent);
begin
  if (slCellSelected in Selections) or (slCellFixed in Selections) then Exit;
  if slRowSelected in Selections then
    if Query1.State in dsEditModes then Color := clRed else Color := $00646464 else
  if slMultiSelected in Selections then Color := clInactiveCaption;
end;

procedure TXFilesForm2.XDBGrid1ColumnMoving(Sender: TObject; FromIndex,
  ToIndex: Integer; var Accept: Boolean);
begin
  Accept := (FromIndex <> 12) and (ToIndex <> 12); {Don't move last column}
end;

procedure TXFilesForm2.CheckBox1Click(Sender: TObject);
begin
{$IFDEF VER100}{Delphi 3}
  XDBGrid1.ColumnByName('TaxRate').WidthBase := Ord(CheckBox1.Checked) * 48;
{$ELSE}
{$IFDEF VER110}{C++Builder 3}
  XDBGrid1.ColumnByName('TaxRate').WidthBase := Ord(CheckBox1.Checked) * 48;
{$ELSE}
  XDBGrid1.ColumnByName('TaxRate').Visible := CheckBox1.Checked;
{$ENDIF VER110}
{$ENDIF VER100}
  XDBGrid1.SetFocus;
end;

procedure TXFilesForm2.CheckBox2Click(Sender: TObject);
begin
  with XDBGrid2 do
    if MasterGrid <> nil then MasterGrid := nil else MasterGrid := XDBGrid1;
  XDBGrid1.SetFocus;
end;

procedure TXFilesForm2.CheckBox3Click(Sender: TObject);
begin
  with XDBGrid1 do StretchMode := not StretchMode;
  XDBGrid1.SetFocus;
end;

procedure TXFilesForm2.CheckBox4Click(Sender: TObject);
begin
  with XDBGrid1 do
    if not (dgRowSelect in Options) then Options := Options + [dgRowSelect]
    else Options := Options - [dgRowSelect] + [dgEditing];
  XDBGrid1.SetFocus;
end;

{Extended selection}

procedure TXFilesForm2.XDBGrid1FillerClick(Sender: TObject);
var
  P: TPoint;
begin
  P := ClientToScreen(Point(0, XDBGrid1.TitleHeight));
  FillerPopupMenu.Popup(P.X + 2, P.Y + 2);
end;

procedure TXFilesForm2.AutoUnselectOffClick(Sender: TObject);
begin
  with AutoUnselectOff do
  begin
    Checked := not Checked;
    with XDBGrid1 do
      if Checked then Options := Options + [dgAutoUnselectOff]
      else Options := Options - [dgAutoUnselectOff];
    UnselectAll.Enabled := Checked or ExtendedSelect.Checked;
  end;
end;

procedure TXFilesForm2.ExtendedSelectClick(Sender: TObject);
begin
  with ExtendedSelect do
  begin
    Checked := not Checked;
    with XDBGrid1 do
      if Checked then Options := Options + [dgExtendedSelect]
      else Options := Options - [dgExtendedSelect];
    SelectAll.Enabled := Checked;
    InvertAll.Enabled := Checked;
    UnselectAll.Enabled := Checked or AutoUnselectOff.Checked;
    SelectRows.Enabled := Checked;
    InvertRows.Enabled := Checked;
    SetSelectionAnchor.Enabled := Checked;
    ClearSelectionAnchor.Enabled := Checked;
  end;
end;

procedure TXFilesForm2.SelectAllClick(Sender: TObject);
begin
  XDBGrid1.SelectAll;
end;

procedure TXFilesForm2.InvertAllClick(Sender: TObject);
begin
  XDBGrid1.InvertAll;
end;

procedure TXFilesForm2.UnselectAllClick(Sender: TObject);
begin
  XDBGrid1.UnselectAll;
end;

procedure TXFilesForm2.InvertRowClick(Sender: TObject);
begin
  with XDBGrid1.SelectedRows do
    CurrentRowSelected := not CurrentRowSelected;
end;

procedure TXFilesForm2.SelectRowsClick(Sender: TObject);
begin
  XDBGrid1.SelectRows;
end;

procedure TXFilesForm2.InvertRowsClick(Sender: TObject);
begin
  XDBGrid1.InvertRows;
end;

procedure TXFilesForm2.SetSelectionAnchorClick(Sender: TObject);
begin
  with XDBGrid1 do
    SelectionAnchor := DataSource.DataSet.Bookmark;
end;

procedure TXFilesForm2.ClearSelectionAnchorClick(Sender: TObject);
begin
  XDBGrid1.SelectionAnchor := '';
end;

{Print & Preview}

procedure TXFilesForm2.PrintButtonClick(Sender: TObject);
begin
  XQRGrid1.Print;
end;

procedure TXFilesForm2.PrintAllButtonClick(Sender: TObject);
begin
  XQRGrid1.PrintAll;
end;

procedure TXFilesForm2.PreviewButtonClick(Sender: TObject);
begin
  XQRGrid1.Preview;
end;

procedure TXFilesForm2.ShowReportButtonClick(Sender: TObject);
begin
  XQRGrid1.ShowReport;
end;

procedure TXFilesForm2.SaveReportButtonClick(Sender: TObject);
begin
  if SaveDialog.Execute then XQRGrid1.SaveReport(SaveDialog.FileName);
end;

procedure TXFilesForm2.ReportChange(Sender: TObject);
begin
  XQRGrid1.ReportAlign := TXReportAlign(AlignComboBox.ItemIndex);
  XQRGrid1.ReportPart := PartUpDown.Position;
end;

procedure TXFilesForm2.ByPaymentCheckBoxClick(Sender: TObject);
begin
  if ByPaymentCheckBox.Checked then
  begin
    XQRGrid1.ReportBands.GroupExpression := 'PaymentMethod';
    XDBGrid1.ColumnByName('PaymentMethod').Report.Visible := False;
  end else
  begin
    XQRGrid1.ReportBands.GroupExpression := '';
    XDBGrid1.ColumnByName('PaymentMethod').Report.Visible := True;
  end;
end;

procedure TXFilesForm2.OnNewPageCheckBoxClick(Sender: TObject);
begin
  if OnNewPageCheckBox.Checked then
    XQRGrid1.Options := XQRGrid1.Options + [roGroupForceNewPage]
  else
    XQRGrid1.Options := XQRGrid1.Options - [roGroupForceNewPage];
end;

end.
