// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'WebCopy.pas' rev: 3.00

#ifndef WebCopyHPP
#define WebCopyHPP
#include <ShellAPI.hpp>
#include <StdCtrls.hpp>
#include <ComCtrls.hpp>
#include <WinInet.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Webcopy
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TWCopyThread;
class DELPHICLASS TWebCopy;
class DELPHICLASS TWebCopyItems;
class DELPHICLASS TWebCopyItem;
class PASCALIMPLEMENTATION TWebCopyItems : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	Classes::TComponent* fOwner;
	HIDESBASE TWebCopyItem* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TWebCopyItem* Value);
	int __fastcall GetActiveItems(void);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	
public:
	__fastcall TWebCopyItems(Classes::TComponent* aOwner);
	HIDESBASE TWebCopyItem* __fastcall Add(void);
	HIDESBASE TWebCopyItem* __fastcall Insert(int index);
	__property TWebCopyItem* Items[int Index] = {read=GetItem, write=SetItem};
	__property int ActiveItems = {read=GetActiveItems, nodefault};
public:
	/* TCollection.Destroy */ __fastcall virtual ~TWebCopyItems(void) { }
	
};

typedef void __fastcall (__closure *TWebCopyError)(System::TObject* Sender, int errorcode);

typedef void __fastcall (__closure *TWebCopyThreadDone)(System::TObject* Sender);

typedef void __fastcall (__closure *TWebCopyFileDone)(System::TObject* Sender, int idx);

typedef void __fastcall (__closure *TWebCopyFileStart)(System::TObject* Sender, int idx);

typedef void __fastcall (__closure *TWebCopyConnectError)(System::TObject* Sender);

typedef void __fastcall (__closure *TWebCopyURLNotFound)(System::TObject* Sender, System::AnsiString 
	url);

typedef void __fastcall (__closure *TWebCopyCancel)(System::TObject* Sender);

typedef void __fastcall (__closure *TWebCopyOverwrite)(System::TObject* Sender, System::AnsiString tgtfile
	, bool &allow);

typedef void __fastcall (__closure *TWebCopyProgress)(System::TObject* Sender, int fileidx, int size
	, int totsize);

class PASCALIMPLEMENTATION TWebCopy : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool fAlwaysOnTop;
	int ffilenum;
	bool fcancelled;
	Forms::TForm* fform;
	bool fformClosed;
	Comctrls::TProgressBar* fprogress;
	Stdctrls::TLabel* ffilelbl;
	Stdctrls::TLabel* fsizelbl;
	Stdctrls::TLabel* fratelbl;
	Stdctrls::TButton* fcancelbtn;
	Stdctrls::TButton* fbtnshowfile;
	Stdctrls::TButton* fbtnshowfolder;
	Comctrls::TAnimate* fanim;
	System::AnsiString fLastFile;
	System::AnsiString fLastDir;
	System::AnsiString fDlgCaption;
	System::AnsiString fFileLabel;
	System::AnsiString fProgressLabel;
	System::AnsiString fRateLabel;
	System::AnsiString fProxy;
	System::AnsiString fProxyUserID;
	System::AnsiString fProxyPassword;
	TWebCopyItems* fItems;
	void *fHinternet;
	TWebCopyError fOnError;
	TWebCopyThreadDone fOnCopyDone;
	TWebCopyFileDone fOnFileDone;
	TWebCopyFileStart fOnFileStart;
	TWebCopyConnectError fOnConnectError;
	TWebCopyURLNotFound fOnURLNotFound;
	TWebCopyCancel fOnCopyCancel;
	TWebCopyOverwrite fOnCopyOverwrite;
	TWebCopyProgress fOnCopyProgress;
	bool fShowDialog;
	System::AnsiString fFileOfLabel;
	System::AnsiString fFromServerLabel;
	bool fShowOpenFolder;
	bool fShowOpenFile;
	bool __fastcall HttpGetFile(System::AnsiString url, System::AnsiString tgtdir, System::AnsiString tgtfn
		);
	bool __fastcall FileGetFile(System::AnsiString fuserid, System::AnsiString fpassword, System::AnsiString 
		fhost, int fPort, System::AnsiString url, System::AnsiString tgtdir, System::AnsiString tgtfn);
	bool __fastcall FtpGetFile(System::AnsiString fuserid, System::AnsiString fpassword, System::AnsiString 
		fhost, int fPort, System::AnsiString url, System::AnsiString tgtdir, System::AnsiString tgtfn);
	System::AnsiString __fastcall MakeProxyUrl(System::AnsiString url);
	System::AnsiString __fastcall ExtractServer(System::AnsiString url);
	void __fastcall CreateForm(void);
	void __fastcall ThreadDone(System::TObject* Sender);
	
protected:
	void __fastcall CancelClick(System::TObject* sender);
	void __fastcall OpenFile(System::TObject* sender);
	void __fastcall OpenFolder(System::TObject* sender);
	
public:
	void __fastcall Execute(void);
	void __fastcall ThreadExecute(void);
	void __fastcall DoCopy(void);
	void __fastcall DoThreadCopy(void);
	__fastcall virtual TWebCopy(Classes::TComponent* aOwner);
	__fastcall virtual ~TWebCopy(void);
	__property Forms::TForm* ProgressForm = {read=fform};
	__property Comctrls::TProgressBar* ProgressBar = {read=fprogress};
	__property Stdctrls::TLabel* ProgressFileLabel = {read=ffilelbl};
	__property Stdctrls::TLabel* ProgressSizeLabel = {read=fsizelbl};
	__property Stdctrls::TLabel* ProgressRateLabel = {read=fratelbl};
	__property bool FormClosed = {read=fformClosed, write=fformClosed, nodefault};
	
__published:
	__property bool AlwaysOnTop = {read=fAlwaysOnTop, write=fAlwaysOnTop, default=0};
	__property System::AnsiString Proxy = {read=fProxy, write=fProxy};
	__property System::AnsiString ProxyUserID = {read=fProxyUserID, write=fProxyUserID};
	__property System::AnsiString ProxyPassword = {read=fProxyPassword, write=fProxyPassword};
	__property System::AnsiString DlgCaption = {read=fDlgCaption, write=fDlgCaption};
	__property System::AnsiString DlgFileLabel = {read=fFileLabel, write=fFileLabel};
	__property System::AnsiString DlgFileOfLabel = {read=fFileOfLabel, write=fFileOfLabel};
	__property System::AnsiString DlgFromServerLabel = {read=fFromServerLabel, write=fFromServerLabel};
		
	__property System::AnsiString DlgProgressLabel = {read=fProgressLabel, write=fProgressLabel};
	__property System::AnsiString DlgRateLabel = {read=fRateLabel, write=fRateLabel};
	__property TWebCopyItems* Items = {read=fItems, write=fItems};
	__property bool ShowDialog = {read=fShowDialog, write=fShowDialog, nodefault};
	__property bool ShowOpenFile = {read=fShowOpenFile, write=fShowOpenFile, nodefault};
	__property bool ShowOpenFolder = {read=fShowOpenFolder, write=fShowOpenFolder, nodefault};
	__property TWebCopyConnectError OnConnectError = {read=fOnConnectError, write=fOnConnectError};
	__property TWebCopyCancel OnCopyCancel = {read=fOnCopyCancel, write=fOnCopyCancel};
	__property TWebCopyThreadDone OnCopyDone = {read=fOnCopyDone, write=fOnCopyDone};
	__property TWebCopyOverwrite OnCopyOverWrite = {read=fOnCopyOverwrite, write=fOnCopyOverwrite};
	__property TWebCopyProgress OnCopyProgress = {read=fOnCopyProgress, write=fOnCopyProgress};
	__property TWebCopyError OnError = {read=fOnError, write=fOnError};
	__property TWebCopyFileDone OnFileDone = {read=fOnFileDone, write=fOnFileDone};
	__property TWebCopyFileStart OnFileStart = {read=fOnFileStart, write=fOnFileStart};
	__property TWebCopyURLNotFound OnURLNotFound = {read=fOnURLNotFound, write=fOnURLNotFound};
};

class PASCALIMPLEMENTATION TWCopyThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	TWebCopy* webcopy;
	
protected:
	virtual void __fastcall Execute(void);
	
public:
	__fastcall TWCopyThread(TWebCopy* awebcopy);
public:
	/* TThread.Destroy */ __fastcall virtual ~TWCopyThread(void) { }
	
};

enum TWebCopyProtocol { wpHttp, wpFtp, wpFile };

class PASCALIMPLEMENTATION TWebCopyItem : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	System::AnsiString fURL;
	System::AnsiString fTargetDir;
	System::AnsiString fTargetFilename;
	TWebCopyProtocol fProtocol;
	System::AnsiString fFTPHost;
	System::AnsiString fFTPUserID;
	System::AnsiString fFTPPassword;
	int fFTPPort;
	bool fActive;
	bool fSuccess;
	
public:
	__fastcall virtual TWebCopyItem(Classes::TCollection* Collection);
	__property bool Success = {read=fSuccess, nodefault};
	
__published:
	__property bool Active = {read=fActive, write=fActive, default=1};
	__property System::AnsiString FTPHost = {read=fFTPHost, write=fFTPHost};
	__property System::AnsiString FTPUserID = {read=fFTPUserID, write=fFTPUserID};
	__property System::AnsiString FTPPassword = {read=fFTPPassword, write=fFTPPassword};
	__property int FTPPort = {read=fFTPPort, write=fFTPPort, nodefault};
	__property TWebCopyProtocol Protocol = {read=fProtocol, write=fProtocol, nodefault};
	__property System::AnsiString TargetDir = {read=fTargetDir, write=fTargetDir};
	__property System::AnsiString TargetFilename = {read=fTargetFilename, write=fTargetFilename};
	__property System::AnsiString URL = {read=fURL, write=fURL};
public:
	/* TCollectionItem.Destroy */ __fastcall virtual ~TWebCopyItem(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define errFilesIdentical (Byte)(0)
#define errCannotOpenSourceFile (Byte)(1)
#define errSourceFileZeroLength (Byte)(2)
#define errCannotCreateTargetFile (Byte)(3)
#define errCopyReadFailure (Byte)(4)
#define errCopyWriteFailure (Byte)(5)

}	/* namespace Webcopy */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Webcopy;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// WebCopy
