unit WavePlayer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  mMsystem,ExtCtrls, ComCtrls, Menus, StdCtrls, Buttons, Db, DBTables, DBCtrls,
  MPlayer, Generic, dbmeter, WaveRecorder;

type
  TfmRecorder = class(TForm)
    gbWave: TGroupBox;
    ImportBtn: TBitBtn;
    btnClear: TBitBtn;
    StopBtn: TBitBtn;
    PauseBtn: TBitBtn;
    PlayBtn: TBitBtn;
    RecordBtn: TBitBtn;
    btnExit: TBitBtn;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Import1: TMenuItem;
    Export1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Player1: TMenuItem;
    Play1: TMenuItem;
    Pause1: TMenuItem;
    Stop1: TMenuItem;
    N2: TMenuItem;
    Record1: TMenuItem;
    muOption: TMenuItem;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Timer1: TTimer;
    muRecOption: TMenuItem;
    pnDisplay: TPanel;
    Memo1: TListBox;
    Panel3: TPanel;
    Gauge1: Tdbmeter;
    Gauge2: Tdbmeter;
    Gauge3: Tdbmeter;
    Gauge4: Tdbmeter;
    Gauge5: Tdbmeter;
    Gauge6: Tdbmeter;
    Gauge7: Tdbmeter;
    Gauge8: Tdbmeter;
    Wave: TWaveRecorder;
    procedure ImportBtnClick(Sender: TObject);
    procedure ExportBtnClick(Sender: TObject);
    procedure RecordBtnClick(Sender: TObject);
    procedure PlayBtnClick(Sender: TObject);
    procedure PauseBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure WavePlayed(Sender: TObject);
    procedure WaveRecorded(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnExitClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure WaveUpdateStatistics(Sender: TObject);
  private
    { Private declarations }
    OldHandler : TNotifyEvent;
    procedure RecordLevelChange(Sender: TObject);
    procedure LocalOnHint( sender : TObject);
  public
    { Public declarations }
    procedure Initialize;
  end;

var
  fmRecorder: TfmRecorder;

implementation

{$R *.DFM}

//******************* TfmDBRecorder.Initialize *************************
Procedure TfmRecorder.Initialize;
Var
   i,
   RecordingLevel          : DWord;
   TempMenu   : TMenuItem;
   wfx        : TWAVEFORMATEX;
Const
   arChannels  : array[0..5] of integer = (1,2,1,2,1,2);
   arSamples   : array[0..5] of integer = (11025,11025, 22050, 22050,44100, 44100);
begin
    If Assigned(muRecOption)then
    begin
      // Fill out the menu structure
      For i := 0 to 5 do
      begin
        wfx := Wave.FillWaveFormatEx( arChannels[i], arSamples[i]);
        If Wave.IsWaveFormatSupported(@wfx, wioWaveIn) then
        begin
            With muRecOption do
            begin
              TempMenu  := TMenuItem.Create(muRecOption);
              With TempMenu do
              begin
                 Caption   := Format('%.2f kHz, %d Channel, %d-bit', [wfx.nSamplesPerSec / 1000, wfx.nChannels,wfx.wBitsPerSample]);
                 RadioItem := True;
                 OnClick   := RecordLevelChange;
                 Tag       := i;
              end;
              Add(TempMenu);
            end;
        end;
      end;
      // Set initial/closest Setting from Registry
      RecordingLevel  :=  Ord(Wave.RecordingLevel);
      While RecordingLevel > Pred(muRecOption.Count) do
         Dec(RecordingLevel);
      muRecOption.Items[RecordingLevel].Checked := True;
      muRecOption.Items[RecordingLevel].Click;
    end;
end;
{----------------------------------------------------------------------
		ImportBtnClick
------------------------------------}
procedure TfmRecorder.ImportBtnClick(Sender: TObject);
begin
        OpenDialog1.Filter := 'Sound Files|*.wav';
	if (OpenDialog1.Execute) then
           Wave.LoadFromFile(OpenDialog1.Filename);
end;
{----------------------------------------------------------------------
		UpdateStatistic
------------------------------------}
procedure TfmRecorder.WaveUpdateStatistics( sender : TObject);
begin
        RecordBtn.Enabled     := True;
        Record1.Enabled       := True;
        ImportBtn.Enabled     := True;
        Import1.Enabled       := True;
        Export1.Enabled       := True;
        muRecOption.Enabled   := True;

        PlayBtn.Enabled       := Wave.SoundValid;
        Play1.Enabled         := Wave.SoundValid;
        btnClear.Enabled      := Wave.SoundValid;
        Export1.Enabled       := Wave.SoundValid;

        Memo1.Items.Text := Wave.GetFormatString
end;
//******************* TfmDBRecorder.ExportBtnClick *************************
procedure TfmRecorder.ExportBtnClick(Sender: TObject);
begin
        SaveDialog1.Filter := 'Sound Files|*.wav';
	if (SaveDialog1.Execute) then
           if (Wave.SoundValid) then 	// is there a Wave to export ?
         	Wave.SaveToFile(SaveDialog1.Filename);
end;
//******************* TfmDBRecorder.RecordBtnClick *************************
procedure TfmRecorder.RecordBtnClick(Sender: TObject);
begin
	if (Wave.RecordWave) then
	  begin
                Memo1.Items.Text     := 'Recording';
		RecordBtn.Enabled    := false;
                Record1.Enabled      := false;
		PlayBtn.Enabled      := false;
                Play1.Enabled        := false;
		StopBtn.Enabled      := true;
                Stop1.Enabled        := true;
		PauseBtn.Enabled     := false;
                Pause1.Enabled       := false;
                btnClear.Enabled     := false;
                ImportBtn.Enabled    := false;
                Import1.Enabled      := false;
                Export1.Enabled      := false;                
                btnExit.Enabled      := false;
	  end
        else
    	  raise Exception.Create('Could not start recording!');
end;
//******************* TfmDBRecorder.PlayBtnClick *************************
procedure TfmRecorder.PlayBtnClick(Sender: TObject);
begin
        Randomize; // for Gauges 
        If Wave.Paused then
          timer1.enabled := Wave.Restart
        Else
          timer1.enabled := Wave.Play;

        If timer1.enabled then
        begin
          RecordBtn.Enabled    := false;
          btnClear.Enabled     := false;
          ImportBtn.Enabled    := false;
          Import1.Enabled      := false;
          Export1.Enabled      := false;
          Record1.Enabled      := false;
          PlayBtn.Enabled      := false;
          Play1.Enabled        := false;
          StopBtn.Enabled      := true;
          Stop1.Enabled        := true;
          PauseBtn.Enabled     := true;
          Pause1.Enabled       := true;
          btnExit.Enabled      := false;
       end;   
end;
//******************* TfmDBRecorder.PauseBtnClick *************************
procedure TfmRecorder.PauseBtnClick(Sender: TObject);
begin
	Wave.Pause;

	RecordBtn.Enabled        :=false;
        Record1.Enabled          :=false;
	PlayBtn.Enabled          :=Wave.SoundValid;
        Play1.Enabled            :=Wave.SoundValid;
	StopBtn.Enabled          :=true;
        Stop1.Enabled            :=true;
	PauseBtn.Enabled         :=false;
        Pause1.Enabled           :=false;
        Timer1.Enabled           :=false;
end;
//******************* TfmDBRecorder.StopBtnClick *************************
procedure TfmRecorder.StopBtnClick(Sender: TObject);
begin
	Wave.Stop;
end;
//******************* TfmDBRecorder.WavePlayed *************************
procedure TfmRecorder.WavePlayed(Sender: TObject);
var
   Gauge : TdbMeter;
   i : Integer;
begin
	RecordBtn.Enabled          := true;
        Record1.Enabled            := true;
        ImportBtn.Enabled          := true;
        Import1.Enabled            := true;
        Export1.Enabled            := True;
	PlayBtn.Enabled            := Wave.SoundValid;
        Play1.Enabled              := Wave.SoundValid;
        btnClear.Enabled           := Wave.SoundValid;
	StopBtn.Enabled            := false;
        Stop1.Enabled              := false;
	PauseBtn.Enabled           := false;
        Pause1.Enabled             := false;
        timer1.enabled             := False;
        btnExit.Enabled            := true;

        For i := 1 to 8 do begin
            Gauge := TdbMeter(FindComponent(Format('Gauge%d',[i])));
            Gauge.Position := 0;
        end;
end;
//******************* TfmDBRecorder.WaveRecorded *************************
procedure TfmRecorder.WaveRecorded(Sender: TObject);
begin

	RecordBtn.Enabled          := true;
        Record1.Enabled            := true;
        ImportBtn.Enabled          := true;
        Import1.Enabled            := true;
        Export1.Enabled            := True;
	PlayBtn.Enabled            := Wave.SoundValid;
        Play1.Enabled              := Wave.SoundValid;
        btnClear.Enabled           := Wave.SoundValid;
	StopBtn.Enabled            := false;
        Stop1.Enabled              := false;
	PauseBtn.Enabled           := false;
        Pause1.Enabled             := false;
        timer1.enabled             := False;
        btnExit.Enabled            := true;
end;
//******************* TfmDBRecorder.Timer1Timer *************************
procedure TfmRecorder.Timer1Timer(Sender: TObject);
Const i : Integer = 1;
var
   Gauge : TdbMeter;
begin            
    Gauge := TdbMeter(FindComponent(Format('Gauge%d',[i])));
    Gauge.Position := random(80);
    Inc(i);
    if (i > 8) then i := 1;
end;
//******************* TfmDBRecorder.Exit1Click *************************
procedure TfmRecorder.Exit1Click(Sender: TObject);
begin
   Close;
end;
//******************* TfmDBRecorder.FormCreate *************************
procedure TfmRecorder.FormCreate(Sender: TObject);
begin
     OldHandler := Application.OnHint;
     Application.OnHint := LocalOnHint;
     Initialize;
end;
{----------------------------------------------------------------------
		LocalOnHint
------------------------------------}
procedure TfmRecorder.LocalOnHint (Sender: TObject) ;
begin
    Statusbar1.SimpleText := GetLongHint(Application.Hint);
end;
//******************* TfmDBRecorder.FormClose *************************
procedure TfmRecorder.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   Application.OnHint := OldHandler;
end;
//******************* TfmDBRecorder.btnExitClick *************************
procedure TfmRecorder.btnExitClick(Sender: TObject);
begin
  Close;
end;
//******************* TfmDBRecorder.btnClearClick *************************
procedure TfmRecorder.btnClearClick(Sender: TObject);
begin
   Wave.Clear;
end;
//******************* TfmDBRecorder.FormCloseQuery *************************
procedure TfmRecorder.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
   CanClose := Not Timer1.enabled;
end;
//******************* TfmDBRecorder.RecordLevelChange *************************
procedure TfmRecorder.RecordLevelChange(Sender: TObject);
begin
   With TmenuItem(Sender) do
   begin
    Wave.RecordingLevel    := Tag;
    Checked                := True;
  end;
end;


end.
