unit FormMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Buttons, VrTypes, VrClasses, VrGradient,
  VrMatrix, VrBlotter, VrSpectrum, VrLcd, VrTracker, VrLeds, VrScanner,
  VrCalendar, VrAnalog, VrRaster;

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    VrGradient1: TVrGradient;
    ColorDialog: TColorDialog;
    FontDialog: TFontDialog;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    TabSheet2: TTabSheet;
    Panel1: TPanel;
    Label2: TLabel;
    VrBlotter1: TVrBlotter;
    VrMatrix1: TVrMatrix;
    BitBtn4: TBitBtn;
    TabSheet3: TTabSheet;
    SpectrumTimer: TTimer;
    VrGradient2: TVrGradient;
    VrBlotter2: TVrBlotter;
    VrSpectrum1: TVrSpectrum;
    BitBtn5: TBitBtn;
    TabSheet4: TTabSheet;
    Panel3: TPanel;
    VrNum1: TVrNum;
    Label3: TLabel;
    VrLed1: TVrLed;
    VrIndicator1: TVrIndicator;
    VrBlotter3: TVrBlotter;
    VrTracker1: TVrTracker;
    TabSheet5: TTabSheet;
    Panel4: TPanel;
    VrCalendar1: TVrCalendar;
    Label4: TLabel;
    BitBtn6: TBitBtn;
    UpDown1: TUpDown;
    Label5: TLabel;
    TabSheet6: TTabSheet;
    Panel5: TPanel;
    VrAnalogClock1: TVrAnalogClock;
    Label6: TLabel;
    VrClock1: TVrClock;
    Label7: TLabel;
    VrClock2: TVrClock;
    Label8: TLabel;
    VrClock3: TVrClock;
    Label9: TLabel;
    VrNum2: TVrNum;
    TabSheet7: TTabSheet;
    Panel6: TPanel;
    VrRaster1: TVrRaster;
    RasterTimer: TTimer;
    VrGradient3: TVrGradient;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    TabSheet8: TTabSheet;
    Panel7: TPanel;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure SpectrumTimerTimer(Sender: TObject);
    procedure VrTracker1Change(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure VrCalendar1Click(Sender: TObject);
    procedure UpDown1Changing(Sender: TObject; var AllowChange: Boolean);
    procedure VrClock3ClockTick(Sender: TObject; Seconds: Word);
    procedure TabSheet3Exit(Sender: TObject);
    procedure TabSheet2Exit(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure BitBtn9Click(Sender: TObject);
    procedure TabSheet7Exit(Sender: TObject);
    procedure RasterTimerTimer(Sender: TObject);
    procedure Memo1Enter(Sender: TObject);
  private
    CalendarClick: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  MatrixText = 'Thank you for using ' +
    '"Varian Led Studio...............Don''t '+
    'forget to register this evaluation copy.............';

  StopRun: array[Boolean] of string = ('Run', 'Stop');


procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  PageControl.ActivePage := TabSheet1;

  Caption := Format('%s, %s',
    [Application.Title, '(c) 1996-1998 Varian Software Services nl']);
  VrMatrix1.Text := MatrixText;

  with VrCalendar1 do
    for I := 0 to Pred(Count) do
      Items[I].Visible := I <= 18;

  CalendarClick := -1;
  VrCalendar1Click(VrCalendar1);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  Colordialog.Color := VrGradient1.StartColor;
  if Colordialog.Execute then
    VrGradient1.StartColor := ColorDialog.Color;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  Colordialog.Color := VrGradient1.EndColor;
  if Colordialog.Execute then
    VrGradient1.EndColor := ColorDialog.Color;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  if VrGradient1.Orientation = voVertical then
    VrGradient1.Orientation := voHorizontal
  else VrGradient1.Orientation := voVertical;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
  VrMatrix1.AutoScroll := not VrMatrix1.AutoScroll;
  BitBtn4.Caption := StopRun[VrMatrix1.AutoScroll];
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
  VrSpectrum1.Reset(0);
  SpectrumTimer.Enabled := not SpectrumTimer.Enabled;
  BitBtn5.Caption := StopRun[SpectrumTimer.Enabled];
end;

procedure TForm1.SpectrumTimerTimer(Sender: TObject);
var
  I, Value: Integer;
begin
  with VrSpectrum1 do
    for I := 0 to Pred(Count) do
    begin
      Value := Random(Max + 1);
      Items[I].Position := Value;
    end;
end;

procedure TForm1.VrTracker1Change(Sender: TObject);
begin
  VrNum1.Value := VrTracker1.Position;
  VrLed1.Active := VrTracker1.Position = VrTracker1.Max;
  VrIndicator1.Position := VrTracker1.Position;
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
  VrCalendar1.TrackMouse := not VrCalendar1.TrackMouse;
end;

procedure TForm1.VrCalendar1Click(Sender: TObject);
const
  LabelText = 'Item selected: %d';
var
  Id: Integer;
begin
  Label4.Caption := Format(LabelText, [Succ(VrCalendar1.ItemIndex)]);
  Id := VrCalendar1.ItemIndex;
  if CalendarClick <> -1 then
      VrCalendar1.Items[CalendarClick].Active := false;
  if Id <> -1 then
  begin
    CalendarClick := Id;
    VrCalendar1.Items[CalendarClick].Active := true;
  end;
end;

procedure TForm1.UpDown1Changing(Sender: TObject;
  var AllowChange: Boolean);
begin
  VrCalendar1.FirstIndex := UpDown1.Position;
end;

procedure TForm1.VrClock3ClockTick(Sender: TObject; Seconds: Word);
begin
  VrNum2.Value := VrClock3.Seconds;
end;

procedure TForm1.TabSheet3Exit(Sender: TObject);
begin
  if SpectrumTimer.Enabled then
    BitBtn5Click(BitBtn5);
end;

procedure TForm1.TabSheet2Exit(Sender: TObject);
begin
  if VrMatrix1.AutoScroll then
    BitBtn4Click(BitBtn4);
end;

procedure TForm1.BitBtn7Click(Sender: TObject);
begin
  RasterTimer.Enabled := true;
end;

procedure TForm1.BitBtn8Click(Sender: TObject);
var
  I: Integer;
begin
  RasterTimer.Enabled := false;
  with VrRaster1 do
    for I := 0 to Pred(Count) do
      Items[I].Active := false;
end;

procedure TForm1.BitBtn9Click(Sender: TObject);
begin
  VrRaster1.MultiSelect := not VrRaster1.MultiSelect;
end;

procedure TForm1.TabSheet7Exit(Sender: TObject);
begin
  if RasterTimer.Enabled then
    BitBtn8Click(BitBtn8);
end;

procedure TForm1.RasterTimerTimer(Sender: TObject);
var
  I: Integer;
begin
  with VrRaster1 do
  begin
    I := Random(Count);
    if MultiSelect then
      Items[I].Active := not Items[I].Active
    else
      Items[I].Active := true;
  end;
end;

procedure TForm1.Memo1Enter(Sender: TObject);
begin
  TabSheet8.SetFocus;
end;

end.
