unit mainform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  sfSkin;

type
  TMain_Form = class(TForm)
    Skin1: TSkin;
    procedure FormCreate(Sender: TObject);
    procedure Skin1ButtonClick(Sender: TObject; Name: String);
  private
    FMute: Boolean;
    FNumber: string;
    procedure ToggleMute;
    procedure ClearNumber;
    procedure AddDigit(Ch: string);
  public
    { Public declarations }
  end;

var
  Main_Form: TMain_Form;

implementation

{$R *.DFM}

const
  BUTTON_EXIT = 'BUTTON_EXIT';
  BUTTON_MUTE = 'BUTTON_MUTE';
  BUTTON_CLEAR = 'BUTTON_CLEAR';
  BUTTON_1 = 'BUTTON_1';
  BUTTON_2 = 'BUTTON_2';
  BUTTON_3 = 'BUTTON_3';
  BUTTON_4 = 'BUTTON_4';
  BUTTON_5 = 'BUTTON_5';
  BUTTON_6 = 'BUTTON_6';
  BUTTON_7 = 'BUTTON_7';
  BUTTON_8 = 'BUTTON_8';
  BUTTON_9 = 'BUTTON_9';
  BUTTON_0 = 'BUTTON_0';
  BUTTON_A = 'BUTTON_A';
  BUTTON_B = 'BUTTON_B';
  BUTTON_CALL = 'BUTTON_CALL';


procedure TMain_Form.FormCreate(Sender: TObject);
begin
  FMute := True;
  Skin1.LoadFromFile('demo.sff');
end;

procedure TMain_Form.ToggleMute;
var
  Tmp: string;
begin
  FMute := not FMute;
  if FMute then Tmp := 'MUTE'
   else Tmp := '';
  Skin1.TextOut('TEXT_MUTE', Tmp);
end;

procedure TMain_Form.ClearNumber;
begin
  FNumber := '';
  Skin1.TextOut('TEXT_NUMBER', '');
end;

procedure TMain_Form.AddDigit(Ch: string);
begin
  FNumber := FNumber + Ch;
  Skin1.TextOut('TEXT_NUMBER', FNumber);
end;

procedure TMain_Form.Skin1ButtonClick(Sender: TObject; Name: String);
begin
  if Name = BUTTON_EXIT then
    Application.Terminate
  else
  if Name = BUTTON_MUTE then
    ToggleMute
  else
  if Name = BUTTON_CLEAR then
    ClearNumber
  else
  if Name = BUTTON_1 then
    AddDigit('1')
  else
  if Name = BUTTON_2 then
    AddDigit('2')
  else
  if Name = BUTTON_3 then
    AddDigit('3')
  else
  if Name = BUTTON_4 then
    AddDigit('4')
  else
  if Name = BUTTON_5 then
    AddDigit('5')
  else
  if Name = BUTTON_6 then
    AddDigit('6')
  else
  if Name = BUTTON_7 then
    AddDigit('7')
  else
  if Name = BUTTON_8 then
    AddDigit('8')
  else
  if Name = BUTTON_9 then
    AddDigit('9')
  else
  if Name = BUTTON_0 then
    AddDigit('0')
  else
  if Name = BUTTON_A then
    AddDigit('*')
  else
  if Name = BUTTON_B then
    AddDigit('#')  
  else
  if Name = BUTTON_CALL then
    ShowMessage('Ring ring...');

end;

end.
