unit f_atfilt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, ExtCtrls, StdCtrls, Grids, DBGrids, Buttons,
  DBTableFilter, ComCtrls; 

type
  TfmDBTableFilter = class(TForm)
    Table1: TTable;
    Panel1: TPanel;
    btApplyFilter: TButton;
    Label3: TLabel;
    lbDesc: TLabel;
    DataSource1: TDataSource;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Addr1: TStringField;
    Table1Addr2: TStringField;
    Table1City: TStringField;
    Table1State: TStringField;
    Table1Zip: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1FAX: TStringField;
    Table1TaxRate: TFloatField;
    Table1Contact: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    Panel3: TPanel;
    Memo1: TMemo;
    Label5: TLabel;
    Label6: TLabel;
    Label1: TLabel;
    lbFilter: TLabel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    DBGrid1: TDBGrid;
    TabSheet2: TTabSheet;
    rgSyntax: TRadioGroup;
    Label2: TLabel;
    Splitter1: TSplitter;
    GroupBox1: TGroupBox;
    cbCanBeEmpty: TCheckBox;
    cbAutoInsert: TCheckBox;
    cbShowButtons: TCheckBox;
    TabSheet3: TTabSheet;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    edLeftMargin: TEdit;
    edRightMargin: TEdit;
    edLineSeparation: TEdit;
    edControlSeparation: TEdit;
    edTopMargin: TEdit;
    Apply: TButton;
    edLevelIndent: TEdit;
    rgLayoutType: TRadioGroup;
    GroupBox3: TGroupBox;
    cbInsertCondition: TCheckBox;
    cbDeleteCondition: TCheckBox;
    cbIncreaseLevel: TCheckBox;
    cbDecreaseLevel: TCheckBox;
    cbUseAsParam: TCheckBox;
    GroupBox4: TGroupBox;
    Button1: TButton;
    shLabelColor: TShape;
    BitBtn1: TBitBtn;
    shParamColor: TShape;
    BitBtn2: TBitBtn;
    FontDialog: TFontDialog;
    ColorDialog: TColorDialog;
    DBTableFilter1: TDBTableFilter;
    procedure btApplyFilterClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rgSyntaxClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure rgLayoutTypeClick(Sender: TObject);
    procedure cbCanBeEmptyClick(Sender: TObject);
    procedure cbAutoInsertClick(Sender: TObject);
    procedure cbShowButtonsClick(Sender: TObject);
    procedure ApplyClick(Sender: TObject);
    procedure cbInsertConditionClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmDBTableFilter: TfmDBTableFilter;

implementation

{$R *.DFM}

procedure TfmDBTableFilter.btApplyFilterClick(Sender: TObject);
begin                                                                          
   lbDesc.Caption:=DBTableFilter1.DescString; { Show description string }
   lbFilter.Caption:=DBTableFilter1.FilterString; { Show filter string }
   if (DBTableFilter1.SyntaxType=stBDEFilter) or (DBTableFilter1.SyntaxType=stCustom) then
   begin
      Table1.Filter:=DBTableFilter1.FilterString; { Filter the table }
      Table1.Filtered:=true;
      Table1.Refresh;
   end else
      ShowMessage('The filter only can be applied if syntax type is BDE Filter. '+
      'For the other syntax types, just look at the filter string. You could use the '+
      'filter string in a Where clause of a SQL statement.');
end;

procedure TfmDBTableFilter.FormCreate(Sender: TObject);
begin
   lbDesc.Caption:='';
   lbFilter.Caption:='';
end;

procedure TfmDBTableFilter.rgSyntaxClick(Sender: TObject);
var ASyntaxType: TSyntaxType;
begin
   Case rgSyntax.ItemIndex of
      0 : ASyntaxType:=stBDEFilter;
      1 : ASyntaxType:=stLocalSQL;
      2 : ASyntaxType:=stAccessSQL;
      3 : ASyntaxType:=stOracleSQL;
      4 : ASyntaxType:=stInterbaseSQL;
      5 : ASyntaxType:=stCustom;
   end;
   With DBTableFilter1 do if SyntaxType<>ASyntaxType then
   begin
      FilterFields.Clear;
      AddFields(Table1);
      SyntaxType:=ASyntaxType;
   end;
end;

procedure TfmDBTableFilter.FormShow(Sender: TObject);
begin
   Table1.Active:=true;
   DBTableFilter1.Datasource:=Datasource1;
end;



procedure TfmDBTableFilter.rgLayoutTypeClick(Sender: TObject);
begin
   Case rgLayoutType.ItemIndex of
      0 : DBTableFilter1.LayoutType:=ltCombos;
      1 : DBTableFilter1.LayoutType:=ltLabels;
   end;
end;


procedure TfmDBTableFilter.cbCanBeEmptyClick(Sender: TObject);
begin
   DBTableFilter1.CanBeEmpty:=cbCanBeEmpty.Checked;
end;

procedure TfmDBTableFilter.cbAutoInsertClick(Sender: TObject);
begin
   DBTableFilter1.AutoInsert:=cbAutoInsert.Checked;
end;

procedure TfmDBTableFilter.cbShowButtonsClick(Sender: TObject);
begin
   DBTableFilter1.ShowButtons:=cbShowButtons.checked;
end;



procedure TfmDBTableFilter.ApplyClick(Sender: TObject);
begin
   With DBTableFilter1 do
   begin
      LeftMargin        := StrToInt(edLeftMargin.Text);
      TopMargin         := StrToInt(edTopMargin.Text);
      RightMargin       := StrToInt(edRightMargin.Text);
      ControlSeparation := StrToInt(edControlSeparation.Text);
      LineSeparation    := StrToInt(edLineSeparation.Text);
      LevelIndent       := StrToInt(edLevelIndent.Text);
   end;
end;









procedure TfmDBTableFilter.cbInsertConditionClick(Sender: TObject);
Var APopupItems: TFilterPopupItems;
begin
   APopupItems:=[];
   if cbInsertCondition.Checked    then   APopupItems:=APopupItems+[foInsertCondition];
   if cbDeleteCondition.Checked    then   APopupItems:=APopupItems+[foDeleteCondition];
   if cbIncreaseLevel.Checked      then   APopupItems:=APopupItems+[foIncreaseLevel];
   if cbDecreaseLevel.Checked      then   APopupItems:=APopupItems+[foDecreaseLevel];
   if cbUseAsParam.Checked         then   APopupItems:=APopupItems+[foUseAsParam];
   DBTableFilter1.PopupItems:=APopupItems;
end;


procedure TfmDBTableFilter.Button1Click(Sender: TObject);
begin
   FontDialog.Font.Assign(DBTableFilter1.Font);
   if FontDialog.Execute then
      DBTableFilter1.Font.Assign(FontDialog.Font);
end;

procedure TfmDBTableFilter.BitBtn1Click(Sender: TObject);
begin
   if ColorDialog.Execute then
   begin
      DBTableFilter1.LabelColor:=ColorDialog.Color;
      shLabelColor.Brush.Color:=ColorDialog.Color;
   end;
end;

procedure TfmDBTableFilter.BitBtn2Click(Sender: TObject);
begin
   if ColorDialog.Execute then
   begin
      DBTableFilter1.ParamColor:=ColorDialog.Color;
      shParamColor.Brush.Color:=ColorDialog.Color;
   end;
end;


end.
