unit f_atdbrc;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DBCtrls, atDBRecord, Buttons, DB, DBTables;

type
  TfmatDBRecord = class(TForm) 
    atDBRecord1: TatDBRecord;
    DBNavigator1: TDBNavigator;
    Panel1: TPanel;
    grLayout: TRadioGroup;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    cbTable: TComboBox;
    cbReturn: TCheckBox;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    Table1: TTable;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    Table3: TTable;
    rbDefault: TRadioButton;
    rbPersistent: TRadioButton;
    Table3CustNo: TFloatField;
    Table3Company: TStringField;
    Table3Addr1: TStringField;
    Table3Addr2: TStringField;
    Table3City: TStringField;
    Table3State: TStringField;
    Table3Country: TStringField;
    Table3Phone: TStringField;
    Table3FAX: TStringField;
    Table3TaxRate: TFloatField;
    Table3Contact: TStringField;
    Table3LastInvoiceDate: TDateTimeField;
    Table3Zip: TStringField;
    Table2: TTable;
    Table2OrderNo: TFloatField;
    Table2CustNo: TFloatField;
    Table2SaleDate: TDateTimeField;
    Table2ShipDate: TDateTimeField;
    Table2EmpNo: TIntegerField;
    Table2ShipToContact: TStringField;
    Table2ShipToAddr1: TStringField;
    Table2ShipToAddr2: TStringField;
    Table2ShipToCity: TStringField;
    Table2ShipToState: TStringField;
    Table2ShipToZip: TStringField;
    Table2ShipToCountry: TStringField;
    Table2ShipToPhone: TStringField;
    Table2ShipVIA: TStringField;
    Table2PO: TStringField;
    Table2Terms: TStringField;
    Table2PaymentMethod: TStringField;
    Table2ItemsTotal: TCurrencyField;
    Table2TaxRate: TFloatField;
    Table2Freight: TCurrencyField;
    Table2AmountPaid: TCurrencyField;
    Table2Customer: TStringField;
    Panel3: TPanel;
    Memo1: TMemo;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure cbTableChange(Sender: TObject);
    procedure grLayoutClick(Sender: TObject);
    procedure cbReturnClick(Sender: TObject);
    procedure rbPersistentClick(Sender: TObject);
  private
    { Private declarations }
    Updating : boolean;
  public
    { Public declarations }
  end;

var
  fmatDBRecord: TfmatDBRecord;

implementation

{$R *.DFM}

procedure TfmatDBRecord.BitBtn1Click(Sender: TObject);
begin
   Close;
end;

procedure TfmatDBRecord.FormShow(Sender: TObject);
begin
   Table2.Open;
   Table3.Open;
   Updating:=true;
   Session.GetTableNames('DBDEMOS','*.db',false,false,cbTable.Items);
   cbTable.ItemIndex:=cbTable.Items.IndexOf('COUNTRY');
   Updating:=false;
end;

procedure TfmatDBRecord.cbTableChange(Sender: TObject);
begin
   if (not Updating) and (cbTable.ItemIndex>0) then With Table1 do
   begin
      Close;
      TableName:=cbTable.Text;
      atDBRecord1.DataSource:=DataSource1;
      Open;
   end;
end;

procedure TfmatDBRecord.grLayoutClick(Sender: TObject);
begin
   Case grLayout.ItemIndex of
      0 : atDBRecord1.ScreenLayout:=slJustified;
      1 : atDBRecord1.ScreenLayout:=slNotAdjusted;
   end;
end;

procedure TfmatDBRecord.cbReturnClick(Sender: TObject);
begin
   atDBRecord1.WantReturns:=cbReturn.checked;
end;

procedure TfmatDBRecord.rbPersistentClick(Sender: TObject);
begin
   cbTable.Enabled:=rbDefault.checked;
   if rbDefault.checked then
   begin
      atDBRecord1.DataSource:=DataSource1;
      cbTableChange(Self);
   end
   else
      atDBRecord1.DataSource:=DataSource2;
end;

end.
