unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, DBTables, UsersSTD, Db, Grids, DBGrids, StdCtrls;

type
  TSampleMain = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    Print1: TMenuItem;
    System1: TMenuItem;
    ChangePassword1: TMenuItem;
    Exit1: TMenuItem;
    UsersAdministration1: TMenuItem;
    UsersSTD: TUsersSTD;
    Memo1: TMemo;
    N1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure UsersAdministration1Click(Sender: TObject);
    procedure ChangePassword1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SampleMain: TSampleMain;

implementation

{$R *.DFM}

procedure TSampleMain.FormActivate(Sender: TObject);
begin
  Caption:=Caption+' - User: '+UsersSTD.ActualUser.RealName;
end;

procedure TSampleMain.UsersAdministration1Click(Sender: TObject);
begin
  if UsersSTD.AccessLevelOk(TotalLevel) then
    UsersSTD.UsersADM
  else
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can''t access this option.')
end;

procedure TSampleMain.ChangePassword1Click(Sender: TObject);
begin
  UsersSTD.ChangeUserPassword;
end;

procedure TSampleMain.New1Click(Sender: TObject);
begin
  if UsersSTD.AccessLevelOk(Level0) then
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
  else
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can''t access this option.')
end;

procedure TSampleMain.Save1Click(Sender: TObject);
begin
  if UsersSTD.AccessLevelOk(Level1) then
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
  else
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can''t access this option.')
end;

procedure TSampleMain.SaveAs1Click(Sender: TObject);
begin
  if UsersSTD.AccessLevelOk(Level2) then
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
  else
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can''t access this option.')
end;

procedure TSampleMain.Print1Click(Sender: TObject);
begin
  if UsersSTD.AccessLevelOk(Level3) then
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
  else
    ShowMessage('User '+UsersSTD.ActualUser.UserName+' can''t access this option.')
end;

procedure TSampleMain.Exit1Click(Sender: TObject);
begin
  Close;
end;


procedure TSampleMain.FormCreate(Sender: TObject);
begin
  if not UsersSTD.Login then
    begin
      ShowMessage('You are not allowed to use this application. If you don''t remember your password, pelase contact the administrator.');
      Application.Terminate;
    end;
end;

end.
