unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, DBTables, UsersSTD, Db, Grids, DBGrids, StdCtrls;

type
  TSampleMain = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    Print1: TMenuItem;
    System1: TMenuItem;
    ChangePassword1: TMenuItem;
    Exit1: TMenuItem;
    UsersAdministration1: TMenuItem;
    UsersSTD: TUsersSTD;
    Memo1: TMemo;
    N1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure UsersAdministration1Click(Sender: TObject);
    procedure ChangePassword1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SampleMain: TSampleMain;

implementation

{$R *.DFM}

procedure TSampleMain.FormCreate(Sender: TObject);
begin
  if not UsersSTD.Login then
    begin
      ShowMessage('You are not allowed to use this application. If you don''t remember your password, please contact the administrator.');
      Application.Terminate;
    end;
end;

procedure TSampleMain.FormActivate(Sender: TObject);
var
  i: Integer;

procedure DisableMenu(MenuItem: TMenuItem);
var
  i: Integer;
begin
  for i:=0 to MenuItem.Count-1 do
    begin
      if UsersSTD.ActualUser.AccessLevel>MenuItem.Items[i].Tag then
        MenuItem.Items[i].Enabled:=False
      else if MenuItem.Items[i].Count>0 then
        DisableMenu(MenuItem.Items[i]);
    end;
end;

begin
  Caption:=Caption+' - User: '+UsersSTD.ActualUser.RealName;
  for i:=0 to Mainmenu.Items.Count-1 do
    begin
      if UsersSTD.ActualUser.AccessLevel>MainMenu.Items[i].Tag then
        MainMenu.Items[i].Enabled:=False
      else if MainMenu.Items[i].Count>0 then
        DisableMenu(MainMenu.Items[i]);
    end;
  {
   Note that using this technique, you don't need to
   test if the user has or not access to the resorces
   you want to protect, but you must be carefull with
   the tag values of the Menu items.
  }
end;

procedure TSampleMain.UsersAdministration1Click(Sender: TObject);
begin
  UsersSTD.UsersADM;
end;

procedure TSampleMain.ChangePassword1Click(Sender: TObject);
begin
  UsersSTD.ChangeUserPassword;
end;

procedure TSampleMain.New1Click(Sender: TObject);
begin
  ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
end;

procedure TSampleMain.Save1Click(Sender: TObject);
begin
  ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
end;

procedure TSampleMain.SaveAs1Click(Sender: TObject);
begin
  ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
end;

procedure TSampleMain.Print1Click(Sender: TObject);
begin
  ShowMessage('User '+UsersSTD.ActualUser.UserName+' can access this option.')
end;

procedure TSampleMain.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
