{ ****************************************************************************** }
{ *  Program name.: csTwainConsts.pas           Project...: TWAIN Component    * }
{ *  Documentation: -                           Version...: 1.00               * }
{ *  Date.........: 99-07-11                    Created by: FAZI               * }
{ *  Updated......: 99-07-11                    Updated by: FAZI               * }
{ *  Compiler.....: Borland Delphi              Version...: 3 & 4              * }
{ *                                                                            * }
{ ****************************************************************************** }
{ *                  Copyright (c) 1999 Component Store Ltd.                   * }
{ *                            All rights reserved                             * }
{ ****************************************************************************** }

unit csTwainConsts;

interface

resourcestring

 //////////////////////////////////////////////////////////////////////////
 // TWAIN Error Detail Descriptions
 //////////////////////////////////////////////////////////////////////////

  SED_NONE	         = '[no details available]';
  SED_START_TRIPLET_ERRS = '';
  SED_CAP_GET            = 'DAT_CAPABILITY/MSG_GET failed';
  SED_CAP_SET            = 'DAT_CAPABILITY/MSG_SET failed';
  SED_DSM_FAILURE        = 'Source Manager operation failed';
  SED_DS_FAILURE	 = 'DataSource operation failed';
  SED_END_TRIPLET_ERRS   = '';
  SED_NOT_STATE_4	 = 'TWAIN session not in State 4 (Source Open)';
  SED_NULL_HCON	         = 'MSG_GET returned a NULL container handle';
  SED_BAD_HCON	         = 'MSG_GET returned an invalid container handle';
  SED_BAD_CONTYPE	 = 'Returned container is not valid type';
  SED_BAD_ITEMTYPE	 = 'Returned container has invalid ItemType';
  SED_CAP_GET_EMPTY	 = 'Returned container is empty';
  SED_CAP_SET_EMPTY	 = 'App and source found NO values in common';

 //////////////////////////////////////////////////////////////////////////
 // TWAIN Return Code Descriptions
 //////////////////////////////////////////////////////////////////////////

  SRC_SUCCESS	         = 'TWRC_SUCCESS';
  SRC_FAILURE	         = 'TWRC_FAILURE';
  SRC_CHECKSTATUS	 = 'TWRC_CHECKSTATUS';
  SRC_CANCEL	         = 'TWRC_CANCEL';
  SRC_DSEVENT	         = 'TWRC_DSEVENT';
  SRC_NOTDSEVENT	 = 'TWRC_NOTDSEVENT';
  SRC_XFERDONE	         = 'TWRC_XFERDONE';
  SRC_ENDOFLIST	         = 'TWRC_ENDOFLIST';

 //////////////////////////////////////////////////////////////////////////
 // TWAIN Condition Code Descriptions
 //////////////////////////////////////////////////////////////////////////

  SCC_SUCCESS	         = 'TWCC_SUCCESS';
  SCC_BUMMER	         = 'TWCC_BUMMER (Failure due to unknown causes)';
  SCC_LOWMEMORY	         = 'TWCC_LOWMEMORY';
  SCC_NODS	         = 'TWCC_NODS (No Data Source)';
  SCC_MAXCONNECTIONS	 = 'TWCC_MAXCONNECTIONS (DS is connected to max possible apps)';
  SCC_OPERATIONERROR	 = 'TWCC_OPERATIONERROR (DS or DSM reported error, app shouldn''t)';
  SCC_BADCAP	         = 'TWCC_BADCAP (Unknown capability)';
  SCC_UNDEFINED7	 = '7 (undefined)';
  SCC_UNDEFINED8	 = '8 (undefined)';
  SCC_BADPROTOCOL	 = 'TWCC_BADPROTOCOL (Unrecognized triplet)';
  SCC_BADVALUE	         = 'TWCC_BADVALUE (Data parameter out of range)';
  SCC_SEQERROR   	 = 'TWCC_SEQERROR (Triplet out of sequence)';
  SCC_BADDEST	         = 'TWCC_BADDEST (Unknown dest. App/Src in DSM_Entry)';

  SEG_GETCAP_NOTSTATE_4  = 'Attempt to get capability value below State 4.';
  SEG_INSUFFICIENT_MEM   = 'Insufficient memory';
  SEG_LOAD_DSM           = 'Unable to load Source Manager ';
  SEG_OPEN_DSM           = 'Unable to open Source Manager.';
  SEG_OPEN_DS            = 'Unable to open default Data Source.';
  SEG_ENABLE_DS          = 'Failed to enable Data Source.';

 //////////////////////////////////////////////////////////////////////////
 // TWAIN Dialog Strings
 //////////////////////////////////////////////////////////////////////////

  SPT_BLACK_WHITE        = 'Black & White';
  SPT_16_GRAYSCALE       = '16 Grays';
  SPT_256_GRAYSCALE      = '256 Grays';
  SPT_16_COLOR           = '16 Colors';
  SPT_256_COLOR          = '256 Colors';
  SPT_TRUE_COLOR         = 'Millions of Colors';

  SFS_DETECTED           = 'Detected';
  SFS_A4                 = 'A4';
  SFS_A5                 = 'A5';
  SFS_B5                 = 'B5';
  SFS_LEGAL              = 'Legal';
  SFS_LETTER             = 'Letter';

  SBD_THRESHOLD          = 'Threshold';
  SBD_HALFTONES          = 'Halftones';
  SBD_DIFFUSION          = 'Diffusion';

  SDL_TITLE              = 'TWAIN Dialog';
  SBT_OK                 = '&Ok';
  SBT_CANCEL             = '&Cancel';
  SBT_SELECT_SOURCE      = '&Select Source';
  SBT_ACQUIRE            = '&Acquire';
  SBT_GET_CAPABILITIES   = '&Get Capabilities';

  STB_CURRENT_VALUES     = 'Preferences';
  STB_SCANER_TEST        = 'Scanner Test';
  STB_DIAGNOSTIC         = 'Diagnostic';

  SGB_IMAGE              = ' Image ';
  SGB_PRODUCT            = ' Product ';
  SGB_PROTOCOL           = ' Protocol ';
  SGB_CAPABILITIES       = ' Capabilities ';

  SLB_PIXELTYPE          = 'Pixeltype';
  SLB_FRAMESIZE          = 'Framesize';
  SLB_BITREDUCTION       = 'Bitdepthreduction';
  SLB_RESOLUTION         = 'Resolution';
  SLB_BRIGHTNESS         = 'Brightness';
  SLB_CONTRAST           = 'Contrast';
  SLB_HIGHLIGHT          = 'Highlight';
  SLB_SHADOW             = 'Shadow';
  SLB_THRESHOLD          = 'Threshold';

  SLB_AUTO_BRIGHTNESS    = 'Auto Brightness';
  SLB_INVERTED           = 'Inverted';

  SLB_MANUFACTURER       = 'Manufacturer';
  SLB_PRODUCTFAMILY      = 'Productfamily';
  SLB_PRODUCTNAME        = 'Productname';

  SLB_PROTOCOLMAJOR      = 'Protocol Major';
  SLB_PROTOCOLMINOR      = 'Protocol Minor';
implementation
end.
