{ *************************************************************************** }
{ *  Program name........: DemoMain.pas     Project......: Twain scanning   * }
{ *  Documentation.......: -                Version......: 2.00             * }
{ *  Date................: 99-07-23         Created by...: FAZI             * }
{ *  Updated.............: 99-07-23         Updated by...: FAZI             * }
{ *  Compiler............: Borland Delphi   Version......: 3.0 & 4.0        * }
{ *                                                                         * }
{ *************************************************************************** }
{ *                 Copyright (c) 1996,99 Component Store Ltd.              * }
{ *                            All rights reserved                          * }
{ *************************************************************************** }
unit Main40;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, csTwainScan, csTwainDialog, ComCtrls;

type
  TMainForm = class(TForm)
    csTwainDialog: TcsTwainDialog;
    MainMenu1: TMainMenu;
    miFile: TMenuItem;
    scbViewer: TScrollBox;
    Image: TImage;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    miAcquire: TMenuItem;
    miSelectSource: TMenuItem;
    N1: TMenuItem;
    Print1: TMenuItem;
    PrinterSetup1: TMenuItem;
    N2: TMenuItem;
    miExit: TMenuItem;
    miScannerSetup: TMenuItem;
    Save2: TMenuItem;
    Saveas1: TMenuItem;
    csTwainScan: TcsTwainScan;
    StatusBar: TStatusBar;
    procedure miAcquireClick(Sender: TObject);
    procedure miSelectSourceClick(Sender: TObject);
    procedure miScannerSetupClick(Sender: TObject);
    procedure miExitClick(Sender: TObject);
    procedure csTwainScanDibReady(Sender: TObject; hDib: HBITMAP);
    procedure csTwainScanMemoryReady(Sender: TObject; hMem: Cardinal);
    procedure csTwainScanNewImage(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
{$R *.DFM}

procedure TMainForm.miAcquireClick(Sender: TObject);
begin
  csTwainScan.Acquire;
end;

procedure TMainForm.miSelectSourceClick(Sender: TObject);
begin
  csTwainScan.SelectSource;
end;

procedure TMainForm.miScannerSetupClick(Sender: TObject);
begin
  csTwainDialog.Execute;
end;

procedure TMainForm.miExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.csTwainScanDibReady(Sender: TObject; hDib: HBITMAP);
begin
  Image.Picture.Bitmap.Handle := hDib;
  StatusBar.SimpleText:= 'Pages stored in the current document: '
    + IntToStr(csTwainScan.FrameCount);  
end;

procedure TMainForm.csTwainScanMemoryReady(Sender: TObject; hMem: Cardinal);
var
  BmpFile : TFileStream;
  Bmf     : TBitmapFileHeader;
  Buf     : pointer;
  FilePath: string;
begin
  FilePath      := ExtractFilePath(Application.ExeName);
  BmpFile       := TFileStream.Create(FilePath + '\DEMO.BMP', fmCreate);
  Bmf.bfType    := $4D42;
  Bmf.bfSize    := SizeOf(Bmf) + GlobalSize(hMem);
  Bmf.bfOffBits := SizeOf(TBitmapInfoHeader);
  Buf           := GlobalLock(hMem);
  try
    BmpFile.Write(Bmf, SizeOf(Bmf));
    BmpFile.Write(Buf^, GlobalSize(hMem));
  finally
    GlobalUnlock(hMem);
    BmpFile.Free;
  end;
end;

procedure TMainForm.csTwainScanNewImage(Sender: TObject);
begin
  Image.Picture.Bitmap.FreeImage;
end;

end.























