unit SSTry;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, SSheet, StdCtrls, Grids, ExtCtrls, Mask, Buttons, Menus;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ComboBox1: TComboBox;
    RG1: TRadioGroup;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Insert1: TMenuItem;
    Column1: TMenuItem;
    Row1: TMenuItem;
    Delete1: TMenuItem;
    Column2: TMenuItem;
    Row2: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    RadioGroup1: TRadioGroup;
    TxColor: TSSColorCombo;
    BColor: TSSColorCombo;
    Label8: TLabel;
    FMTEd: TEdit;
    ABtn: TButton;
    DBtn: TButton;
    A: TSpreadSheet;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure RG1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Column1Click(Sender: TObject);
    procedure Row1Click(Sender: TObject);
    procedure Column2Click(Sender: TObject);
    procedure Row2Click(Sender: TObject);
    procedure ASelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure TxColorChange(Sender: TObject);
    procedure BColorChange(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ABtnClick(Sender: TObject);
    procedure DBtnClick(Sender: TObject);
    procedure AFormatListChanged(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$IFDEF WIN32}
{$IFDEF VER100}
uses OleCtrls;
{$ELSE}
uses OleAuto;
{$ENDIF}
{$ENDIF}

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  AFormatListChanged(nil);
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  A.SetFocus;
end;

procedure TForm1.RG1Click(Sender: TObject);
begin
  if rg1.tag = 0 then A.Justification[A.Row, A.Col] := RG1.ItemIndex;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  with SaveDialog1 do
  begin
    FileName := '';
    if Execute then A.SaveToFile(FileName);
  end;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  with OpenDialog1 do
  begin
    FileName := '';
    if Execute then  A.LoadFromFile(FileName);
  end;
end;

procedure TForm1.Column1Click(Sender: TObject);
begin
  A.InsertColumn(A.Col);
end;

procedure TForm1.Row1Click(Sender: TObject);
begin
   A.InsertRow(A.Row);
end;

procedure TForm1.Column2Click(Sender: TObject);
begin
  A.DeleteColumn(A.Col);
end;

procedure TForm1.Row2Click(Sender: TObject);
begin
  A.DeleteRow(A.Row);
end;

procedure TForm1.ASelectCell(Sender: TObject; Col, Row: Longint;
  var CanSelect: Boolean);
begin
  Label1.Caption := 'Number  : ' + FloatToStr(A.Number[Row,Col]);
  Label2.Caption := 'Text    : ' + A.Text[Row,Col];
  Label3.Caption := 'Formula : ' + A.Formula[Row,Col];
  case A.Attrib[Row,Col] of
    isBlank               : Label4.Caption := 'Attrib : isBlank';
    isNumber              : Label4.Caption := 'Attrib : isNumber';
    isText                : Label4.Caption := 'Attrib : isText';
    isLogical             : Label4.Caption := 'Attrib : isLogical';
    isDate                : Label4.Caption := 'Attrib : isDate';
    isFormulaNumber       : Label4.Caption := 'Attrib : isFormulaNumber';
    isFormulaText         : Label4.Caption := 'Attrib : isFormulaText';
    isFormulaLogical      : Label4.Caption := 'Attrib : isFormulaLogical';
    isFormulaDate         : Label4.Caption := 'Attrib : isFormulaDate';
    isFormulaError        : Label4.Caption := 'Attrib : isFormulaError';
    isEmpty               : Label4.Caption := 'Attrib : isEmpty';
  end;
  ComboBox1.ItemIndex := ComboBox1.Items.IndexOf(A.CellFormat[Row,Col]);
  rg1.tag := 1;
  RG1.ItemIndex := A.Justification[Row,Col];
  rg1.tag := 0;
  TxColor.SelColor := A.TextColor[Row,Col];
  BColor.SelColor := A.BackColor[Row,Col];
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  A.DisplayFormulas := RadioGroup1.ItemIndex = 0;
end;

procedure TForm1.TxColorChange(Sender: TObject);
begin
  A.TextColor[A.Row, A.Col] := TxColor.SelColor;
end;

procedure TForm1.BColorChange(Sender: TObject);
begin
  A.BackColor[A.Row, A.Col] := BColor.SelColor;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  A.CellFormat[A.Row, A.Col] := ComboBox1.Items[ComboBox1.ItemIndex];
end;

procedure TForm1.ABtnClick(Sender: TObject);
begin
  A.AddFormat(FMTEd.Text);
end;

procedure TForm1.DBtnClick(Sender: TObject);
begin
  if A.DelFormatS(ComboBox1.Items[ComboBox1.ItemIndex]) < 0
    then ShowMessage('Cannot delete');
end;

procedure TForm1.AFormatListChanged(Sender: TObject);
var
  Can: Boolean;
begin
  A.GetFormats(ComboBox1.Items);
  ASelectCell(nil, A.Col, A.Row, Can);
end;

end.
