unit p1Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolKitMan, StdCtrls, ComCtrls,ComType,dbtables,db,dbgrids,dbctrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    ToolKitFormEdit1: TToolKitFormEdit;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ToolKitFormEdit1CreateNewObject(Sender: TObject;
      var Control: TControl; var Form: TForm);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  ToolKitFormEdit1.ToolKitManager.Mode:=pmDesign;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  Canvas.MoveTo (0,0);
  Canvas.LineTo(Width,Height);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ToolKitFormEdit1.ToolKitManager.GlobalOnCreateNewObject:=ToolKitFormEdit1CreateNewObject;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Form1.ToolKitFormEdit1.ToolKitManager.SaveForm (Self);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  //Load the form then showmodal then Destroy!
  If ToolKitFormEdit1.FormSavedAvailable Then TForm1(ToolKitFormEdit1.ToolKitManager.LoadForm ('Form1',TForm1,smModal)).Destroy;
end;

procedure TForm1.ToolKitFormEdit1CreateNewObject(Sender: TObject;
  var Control: TControl; var Form: TForm);
Var
  ATable : TTable;
  Nav    : TDBgrid;
  Image  : TDBImage;
begin
  If (Control.ClassName='TDataSource') And (Sender Is TToolKitManager) Then
  Begin
    MessageDlg('Thanks', mtInformation,[mbOk], 0);
    ATable := TTable.Create(Form);
    ATable.DataBaseName:='DBDEMOS';
    ATable.TableName:='ANIMALS.DBF';

    Nav:= TDBgrid.Create(Form);
    Nav.Parent:=Form;
    Nav.DataSource:=TDataSource(Control);
    Nav.Align:=alBottom;
    Nav.Visible:=True;

    Image  := TDBImage.Create(Form);
    Image.Parent:=Form;
    Image.DataSource:=TDataSource(Control);
    Image.DataField:='BMP';
    Image.Align:=alRight;
    Image.Width:=300;
    Image.Visible:=True;

    ATable.Active:=True;
    TDataSource(Control).DataSet:=ATable;
  End Else
  Begin
    If Sender Is TToolKitManager Then
      MessageDlg('Message From ToolKitManager. New Object : '+Control.Name + ' Of Class : ' +Control.ClassName+' Created on '+ Form.Name , mtInformation,[mbOk], 0)
    Else
      MessageDlg('Message From '+TToolKitFormEdit(Sender).Name+'. New Object : '+Control.Name + ' Of Class : ' +Control.ClassName+' Created on '+ Form.Name , mtInformation,[mbOk], 0);
  End;
end;

end.
