unit emenu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Buttons, ComCtrls, PEdit, ExtCtrls,Util;

type
  TFrmMenu = class(TForm)
    MenuEdit: TTreeView;
    BitBtn1: TBitBtn;
    Edit1: TEdit;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    PComp: TPropertiesComponent;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure MenuEditClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmMenu: TFrmMenu;

implementation


{$R *.DFM}

procedure TFrmMenu.BitBtn1Click(Sender: TObject);
Var
  NewItem: TMenuItem;
Begin
  NewItem := TMenuItem.Create(TComponent(Self.Tag).Owner);
  NewItem.Caption := Edit1.Text;
  NewItem.Name := GetValidName (TwinControl(TComponent(Self.Tag).Owner), 'Menu');
  TMainMenu(Self.Tag).Items.Add(NewItem);
  MenuEdit.Items.AddObject(Nil,Edit1.Text,NewItem);
  MenuEdit.FullExpand;
  PComp.SpyComp(NewItem);
  If Not PComp.FormProperties.Visible Then PComp.Show;
End;

procedure TFrmMenu.BitBtn2Click(Sender: TObject);
Var
  NewItem: TMenuItem;
Begin
  NewItem := TMenuItem.Create(TComponent(Self.Tag).Owner);
  NewItem.Caption := Edit1.Text;
  NewItem.Name := GetValidName (TwinControl(TComponent(Self.Tag).Owner), 'Menu');
  TMenuItem(MenuEdit.Selected.Data).Add(NewItem);
  MenuEdit.Items.AddChildObject(MenuEdit.Selected,Edit1.Text,NewItem);
  MenuEdit.FullExpand;
  PComp.SpyComp(NewItem);
  If Not PComp.FormProperties.Visible Then PComp.Show;
end;

procedure TFrmMenu.MenuEditClick(Sender: TObject);
begin
  BitBtn2.Enabled:=MenuEdit.Selected<>Nil;
  If MenuEdit.Selected=Nil Then Exit;
  PComp.SpyComp(TMenuItem(MenuEdit.Selected.Data));
  If Not PComp.FormProperties.Visible Then PComp.Show;
end;

procedure TFrmMenu.FormCreate(Sender: TObject);
begin
  PComp.FormProperties.ListComp.Enabled:=False;
  PComp.FormProperties.Tag:=LongInt(PComp.FormProperties);
  Self.Tag:=LongInt(Self);
end;

procedure TFrmMenu.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  PComp.FormProperties.Visible:=False;
end;

procedure TFrmMenu.Edit1Change(Sender: TObject);
begin
  BitBtn1.Enabled:=Trim(Edit1.Text)<>'';
end;

End.
