unit Util;

interface
uses
  Classes, Controls, SysUtils, Graphics;

Type
  TOptionsRec   = Record
    GridColor   : TColor;
    GridSize    ,
    GridX       ,
    GridY       : Integer;
    ShowGrid    ,
    SnapToGrid  : Boolean;
  End;

Var
  OptionsRec    : TOptionsRec;

Function GlobalNameFind ( AOwner : TWinControl; AName: String) : TComponent;
Function GetValidName (AOwner : TWinControl; Prefix: String) : String;

Implementation

Function GlobalNameFind ( AOwner : TWinControl; AName: String) : TComponent;
Var
  Count    : Integer;
Begin
  If UpperCase(AOwner.Name)=UpperCase(AName) Then
  Begin
    Result:=AOwner;
    Exit;
  End;
  Result:=AOwner.FindComponent(AName);
  If Result<>Nil Then Exit;
  For Count:=0 To AOwner.ComponentCount-1 Do
  Begin
    If AOwner.Components[Count] Is TWinControl Then Result:=GlobalNameFind ( TWinControl(AOwner.Components[Count]),AName);
    If Result<>Nil Then Break;
  End;
End;

Function GetValidName (AOwner : TWinControl; Prefix: String) : String;
Var
  Count   : Integer;
  IsValid : Boolean;
Begin
 IsValid:=False;
 Count:=1;
 Result:=Prefix+IntToStr(Count);
 While Not IsValid Do
 Begin
   IsValid:=GlobalNameFind(AOwner,Prefix+IntToStr(Count))=Nil;
   If IsValid Then
   Begin
     Result:=Prefix+IntToStr(Count);
     Exit;
   End;
   Inc(Count);
 End;
End;

end.
