unit MainMenu97;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TB97, Menus;

type
  TWhatDo = (wdDelete, wdHide, wdNothing);

  TMainMenu97 = class;
  TMenuItemBitmap = class
  public
    MenuName : string;
    MenuItem : TMenuItem;
    Bitmap : TBitmap;
    destructor Destroy; override;
  end;

  TMenuItemBitmaps = class (TPersistent)
  private
    ABitmaps : TList;
    FMainMenu97 : TMainMenu97;
    function GetBitmaps (index : TMenuItem) : TBitmap;
    procedure SetBitmaps (index : TMenuItem; ABitmap : TBitmap);
    procedure ReadData (Stream : TStream);
    procedure WriteData (Stream : TStream);
  protected
    property MainMenu97 : TMainMenu97 read FMainMenu97 write FMainMenu97;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    procedure Add (MenuItem : TMenuItem; Bitmap : TBitmap);
    property Bitmaps [index : TMenuItem] : TBitmap read GetBitmaps write SetBitmaps; default;
  end;

  TMainMenu97 = class(TToolbar97)
  Private
    FMainMenu : TMainMenu;
    FPopups : TList;
    FWhatDo : TWhatDo;
    FBitmaps : TMenuItemBitmaps;
    FBitmapsChecked : TMenuItemBitmaps;
    function GetPopups (index : integer) : TPopupMenu;
    procedure SetMainMenu (AMainMenu : TMainMenu);
  Protected
    procedure DefineProperties (Filer : TFiler); override;
    procedure Loaded; override;
    procedure Notification (AComponent: TComponent; Operation: TOperation); override;
    procedure FixupReferences;
  Public
    MenuItemList   : TList;
    constructor Create (AOwner : TComponent); Override;
    destructor Destroy; override;
    property Popups [index : integer] : TPopupMenu read GetPopups;
  Published
    property MainMenu : TMainMenu read FMainMenu write SetMainMenu;
    property WhatDoWithOldMenus : TWhatDo read FWhatDo write FWhatDo default wdDelete;
    property Bitmaps : TMenuItemBitmaps read FBitmaps stored false;
    property BitmapsChecked : TMenuItemBitmaps read FBitmapsChecked stored false;
  End;

Procedure Register;

implementation

uses
  OptionBox97, UnitMenuItems;

type
  TMenuOptionBox97 = class (TOptionBox97)
  private
    function GetCaption : string;
    procedure SetCaption (const Value : string);
  public
    constructor Create (AOwner : TComponent); override;
  published
    property Caption : string read GetCaption write SetCaption;
  end;

Procedure Register;
Begin
  RegisterComponents('New', [TMainMenu97]);
End;

constructor TMenuOptionBox97.Create;
begin
  inherited Create (AOwner);
  NoModifyTag := true;
end;

function TMenuOptionBox97.GetCaption;
begin
  Result := inherited Caption;
end;

procedure TMenuOptionBox97.SetCaption;
var
  DC: HDC;
  Rect: TRect;
begin
  inherited Caption := value;
  Rect := ClientRect;
  DC := GetDC(0);
  Canvas.Handle := DC;
  Canvas.Font := Font;
  DrawText(Canvas.Handle, PChar (Caption), length (Caption), Rect, (DT_EXPANDTABS or DT_CALCRECT));
  Canvas.Handle := 0;
  ReleaseDC(0, DC);
  SetBounds(Left, Top, Rect.Right + 10, Top + Height);
end;

{ TMenuItemBitmap }

destructor TMenuItemBitmap.Destroy;
begin
  Bitmap.Free;
  inherited Destroy;
end;

{ TMenuItemBitmaps }

constructor TMenuItemBitmaps.Create;
begin
  inherited Create;
  ABitmaps := TList.Create;
end;

destructor TMenuItemBitmaps.Destroy;
begin
  Clear;
  ABitmaps.Free;
  inherited Destroy;
end;

procedure TMenuItemBitmaps.Clear;
begin
  while ABitmaps.Count > 0 do
    begin
      TMenuItemBitmap (ABitmaps [0]).Free;
      ABitmaps.Delete (0);
    end;
end;

procedure TMenuItemBitmaps.Add;
var
  Item : TMenuItemBitmap;
begin
  Item := TMenuItemBitmap.Create;
  Item.MenuItem := MenuItem;
  Item.Bitmap := Bitmap;
  Item.MenuName := MenuItem.Name;
  ABitmaps.Add (Item);
end;

function TMenuItemBitmaps.GetBitmaps;
var
  i : integer;
begin
  for i := 0 to ABitmaps.Count - 1 do
    if TMenuItemBitmap (ABitmaps [i]).MenuItem = index
      then
      begin
        Result := TMenuItemBitmap (ABitmaps [i]).Bitmap;
        exit;
      end;
  Result := nil;
end;

procedure TMenuItemBitmaps.SetBitmaps;
var
  i : integer;
begin
  for i := 0 to ABitmaps.Count - 1 do
    if TMenuItemBitmap (ABitmaps [i]).MenuItem = index
      then
      begin
        if TMenuItemBitmap (ABitmaps [i]).Bitmap = nil
          then TMenuItemBitmap (ABitmaps [i]).Bitmap := TBitmap.Create;
        TMenuItemBitmap (ABitmaps [i]).Bitmap.Assign (ABitmap);
        break;
      end;
end;

procedure TMenuItemBitmaps.ReadData;
var
  i, n, ASize : integer;
  MemStream : TMemoryStream;
  MenuItemBitmap : TMenuItemBitmap;
  Reader : TReader;
begin
  Reader := TReader.Create (Stream, 1024);
  try
    with Reader do
      begin
        n := ReadInteger;
        for i := 0 to n - 1 do
          begin
            MenuItemBitmap := TMenuItemBitmap.Create;
            try
              with MenuItemBitmap do
                begin
                  MenuName := ReadString;
                  ASize := ReadInteger;
                  if ASize > 0
                    then
                    begin
                      MemStream := TMemoryStream.Create;
                      try
                        MemStream.SetSize (ASize);
                        Read (MemStream.Memory^, ASize);
                        Bitmap := TBitmap.Create;
                        Bitmap.LoadFromStream (MemStream);
                      finally
                        MemStream.Free;
                      end;
                    end;
                end;
            finally
              ABitmaps.Add (MenuItemBitmap);
            end;
          end;
      end;
  finally
    Reader.Free;
  end;
end;

procedure TMenuItemBitmaps.WriteData;
var
  i : integer;
  MemStream : TMemoryStream;
  Writer : TWriter;
begin
  Writer := TWriter.Create (Stream, 1024);
  try
    with Writer do
      begin
        WriteInteger (ABitmaps.Count);
        for i := 0 to ABitmaps.Count - 1 do
          with TMenuItemBitmap (ABitmaps [i]) do
            begin
              WriteString (MenuItem.Name);
              if (Bitmap = nil) or (Bitmap.Empty)
                then WriteInteger (0)
                else
                begin
                  MemStream := TMemoryStream.Create;
                  try
                    Bitmap.SaveToStream (MemStream);
                    WriteInteger (MemStream.Size);
                    Write (MemStream.Memory^, MemStream.Size);
                  finally
                    MemStream.Free;
                  end;
                end;
            end;
      end;
  finally
    Writer.Free;
  end;
end;

{ TMainMenu97 }

constructor TMainMenu97.Create;
begin
  inherited Create (AOwner);
  MenuItemList := TList.Create;
  FPopups := TList.Create;
  FBitmaps := TMenuItemBitmaps.create;
  FBitmaps.MainMenu97 := self;
  FbitmapsChecked := TMenuItemBitmaps.Create;
  FBitmapsChecked.MainMenu97 := self;
end;

destructor TMainMenu97.Destroy;
begin
  MenuItemList.Free;
  FPopups.Free;
  FBitmaps.Free;
  FBitmapsChecked.Free;
  inherited Destroy;
end;

procedure TMainMenu97.SetMainMenu;
begin
  if AMainMenu <> FMainMenu
    then
    begin
      FMainMenu := AMainMenu;
      if not (csLoading in ComponentState)
        then
        begin
          FBitmaps.Clear;
          FBitmapsChecked.Clear;
        end;
    end;
end;

procedure TMainMenu97.DefineProperties;
begin
  inherited DefineProperties (Filer);
  Filer.DefineBinaryProperty ('TheBitmaps', FBitmaps.ReadData, FBitmaps.WriteData, FBitmaps.ABitmaps.Count > 0);
  Filer.DefineBinaryProperty ('TheBitmapsChecked', FBitmapsChecked.ReadData, FBitmapsChecked.WriteData, FBitmapsChecked.ABitmaps.Count > 0);
end;

procedure TMainMenu97.Notification;
var
  i : integer;
begin
  inherited Notification (AComponent, Operation);
  if (Operation = opRemove) and (AComponent is TMenuItem)
    then
    begin
      for i := 0 to FBitmaps.ABitmaps.Count - 1 do
        if TMenuItemBitmap (FBitmaps.ABitmaps [i]).MenuItem = AComponent
          then
          begin
            FBitmaps.ABitmaps.Delete (i);
            break;
          end;
    end;
  if (Operation = opRemove) and (AComponent = MainMenu)
    then
    begin
      MainMenu := nil;
      FBitmaps.Clear;
      FBitmapsChecked.Clear;
    end;
end;

function TMainMenu97.GetPopups;
begin
  Result := TPopupMenu (FPopups [index]);
end;

procedure TMainMenu97.FixupReferences;
var
  i : integer;
  Item : TMenuItem;
  MName : string;
begin
  if MainMenu <> nil
    then
    begin
      for i := 0 to FBitmaps.ABitmaps.Count - 1 do
        begin
          MName := TMenuItemBitmap (FBitmaps.ABitmaps [i]).MenuName;
          Item := TMenuItem (Owner.FindComponent (MName));
          TMenuItemBitmap (FBitmaps.ABitmaps [i]).MenuItem := Item;
        end;
      for i := 0 to FBitmapsChecked.ABitmaps.Count - 1 do
        begin
          MName := TMenuItemBitmap (FBitmapsChecked.ABitmaps [i]).MenuName;
          Item := TMenuItem (Owner.FindComponent (MName));
          TMenuItemBitmap (FBitmapsChecked.ABitmaps [i]).MenuItem := Item;
        end;
    end;
end;

procedure TMainMenu97.Loaded;
const
  ItemCount : integer = 0;
var
  i, j : integer;
  Button : TMenuOptionBox97;
  Deep : integer;
procedure AddItems (MenuFrom, MenuTo : TMenuItem);
var
  i : integer;
  Sub : TMenuItem;
  ABitMapCh, ABitMap, Bit, BitCh : TBitMap;
  H, HCh : THandle;
begin
  inc (Deep);
  try
    if Deep = 1
      then
      begin
        Bit := FBitmaps [MenuFrom];
        if (Bit <> nil) and (not Bit.Empty)
          then
          begin
            Button.Glyph.Assign (Bit);
            Button.Width := Button.Width + Bit.Width;
          end;
      end;
    for i := 0 to MenuFrom.Count - 1 do
      begin
        Sub := TMenuItem.Create (MenuTo);
        with MenuFrom [i] do
          begin
            Sub.Caption := Caption;
            Sub.Break := Break;
            Sub.OnClick := OnClick;
            Sub.Default := Default;
            Sub.Name := '_'+Name;
            Sub.Enabled := Enabled;
            Sub.RadioItem := RadioItem;
            Sub.Checked := Checked;
            Sub.GroupIndex := GroupIndex;
            Sub.HelpContext := HelpContext;
            Sub.Hint := Hint;
            Sub.MenuIndex := MenuIndex;
            Sub.ShortCut := ShortCut;
            Sub.Tag := Tag;
            Sub.Visible := Visible;
          end;
        MenuItemList.Add(Sub);
        MenuTo.Add (Sub);
        if MenuFrom.Items [i].Count > 0
          then AddItems (MenuFrom.Items [i], Sub);
      end;
    for i := 0 to MenuTo.Count - 1 do
      begin
        Bit := FBitmaps [MenuFrom.Items [i]];
        BitCh := FBitmapsChecked [MenuFrom.Items [i]];
        if (Bit <> nil) and (not Bit.Empty)
          then
          begin
            ABitmap := TBitmap.Create;
            ABitmap.Assign (Bit);
            H := ABitmap.Handle;
          end
          else H := 0;
        if (BitCh <> nil) and (not BitCh.Empty)
          then
          begin
            ABitmapCh := TBitmap.Create;
            ABitmapCh.Assign (BitCh);
            HCh := ABitmapCh.Handle;
          end
          else HCh := 0;
        SetMenuItemBitmaps (MenuTo.Handle, i, MF_BYPOSITION, H, HCh)
      end;
  finally
    dec (Deep);
  end;
end;
begin
  inherited Loaded;
  FixupReferences;
  if (not (csDesigning in ComponentState)) and (FMainMenu <> nil)
    then
    begin
      j := 0;
      Deep := 0;
      with FMainMenu.Items do
        for i := 0 to Count - 1 do
          begin
            Button := TMenuOptionBox97.Create (self);
            with Button do
              begin
                ChangeCaptionOnSelect := false;
                DropDownArrow := false;
                DropDownOnClick := true;
                Left := j;
                Caption := FMainMenu.Items.Items [i].Caption;
                Height := 19;
                Parent := self;
                OnClick := FMainMenu.Items.Items [i].OnClick;
                FPopups.Add (TPopupMenu.Create (Owner));
                DropDownMenu := TPopupMenu (FPopups [i]);
                AddItems (FMainMenu.Items.Items [i], TPopupMenu (FPopups [i]).Items);
                Initialize;
                inc (j, Width);
              end;
          end;
      j := 0;
      for i := 0 to ComponentCount - 1 do
        begin
          if Components [i] is TOptionBox97
            then
            begin
              (Components [i] as TOptionBox97).Height := 19;
              case FWhatDo of
                wdDelete : FMainMenu.Items.Delete (0);
                wdHide : FMainMenu.Items.Items [j].Visible := false;
                wdNothing : (* Nothing to do *);
              end;
              inc (j);
            end;
        end;
    end;
end;

end.
