Unit CtrInt;

Interface

Uses SysUtils,Classes,Controls,ComType;

Function  AddAliasGroup          ( GroupName, AClassName : String) : PAliasGroup;
Function  FindAliasGroup         ( GroupName : String) : PAliasGroup;
Function  FindRefClass           ( AClassName: String) : PRegControls;
Function  AddAlias               ( GroupName, APropertyName, AAliasName : String) : PAlias;
//Function  GetValueByAlias        ( ClassName, AliasName    : String) : Variant;
//Function  GetValueByProperty     ( ClassName, PropertyName : String) : Variant;
//Procedure SetValueByProperty     ( ClassName, PropertyName : String; Value : Variant);

Function  AddGroupControls       ( AName : String ) : PGroupCtrls;
Function  FindGroupControls      ( AName : String ) : PGroupCtrls;
Function  AddClassRef            ( AClassRef : TPersistentClass;
                                   GroupName, AClassName, AHint : String; ATag : LongInt ) : PRegControls;
Procedure IterateGroups          ( ACallBackGroup : TCallBackGroup);

Implementation

Var
  AliasGroupStart        ,
  AliasGroupEnd          : PAliasGroup;
  GroupCtrlsStart        ,
  GroupCtrlsEnd          : PGroupCtrls;
  GlobalID               : LongInt;

Function  FindRefClass           ( AClassName: String) : PRegControls;
Var
  AGroup : PGroupCtrls;
Begin
  AGroup := GroupCtrlsStart;
  Result := Nil;
  While (AGroup<>Nil) Do
  Begin
    Result:=AGroup^.RegControlsStart;
    While (Result<>Nil) And (UpperCase(Result^.ClassRef.ClassName)<>UpperCase(AClassName)) Do Result:=Result^.Next;
    If Result<>Nil Then Exit;
    AGroup:=AGroup^.Next;
  End;
End;

Function  FindAliasGroup         ( GroupName : String) : PAliasGroup;
Begin
  Result:=AliasGroupStart;
  While (Result<>Nil) And (UpperCase(Result^.Name)<>UpperCase(GroupName)) Do Result:=Result^.Next;
End;

Function  AddAliasGroup          ( GroupName, AClassName  : String) : PAliasGroup;
Var
  ARegControls : PRegControls;
Begin
  Result:=Nil;
  ARegControls := FindRefClass( AClassName );
  If ARegControls=Nil Then Exit;
  New(Result);
  ARegControls^.AliasGroup:=Result;
  If AliasGroupStart=Nil Then AliasGroupStart:=Result;
  With Result^ Do
  Begin
    ClassName:=AClassName;
    Name := GroupName;
    Next := Nil;
    Prev := AliasGroupEnd;
    If AliasGroupEnd<>Nil Then AliasGroupEnd^.Next := Result;
  End;
  AliasGroupEnd:=Result;
End;

Function  AddAlias ( GroupName, APropertyName, AAliasName : String) : PAlias;
Var
  AGroup : PAliasGroup;
Begin
  AGroup := FindAliasGroup(GroupName);
  Result := Nil;
  If AGroup=Nil Then Exit;
  New (Result);
  If AGroup^.AliasStart=Nil Then AGroup^.AliasStart:=Result;
  With Result^ Do
  Begin
    PropertyName  := APropertyName;
    PropertyAlias := AAliasName;
    Prev          := AGroup^.AliasEnd;
    Next          := Nil;
    If AGroup^.AliasEnd<>Nil Then AGroup^.AliasEnd^.Next:=Result;
  End;
  AGroup^.AliasEnd:=Result;
End;

Function  FindGroupControls      ( AName : String ) : PGroupCtrls;
Var
  AGroup : PGroupCtrls;
Begin
  AGroup := GroupCtrlsStart;
  While (AGroup<>Nil) And (UpperCase(AGroup^.Name)<>UpperCase(AName)) Do AGroup:=AGroup^.Next;
  Result:=AGroup;
End;

Function AddGroupControls ( AName : String ) : PGroupCtrls;
Begin
  New (Result);
  If GroupCtrlsStart=Nil Then GroupCtrlsStart:=Result;
  With Result^ Do
  Begin
    Name             := AName;
    CountCtrls       := 0;
    RegControlsEnd   := Nil;
    RegControlsStart := Nil;
    Next             := Nil;
    Prev             := GroupCtrlsEnd;
    If GroupCtrlsEnd<>Nil Then GroupCtrlsEnd^.Next:=Result;
  End;
  GroupCtrlsEnd:=Result;
End;

Procedure IterateGroups ( ACallBackGroup : TCallBackGroup);
Var
  AGroup : PGroupCtrls;
Begin
  AGroup := GroupCtrlsStart;
  While AGroup<>Nil Do
  Begin
    ACallBackGroup (AGroup);
    AGroup:=AGroup^.Next;
  End;
End;

Function AddClassRef ( AClassRef : TPersistentClass; GroupName,AClassName,AHint : String; ATag : LongInt ) : PRegControls;
Var
  AGroup : PGroupCtrls;
  CLName : String;
Begin
  Result := Nil;
  AGroup:=FindGroupControls(GroupName);
  If AGroup = Nil Then AGroup:=FindGroupControls('Default');
  If AGroup = Nil Then Exit;
  Inc(GlobalID);
  New (Result);
  If AGroup^.RegControlsStart=Nil Then AGroup^.RegControlsStart:=Result;
  With Result^ Do
  Begin
    Tag        := ATag;  
    Count      := 0;
    ID         := GlobalID;
    Hint       := AHint;
    Name       := AClassName;
    ClassRef   := AClassRef;
    AliasGroup := Nil;
    Next       := Nil;
    Prev       := AGroup^.RegControlsEnd;
    If AGroup^.RegControlsEnd<>Nil Then AGroup^.RegControlsEnd^.Next:=Result;
    Try
      CLName:=AClassRef.ClassName;
      If GetClass(CLName)=Nil Then
      Try
        RegisterClass(AClassRef);
      Except
      End;
    Except
      Try
        RegisterClass(AClassRef);
      Except
      End;
    End;
  End;
  Inc(AGroup^.CountCtrls);
  AGroup^.RegControlsEnd:=Result;
End;

Procedure InitModule;
Begin
  GroupCtrlsStart  := Nil;
  GroupCtrlsEnd    := Nil;
  AliasGroupStart  := Nil;
  AliasGroupEnd    := Nil;
  GlobalID         := 0;
End;

Procedure FreeModule;
Var
  ActG  ,
  NxG   : PGroupCtrls;
  ActC  ,
  NxC   : PRegControls;
Begin
  ActG:=GroupCtrlsStart;
  While ActG<>Nil Do
  Begin
    NxG:=ActG^.Next;
    ActC:=ActG^.RegControlsStart;
    While ActC<>Nil Do
    Begin
      //Dispose Control
      NxC:=ActC^.Next;
      Dispose(ActC);
      ActC:=NxC;
    End;
    //Dispose Group
    Dispose(ActG);
    ActG:=NxG;
  End;
End;

Initialization
  InitModule;

Finalization
  FreeModule;
End.
