// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ThumbnailList.pas' rev: 4.00

#ifndef ThumbnailListHPP
#define ThumbnailListHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Menus.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <ActiveX.hpp>	// Pascal unit
#include <ComObj.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Thumbnaillist
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TIPicture;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TIPicture : public Graphics::TGraphic 
{
	typedef Graphics::TGraphic inherited;
	
private:
	_di_IPicture gpPicture;
	Classes::TMemoryStream* FDatastream;
	bool FIsEmpty;
	bool FStretched;
	int FLogPixX;
	int FLogPixY;
	AnsiString FID;
	int FFrame;
	Classes::TNotifyEvent FOnFrameChange;
	Word FFrameXPos;
	Word FFrameYPos;
	Word FFrameXSize;
	Word FFrameYSize;
	bool FFrameTransp;
	Word FFrameDisposal;
	Word FAnimMaxX;
	Word FAnimMaxY;
	void __fastcall LoadPicture(void);
	int __fastcall GetFrameCount(void);
	bool __fastcall IsGIFFile(void);
	int __fastcall GetFrameTime(int i);
	
protected:
	virtual bool __fastcall GetEmpty(void);
	virtual int __fastcall GetHeight(void);
	virtual int __fastcall GetWidth(void);
	virtual void __fastcall SetHeight(int Value);
	virtual void __fastcall SetWidth(int Value);
	virtual void __fastcall ReadData(Classes::TStream* Stream);
	virtual void __fastcall WriteData(Classes::TStream* Stream);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const Windows::TRect &Rect);
	void __fastcall SetFrame(const int Value);
	
public:
	__fastcall virtual TIPicture(void);
	__fastcall virtual ~TIPicture(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall LoadFromFile(const AnsiString FileName);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromResourceName(unsigned Instance, const AnsiString ResName);
	void __fastcall LoadFromResourceID(unsigned Instance, int ResID);
	void __fastcall LoadFromURL(AnsiString url);
	virtual void __fastcall LoadFromClipboardFormat(Word AFormat, unsigned AData, HPALETTE APalette);
	virtual void __fastcall SaveToClipboardFormat(Word &AFormat, unsigned &AData, HPALETTE &APalette);
	__property AnsiString ID = {read=FID, write=FID};
	__property bool IsGIF = {read=IsGIFFile, nodefault};
	__property int FrameCount = {read=GetFrameCount, nodefault};
	__property int FrameTime[int i] = {read=GetFrameTime};
	int __fastcall GetMaxHeight(void);
	int __fastcall GetMaxWidth(void);
	
__published:
	__property bool Stretch = {read=FStretched, write=FStretched, nodefault};
	__property int Frame = {read=FFrame, write=SetFrame, nodefault};
	__property Classes::TNotifyEvent OnFrameChange = {read=FOnFrameChange, write=FOnFrameChange};
};

#pragma pack(pop)

#pragma option push -b-
enum TThumbnailSource { tsPicture, tsFile };
#pragma option pop

class DELPHICLASS TThumbnail;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TThumbnail : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	TIPicture* FPicture;
	AnsiString FFilename;
	TThumbnailSource FSource;
	AnsiString FCaption;
	int FTag;
	void __fastcall SetPicture(const TIPicture* Value);
	void __fastcall SetFileName(const AnsiString Value);
	void __fastcall SetCaption(const AnsiString Value);
	HIDESBASE void __fastcall Changed(void);
	void __fastcall PictureChanged(System::TObject* Sender);
	
public:
	__fastcall virtual TThumbnail(Classes::TCollection* Collection);
	__fastcall virtual ~TThumbnail(void);
	
__published:
	__property TIPicture* Picture = {read=FPicture, write=SetPicture};
	__property TThumbnailSource Source = {read=FSource, write=FSource, nodefault};
	__property AnsiString Filename = {read=FFilename, write=SetFileName};
	__property AnsiString Caption = {read=FCaption, write=SetCaption};
	__property int Tag = {read=FTag, write=FTag, nodefault};
};

#pragma pack(pop)

class DELPHICLASS TThumbnails;
class DELPHICLASS TThumbnailList;
#pragma option push -b-
enum TThumbnailOrientation { toVertical, toHorizontal };
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TThumbnailList : public Stdctrls::TCustomListBox 
{
	typedef Stdctrls::TCustomListBox inherited;
	
private:
	TThumbnails* FThumbnails;
	int FUpdateCount;
	bool FShowCaption;
	TThumbnailOrientation FOrientation;
	int FThumbnailSize;
	bool FBuffered;
	bool FShowSelection;
	HIDESBASE MESSAGE void __fastcall CNDrawItem(Messages::TWMDrawItem &Message);
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Message);
	void __fastcall SetThumbnails(const TThumbnails* Value);
	void __fastcall BuildItems(void);
	void __fastcall SetShowCaption(const bool Value);
	void __fastcall SetOrientation(const TThumbnailOrientation Value);
	void __fastcall SetThumbnailSize(const int Value);
	void __fastcall SetShowSelection(const bool Value);
	
protected:
	virtual void __fastcall DrawItem(int Index, const Windows::TRect &ARect, Stdctrls::TOwnerDrawState 
		AState);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	void __fastcall UpdateHorzScroll(void);
	__property Items ;
	DYNAMIC void __fastcall Resize(void);
	
public:
	__fastcall virtual TThumbnailList(Classes::TComponent* AOwner);
	__fastcall virtual ~TThumbnailList(void);
	virtual void __fastcall Loaded(void);
	void __fastcall ShowFolder(AnsiString FolderName);
	
__published:
	__property Align ;
	__property Anchors ;
	__property Constraints ;
	__property DragKind ;
	__property ParentBiDiMode ;
	__property BorderStyle ;
	__property bool Buffered = {read=FBuffered, write=FBuffered, default=1};
	__property Color ;
	__property Columns ;
	__property Cursor ;
	__property DragCursor ;
	__property DragMode ;
	__property Enabled ;
	__property Font ;
	__property MultiSelect ;
	__property TThumbnailOrientation Orientation = {read=FOrientation, write=SetOrientation, default=0}
		;
	__property ParentColor ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PopupMenu ;
	__property bool ShowCaption = {read=FShowCaption, write=SetShowCaption, default=1};
	__property ShowHint ;
	__property bool ShowSelection = {read=FShowSelection, write=SetShowSelection, nodefault};
	__property TabOrder ;
	__property TabStop ;
	__property TThumbnails* Thumbnails = {read=FThumbnails, write=SetThumbnails};
	__property int ThumbnailSize = {read=FThumbnailSize, write=SetThumbnailSize, nodefault};
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDock ;
	__property OnStartDock ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TThumbnailList(HWND ParentWindow) : Stdctrls::TCustomListBox(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TThumbnails : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TThumbnailList* FOwner;
	int FThumbnailCount;
	HIDESBASE TThumbnail* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TThumbnail* Value);
	HIDESBASE void __fastcall Changed(System::TObject* Sender);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	void __fastcall AddThumb(void);
	void __fastcall RemoveThumb(void);
	
public:
	__fastcall TThumbnails(TThumbnailList* AOwner);
	HIDESBASE TThumbnail* __fastcall Add(void);
	HIDESBASE TThumbnail* __fastcall Insert(int index);
	__property TThumbnail* Items[int Index] = {read=GetItem, write=SetItem};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TThumbnails(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Thumbnaillist */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Thumbnaillist;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ThumbnailList
