unit UMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ComCtrls, ExtCtrls, StdCtrls, Buttons, TGClasses, Globe4, TGSysUtils, GlobeUtils;

const
	TITLE = 'World Clock : ';

type
	TForm1 = class(TForm)
		Panel1: TPanel;
		cbxAuto: TCheckBox;
		Timer1: TTimer;
    sbDate: TScrollBar;
    sbTime: TScrollBar;
    Label1: TLabel;
    Label2: TLabel;
    SpeedButton1: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Globe: TGlobe4;
		procedure GlobeRender(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure Timer1Timer(Sender: TObject);
		procedure sbDateChange(Sender: TObject);
		procedure Panel1Click(Sender: TObject);
		procedure GlobeDblClick(Sender: TObject);
		procedure GlobeMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
    procedure GlobePaint(Sender: TObject);
    procedure GlobeMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GlobeZoomed(Sender: TObject);
    procedure GlobePaintGraticule(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	Form1: TForm1;
	gDateTime, gFirstDayOfYear : TDateTime;
	giBar : integer;


implementation

{$R *.DFM}

{----------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
var
	iYear,iTmp : word;
begin
	Globe.SurfaceTextureName := ExtractFilePath( ParamStr(0)) + 'World.bmp';

	if Globe.SurfaceTextureName = '' then
    CreateFileLayer( Globe, ExtractFilePath( ParamStr(0)) + 'World.lyr' );

	DecodeDate( date, iYear, iTmp, iTmp );
	gFirstDayOfYear := EncodeDate( iYear, 1, 1 );
	giBar := 0;
	Timer1Timer( Sender );
end;

{----------------------------------------------------------------------------}
procedure TForm1.FormResize(Sender: TObject);
begin
	Globe.Projection.Altitude := 0;
end;

{----------------------------------------------------------------------------}
function TimeWithBias( ADateTime : TDateTime ) : TDateTime;
var
	TimeZone : TTimeZoneInformation;
	iBias : integer;
begin
	case GetTimeZoneInformation( TimeZone ) of
	1 :		iBias := TimeZone.Bias + TimeZone.StandardBias;
	2 :		iBias := TimeZone.Bias + TimeZone.DayLightBias;
	else	iBias := 0;
	end;
	Result := ADateTime + iBias / 1440;
end;

{----------------------------------------------------------------------------}
procedure TForm1.GlobeRender(Sender: TObject);
var
	idx : integer;
	ptSun : TPointLL;
begin
	with Globe do
	begin
		ptSun := RenderDIBShadow( TimeWithBias( gDateTime ), clGray, clSilver, 1 );

		Globe.RenderTextout( ptSun.iLongX, ptSun.iLatY, 'S', Pixel );

		if Projection.ProjectionClass <> 'TSphericalPrj' then
		begin
			Globe.GlobeCanvas.Font.Color := clWhite;
			RenderTextOut( 0, GU_90_DEGREE - GU_DEGREE, '0', Pixel );
			RenderTextOut( 0, -GU_90_DEGREE + GU_DEGREE * 10, '0', Pixel );

			for idx := 1 to 11 do
			begin
				RenderTextOut( GU_DEGREE * idx * 15, GU_90_DEGREE - GU_DEGREE, '+' + IntToStr( idx ), Pixel);
				RenderTextOut( GU_DEGREE * idx * -15, GU_90_DEGREE - GU_DEGREE, '-' + IntToStr( idx ), Pixel);
				RenderTextOut( GU_DEGREE * idx * 15, -GU_90_DEGREE + GU_DEGREE * 10, '+' + IntToStr( idx ), Pixel);
				RenderTextOut( GU_DEGREE * idx * -15, -GU_90_DEGREE + GU_DEGREE * 10, '-' + IntToStr( idx ), Pixel);
			end;
			RenderTextOut( -GU_180_DEGREE, GU_90_DEGREE - GU_DEGREE, '-12', Pixel);
			RenderTextOut( -GU_180_DEGREE, -GU_90_DEGREE + GU_DEGREE * 10, '-12', Pixel);
		end;
	end;
end;

{----------------------------------------------------------------------------}
procedure TForm1.GlobePaint(Sender: TObject);
begin
	with Globe do
	begin
		GlobeCanvas.Pen.Color := clRed;
		GlobeCanvas.Pen.Width := 1;
		RenderLine( PointLL( giBar, GU_90_DEGREE ), PointLL( giBar, -GU_90_DEGREE ), 32);
	end;
	Caption := TITLE + DateTimeToStr( gDateTime + ( giBar div ( GU_DEGREE * 15 )) / 24 );
end;

{----------------------------------------------------------------------------}
procedure TForm1.GlobeMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
var
	ptLL : TPointLL;
begin
	if ( Button = mbLeft ) and ( ssCtrl in Shift ) then
	begin
		Globe.Projection.DeviceXYToLL( X, Y, ptLL );
		giBar := ptLL.iLongX;
		Globe.Invalidate;
	end;
end;

{----------------------------------------------------------------------------}
procedure TForm1.GlobeMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	if ssLeft in Shift then
		GlobeMouseDown( Sender, mbLeft, Shift, X, Y );
end;

{----------------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
const
	iCounter : integer = 0;
begin
	if not cbxAuto.Checked then
		iCounter := 0
	else
	begin
		gDateTime := Now;

		Dec( iCounter );
		if iCounter <= 0 then
		begin
			iCounter := 5;
			sbTime.Position := Round( Frac( gDateTime ) * 1440 );
			sbDate.Position := Trunc( Date ) - Trunc( gFirstDayOfYear );
			cbxAuto.Checked := True;
			Globe.RedrawLayers;
			gDateTime := Now;
		end;
	end;
end;

{----------------------------------------------------------------------------}
procedure TForm1.sbDateChange(Sender: TObject);
begin
	cbxAuto.Checked := False;
	gDateTime := gFirstDayOfYear + sbDate.Position + sbTime.Position / 1440;
	Globe.RedrawLayers;
end;

procedure TForm1.Panel1Click(Sender: TObject);
begin
end;

{----------------------------------------------------------------------------}
procedure TForm1.GlobeDblClick(Sender: TObject);
begin
	Globe.Align := alNone;
	if Panel1.Visible then
	begin
		Panel1.Visible := False;
		if Form1.WindowState = wsNormal then
			Height := Height - Panel1.Height;
	end
	else
	begin
		if Form1.WindowState = wsNormal then
			Height := Height + Panel1.Height;
		Panel1.Visible := True;
	end;
	Globe.Align := alClient;
end;

{----------------------------------------------------------------------------}
procedure TForm1.GlobeZoomed(Sender: TObject);
var
	ptLL : TPointLL;
begin
	with Globe do
		if Projection.DeviceXYToLL( Width div 2, Height div 2, ptLL ) then
			LocateToLL( ptLL.iLongX, ptLL.iLatY )
		else
			Projection.CenterXY := Point( Width div 2, Height div 2 );
end;

{----------------------------------------------------------------------------}
procedure TForm1.GlobePaintGraticule(Sender: TObject);
var
	idx, iStep  : Integer;
begin
	with Globe do
	begin
		with GlobeCanvas.Pen do
		begin
			Width := 1;
			Color := clWhite;
			Style := psDot;
		end;

		iStep := MaxVal(36, MinVal(180, Round(180 * Globe.Projection.ScaleFactor)));

		{ draw lines of Longitude }
		idx := -GU_180_DEGREE;
		repeat
			RenderLine(PointLL(idx, - GU_90_DEGREE + GU_DEGREE), PointLL(idx, GU_90_DEGREE - GU_DEGREE), iStep);
			Inc(idx, 15 * GU_DEGREE);
		until idx >= GU_180_DEGREE;

		{ draw lines of Latitude }
		idx := 0;
		repeat
			RenderLine(PointLL(GU_180_DEGREE, idx), PointLL( -GU_180_DEGREE, idx), iStep * 2);
			RenderLine(PointLL(GU_180_DEGREE, -idx), PointLL( -GU_180_DEGREE, -idx), iStep * 2);
			Inc(idx, 15 * GU_DEGREE);
		until idx >= 85 * GU_DEGREE;
	end;
end;

{----------------------------------------------------------------------------}
procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
	Globe.Projection.ProjectionClass := 'TSphericalPrj';
	Globe.Projection.Altitude := 0;
end;

{----------------------------------------------------------------------------}
procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
	Globe.Projection.ProjectionClass := 'TCartesianPrj';
	Globe.Projection.Altitude := 0;
end;

end.
