unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, StdCtrls, Db, Grids,
  DBGrids, DBCtrls, TGSysUtils, TGClasses, Globe4, TGObjects, TGPresenters,
  TGLayerDS, TGWindBarb;

type
  TForm1 = class( TForm )
    Panel1 : TPanel;
    SpeedButton1 : TSpeedButton;
    SpeedButton2 : TSpeedButton;
    SpeedButton3 : TSpeedButton;
    OpenDialog1 : TOpenDialog;
    SpeedButton4 : TSpeedButton;
    Panel2 : TPanel;
    DBGrid1 : TDBGrid;
    DataSource1 : TDataSource;
    Panel3 : TPanel;
    btnZoomOut : TSpeedButton;
    btnZoomIn : TSpeedButton;
    Splitter1 : TSplitter;
    btnTransparent : TSpeedButton;
    SpeedButton7 : TSpeedButton;
    btnAbout: TSpeedButton;
    Timer1: TTimer;
    OpenDialog2: TOpenDialog;
    Globe: TGlobe4;
    Globe2: TGlobe4;
    GlobeLayerDS: TGlobeLayerDS;
    procedure FormCreate( Sender : TObject );
    procedure GlobeRender( Sender : TObject );
    procedure GlobeMouseMove( Sender : TObject; Shift : TShiftState; X,
      Y : Integer );
    procedure SpeedButton1Click( Sender : TObject );
    procedure Globe2Paint( Sender : TObject );
    procedure GlobePaint( Sender : TObject );
    procedure btnZoomClick( Sender : TObject );
    procedure btnViewTypeClick( Sender : TObject );
    procedure btnAboutClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Idle(Sender: TObject; var Done: Boolean);
  end;

var
  Form1 : TForm1;
  LayerBrush : TBrush;
  MyObject: TGlobeObject;
  ptList, ptList2 : TGeoDataObject;
  giUpdateGlobe : integer;

implementation

{$R *.DFM}

Uses uAbout;

{------------------------------------------------------------------------------
  TForm1.FormCreate
------------------------------------------------------------------------------}
procedure TForm1.FormCreate( Sender : TObject );
var
  ALayer : TGlobeLayer;
  sAppPath : string;
  PolyPresenter : TPolyPresenter;
begin
  sAppPath := ExtractFilePath( Application.ExeName );

//  Globe.EnvironmentFile := sAppPath + 'tglobe.env';

  if Globe.Layers.Count > 0 then
  begin
    GlobeLayerDS.LayerName := Globe.Layers[0].Name;
    GlobeLayerDS.Active := true;
  end;

  LayerBrush := TBrush.Create;
  LayerBrush.Style := bsClear;

  Globe2.SurfaceTextureName := sAppPath + 'world.bmp';

  { Zoom the globes out to their extents }
  Globe.Projection.Altitude := 0;
  Globe2.Projection.Altitude := 0;

  { Create an animated Layer }
  ALayer := TGlobeLayer.Create( Globe );
  ALayer.Animated := True;

//  Globe.Layers.GlobalPresenters.Add( TWindBarbPresenter.Create( Globe, 99 ));
//  with TWindBarbObject.Create( ALayer.Objects ) do
//    PresenterID := 99;



  ptList := TGeoDataObject.Create( ALayer.Objects );
  ptList.Chains[0].StoreHeight := True;
  ptList.PresenterID := GLOBAL_POLY_PRESENTER;

  ptList2 := TGeoDataObject.Create( ALayer.Objects );
  ptList2.PresenterID := GLOBAL_POLY_PRESENTER;
  ptList2.Selected := True;

  PolyPresenter := TPolyPresenter( Globe.Layers.GlobalPresenters.ByID( GLOBAL_POLY_PRESENTER, False ));
  if PolyPresenter <> nil then
  begin
    PolyPresenter.PolyPen.PenColor := clBlue;
    PolyPresenter.PolyPen.PenWidth := 2;
    PolyPresenter.PolyPen.PenUnit := NauticalMile;
  end;

  MyObject :=  TGeoDataObject.Create( ALayer.Objects );
  MyObject.Title := 'AirCraft';
  MyObject.PresenterID := GLOBAL_POINT_PRESENTER;

  with TPointPresenter( Globe.Layers.GlobalPresenters.ByID( GLOBAL_POINT_PRESENTER, False )) do
  begin
    PointType := ppImage;
    PointSize := 150;
    PointUnit := NauticalMile;
    ImageName := 'World.bmp';
  end;

  Application.OnIdle := Idle;
end;

{------------------------------------------------------------------------------
  TForm1.Idle
------------------------------------------------------------------------------}
procedure TForm1.Idle(Sender: TObject; var Done: Boolean);
begin
  if giUpdateGlobe = 1 then
    with Globe2 do
    begin
      Invalidate;
      if Projection.ProjectionClass = 'TSphericalPrj' then
      begin
        Projection.YRotation := Globe.Projection.YRotation;
        Projection.XRotation := Globe.Projection.XRotation;
      end;
    end;

  if giUpdateGlobe = 2 then
    with Globe do
      if Projection.ProjectionClass = 'TSphericalPrj' then
      begin
        Projection.YRotation := Globe2.Projection.YRotation;
        Projection.XRotation := Globe2.Projection.XRotation;
      end;

  giUpdateGlobe := 0;
  Done := False;
end;

{------------------------------------------------------------------------------
  TForm1.Globe1MouseMove
------------------------------------------------------------------------------}
procedure TForm1.GlobeMouseMove( Sender : TObject; Shift : TShiftState; X,
  Y : Integer );
var
  obj : TGlobeObject;
  sTmp : string;
  pt : TPointLL;
begin
  with Globe.Projection do
  begin
    DeviceXYToLL( X, Y, pt );
    sTmp := Format( '%d,%d %d %d ', [ pt.iLongX, pt.iLatY,
      CenterXY.X, CenterXY.Y ] );
  end;

  obj := Globe.Layers.ObjectAtXY( X, Y );
  if obj <> nil then
    sTmp := sTmp + obj.Title;
  Caption := 'TGlobe Version 4.00 Demo : ' + sTmp;
end;

{------------------------------------------------------------------------------
  TForm1.SpeedButton1Click
------------------------------------------------------------------------------}
procedure TForm1.SpeedButton1Click( Sender : TObject );
begin
  case TSpeedButton( Sender ).Tag of
  0 :
    begin
      Globe.Projection.ProjectionClass := 'TSphericalPrj';
      Globe2.Projection.ProjectionClass := 'TSphericalPrj';
      Globe2.MouseRotateButton := mzbLeft
    end;
  1 :
    begin
      Globe.Projection.ProjectionClass := 'TCartesianPrj';
      Globe2.Projection.ProjectionClass := 'TCartesianPrj';
      Globe2.MouseRotateButton := mzbNone;
    end;
  2 :
    begin
      Globe.Projection.ProjectionClass := 'TMercatorPrj';
      Globe2.Projection.ProjectionClass := 'TMercatorPrj';
      Globe2.MouseRotateButton := mzbNone;
    end;
  end;
  Globe.Projection.ScaleFactor := 0;
  Globe2.Projection.ScaleFactor := 0;
end;

{------------------------------------------------------------------------------
  TForm1.Globe1Render
------------------------------------------------------------------------------}
procedure TForm1.GlobeRender( Sender : TObject );
begin
  giUpdateGlobe := TGlobe4( Sender ).Tag;
end;

{------------------------------------------------------------------------------
  TForm1.Globe2Paint
------------------------------------------------------------------------------}
procedure TForm1.Globe2Paint( Sender : TObject );
var
  eW, eH : Extended;
  iX, iY : integer;
begin
  with Globe2 do
  begin
    eW := ( Globe.Width / Globe.Projection.ScaleFactor ) * Projection.ScaleFactor;
    eH := ( Globe.Height / Globe.Projection.ScaleFactor ) * Projection.ScaleFactor;
    iY := Round( Height / 2 - eH * ( Globe.Projection.CenterXY.Y / Globe.Height ) );
    iX := Round( Width / 2 - eW * ( Globe.Projection.CenterXY.X / Globe.Width ) );
    GlobeCanvas.Brush.Color := clRed;
    GlobeCanvas.FrameRect( Rect( iX, iY, iX + Round( eW ), iY + Round( eH )) );
  end;
end;

{------------------------------------------------------------------------------
  TForm1.Globe1Paint
------------------------------------------------------------------------------}
procedure TForm1.GlobePaint( Sender : TObject );
begin
  if MyObject <> nil then
  begin
    Globe.GlobeCanvas.Pen.color := clBlue;
//    Globe.RenderCircle( MyObject.Centroid, GU_DEGREE * 10, 36 );
  end;
end;

{------------------------------------------------------------------------------
  TForm1.btnZoomClick
------------------------------------------------------------------------------}
procedure TForm1.btnZoomClick( Sender : TObject );
begin
  with TSpeedButton( Sender ) do
    Globe.Projection.Altitude := Round( Globe.Projection.Altitude * ( Tag / 100 ));
end;

{------------------------------------------------------------------------------
  TForm1.btnViewTypeClick
------------------------------------------------------------------------------}
procedure TForm1.btnViewTypeClick( Sender : TObject );
begin
  with Globe do
    case TSpeedButton( Sender ).Tag of
      0 : // Normal
        begin
          SurfaceTextureName := '';
          GlobeOptions := GlobeOptions - [goTransparentGlobe];
        end;
      1 : // Transparent
        begin
          SurfaceTextureName := '';
          GlobeOptions := GlobeOptions + [goTransparentGlobe];
        end;
      2 : // Texturemapped
        begin
          GlobeOptions := GlobeOptions - [goTransparentGlobe];
          if OpenDialog1.Execute then
            SurfaceTextureName := OpenDialog1.FileName;
        end;
    end;
end;

{------------------------------------------------------------------------------
  TForm1.btnAboutClick
------------------------------------------------------------------------------}
procedure TForm1.btnAboutClick(Sender: TObject);
begin
  FormAbout.ShowModal;
end;

{------------------------------------------------------------------------------
  TForm1.Timer1Timer
------------------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
const
  iStep : Extended = 0;
begin
  if MyObject <> nil then
  begin
    with MyObject.Centroid do
      MyObject.Centroid := PointLLH(
        ( iLongX + GU_DEGREE ) mod GU_360_DEGREE,
        Round( 60 * GU_DEGREE * Cos( iStep )),
        5 * GU_DEGREE + Round( GU_DEGREE * 5 * Sin( iLongX * GU_TORADIANS * 8 )));

    iStep := SphericalMod( iStep + LocalPi / 100 );

    ptList2.Chains[0].Add( PointLL( MyObject.Centroid.iLongX, MyObject.Centroid.iLatY ));
    ptList.Chains[0].Add( MyObject.Centroid );
    if ptList.Chains[0].Count > 100 then
    begin
      ptList.Chains[0].Delete( 0 );
      ptList2.Chains[0].Delete( 0 );
    end;
    ptList2.RedrawObject;
    ptList.RedrawObject;
  end;
end;

end.

