unit fmImage;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Globe4, ExtCtrls, StdCtrls, ComCtrls;

type
  TFormImage = class(TForm)                     
    PaintBox1: TPaintBox;
    TrackBar1: TTrackBar;
    TrackBar2: TTrackBar;
    RadioGroup1: TRadioGroup;
    procedure TrackBarsChange(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Globe : TGlobe4;
  end;

var
  FormImage: TFormImage;

implementation

{$R *.DFM}
procedure TFormImage.TrackBarsChange(Sender: TObject);
var
  Metafile : TMetafile;
  Bitmap : TBitmap;
begin
  Paintbox1.Canvas.Brush.Color := Paintbox1.Color; 
  Paintbox1.Canvas.FillRect( PaintBox1.ClientRect );
  if Globe <> nil then
  begin
    case RadioGroup1.ItemIndex of
    2 : //Metafile
    begin
      Metafile := Globe.GetMetaFile( Trackbar1.Position, Trackbar2.Position, True );
      Paintbox1.Canvas.Draw( 0, 0, Metafile );
      Metafile.Free;
    end;
    1 : // Bitmap
    begin
      Bitmap := Globe.GetBitmap( Trackbar1.Position, Trackbar2.Position );
      Paintbox1.Canvas.Draw( 0, 0, Bitmap );
      Bitmap.Free;
    end;
    0 : // Direct
      Globe.RenderToCanvas( Paintbox1.Canvas,
        Rect( 0, 0, Trackbar1.Position, Trackbar2.Position), True);
    end;
  end;
end;

procedure TFormImage.FormPaint(Sender: TObject);
begin
  TrackBarsChange(nil);
end;

end.
