unit TGMMStream;

interface

uses Windows, SysUtils, Classes;

type

  TMemoryMapStream = class( TCustomMemoryStream )
  private
    FileHandle : THandle;
    MappingHandle : THandle;
  protected
    procedure SetSize(NewSize: Longint); override;
  public
    constructor Create(FileName : string);
    destructor Destroy; override;

    function Write(const Buffer; Count: Longint): Longint; override;
  end;

implementation

constructor TMemoryMapStream.Create(FileName: string);
var
  iSize : integer;
begin
  FileHandle := CreateFile( PChar(FileName), GENERIC_READ, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);

  if FileHandle = INVALID_HANDLE_VALUE then
    raise Exception.Create('Unable to open file');

  iSize := GetFileSize(FileHandle,nil);

  MappingHandle := CreateFileMapping( FileHandle, nil, PAGE_READONLY, 0, iSize, nil);

  if MappingHandle = 0 then
    raise Exception.Create('Unable to create file mapping');

  SetPointer( MapViewOfFile( MappingHandle, FILE_MAP_READ, 0, 0, iSize), iSize );
  if Memory = nil then
    raise Exception.Create('Unable to map view of file');
end;

destructor TMemoryMapStream.Destroy;
begin
  if Memory <> nil then
    UnmapViewOfFile(Memory);
  if MappingHandle <> 0 then
    CloseHandle(MappingHandle);
  if FileHandle <> 0 then
    CloseHandle(FileHandle);
  inherited Destroy;
end;


procedure TMemoryMapStream.SetSize(NewSize: Integer);
begin
  raise Exception.Create( Self.Classname + '.SetSize: Not supported' );
end;

function TMemoryMapStream.Write(const Buffer; Count: Integer): Longint;
begin
  raise Exception.Create( Self.Classname + '.Write: Not supported' );
end;

end.

