unit TGDBSource;

interface

uses
  Windows, Classes, SysUtils, DB, Globe4, TGSysUtils,
  TGObjects, TGPresenters, TGClasses, TGXML;

type

  {---------------------------- TGlobeDBReader --------------------------------}
  TGlobeDBReader = class(TGlobeObjectSource)
  private
    FDataSource: TDataSource;
  protected
    procedure SetActive(const Value: Boolean); override;
    procedure MapDataSource; virtual; abstract;
  public
    constructor Create( ParentGlobe : TCustomGlobe4 ); override;
    destructor Destroy; override;

    property DataSource : TDataSource read FDataSource write FDataSource;
  end;

  {---------------------------- TGlobeDBPointReader ---------------------------}
  TGlobeDBPointReader = class(TGlobeDBReader)
  protected
    procedure MapDataSource; override;

  public
    function LoadObject(iIndex : integer; bNewObject : Boolean) : TGlobeObject; override;

    function SaveEnvironment : TGXML_Element; override;
    procedure LoadEnvironment( Element : TGXML_Element ); override;
    procedure SaveMetaData; override;
    procedure LoadMetaData; override;
  end;

implementation

constructor TGlobeDBReader.Create(ParentGlobe: TCustomGlobe4);
begin
  inherited;

end;

destructor TGlobeDBReader.Destroy;
begin
  inherited;

end;

procedure TGlobeDBReader.SetActive(const Value: Boolean);
begin
  inherited;
  
  if ( DataSource <> nil ) and ( DataSource.DataSet <> nil ) then
    DataSource.DataSet.Active := Value;
end;

end.
