{------------------------------------------------------------------------------
  Module:   uMain.pas

            Object Editor main form

            Uses some RX components ( RXGrids ) -
              RX is available from DSP - http://sunsite.icm.edu.pl/delphi/

  Author:   Graham Knight
  Email:    tglobe@iname.com
------------------------------------------------------------------------------}
unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  E002Glob, Menus, StdCtrls, Grids, TypInfo, TGLYRMapper, TGMIFMapper, TGObjects,
  TGPresenters, TGSHPMapper, Buttons, ExtCtrls, RXGrids, TGProp, Globe4,
  TGSysUtils, ComCtrls, TGClasses, GlobeProjections;

type
  TForm1 = class(TForm)
    OpenDialogLYR: TOpenDialog;
    MainMenu1 : TMainMenu;
    ZoomExtents2 : TMenuItem;
    LoadLYR: TMenuItem;
    File1 : TMenuItem;
    View1 : TMenuItem;
    pnlHint : TPanel;
    N5 : TMenuItem;
    TransparentGlobe1 : TMenuItem;
    NewLayer: TMenuItem;
    Exit1 : TMenuItem;
    N7 : TMenuItem;
    N9 : TMenuItem;
    SaveLYR: TMenuItem;
    SaveDialogLYR: TSaveDialog;
    ImportLayer: TMenuItem;
    N12 : TMenuItem;
    LoadEnvironment: TMenuItem;
    SaveENV: TMenuItem;
    N1 : TMenuItem;
    Statistics1 : TMenuItem;
    OpenDialogImport: TOpenDialog;
    OpenDialogEnv: TOpenDialog;
    SaveDialogENV: TSaveDialog;
    Splitter3: TSplitter;
    Panel5: TPanel;
    Splitter1: TSplitter;
    pcData: TPageControl;
    tsLayers: TTabSheet;
    lvLayers: TListView;
    tsInspector: TTabSheet;
    Panel7: TPanel;
    Splitter2: TSplitter;
    sgProps: TRxDrawGrid;
    sgPoints: TRxDrawGrid;
    Panel2: TPanel;
    lblObjClass: TLabel;
    btnBack: TBitBtn;
    tsPresenters: TTabSheet;
    lvPresenters: TListView;
    tsBlank: TTabSheet;
    tsObjects: TTabSheet;
    lvObjects: TListView;
    Panel1: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    SpeedButton3: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    cbxProjections: TComboBox;
    Globe: TGlobe4;
    TreeView: TTreeView;
    Panel6: TPanel;
    eObjectFilter: TEdit;
    Label1: TLabel;
    Panel8: TPanel;
    Label2: TLabel;
    eLayerFilter: TEdit;
    procedure ZoomExtents1Click(Sender : TObject);
    procedure btnBackClick(Sender : TObject);
    procedure sgPropsDrawCell(Sender : TObject; Col, Row : Integer;
      Rect : TRect; State : TGridDrawState);
    procedure sgPropsSelectCell(Sender : TObject; Col, Row : Integer;
      var CanSelect : Boolean);
    procedure sgPropsGetEditStyle(Sender : TObject; ACol, ARow : Integer;
      var Style : TInplaceEditStyle);
    procedure sgPropsEditButtonClick(Sender : TObject);
    procedure sgPropsGetEditText(Sender : TObject; ACol, ARow : Integer;
      var Value : string);
    procedure sgPropsGetPicklist(Sender : TObject; ACol, ARow : Integer;
      PickList : TStrings);
    procedure sgPropsSetEditText(Sender : TObject; ACol, ARow : Integer;
      const Value : string);
    procedure FormCreate(Sender : TObject);
    procedure LoadLYRClick(Sender : TObject);
    procedure sgPointsDrawCell(Sender : TObject; Col, Row : Integer;
      Rect : TRect; State : TGridDrawState);
    procedure sgPointsSelectCell(Sender : TObject; Col, Row : Integer;
      var CanSelect : Boolean);
    procedure sgPointsSetEditText(Sender : TObject; ACol, ARow : Integer;
      const Value : string);
    function sgPointsAcceptEditKey(Sender : TObject;
      var Key : Char) : Boolean;
    procedure sgPointsGetEditText(Sender : TObject; ACol, ARow : Integer;
      var Value : string);
    procedure TransparentGlobe1Click(Sender : TObject);
    procedure Exit1Click(Sender : TObject);
    procedure NewLayerClick(Sender : TObject);
    procedure InsertPoint1Click(Sender : TObject);
    procedure DeletePoint1Click(Sender : TObject);
    procedure AppendPoint1Click(Sender : TObject);
    procedure btnZoomClick(Sender : TObject);
    procedure SaveLYRClick(Sender : TObject);
    procedure cbxProjectionsChange(Sender : TObject);
    procedure LoadEnvironmentClick(Sender : TObject);
    procedure SaveENVClick(Sender : TObject);
    procedure Statistics1Click(Sender : TObject);
    procedure ImportLayerClick(Sender : TObject);
    procedure TreeViewExpanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
    procedure TreeViewClick(Sender: TObject);
    procedure sgPropsColumnSized(Sender: TObject);
    procedure GlobeObjectSelectChange(Sender: TGlobe4;
      GlobeObject: TGlobeObject);
    procedure eObjectFilterChange(Sender: TObject);
    procedure GlobeProgress(Sender: TGlobe4; MsgType: TProgressMessage;
      const MsgText: String; var Abort: Boolean);
    procedure lvObjectsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure EditNewObject(obj : TPersistent);
    procedure EditObject;
    procedure EditPoints(obj : TGeoDataObject);
    procedure Push(obj : TPersistent);

    function ValidRow(iRow : integer) : Boolean;
    procedure HintHandler(Sender : TObject);

    procedure BuildTreeView;
  end;

var
  Form1 : TForm1;
  gObjProperties : TGlobeProperties;
  gPropertyAttributes : TGlobePropertyAttributes;
  gCurrentEditObject : TPersistent;

  gStack : array[0..16] of TPersistent;
  giStackTop : integer;

implementation

{$R *.DFM}

uses SelLayer, GlobeUtils;

{------------------------------------------------------------------------------
  TForm1.FormCreate
------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender : TObject);
begin
  Application.OnHint := HintHandler;
  cbxProjections.ItemIndex := 0;
  Globe.Projection.Altitude := 0;
  BuildTreeView;
  pcData.ActivePage := tsBlank;
end;

{------------------------------------------------------------------------------
  TForm1.HintHandler
------------------------------------------------------------------------------}
procedure TForm1.HintHandler(Sender : TObject);
begin
  pnlHint.Caption := Application.Hint;
end;


{------------------------------------------------------------------------------
  TForm1.ZoomExtents1Click
------------------------------------------------------------------------------}
procedure TForm1.ZoomExtents1Click(Sender : TObject);
begin
  Globe.Projection.Altitude := 0;
end;

{------------------------------------------------------------------------------
  TForm1.New1Click
------------------------------------------------------------------------------}
procedure TForm1.NewLayerClick(Sender : TObject);
begin
  Globe.Clear;
  BuildTreeView;
end;

{------------------------------------------------------------------------------
  TForm1.Exit1Click
------------------------------------------------------------------------------}
procedure TForm1.Exit1Click(Sender : TObject);
begin
  Close;
end;


{------------------------------------------------------------------------------
  TForm1.SaveLYRClick
------------------------------------------------------------------------------}
procedure TForm1.SaveLYRClick(Sender : TObject);
begin
{    SaveDialogLYR.FileName := CurrentLayer.Name;
    if SaveDialogLYR.Execute then
      WriteLayerToLYRfile( CurrentLayer, SaveDialogLYR.FileName );
}end;

{------------------------------------------------------------------------------
  TForm1.Load1Click
------------------------------------------------------------------------------}
procedure TForm1.LoadLYRClick(Sender : TObject);
var
  idx : integer;
begin
  if OpenDialogLYR.Execute then
  begin
    Application.ProcessMessages;
    for idx := 0 to OpenDialogLYR.Files.Count - 1 do
      CreateFileLayer( Globe, OpenDialogLYR.Files[idx] );
  end;

  BuildTreeView;
end;

{------------------------------------------------------------------------------
  TForm1.LoadProfile1Click
------------------------------------------------------------------------------}
procedure TForm1.LoadEnvironmentClick(Sender : TObject);
begin
  if OpenDialogEnv.Execute then
    Globe.EnvironmentFile := OpenDialogEnv.FileName;

  BuildTreeView;
end;

{------------------------------------------------------------------------------
  TForm1.SaveENVClick
------------------------------------------------------------------------------}
procedure TForm1.SaveENVClick(Sender : TObject);
var
  sFilename : string;
begin
  SaveDialogENV.InitialDir := ExtractFilePath(Globe.EnvironmentFile);
  SaveDialogENV.FileName := Globe.EnvironmentFile;
  if SaveDialogENV.Execute then
  begin
    sFilename := SaveDialogENV.FileName;
    if ExtractFileExt( sFilename ) = '' then
      sFilename := ChangeFileExt( sFilename, '.env' );
    Globe.SaveEnvironmentToFile(sFilename);
  end;
end;

{------------------------------------------------------------------------------
  TForm1.ValidRow
------------------------------------------------------------------------------}
function TForm1.ValidRow(iRow : integer) : Boolean;
begin
  Result := (gObjProperties <> nil) and (iRow > 0) and (iRow <= gObjProperties.Count);
end;

{------------------------------------------------------------------------------
  TForm1.EditNewObject
------------------------------------------------------------------------------}
procedure TForm1.EditNewObject(obj : TPersistent);
begin
  pcData.ActivePage := tsInspector;
  gObjProperties.Free;
  gObjProperties := nil;

  sgProps.RowCount := 2;
  sgProps.Repaint;

  sgPoints.Visible := False;
  Splitter2.Visible := False;
  btnBack.Enabled := False;

  giStackTop := 0;

  gCurrentEditObject := obj;
  if obj <> nil then
    EditObject;
end;

{------------------------------------------------------------------------------
  TForm1.EditObject
------------------------------------------------------------------------------}
procedure TForm1.EditObject;
begin
  sgPoints.Visible := False;
  Splitter2.Enabled := False;
  if gCurrentEditObject = nil then
    Exit;

  gStack[giStackTop] := gCurrentEditObject;

  lblObjClass.Caption := gCurrentEditObject.ClassName;

//  if gCurrentEditObject is TGeoDataObject then
//    EditPoints(TGeoDataObject(gCurrentEditObject));

  with sgProps do
  begin
    EditorMode := False;

    gObjProperties.Free;
    gObjProperties := TGlobeProperties.Create(gCurrentEditObject);

    if gObjProperties.Count > 0 then
    begin
      RowCount := gObjProperties.Count + 1;
      Row := 1;
      Col := 1;
      EditorMode := True;
      Repaint;
    end;
  end;
end;

{------------------------------------------------------------------------------
  TForm1.EditPoints
------------------------------------------------------------------------------}
procedure TForm1.EditPoints(obj : TGeoDataObject);
var
  iRow, iCol : integer;
begin
  if obj.Chains.Count > 0 then
    with sgPoints do
    begin
      Splitter2.Enabled := True;
      Visible := True;
      iRow := Row;
      iCol := Col;
      RowCount := MaxVal(2, obj.Chains[0].Count + 1);
      Row := MaxVal(1, iRow);
      Col := MaxVal(1, iCol);
      Invalidate;
      sgProps.Invalidate;
    end;
end;

{------------------------------------------------------------------------------
  TForm1.Push
------------------------------------------------------------------------------}
procedure TForm1.Push(obj : TPersistent);
begin
  if obj = nil then
    Exit;

  gCurrentEditObject := obj;

  Inc(giStackTop);
  btnBack.Enabled := True;
  EditObject;
end;

{------------------------------------------------------------------------------
  TForm1.btnBackClick
------------------------------------------------------------------------------}
procedure TForm1.btnBackClick(Sender : TObject);
begin
  Dec(giStacktop);
  gCurrentEditObject := gStack[giStackTop];
  btnBack.Enabled := giStackTop > 0;
  EditObject;
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsDrawCell
------------------------------------------------------------------------------}
procedure TForm1.sgPropsDrawCell(Sender : TObject; Col, Row : Integer;
  Rect : TRect; State : TGridDrawState);
begin
  if (Col = 0) and (Row > 0) then
    sgProps.Canvas.Brush.Color := clBtnFace;

  if ValidRow(Row) then
    sgProps.DrawStr(Rect, sIFE(Col = 0, gObjProperties.Name[Row - 1],
      gObjProperties.Value[Row - 1]), taLeftJustify)
  else
    if Row = 0 then
      sgProps.DrawStr(Rect, sIFE(Col = 0, 'Property', 'Value'), taLeftJustify);
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsSelectCell
------------------------------------------------------------------------------}
procedure TForm1.sgPropsSelectCell(Sender : TObject; Col, Row : Integer;
  var CanSelect : Boolean);
begin
  CanSelect := (Col > 0) and ValidRow(Row);
  sgProps.EditorMode := True;
  if CanSelect then
  begin
    gPropertyAttributes := gObjProperties.Attributes[Row - 1];
    sgPropsColumnSized( nil );
  end;
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsGetEditStyle
------------------------------------------------------------------------------}
procedure TForm1.sgPropsGetEditStyle(Sender : TObject; ACol, ARow : Integer;
  var Style : TInplaceEditStyle);
begin
  if ValidRow(ARow) then
  begin
    Style := ieSimple;

    if paClass in gPropertyAttributes then
      Style := ieEllipsis;
    if paList in gPropertyAttributes then
      Style := iePickList;
  end;
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsGetEditText
------------------------------------------------------------------------------}
procedure TForm1.sgPropsGetEditText(Sender : TObject; ACol, ARow : Integer;
  var Value : string);
begin
  if ValidRow(ARow) then
    Value := gObjProperties.Value[ARow - 1]
  else
    Value := '';
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsSetEditText
------------------------------------------------------------------------------}
procedure TForm1.sgPropsSetEditText(Sender : TObject; ACol, ARow : Integer;
  const Value : string);
begin
  if ValidRow(ARow) then
    if Value <> gObjProperties.Value[ARow - 1] then
    begin
      gObjProperties.Value[ARow - 1] := Value;

      if gCurrentEditObject is TGeoDataObject then
        TGlobeObject(gCurrentEditObject).RedrawObject;

      Globe.RedrawLayers;
      sgProps.Invalidate;
    end;
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsEditButtonClick
------------------------------------------------------------------------------}
procedure TForm1.sgPropsEditButtonClick(Sender : TObject);
begin
  with sgProps do
    if ValidRow(Row) then
      if gObjProperties.PropertyEditor(Row - 1) then
      begin
        InplaceEditor.EditText := gObjProperties.Value[Row - 1];
        Globe.RedrawLayers;
      end
      else
        if gObjProperties.Kind[Row - 1] = tkClass then
          Push(TGlobeRoot(gObjProperties.OrdinalProp[Row - 1]));
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsGetPicklist
------------------------------------------------------------------------------}
procedure TForm1.sgPropsGetPicklist(Sender : TObject; ACol, ARow : Integer;
  PickList : TStrings);
begin
  if ValidRow(ARow) then
    gObjProperties.GetPicklist(ARow - 1, PickList);
end;

{------------------------------------------------------------------------------
  TForm1.sgPropsColumnSized
------------------------------------------------------------------------------}
procedure TForm1.sgPropsColumnSized(Sender: TObject);
begin
  with sgProps do
    ColWidths[1] := (ClientWidth - ColWidths[0]) - 1;
end;

{------------------------------------------------------------------------------
  TForm1.sgPointsDrawCell
------------------------------------------------------------------------------}
procedure TForm1.sgPointsDrawCell(Sender : TObject; Col, Row : Integer;
  Rect : TRect; State : TGridDrawState);
var
  sText : string;
begin
  if (Col = 0) and (Row > 0) then
    sgPoints.Canvas.Brush.Color := clBtnFace;

  sText := '';
  if Row = 0 then
    case Col of
      0 : sText := 'ID';
      1 : sText := 'Longitude';
      2 : sText := 'Latitude';
      3 : sText := 'Height';
    end
  else
{    if CurrentObject <> nil then
      with CurrentObject as TGeoDataObject do
        if Row <= Chains[0].Count then
          with Chains[0].AsLL[Row - 1] do
            case Col of
              0 : sText := IntTostr(Row - 1);
              1 : Str(GlobeUnitsToDecimal(iLongX) : 3 : 4, sText);
              2 : Str(GlobeUnitsToDecimal(iLatY) : 3 : 4, sText);
              //              3 : Str( GlobeUnitsToDecimal( iHeightZ ):3:4, sText );
            end;
}  sgPoints.DrawStr(Rect, sText, taLeftJustify);
end;

{------------------------------------------------------------------------------
  TForm1.sgPointsSelectCell
------------------------------------------------------------------------------}
procedure TForm1.sgPointsSelectCell(Sender : TObject; Col, Row : Integer;
  var CanSelect : Boolean);
begin
  CanSelect := (Row > 0) and (Col > 0);
end;

{------------------------------------------------------------------------------
  TForm1.sgPointsAcceptEditKey
------------------------------------------------------------------------------}
function TForm1.sgPointsAcceptEditKey(Sender : TObject;
  var Key : Char) : Boolean;
begin
  Result := Key in ['0'..'9', '-', '+', '.'];
end;

{------------------------------------------------------------------------------
  TForm1.sgPointsSetEditText
------------------------------------------------------------------------------}
procedure TForm1.sgPointsSetEditText(Sender : TObject; ACol, ARow : Integer;
  const Value : string);
var
  iVal : integer;
  ptLL : TPointLL;
begin
  try
    iVal := DecimalToGlobeUnits(StrToFloat(Value));
  except
    Exit;
  end;

{  if CurrentObject <> nil then
    with CurrentObject as TGeoDataObject do
    begin
      ptLL := Chains[0].AsLL[ARow - 1];

      case ACol of
        1 : ptLL.iLongX := iVal;
        2 : ptLL.iLatY := iVal;
        //      3 : ptLL.iHeightZ := iVal;
      end;

      Chains[0].AsLL[ARow - 1] := ptLL;
    end;
}  Globe.RedrawLayers;
end;

{------------------------------------------------------------------------------
  TForm1.sgPointsGetEditText
------------------------------------------------------------------------------}
procedure TForm1.sgPointsGetEditText(Sender : TObject; ACol, ARow : Integer;
  var Value : string);
var
  iVal : integer;
begin
  iVal := 0;
{  if CurrentObject <> nil then
    with CurrentObject as TGeoDataObject do
      if ARow <= Chains[0].Count then
        with Chains[0].AsLL[ARow - 1] do
          case ACol of
            1 : iVal := iLongX;
            2 : iVal := iLatY;
            //        3 : iVal := iHeightZ;
          end;
}  Str(GlobeUnitsToDecimal(iVal) : 3 : 4, Value);
end;

{------------------------------------------------------------------------------
  TForm1.TransparentGlobe1Click
------------------------------------------------------------------------------}
procedure TForm1.TransparentGlobe1Click(Sender : TObject);
begin
  with TransparentGlobe1 do
  begin
    Checked := not Checked;
    if Checked then
      Globe.GlobeOptions := Globe.GlobeOptions + [goTransparentGlobe]
    else
      Globe.GlobeOptions := Globe.GlobeOptions - [goTransparentGlobe];
  end;
end;

{------------------------------------------------------------------------------
  TForm1.InsertPoint1Click
------------------------------------------------------------------------------}
procedure TForm1.InsertPoint1Click(Sender : TObject);
begin
  {  if CurrentObject is TGeoDataObject then
      with sgPoints, TGeoDataObject( CurrentObject ) do
      begin
        if Row = 1 then
          TPointListLL( PointList ).Add( PointsLL[0] )
        else
          with PointsLL[Row - 2] do
            InsertPointLL( Row - 1, PointLLH(
              iLongX + ( PointsLL[Row - 1].iLongX - iLongX ) div 2,
              iLatY + ( PointsLL[Row - 1].iLatY - iLatY ) div 2,
              iHeightZ + ( PointsLL[Row - 1].iHeightZ - iHeightZ ) div 2 ));
        EditPoints( TGeoDataObject( CurrentObject ));
      end;
  }
end;

{------------------------------------------------------------------------------
  TForm1.AppendPoint1Click
------------------------------------------------------------------------------}
procedure TForm1.AppendPoint1Click(Sender : TObject);
begin
  {  if CurrentObject is TGeoDataObject then
      with sgPoints, TGeoDataObject( CurrentObject ) do
      begin
        if CountLL > 0 then
          AddPointLL( PointsLL[CountLL - 1] )
        else
          AddPointLL( PointLL( 0, 0 ));
        EditPoints( TGeoDataObject( CurrentObject ));
      end;
  }
end;

{------------------------------------------------------------------------------
  TForm1.DeletePoint1Click
------------------------------------------------------------------------------}
procedure TForm1.DeletePoint1Click(Sender : TObject);
begin
  {  if CurrentObject is TGeoDataObject then
      with sgPoints, TGeoDataObject( CurrentObject ) do
      begin
        DeletePointLL( Row - 1 );
        EditPoints( TGeoDataObject( CurrentObject ));
      end;
  }
end;

{------------------------------------------------------------------------------
  TForm1.btnZoomClick
------------------------------------------------------------------------------}
procedure TForm1.btnZoomClick(Sender : TObject);
begin
  with TComponent(Sender) do
    if Tag = 0 then
      Globe.Projection.Altitude := 0
    else
      Globe.Projection.Altitude := Round(Globe.Projection.Altitude * (Tag / 100));
end;

{------------------------------------------------------------------------------
  TForm1.cbxProjectionsChange
------------------------------------------------------------------------------}
procedure TForm1.cbxProjectionsChange(Sender : TObject);
begin
  with cbxProjections do
    Globe.Projection.ProjectionClass := Items[ItemIndex];
end;

{------------------------------------------------------------------------------
  TForm1.Statistics1Click
------------------------------------------------------------------------------}
procedure TForm1.Statistics1Click(Sender : TObject);
var
  iLayer, iPoints, iObjects, IPresent, idx : Integer;
begin
  iPoints := 0;
  iObjects := 0;
  iPresent := 0;
  for iLayer := 0 to Globe.Layers.Count - 1 do
    with TGlobeLayer(Globe.Layers[iLayer]) do
    begin
      Inc(iObjects, Objects.Count);
      Inc(iPresent, Objects.Presenters.Count);
      for idx := 0 to Objects.Count - 1 do
        if Objects[idx] is TGeoDataObject then
          Inc(iPoints, TGeoDataObject(Objects[idx]).Chains[0].Count);
    end;
  ShowMessage(Format('Layers = %d'#10'Presenters = %d'#10'Objects = %d'#10'Points = %d',
    [Globe.Layers.Count, iPresent, iObjects, iPoints]));
end;

{------------------------------------------------------------------------------
  TForm1.Import1Click
------------------------------------------------------------------------------}
procedure TForm1.ImportLayerClick(Sender : TObject);
var
  idx : integer;
begin
  with OpenDialogImport do
    if Execute then
      for idx := 0 to Files.Count - 1 do
        if CompareText(ExtractFileExt(Files[idx]), '.E00') = 0 then
          GlobeImportE00(Globe, Files[idx] );

  BuildTreeView;
end;

{------------------------------------------------------------------------------
  TForm1.BuildTreeView
------------------------------------------------------------------------------}
procedure TForm1.BuildTreeView;
var
  GlobeNode, Node, SubNode : TTreeNode;
  idx : integer;
begin
  with TreeView.Items do
  begin
    BeginUpdate;
    Clear;
    GlobeNode := AddChild( nil, 'Globe' );
    GlobeNode.Data := Globe;

    // Add the Global Presenters Key
    Node := AddChild( GlobeNode, 'GlobalPresenters' );
    Node.Data := Globe.Layers.GlobalPresenters;
    for idx := 0 to Globe.Layers.GlobalPresenters.Count - 1 do
    begin
      SubNode := AddChild( Node, Globe.Layers.GlobalPresenters[idx].Name );
      SubNode.Data := Globe.Layers.GlobalPresenters[idx];
    end;

    // Add the Layers Key
    Node := AddChild( GlobeNode, 'Layers' );
    Node.Data := Globe.Layers;
    for idx := 0 to Globe.Layers.Count - 1 do
    begin
      SubNode := AddChild( Node, Globe.Layers[idx].Name );
      SubNode.Data := Globe.Layers[idx];
      SubNode.HasChildren := True;
    end;

    GlobeNode.Expand( False );
    EndUpdate;
    GlobeNode.Selected := True;
  end;
end;

{------------------------------------------------------------------------------
  TForm1.TreeViewExpanding
------------------------------------------------------------------------------}
procedure TForm1.TreeViewExpanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
var
  idx : integer;
  SubNode : TTreeNode;
begin
  if Node.Count = 0 then
  begin
    TreeView.Items.BeginUpdate;
    Node.DeleteChildren;

    if TObject( Node.Data ) is TGlobeLayer then
      with TGlobeLayer( Node.Data ) do
      begin
        SubNode := TreeView.Items.AddChild( Node, 'Presenters' );
        SubNode.Data := Presenters;
        SubNode.HasChildren := True;

        SubNode := TreeView.Items.AddChild( Node, 'ObjectSource (' + Objects.Name + ')');
        SubNode.Data := Objects;
        SubNode.HasChildren := True;
      end;

    if TObject( Node.Data ) is TGlobeObjectSource then
      with TGlobeObjectSource( Node.Data ) do
      begin
        SubNode := TreeView.Items.AddChild( Node, 'Presenters' );
        SubNode.Data := Presenters;
        SubNode.HasChildren := True;

        SubNode := TreeView.Items.AddChild( Node, 'Objects' );
        SubNode.Data := Node;
        for idx := 0 to Count - 1 do
          TreeView.Items.AddChild( SubNode, GlobeObject[idx].Title ).Data := GlobeObject[idx];
      end;

    if TObject( Node.Data ) is TGlobePresenterStore then
      with TGlobePresenterStore( Node.Data ) do
        for idx := 0 to Count - 1 do
        begin
          SubNode := TreeView.Items.AddChild( Node, Presenters[idx].Name );
          SubNode.Data := Presenters[idx];
        end;

    TreeView.Items.EndUpdate;
  end;
end;

{------------------------------------------------------------------------------
  TForm1.TreeViewClick
------------------------------------------------------------------------------}
procedure TForm1.TreeViewClick(Sender: TObject);
var
  idx : integer;
  sFilter : string;
begin
  if TreeView.Selected <> nil then
  begin
    if TObject( TreeView.Selected.Data ) is TGlobeObject then
    begin
      Globe.Layers.SelectedObject := TGlobeObject( TreeView.Selected.Data );
      Globe.LocateToObject(Globe.Layers.SelectedObject);
    end;


    // Show the Object List
    if TObject( TreeView.Selected.Data ) is TTreeNode then
    begin
      lvObjects.Items.BeginUpdate;
      lvObjects.Items.Clear;
      sFilter := Trim( eObjectFilter.Text );
      with TGlobeObjectSource( TTreeNode( TreeView.Selected.Data ).Data ) do
        for idx := 0 to Count - 1 do
          if CompareText( sFilter, Copy( GlobeObject[idx].Title, 1, Length( sFilter ))) = 0 then
            with lvObjects.Items.Add do
            begin
              Data := GlobeObject[idx];
              Caption := GlobeObject[idx].Title;
              SubItems.Add( GlobeObject[idx].ClassName);
              SubItems.Add( IntToStr( GlobeObject[idx].PresenterID ));
            end;
      lvObjects.Items.EndUpdate;
      pcData.ActivePage := tsObjects;
      Exit;
    end;
    eObjectFilter.Text := '';


    // Show the Layer Store
    if TObject( TreeView.Selected.Data ) is TGlobeLayerStore then
    begin
      lvLayers.Items.BeginUpdate;
      lvLayers.Items.Clear;
      sFilter := Trim( eLayerFilter.Text );
      with TGlobeLayerStore( TreeView.Selected.Data ) do
        for idx := 0 to Count - 1 do
          if CompareText( sFilter, Copy( LayerObjects[idx].Name, 1, Length( sFilter ))) = 0 then
            with lvLayers.Items.Add do
            begin
              Caption := LayerObjects[idx].Name;
              SubItems.Add( IntToStr( LayerObjects[idx].Objects.Count ));
              SubItems.Add( LayerObjects[idx].Objects.Name);
            end;
      lvLayers.Items.EndUpdate;
      pcData.ActivePage := tsLayers;
      Exit;
    end;
    eLayerFilter.Text := '';

    // Show the Presenter Store
    if TObject( TreeView.Selected.Data ) is TGlobePresenterStore then
    begin
      lvPresenters.Items.BeginUpdate;
      lvPresenters.Items.Clear;
      with TGlobePresenterStore( TreeView.Selected.Data ) do
        for idx := 0 to Count - 1 do
          with lvPresenters.Items.Add do
          begin
            Caption := Presenters[idx].Name;
            SubItems.Add( Presenters[idx].ClassName);
            SubItems.Add( IntToStr( Presenters[idx].PresenterID));
          end;
      lvPresenters.Items.EndUpdate;
      pcData.ActivePage := tsPresenters;
      Exit;
    end;

    // Show any object
    if TObject( TreeView.Selected.Data ) is TPersistent then
    begin
      EditNewObject(TGlobeRoot( TreeView.Selected.Data ));
      Exit;
    end;
    pcData.ActivePage := tsBlank;
  end;
end;

{------------------------------------------------------------------------------
  TForm1.GlobeObjectSelectChange
------------------------------------------------------------------------------}
procedure TForm1.GlobeObjectSelectChange(Sender: TGlobe4;
  GlobeObject: TGlobeObject);
var
  aLayer : TGlobeLayer;
  Node : TTreeNode;
  idx, jdx : integer;
begin
  if not GlobeObject.Selected then Exit;

  eObjectFilter.Text := '';
  eLayerFilter.Text := '';

  aLayer := LayerFromObject( Globe, GlobeObject );

  try
    TreeView.Items.BeginUpdate;
    Node := TreeView.Items.GetFirstNode;
    Node.Expand( False );

    Node := Node.Item[1]; // Get the layers Node
    Node.Expand( False );

    for idx := 0 to Node.Count - 1 do
      if Node.Item[idx].Data = aLayer then
      begin
        Node := Node.Item[idx]; // Get the Layer Node
        Node.Expand( False );

        Node := Node.Item[1]; // Get the ObjectSource Node
        Node.Expand( False );

        Node := Node.Item[1]; // Get the Objects Node
        Node.Expand( False );

        for jdx := 0 to Node.Count - 1 do
          if Node.Item[jdx].Data = GlobeObject then
          begin
            Node := Node.Item[jdx]; // Get the Object Node
            Node.Selected := True;
            Node.MakeVisible;
            EditNewObject(TGlobeRoot( Node.Data ));
            Break;
          end;
        Exit;
      end;
  finally
    TreeView.Items.EndUpdate;
  end;
end;

{------------------------------------------------------------------------------
  TForm1.eObjectFilterChange
------------------------------------------------------------------------------}
procedure TForm1.eObjectFilterChange(Sender: TObject);
begin
  TreeViewClick(nil);
end;

{------------------------------------------------------------------------------
  TForm1.GlobeProgress
------------------------------------------------------------------------------}
procedure TForm1.GlobeProgress(Sender: TGlobe4; MsgType: TProgressMessage;
  const MsgText: String; var Abort: Boolean);
begin
  pnlHint.Caption := MsgText;
end;

{------------------------------------------------------------------------------
  TForm1.lvObjectsClick
------------------------------------------------------------------------------}
procedure TForm1.lvObjectsClick(Sender: TObject);
begin
  Globe.Layers.SelectedObject := TGlobeObject( lvObjects.Selected.Data );
  Globe.LocateToObject(Globe.Layers.SelectedObject);
end;

end.

