{-------------------------------------------------------------------------
	Comment:   MinPresenter Source

	Author:	   Graham Knight
  Copyright: Graham Knight 1998
	Email:     gknight@helmstone.co.uk

 This shows just about the minimum that you need to do to create a new
 Presenter.

 This Presenter will display an object as a filled polygon with each
 point in the polygon highlighted by a circle.

 This is given here to show how a minimal presenter can be constructed.
-------------------------------------------------------------------------}

type
	{---------------------------- TMinPresenter ----------------------------}
	TMinPresenter = class( TPolygonPresenter )
	public
		procedure RenderObject( Geom : TGlobeObject ); override;
	end;


implementation


procedure TMinPresenter.RenderObject( Geom : TGlobeObject );
var
	idx : integer;
	pt : TPoint;
begin
	inherited RenderObject( Geom );
	
	for idx := 0 to Geom.CountLL - 1 do
		if Globe.PointLLToDeviceXY( Geom.PointsLL[idx], pt ) then
			Globe.GlobeCanvas.Ellipse( pt.x - 3, pt.y - 3, pt.x + 3, pt.y + 3 );
end;
