{-------------------------------------------------------------------------
 Module:    Image Maker Example Application

 Comment:   Creates an image file from TGlobe data from the command line.

 Author:    Graham Knight
 Email:     tglobe@iname.com
-------------------------------------------------------------------------}
program ImageMaker;
{$APPTYPE CONSOLE}
uses
  Classes, SysUtils, Graphics, Globe4, TGClasses, GlobeUtils, TGLYRMapper, TGSysUtils;

var
  Globe : TGlobe4;
  Image : TBitmap;
begin
  Globe := TGlobe4.Create( nil );

  // Set the globe properties that you want here
  Globe.SurfaceColor := clAqua;

  Globe.LocateToLL(
    DecimalToGlobeUnits( 0.0 ),
    DecimalToGlobeUnits( 23.5 ));

  Globe.GlobeCanvas.ResizeProjection( 400, 400 );
  Globe.Projection.Altitude := Globe.GlobeUnitsFrom( 30, NauticalMile );


  // Load the layers onto the globe
  CreatefileLayer( Globe, '..\TGData\TGWorld.lyr' );



  Image := TBitmap.Create;
  Image.Width := 400;
  Image.Height := 400;

  Globe.RenderToCanvas( Image.Canvas, Rect( 0, 0, 399, 399 ));
  Image.SaveToFile( 'c:\xxx.bmp' );
end.
