unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Menus, DBCtrls, ExtCtrls, ComCtrls, DBAnyIm, ExtDlgs,
  ClipBrd, ShellAPI;

type
  TForm1 = class(TForm)
    Table1: TTable;
    Table1Image: TAnyGraphicField;
    DataSource1: TDataSource;
    DBAnyImage1: TDBAnyImage;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    DBNavigator1: TDBNavigator;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    LoadImage1: TMenuItem;
    Edit1: TMenuItem;
    PasteAs1: TMenuItem;
    Paste1: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    PopupMenu1: TPopupMenu;
    LoadImage2: TMenuItem;
    OpenPictureDialog1: TOpenPictureDialog;
    SavePictureDialog1: TSavePictureDialog;
    SaveImage1: TMenuItem;
    SaveImage2: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    ModifyorConvert1: TMenuItem;
    Cut2: TMenuItem;
    Copy2: TMenuItem;
    Paste2: TMenuItem;
    PasteAs2: TMenuItem;
    N3: TMenuItem;
    ModifyorConvert2: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    TDBAnyImageHelp1: TMenuItem;
    N4: TMenuItem;
    TDBAnyImageHelp2: TMenuItem;
    About2: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure FileLoad1Execute(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure DBAnyImage1PictureChanged(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure EditCopy1Execute(Sender: TObject);
    procedure EditCut1Execute(Sender: TObject);
    procedure EditPaste1Execute(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure EditModify1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure HelpOpen1Execute(Sender: TObject);
  private
    function ClipboardHasGraphicFormat(Item: TMenuItem): Boolean;
    procedure PasteAsFormat(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  with Table1 do begin
    DatabaseName := ExtractFilePath(Application.ExeName);
    Active := True;
  end;
end;

procedure TForm1.FileLoad1Execute(Sender: TObject);
begin
  with OpenPictureDialog1 do
    if Execute then begin
      if not (Table1.State in [dsEdit,dsInsert]) then begin
        if Table1.IsEmpty then
          Table1.Insert else
          Table1.Edit;
       end;
      Table1Image.LoadFromFile(FileName);
    end;
end;

procedure TForm1.FileSave1Execute(Sender: TObject);
begin
  with SavePictureDialog1 do
    if Execute then
      Table1Image.SaveToFile(FileName);
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
begin
  StatusBar1.SimpleText := Format('Record %d of %d   %s file   %d bytes',
  [Table1.RecNo, Table1.RecordCount,DBAnyImage1.GraphicExt, DBAnyImage1.GraphicSize]);
end;

procedure TForm1.DBAnyImage1PictureChanged(Sender: TObject);
begin
  StatusBar1.SimpleText := Format('%s file, %d bytes',
  [DBAnyImage1.GraphicExt, DBAnyImage1.GraphicSize]);
end;

procedure TForm1.File1Click(Sender: TObject);
begin
  SaveImage1.Enabled := not Table1.IsEmpty and not Table1Image.IsNull;
  SaveImage2.Enabled := SaveImage1.Enabled;
end;

procedure TForm1.EditCopy1Execute(Sender: TObject);
begin
  DBAnyImage1.CopyToClipboard;
end;

procedure TForm1.EditCut1Execute(Sender: TObject);
begin
  DBAnyImage1.CutToClipboard;
end;

procedure TForm1.EditPaste1Execute(Sender: TObject);
begin
  DBAnyImage1.PasteFromClipboard;
end;

//The next function checks for avaiable graphic formats in the clipboard
//and creates the corresponding sub menus, saving the format in the Tag property

function TForm1.ClipboardHasGraphicFormat(Item: TMenuItem): Boolean;
var
  Format: Word;
  Picture: TPicture;
  Data: THandle;
  Palette: HPALETTE;
  i, c: Integer;
begin
  Result := False;
  i := 0;
  for c := Item.Count - 1 downto 0 do
    Item.Delete(c);
  Clipboard.Open;
  try
    Picture := TPicture.Create;
    try
      Format := EnumClipboardFormats(0);
      while Format <> 0 do
      begin
        if TPicture.SupportsClipboardFormat(Format) then begin
          Data := GetClipboardData(Format);
          Picture.LoadFromClipboardFormat(Format, Data, Palette);
          Item.Add(TMenuItem.Create(Self));
          with Item.Items[i] do begin
            Caption := GraphicExtension(TGraphicClass(Picture.Graphic.ClassType));
            Tag := Format;
            OnClick := PasteAsFormat;
          end;
        Result := True;
        end;
        Format := EnumClipboardFormats(Format);
        inc(i);
      end;
    finally
      Picture.Free;
    end;
  finally
    Clipboard.Close;
  end;
end;

procedure TForm1.PasteAsFormat(Sender: TObject);
begin
  DBAnyImage1.PasteAsFromClipboard(TMenuItem(Sender).Tag);
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
  Cut1.enabled := (DBAnyImage1.Picture.Graphic <> Nil)
  and not (DBAnyImage1.Picture.Graphic is TIcon);
  Cut2.enabled := Cut1.enabled;
  ModifyorConvert1.Enabled := Cut1.enabled and
  not (DBAnyImage1.Picture.Graphic is TMetafile);
  ModifyorConvert2.Enabled := ModifyorConvert1.Enabled;
  Copy1.Enabled := Cut1.enabled ;
  Copy2.Enabled := Cut1.enabled ;
  PasteAs1.Enabled := ClipboardhasGraphicFormat(PasteAs1);
  Paste1.Enabled := PasteAs1.Enabled;
  Paste2.Enabled := PasteAs1.Enabled;
  PasteAs2.Enabled := ClipboardhasGraphicFormat(PasteAs2);
end;

procedure TForm1.EditModify1Execute(Sender: TObject);
begin
  DBAnyImage1.ConvertGraphic;
end;

procedure TForm1.HelpAbout1Execute(Sender: TObject);
begin
  ShowMessage(Format('TDBAnyImage version %s' + #13 +
  'Copyright  Noatak Racing Team 2000'+ #13 +
  'Software@noatak.com'+ #13 +
  'http://www.noatak.com', [DBAnyImage1.Version]));
end;

procedure TForm1.HelpOpen1Execute(Sender: TObject);
begin
  SetCurrentDir(ExtractFileDir(Application.ExeName));
  ShellExecute(Handle,'open', '..\DBAnyIm.chm',nil,nil,SW_SHOW);
end;

end.
