unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DBGrids, Db, TbJet, ExtCtrls, DBCtrls, ComCtrls, Buttons,
  Mask;

type
  TMainForm = class(TForm)
    TbJetDatabase: TTbJetDatabase;
    DataRecordset: TDataSource;
    PageControl1: TPageControl;
    Recordset: TTabSheet;
    Table: TTabSheet;
    GridDynaset: TDBGrid;
    DBNavigator1: TDBNavigator;
    Open: TButton;
    OpenTable: TButton;
    DBNavigator2: TDBNavigator;
    GridTable: TDBGrid;
    DataTable: TDataSource;
    LFind: TLabel;
    Find: TEdit;
    Indexes: TListBox;
    TbJetTable: TTbJetTable;
    Query: TTabSheet;
    GridQuery: TDBGrid;
    TbJetQuery: TTbJetQuery;
    DataQuery: TDataSource;
    ActiveQuery: TButton;
    LQuery: TLabel;
    QueryText: TEdit;
    DBNavigator3: TDBNavigator;
    Compact: TBitBtn;
    Repair: TBitBtn;
    TbJetTableDESCRIPCION: TStringField;
    TbJetTablePRECIO: TCurrencyField;
    TbJetTableFinal: TCurrencyField;
    TbJetTableLOGICO: TBooleanField;
    Memo: TTabSheet;
    Clientes: TTbJetTable;
    ClientesData: TDataSource;
    LText: TLabel;
    LMemo: TLabel;
    Nombre: TDBEdit;
    Notas: TDBMemo;
    DBNavigator4: TDBNavigator;
    Button1: TButton;
    TbJetTableCODIGO: TStringField;
    TbJetTableID: TIntegerField;
    TbJetRecordset: TTbJetRecordset;
    TbJetRecordsetID: TIntegerField;
    TbJetRecordsetCODIGO: TStringField;
    TbJetRecordsetDESCRIPCION: TStringField;
    TbJetRecordsetPRECIO: TCurrencyField;
    TbJetRecordsetLOGICO: TBooleanField;
    TbJetRecordsetFINAL: TCurrencyField;
    procedure OpenClick(Sender: TObject);
    procedure GridDynasetTitleClick(Column: TColumn);
    procedure OpenTableClick(Sender: TObject);
    procedure GridTableTitleClick(Column: TColumn);
    procedure FindChange(Sender: TObject);
    procedure IndexesClick(Sender: TObject);
    procedure ActiveQueryClick(Sender: TObject);
    procedure GridQueryTitleClick(Column: TColumn);
    procedure CompactClick(Sender: TObject);
    procedure RepairClick(Sender: TObject);
    procedure TbJetTableCalcFields(DataSet: TDataSet);
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TbJetRecordsetCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.OpenClick(Sender: TObject);
begin
  TbJetRecordset.Active := not TbJetRecordset.Active;
end;

procedure TMainForm.GridDynasetTitleClick(Column: TColumn);
begin
  if TbJetRecordset.Active then
    TbJetRecordset.Sort := Column.Field.FieldName;
end;

procedure TMainForm.OpenTableClick(Sender: TObject);
begin
  TbJetTable.Active := not TbJetTable.Active;
  TbJetTable.GetIndexes(Indexes.Items);
end;

procedure TMainForm.GridTableTitleClick(Column: TColumn);
begin
  if TbJetTable.Active then
    TbJetTable.IndexName := Column.Field.FieldName;
end;

procedure TMainForm.FindChange(Sender: TObject);
begin
  TbJetTable.FindNearest([Find.Text]);
end;

procedure TMainForm.IndexesClick(Sender: TObject);
begin
  TbJetTable.IndexName := Indexes.Items[Indexes.ItemIndex];
end;

procedure TMainForm.ActiveQueryClick(Sender: TObject);
begin
  TbJetQuery.SQL.Text := QueryText.Text;
  TbJetQuery.Active := not TbJetQuery.Active;
end;

procedure TMainForm.GridQueryTitleClick(Column: TColumn);
var
  Text : string;
begin
  if TbJetQuery.Active then
    begin
      Text := QueryText.Text + ' ORDER BY '+ Column.Field.FieldName;
      TbJetQuery.Active := False;
      TbJetQuery.SQL.Text := Text;
      TbJetQuery.Active := True;
    end;
end;

procedure TMainForm.CompactClick(Sender: TObject);
begin
  TbJetDatabase.CompactDatabase;
end;

procedure TMainForm.RepairClick(Sender: TObject);
begin
  TbJetDatabase.RepairDatabase;
end;

procedure TMainForm.TbJetTableCalcFields(DataSet: TDataSet);
begin
  if TbJetTablePRECIO.IsNull then
    TbJetTableFINAL.Clear
  else
    TbJetTableFINAL.Value := TbJetTablePRECIO.Value * 0.1;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  Clientes.Active := not Clientes.Active;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  TbJetDatabase.DatabaseName := ExtractFilePath(ParamStr(0))+'Jet.mdb';
end;

procedure TMainForm.TbJetRecordsetCalcFields(DataSet: TDataSet);
begin
  if TbJetRecordsetPRECIO.IsNull then
    TbJetRecordsetFINAL.Clear
  else
    TbJetRecordsetFINAL.Value := TbJetRecordsetPRECIO.Value * 0.1;
end;

end.
