unit Tbjet;
(* ===========================================================================
 * TbJet.dcu - TTbJetCustomRecordset : A custom data set which uses Jet Engine
 * v 1.00                    to read MDB Access Files.
 *  version            Shareware
 *  Delphi 3.0         (for commercial use has a fee of USD 40.- + $20 sources)
 *
 * Author:  Horacio Jamilis
 * E-Mail:  hjamilis@pymesoft.com
 * WWW:     http://members.xoom.com/t_byte/
 *  or      http://www.geocities.com/SiliconValley/Sector/2369/
 * Copyright (C) 1998-1999, Terabyte Software
 *
 * ===========================================================================
 * I have many useful components writen. TTbJetCustomRecordset is just one of them.
 * The others are...
 *  - TbDBF   ... a Custom Dataset to access dBase III+ Files Without BDE or
 *                any other database engine. It is a database engine written in
 *                Delphi. Supports all the fields including Memo. Single user
 *                access and with no indexes yet.
 *  - TbPrint ... a Printing and reporting component set that makes VERY easy
 *                and VERY fast to make database reports (less than a minute).
 *                It can print all you want (but only text, no graphics yet), in
 *                Windows (using a printer driver) or Fast modes (writing directly
 *                to the printer port, using the device features).
 *                So, prints very fast.
 *  - TbLang  ... a MultiLanguage system. With it you could make your programs
 *                multilingual VERY easy. You could edit all the text strings while
 *                you are programing (in the Delphi IDE) or later with a stand alone
 *                aplication. It supports UserStrings (used in the code for messages)
 *                and Dialogs (MessageDlg, InputBox and InputQuery) with translated
 *                caption and buttons. You could use all the languages you wish.
 *                You could save the translations in the EXE or in a Flat File.
 *  - LinkEdit .. Just an TEdit with an elipsis button in it's right side only when
 *                the edit is active (with cursor), and alignment options.
 * Enjoy Them.
 * ===========================================================================
 * v 1.00
 * - First release
 * ===========================================================================
 * Again, my email address is hjamilis@pymesoft.com
 * ===========================================================================
 *)

{ FALTA }
{
- Completar el locate (que no anda)
- Completar el FindKey and FindNearest para Dynasets
- Creacion de tablas
- Modificacion de tablas
- Eliminacion de tablas
}

interface

uses
  Classes, SysUtils, Db, DsgnIntf, ComObj;

const
  Debuging = False;
  TotalTest = True;
// DAO CONSTS
  dbDate	=  8; // Date/Time
  dbText	= 10; // Text
  dbMemo	= 12; // Memo
  dbBoolean	=  1; // Yes/No
  dbInteger	=  3; // Integer
  dbLong	=  4; // Long
  dbCurrency	=  5; // Currency
  dbSingle	=  6; // Single
  dbDouble	=  7; // Double
  dbByte	=  2; // Byte
  dbLongBinary	= 11; // Long Binary (OLE Object)
  dbChar        = 18; // Character
  dbNumeric     = 19;
  dbDecimal     = 20;
  dbFloat       = 21;
  dbTime        = 22;
  dbTimeStamp   = 23;

  dbFixedField = 1;
  dbVariableField = 2;
  dbAutoIncrField = 16;
  dbUpdatableField = 32;
  dbSystemField = 8192;
  dbHyperlinkField = 32768;
  dbDescending = 1;
  
  dbEditNone       =  0;
  dbEditInProgress =  1;
  dbEditAdd        =  2;
  dbEditChanged    =  4;
  dbEditDeleted    =  8;
  dbEditNew        = 16;

  dbUseODBC = 1;
  dbUseJet =  2;

  dbDriverPrompt           = 2;
  dbDriverNoPrompt         = 1;
  dbDriverComplete         = 0;
  dbDriverCompleteRequired = 3;

  dbOpenTable       =  1;
  dbOpenDynaset     =  2;
  dbOpenSnapshot    =  4;
  dbOpenForwardOnly =  8;
  dbOpenDynamic     = 16;

  dbSeeChanges = $00000200;

  dbPessimistic     = $00000002;
  dbOptimistic      = $00000003;
  dbOptimisticValue = $00000001;
  dbOptimisticBatch = $00000005;

  { CommitTransOptionsEnum }

  dbForceOSFlush = 1;

type
  TRecordSetType = (Dynaset, Snapshot, ForwardOnly);

  PTbBookMark = ^TTbBookMark;
  TTbBookMark = array[0..3] of byte;
  TTbDatabaseNameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TTbTableSelectProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure GetValueList(List: TStrings);
  end;

  TTbIndexSelectProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure GetValueList(List: TStrings);
  end;

  TTbDatabaseTypeSelectProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure GetValueList(List: TStrings);
  end;

  EJetError = class (Exception);

  pDateTime = ^TDateTime;
  pBoolean = ^Boolean;
  pInteger = ^Integer;

  PRecInfo = ^TRecInfo;
  TRecInfo = record
    InternalBookmark : TTbBookMark;
    BookmarkFlag: TBookmarkFlag;
  end;

  pRecordHeader = ^tRecordHeader;
  tRecordHeader = record
    DeletedFlag : char;
  end;

  TTbAboutBoxProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TTbJetCustomRecordset = class;
  TTbJetTable = class;

  TTbJetDatabase = class(TComponent)
  private
    { Private declarations }
    Engine : Variant;
    WS : Variant;
    DB : Variant;
    Tables : TList;
    FConnected : boolean;
    FDatabaseName : string;
    FUserName : string;
    FUserPassword : string;
    FAbout: TTbAboutBoxProperty;
    FExclusive : boolean;
    FBeforeOpen,
    FAfterOpen,
    FBeforeClose,
    FAfterClose : TNotifyEvent;
    FKeepConnected : boolean;
    FDatabaseType : string;
    procedure NagScreen;
    procedure SetConnected(State : boolean);
    procedure SetDatabaseName(Name : string);
    procedure SetUserName(UserName : string);
    procedure SetUserPassword(UserPassword : string);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure GetTables(List : TStrings);
    function OpenTable(Table : TTbJetTable) : Variant;
    function OpenRecordset(Table : TTbJetCustomRecordset; RecordSetType : TRecordSetType) : Variant;
    function OpenQuery(SQL : string; Table : TDataset; RecordSetType : TRecordSetType) :  Variant;
    procedure CloseRecordset(RecordSet : TDataset);
    procedure Open;
    procedure Close;
    procedure StartTransaction;
    procedure Commit;
    procedure RollBack;
    procedure RepairDatabase;
    procedure CompactDatabase;
  published
    { Published declarations }
    property DatabaseType : string read FDatabaseType write FDatabaseType;
    property About: TTbAboutBoxProperty read FAbout write FAbout;
    property Connected : boolean read FConnected write SetConnected default False;
    property KeepConnected : boolean read FKeepConnected write FKeepConnected;
    property DatabaseName : string read FDatabaseName write SetDatabaseName;
    property UserName : string read FUserName write SetUserName;
    property UserPassword : string read FUserPassword write SetUserPassword;
    property Exclusive : boolean read FExclusive write FExclusive default False;
    property BeforeOpen : TNotifyEvent read FBeforeOpen write FBeforeOpen;
    property AfterOpen : TNotifyEvent read FAfterOpen write FAfterOpen;
    property BeforeClose : TNotifyEvent read FBeforeClose write FBeforeClose;
    property AfterClose : TNotifyEvent read FAfterClose write FAfterClose;
  end;

  TTbJetCustomRecordset = class(TDataSet)
  private
    RS : Variant;
    FDatabase : TTbJetDatabase;
    FTableName: string; // table path and file name
    // record data
    fRecordHeaderSize : Integer;   // The size of the record header
    FRecordSize,                   // the size of the actual data
    FRecordBufferSize,             // data + housekeeping (TRecInfo)
    FRecordInfoOffset : integer;   // offset of RecInfo in record buffer
    FIsTableOpen: Boolean;         // status
    fReadOnly : Boolean;           // Enhancements
    FEof : boolean;
    FBof : boolean;
    FAbout: TTbAboutBoxProperty;
    FBlobCount:    Integer;
    FBlobCacheOfs: Word;
    FCacheBlobs: boolean;
    FieldOffsets : TList;
    IsAdding : boolean;
    IsEditing : boolean;
    FSort : string;
    fActiveFilter : Boolean;       // If the filtering is active
    FFilter : string;
    FSQL : TStringList;
    FIsOpening : boolean;
    FRecordSetType : TRecordSetType;
    Procedure ConvertDaoToDelphi(Buffer : PChar);
    Procedure ConvertDelphiToDao(Buffer : PChar);
    procedure SetSort(Sort : string);
    procedure SetFilter(Filter : string);
    procedure SetActiveFilter(ActiveFilter : boolean);
    procedure SetSQL(SQL : TStringList);
    function IsEof: Boolean;
    function IsBof: Boolean;
  protected
    // TDataSet virtual abstract method
    function AllocRecordBuffer: PChar; override;
    procedure FreeRecordBuffer(var Buffer: PChar); override;
    procedure GetBookmarkData(Buffer: PChar; Data: Pointer); override;
    function GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
    function GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
    function GetRecordSize: Word; override;
    procedure InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
    procedure InternalClose; override;
    procedure InternalDelete; override;
    procedure InternalFirst; override;
    procedure InternalGotoBookmark(Bookmark: Pointer); override;
    procedure InternalHandleException; override;
    procedure InternalInitFieldDefs; override;
    procedure InternalInitRecord(Buffer: PChar); override;
    procedure InternalLast; override;
    procedure InternalOpen; override;
    procedure InternalEdit; override;
    procedure DoAfterInsert; override;
    procedure InternalPost; override;
    procedure InternalCancel; override;
    procedure InternalSetToRecord(Buffer: PChar); override;
    function IsCursorOpen: Boolean; override;
    procedure SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;
    procedure SetBookmarkData(Buffer: PChar; Data: Pointer); override;
    procedure SetFieldData(Field: TField; Buffer: Pointer); override;
    // TDataSet virtual method (optional)
    function GetRecordCount: Integer; override;
    procedure SetRecNo(Value: Integer); override;
    function GetRecNo: Integer; override;
    // TDataSet - Filter
    function FindRecord(Restart, GoForward: Boolean): Boolean; override;
    procedure ClearCalcFields(Buffer: PChar); override;
  public
    function GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
    constructor Create(AOwner:tComponent); override;
    destructor Destroy; override;
    property Bof: Boolean read IsBof;
    property Eof: Boolean read IsEof;
    procedure First;
    procedure Last;
    function CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
    property TableName: string read FTableName write FTableName;
    property Sort : string read FSort write SetSort;
    property SQL : TStringList read FSQL write SetSQL;
  published
    property RecordSetType : TRecordSetType read FRecordSetType write FRecordSetType;
    property Database : TTbJetDatabase read FDatabase write FDatabase;
    property ReadOnly : Boolean read fReadOnly write fReadonly default False;
    // redeclared data set properties
    property AutoCalcFields;
    property Active;
    property Filter : string read FFilter write SetFilter;
    property Filtered : boolean read FActiveFilter write SetActiveFilter;
    property BeforeOpen;
    property AfterOpen;
    property BeforeClose;
    property AfterClose;
    property BeforeInsert;
    property AfterInsert;
    property BeforeEdit;
    property AfterEdit;
    property BeforePost;
    property AfterPost;
    property BeforeCancel;
    property AfterCancel;
    property BeforeDelete;
    property AfterDelete;
    property BeforeScroll;
    property AfterScroll;
    property OnCalcFields;
    property OnDeleteError;
    property OnEditError;
//    property OnFilterRecord;
    property OnNewRecord;
    property OnPostError;
    property About: TTbAboutBoxProperty read FAbout write FAbout;
  end;

  TTbJetRecordset = class(TTbJetCustomRecordset)
  private
  protected
  public
  published
    property TableName;
    property Sort;
  end;

  TTbJetQuery = class(TTbJetCustomRecordset)
  private
  protected
  public
  published
    property SQL;
  end;

  TTbJetTable = class(TDataSet)
  private
    RS : Variant;
    FDatabase : TTbJetDatabase;
    FTableName: string; // table path and file name
    // record data
    fRecordHeaderSize : Integer;   // The size of the record header
    FRecordSize,                   // the size of the actual data
    FRecordBufferSize,             // data + housekeeping (TRecInfo)
    FRecordInfoOffset : integer;   // offset of RecInfo in record buffer
    FIsTableOpen: Boolean;         // status
    fReadOnly : Boolean;           // Enhancements
    FEof : boolean;
    FBof : boolean;
    FAbout: TTbAboutBoxProperty;
    FBlobCount:    Integer;
    FBlobCacheOfs: Word;
    FCacheBlobs: boolean;
    FieldOffsets : TList;
    IsAdding : boolean;
    IsEditing : boolean;
    FilterBuffer : PChar;
    Filtering : boolean;        // Are we currently filtering?
    FFilter : string;
    FActiveFilter : Boolean;       // If the filtering is active
    FSort : string;
    FIsOpening : boolean;
    Procedure ConvertDaoToDelphi(Buffer : PChar);
    Procedure ConvertDelphiToDao(Buffer : PChar);
    procedure SetSort(Sort : string);
    Function _ProcessFilter(Buffer:PChar):boolean;
    function IsEof: Boolean;
    function IsBof: Boolean;
    function LocateRecord(const KeyFields: string; const KeyValues: Variant;
      Options: TLocateOptions; SyncCursor: Boolean): Boolean;
    procedure SetFilter(Filter : string);
  protected
    // TDataSet virtual abstract method
    function AllocRecordBuffer: PChar; override;
    procedure FreeRecordBuffer(var Buffer: PChar); override;
    procedure GetBookmarkData(Buffer: PChar; Data: Pointer); override;
    function GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
    function GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
    function GetRecordSize: Word; override;
    procedure InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
    procedure InternalClose; override;
    procedure InternalDelete; override;
    procedure InternalFirst; override;
    procedure InternalGotoBookmark(Bookmark: Pointer); override;
    procedure InternalHandleException; override;
    procedure InternalInitFieldDefs; override;
    procedure InternalInitRecord(Buffer: PChar); override;
    procedure InternalLast; override;
    procedure InternalOpen; override;
    procedure InternalEdit; override;
    procedure DoAfterInsert; override;
    procedure InternalPost; override;
    procedure InternalCancel; override;
    procedure InternalSetToRecord(Buffer: PChar); override;
    function IsCursorOpen: Boolean; override;
    procedure SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;
    procedure SetBookmarkData(Buffer: PChar; Data: Pointer); override;
    procedure SetFieldData(Field: TField; Buffer: Pointer); override;
    // TDataSet virtual method (optional)
    function GetRecordCount: Integer; override;
    procedure SetRecNo(Value: Integer); override;
    function GetRecNo: Integer; override;
    // TDataSet - Filter
    function FindRecord(Restart, GoForward: Boolean): Boolean; override;
    procedure ClearCalcFields(Buffer: PChar); override;
  public
    procedure GetIndexes(List : TStrings);
    procedure GetFields(List : TStrings);
    procedure GetIndexDescs(Descs : TList);
    function GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
    constructor Create(AOwner:tComponent); override;
    destructor Destroy; override;
    property Bof: Boolean read IsBof;
    property Eof: Boolean read IsEof;
    function CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
    function  FindKey(const FieldValues: array of variant):boolean;
    procedure FindNearest(const FieldValues: array of shortstring);
    function Locate(const KeyFields: string; const KeyValues: Variant;
             Options: TLocateOptions): Boolean; override;
    function Lookup(const KeyFields: string; const KeyValues: Variant;
      const ResultFields: string): Variant; override;
  published
    property Database : TTbJetDatabase read FDatabase write FDatabase;
    property TableName: string read FTableName write FTableName;
    property IndexName : string read FSort write SetSort;
    property ReadOnly : Boolean read fReadOnly write fReadonly default False;
    // redeclared data set properties
    property AutoCalcFields;
    property Active;
    property Filter : string read FFilter write SetFilter;
    property Filtered;
    property BeforeOpen;
    property AfterOpen;
    property BeforeClose;
    property AfterClose;
    property BeforeInsert;
    property AfterInsert;
    property BeforeEdit;
    property AfterEdit;
    property BeforePost;
    property AfterPost;
    property BeforeCancel;
    property AfterCancel;
    property BeforeDelete;
    property AfterDelete;
    property BeforeScroll;
    property AfterScroll;
    property OnCalcFields;
    property OnDeleteError;
    property OnEditError;
//    property OnFilterRecord;
    property OnNewRecord;
    property OnPostError;
    property About: TTbAboutBoxProperty read FAbout write FAbout;
  end;

  TTbBlobDataArray = array[0..0] of Pointer;
  PTbBlobDataArray = ^TTbBlobDataArray;

  TTbBlobStream = class(TStream)
  private
    FField: TBlobField;
    FDataSet: TDataset;
    FMode: TBlobStreamMode;
    FFieldNo: Integer;
    FPosition: Longint;
    FRecord : PChar;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    function Read(var Buffer; Count: Longint): Longint; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    function Seek(Offset: Longint; Origin: Word): Longint; override;
  end;

procedure Register;

implementation

uses
  Dialogs, Windows, Forms;

var
  JetVersion : string;
  
TYPE
  PBufArray = ^BufArray;
  BufArray = Array[0..0] of Char;

// ****************************************************************************
// Low Level Routines for accessing an internal record

procedure TTbJetCustomRecordset.SetSort(Sort : string);
begin
  FSort := Sort;
  if Active then
    begin
      Close;
      Open;
    end;
end;

Procedure TTbJetCustomRecordset.ConvertDaoToDelphi(Buffer : PChar);
var
  i,n : integer;
  S : string;
  D : double;
  INT : Integer;
  SINT : smallint;
  B : boolean;
  W : word;
  DT : TDateTimeRec;
  TS : TTimeStamp;
  Memo : PChar;
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('ConvertDaoToDelphi');
  for i := 0 to Fieldcount-1 do
    begin
      if Fields[i].FieldNo < 0 then Continue;
      Case Fields[i].DataType of
        ftString :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                S := RS.Fields.Item[n].Value;
                StrPCopy(@PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],PChar(S));
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                S := '';
                StrPCopy(@PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],PChar(S));
              end;
          end;
        ftCurrency, ftFloat :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    D := RS.Fields.Item[n].Value;
                    Move(D,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],8);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftInteger :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    INT := RS.Fields.Item[n].Value;
                    Move(INT,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],4);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftSmallInt :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    SINT := RS.Fields.Item[n].Value;
                    Move(SINT,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],2);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
              end;
          end;
        ftWord :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    W := RS.Fields.Item[n].Value;
                    Move(W,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],2);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftBoolean :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    B := RS.Fields.Item[n].Value;
                    Move(B,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],2);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
              end;
          end;
        ftDateTime :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    TS := DateTimeToTimeStamp(RS.Fields.Item[n].Value);
                    DT.DateTime := TimeStampToMSecs(TS);
                    Move(DT,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],8);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftMemo :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
                S := RS.Fields[n].Value;
                Memo:=StrAlloc(Length(S)+1);
                StrCopy(Memo,PChar(S));
                PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2] := Memo;
                StrCopy(Memo,PChar(S));
                Memo:=StrAlloc(Length(S)+1);
                StrCopy(Memo,PChar(S));
                PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2+1] := Memo;
              end
          end;
      end;
    end;
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('ConvertDaoToDelphi End');
end;

Procedure TTbJetCustomRecordset.ConvertDelphiToDao(Buffer : PChar);
var
  i,j,n : integer;
  S : string;
  D : double;
  INT : Integer;
  SINT : smallint;
  B : boolean;
  W : word;
  DT : TDateTimeRec;
  TS : TTimeStamp;
  E : integer;
  Memo, MemoOriginal : PChar;
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('ConvertDelphiToDao');
  E := RS.EditMode;
  if E = 0 then Raise EJetError.Create('The Jet table is not in edit or insert mode.');
  for i := 0 to Fieldcount-1 do
    begin
      Case Fields[i].DataType of
        ftString :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                S := '';
                j := 0;
                While (j<Fields[i].Size)and(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])+j] <> #0) do
                  begin
                    S := S + PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])+j];
                    inc(j);
                  end;
                RS.Fields.Item[n].Value := S;
               except
               end;
              end
          end;
        ftCurrency, ftFloat :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],D,8);
                    RS.Fields.Item[n].Value := D;
                  end;
               except
               end;
              end
          end;
        ftInteger :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if (RS.Fields.Item[n].Name = Fields[i].FieldName) and (RS.Fields.Item[n].Attributes and dbAutoIncrField <> dbAutoIncrField) then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],INT,4);
                    RS.Fields.Item[n].Value := INT;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftSmallInt :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],SINT,2);
                    RS.Fields.Item[n].Value := SINT;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftWord :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],W,2);
                    RS.Fields.Item[n].Value := W;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftBoolean :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],B,2);
                    RS.Fields.Item[n].Value := B;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftDateTime :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],DT,8);
                    TS := MSecsToTimeStamp(DT.DateTime);
                    RS.Fields.Item[n].Value := TimeStampToDateTime(TS);
                  end;
               except
                 RS.Fields.Item[n].Value := NULL;
               end;
              end
          end;
        ftMemo :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
                Memo := PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2];
                MemoOriginal := PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2+1];
                if StrComp(Memo,MemoOriginal)<>0 then
                  begin
                    RS.Fields[n].Value := String(Memo);
                  end;
              end;
          end;
      end;
    end;
end;

/////////////////////////////////////////////////
////// Part I:
////// Initialization, opening, and closing
/////////////////////////////////////////////////

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalOpen
// I: open the table/file
procedure TTbJetCustomRecordset.InternalOpen;
begin
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalOpen');
  if (FSQL.Text = '') and (TableName = '') then
    raise EJETError.Create('The information provided is not enaught to open the recordset.');
 try
   if not VarIsEmpty(RS) then
     begin
       RS.Close;
       RS := Unassigned;
       FIsTableOpen := False;
       Database.CloseRecordset(self);
     end;
 except
 end;
  if not Database.Connected then Database.Open;
  if FSQL.Text <> '' then
    begin
      RS := Database.OpenQuery(FSQL.Text,self,FRecordSetType);
    end
  else if TableName <> '' then
    begin
      if FSort = '' then
        RS := Database.OpenRecordset(self,FRecordSetType)
      else
        RS := Database.OpenQuery('Select * from '+TableName+' ORDER BY '+FSort,self,FRecordSetType);
    end;
  if (FFilter <> '') and (FActiveFilter) then
    RS.Filter := FFilter;
  RS.MoveFirst;
  RS.MovePrevious;
  // sets record position
//  FCurrentRecord := -1;
  // set the bookmark size
  BookmarkSize := SizeOf(TTbBookMark);
  // initialize the field definitions
  // (another virtual abstract method of TDataSet)
  FIsOpening := True;
  InternalInitFieldDefs;
  FIsOpening := False;
  // if there are no persistent field objects,
  // create the fields dynamically
  if DefaultFields then
    CreateFields;
  // connect the TField objects with the actual fields
  BindFields (True);
  FBlobCacheOfs := FRecordSize + CalcFieldsSize;
  FRecordInfoOffset := FBlobCacheOfs + FBlobCount * SizeOf(Pointer) * 2;
  FRecordBufferSize := FRecordInfoOffset + SizeOf(TRecInfo);
  // get the number of records and check size
//  fRecordCount := RS.RecordCount;
  // everything OK: table is now open
  FIsTableOpen := True;
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalOpenEnd');
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalInitFieldDefs
// I: define the fields
procedure TTbJetCustomRecordset.InternalInitFieldDefs;
var
  I : Integer;
  Offset : integer;
  N : string;
  R : boolean;
  S : integer;
  IsTableClosed, IsDatabaseClosed : boolean;
begin
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalInitFieldDefs');
  FieldDefs.Clear;
  IsTableClosed := False;
  IsDatabaseClosed := False;
  if (CsDesigning in ComponentState) and not Active then
    begin
      IsTableClosed := True;
      if not Database.Connected then
        begin
          IsTableClosed := True;
          Database.Open;
        end;
      if SQL.Text <> '' then
        RS := Database.OpenQuery(SQL.Text,self,RecordSetType)
      else if TableName <> '' then
        RS := Database.OpenRecordset(self,RecordSetType);
    end;
  Offset := SizeOf(tRecordHeader);
  FBlobCount   := 0;
  FRecordSize := 0;
  FieldOffsets.Clear;
  for I:=0 to RS.Fields.Count -1 do
    begin
      FieldOffsets.Add(Pointer(Offset));
      N := RS.Fields.Item[I].Name;
      R := RS.Fields.Item[I].Required;
      if RS.Fields.Item[I].Type = dbBoolean then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftBoolean, 0, R, I+1);
          inc(Offset,1);
        end
      else if RS.Fields.Item[I].Type = dbByte then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftSmallInt, 0, R, I+1);
          inc(Offset,1);
        end
      else if RS.Fields.Item[I].Type = dbInteger then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftSmallInt, 0, R, I+1);
          inc(Offset,2);
        end
      else if RS.Fields.Item[I].Type = dbLong then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftInteger, 0, R, I+1);
          inc(Offset,4);
        end
      else if RS.Fields.Item[I].Type = dbCurrency then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftCurrency, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbSingle then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,4);
        end
      else if RS.Fields.Item[I].Type = dbDouble then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbDate then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftDateTime, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbText then
        begin
          S := RS.Fields.Item[I].Size+1;
          TFieldDef.Create(FieldDefs, N,
                           ftString, S, R, I+1);
          inc(Offset,S+1);
        end
      else if RS.Fields.Item[I].Type = dbChar then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftString, 1, R, I+1);
          inc(Offset,1);
        end
      else if RS.Fields.Item[I].Type = dbNumeric then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbDecimal then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftInteger, 0, R, I+1);
          inc(Offset,4);
        end
      else if RS.Fields.Item[I].Type = dbFloat then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbTime then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftDateTime, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbTimeStamp then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftDateTime, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbMemo then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftMemo, 0, R, I+1);
          FieldOffsets[FieldOffsets.Count-1] := Pointer(FBlobCount);
          inc(FBlobCount);
        end
    end;
  fRecordSize := Offset + SizeOf(tRecordHeader);
  if (CsDesigning in ComponentState) and IsTableClosed and not FIsOpening then
    begin
     try
      if not VarIsEmpty(RS) then
        begin
          RS.Close;
          RS := Unassigned;
        end;
     except
     end;
      Database.CloseRecordset(self);
      if IsDatabaseClosed and Database.Connected then
        Database.Close;
    end;
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalInitFieldDefs End');
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalClose
// I: close the table/file
procedure TTbJetCustomRecordset.InternalClose;
begin
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalClose');
  BindFields(False);
  if DefaultFields then DestroyFields;
 try
   if not VarIsEmpty(RS) then
     begin
       RS.Close;
       RS := Unassigned;
       FIsTableOpen := False;
       Database.CloseRecordset(Self);
     end;
 except
  BindFields(False);
  if DefaultFields then DestroyFields;
 end;
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalClose End');
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.IsCursorOpen
// I: is table open
function TTbJetCustomRecordset.IsCursorOpen: Boolean;
begin
  Result := FIsTableOpen;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.Create
constructor TTbJetCustomRecordset.Create(AOwner:tComponent);
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Create');
  inherited create(aOwner);
  FSQL := TStringList.Create;
  FieldOffsets := TList.Create;
  fRecordHeaderSize := SizeOf(tRecordHeader);
  FEof := False;
  FBof := False;
  FCacheBlobs := True;
  RS := Unassigned;
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Create End');
end;

destructor TTbJetCustomRecordset.Destroy;
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Destroy End');
//  if RS <> Unassigned then
  try
    Close;
  except
  end;
  FieldOffsets.Free;
  FSQL.Free;
  inherited Destroy;
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Destroy End');
end;

////////////////////////////////////////
////// Part II:
////// Bookmarks management and movement
////////////////////////////////////////

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalGotoBookmark
// II: set the requested bookmark as current record
procedure TTbJetCustomRecordset.InternalGotoBookmark (Bookmark: Pointer);
var
  ReqBookmark: PTbBookMark;
  Ole : OleVariant;
begin
  if RS.EditMode = 0 then
    begin
      ReqBookMark := Bookmark;
     try
      Ole := VarArrayCreate([0,3],varByte);
      Ole[0] := ReqBookMark^[0];
      Ole[1] := ReqBookMark^[1];
      Ole[2] := ReqBookMark^[2];
      Ole[3] := ReqBookMark^[3];
      RS.Bookmark := VarAsType(Ole, varOleStr);
     except
      ShowMessage('Bookmark Error');
     end;
    end;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalSetToRecord
// II: same as above (but passes a buffer)
procedure TTbJetCustomRecordset.InternalSetToRecord (Buffer: PChar);
var
  ReqBookmark: TTbBookMark;
begin
  Move(PRecInfo(Buffer + FRecordInfoOffset).InternalBookmark,ReqBookmark,4);
  InternalGotoBookmark (@ReqBookmark);
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.GetBookmarkFlag
// II: retrieve bookmarks flags from buffer
function TTbJetCustomRecordset.GetBookmarkFlag (
  Buffer: PChar): TBookmarkFlag;
begin
  Result := PRecInfo(Buffer + FRecordInfoOffset).BookmarkFlag;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.SetBookmarkFlag
// II: change the bookmark flags in the buffer
procedure TTbJetCustomRecordset.SetBookmarkFlag (Buffer: PChar;
  Value: TBookmarkFlag);
begin
  PRecInfo(Buffer + FRecordInfoOffset).BookmarkFlag := Value;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.GetBookmarkData
// II: read the bookmark data from record buffer
procedure TTbJetCustomRecordset.GetBookmarkData (
  Buffer: PChar; Data: Pointer);
begin
  PTbBookMark(Data)^ :=
    PRecInfo(Buffer + FRecordInfoOffset).InternalBookmark;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.SetBookmarkData
// II: set the bookmark data in the buffer
procedure TTbJetCustomRecordset.SetBookmarkData (
  Buffer: PChar; Data: Pointer);
begin
  PRecInfo(Buffer + FRecordInfoOffset).InternalBookmark :=
    PTbBookMark(Data)^;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalFirst
// II: Go to a special position before the first record
procedure TTbJetCustomRecordset.InternalFirst;
begin
  if not (IsAdding or IsEditing) then
    begin
      RS.MoveFirst;
      RS.MovePrevious;
      FBOF := True;
    end;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalLast
// II: Go to a special position after the last record
procedure TTbJetCustomRecordset.InternalLast;
begin
  if not (IsAdding or IsEditing) then
    begin
      RS.MoveLast;
      RS.MoveNext;
      FEOF := True;
    end;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.GetRecordCount
// II (optional): Record count
function TTbJetCustomRecordset.GetRecordCount: Longint;
begin
  CheckActive;
  Result := 85;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.GetRecNo
// II (optional): Get the number of the current record
function TTbJetCustomRecordset.GetRecNo: Longint;
begin
  UpdateCursorPos;
  Result := RS.PercentPosition;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.SetRecNo
// II (optional): Move to the given record number
procedure TTbJetCustomRecordset.SetRecNo(Value: Integer);
begin
end;

//////////////////////////////////////////
////// Part III:
////// Record buffers and field management
//////////////////////////////////////////

// ____________________________________________________________________________
// TTbJetCustomRecordset.GetRecordSize
/// III: Determine the size of each record buffer in memory
function TTbJetCustomRecordset.GetRecordSize: Word;
begin
  Result := FRecordSize; // data only
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.AllocRecordBuffer
/// III: Allocate a buffer for the record
function TTbJetCustomRecordset.AllocRecordBuffer: PChar;
begin
  Result := StrAlloc(FRecordBufferSize+1);
//  if FBlobCount > 0 then
//    Initialize(PTbBlobDataArray(Result + FBlobCacheOfs)[0]^, FBlobCount*2);
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalInitRecord
// III: Initialize the record (set to zero)
procedure TTbJetCustomRecordset.InternalInitRecord(Buffer: PChar);
//var
//  i : integer;
//  Memo : pchar;
begin
  FillChar(Buffer^, FRecordBufferSize, 32);
{  if FBlobCount>0 then
  for i := 0 to FieldDefs.Count-1 do
    begin
      if Fields[i] is TMemoField then
        begin
          Memo := StrAlloc(1);
          Memo[0] := #0;
          PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FFileDecimals[i])*2] := Memo;
          Memo := StrAlloc(1);
          Memo[0] := #0;
          PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FFileDecimals[i])*2+1] := Memo;
        end;
    end; }
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.FreeRecordBuffer
// III: Free the buffer
procedure TTbJetCustomRecordset.FreeRecordBuffer (var Buffer: PChar);
begin
//  if FBlobCount > 0 then
//    Finalize(PTbBlobDataArray(Buffer + FBlobCacheOfs)[0]^, FBlobCount*2);
  StrDispose(Buffer);
end;

// TTbJetCustomRecordset.FindRecord
// III: Find a record that matches the Filter constraints
function TTbJetCustomRecordset.FindRecord(Restart, GoForward: Boolean): Boolean;
var
  Status : Boolean;
begin
  CheckBrowseMode;
  DoBeforeScroll;
  UpdateCursorPos;
  CursorPosChanged;
  try
    begin
      if GoForward then
      begin
        if Restart then First;
        if Filtered then fActiveFilter := True;
        Status := GetNextRecord;
      end else
      begin
       if Restart then Last;
       if Filtered then fActiveFilter := True;
       Status := GetPriorRecord;
      end;
    end;
  finally
    if Filtered then fActiveFilter := False;
  end;
  Result := Status;
  if Result then DoAfterScroll;
end;

procedure TTbJetCustomRecordset.ClearCalcFields(Buffer: PChar);
begin
  FillChar(Buffer[RecordSize], CalcFieldsSize, 0);
end;

procedure TTbJetTable.ClearCalcFields(Buffer: PChar);
begin
  FillChar(Buffer[RecordSize], CalcFieldsSize, 0);
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.GetRecord
// III: Retrieve data for current, previous, or next record
// (eventually moving to it) and return the status
function TTbJetCustomRecordset.GetRecord(Buffer: PChar;
  GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
  Acceptable : Boolean;
  Ole : OleVariant;
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('InternalGetRecord');
  result := grOk;
  if RS.EOF and RS.BOF then
    Result := grEOF
  else
    repeat
      FEof := False;
      FBof := False;
      case GetMode of
        gmCurrent :
          begin
            if RS.EOF and RS.BOF then
              Result := grError;
          end;
        gmNext :
          begin
            if not RS.EOF then
              begin
                if not (IsAdding or IsEditing) then
                  RS.MoveNext;
                if RS.EOF then
                  begin
                    FEof := True;
                    Result := grEOF;
                    if not (IsAdding or IsEditing) then
                      RS.MoveLast;
                  end;
              end
            else
              begin
                if not (IsAdding or IsEditing) then
                  RS.MoveLast;
                Result := grEOF;
                FEof := True;
              end;
          end;
        gmPrior :
          begin
           if not RS.BOF then
             begin
               if not (IsAdding or IsEditing) then
                 RS.MovePrevious;
               if RS.BOF then
                 begin
                   FBof := True;
                   Result := grBOF;
                   if not (IsAdding or IsEditing) then
                     RS.MoveFirst;
                 end;
             end
           else
             begin
               if not (IsAdding or IsEditing) then
                 RS.MoveFirst;
               Result := grBOF;
               FBof := True;
             end;
          end;
      end;
      // fill record data area of buffer
      if Result = grOK then
        begin
          ConvertDaoToDelphi(Buffer);
          ClearCalcFields(Buffer);
          GetCalcFields(Buffer);
          with PRecInfo(Buffer + FRecordInfoOffset)^ do
            begin
              BookmarkFlag := bfCurrent;
              Ole := RS.Bookmark;
              InternalBookMark[0] := Ole[0];
              InternalBookMark[1] := Ole[1];
              InternalBookMark[2] := Ole[2];
              InternalBookMark[3] := Ole[3];
            end;
        end
      else
        if (Result = grError) and DoCheck then
          raise eJetError.Create('GetRecord: Invalid record');
      Acceptable := pRecordHeader(Buffer)^.DeletedFlag <> '*';
//      if Filtered or fActiveFilter then
//        Acceptable := Acceptable and (_ProcessFilter(Buffer));
      if (GetMode=gmCurrent) and Not Acceptable then
        Result := grError;
    until (Result <> grOK) or Acceptable;
//  if ((Result=grEOF)or(Result=grBOF)) and (Filtered or fActiveFilter) and not (_ProcessFilter(Buffer)) then
//    Result := grError;
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('InternalGetRecord End');
end;

procedure TTbJetCustomRecordset.InternalEdit;
begin
  if IsAdding or IsEditing then Exit;
  RS.Edit;
  IsEditing := True;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalPost
// III: Write the current data to the file
procedure TTbJetCustomRecordset.InternalPost;
begin
  CheckActive;
  if (not ReadOnly) then
    begin
      if IsEditing then
        begin
          ConvertDelphiToDao(ActiveBuffer);
          RS.Update;
          IsEditing := False;
        end
      else if IsAdding then
        begin
          ConvertDelphiToDao(ActiveBuffer);
          RS.Update;
          IsAdding := False;
//          Refresh;
        end;
    end;
end;

// ____________________________________________________________________________
procedure TTbJetCustomRecordset.InternalCancel;
begin
  CheckActive;
  if IsEditing or IsAdding then
    RS.CancelUpdate;
  IsAdding := False;
  IsEditing := False;
end;

procedure TTbJetCustomRecordset.InternalAddRecord(Buffer:Pointer; Append:Boolean);
begin
end;

procedure TTbJetCustomRecordset.DoAfterInsert;
begin
  CheckActive;
  RS.AddNew;
  IsAdding := True;
  ConvertDaoToDelphi(ActiveBuffer);
  inherited DoAfterInsert;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalDelete
// III: Delete the current record
procedure TTbJetCustomRecordset.InternalDelete;
begin
  if IsAdding or IsEditing then Exit;
  if fReadOnly then Exit;
  CheckActive;
  RS.Delete;
  if not RS.EOF then
    RS.MoveNext
  else
    RS.MovePrevious;
  Resync([]);
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.GetFieldData
// III: Move data from record buffer to field
function TTbJetCustomRecordset.GetFieldData(Field:TField; Buffer:Pointer):Boolean;
var
  Buff : PChar;
begin
  Result := False;
  if State = dsCalcFields then
    Buff := CalcBuffer
  else
    Buff := ActiveBuffer;
  if Field.FieldNo > 0 then
    begin
      if PChar(Buff)[Integer(FieldOffsets[Field.FieldNo-1])] = #255 then
        begin
          Result := False;
          Exit;
        end;
      if Assigned(Buffer) then
        Move (pBufArray(Buff)[Integer(FieldOffsets[Field.fieldNo-1])], Buffer^, Field.DataSize)
      else if Field.DataType = ftBoolean then
        Move(pBufArray(Buff)[Integer(FieldOffsets[Field.fieldNo-1])], Buffer^, 1)
      else if Field.DataType = ftDateTime then
        Move(pBufArray(Buff)[Integer(FieldOffsets[Field.fieldNo-1])], Buffer^, 8);
//      else
//        ShowMessage ('very bad error in get field data');
      Result := True;
    end
  else
    begin
      if State in [dsBrowse, dsEdit, dsInsert, dsCalcFields] then
        begin
          Inc(Buff, FRecordSize + Field.Offset);
          Result := Boolean(Buff[0]);
          if Result and (Buffer <> nil) then
            Move(Buff[1], Buffer^, Field.DataSize);
        end;
    end;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.SetFieldData
// III: Move data from field to record buffer
procedure TTbJetCustomRecordset.SetFieldData(Field: TField; Buffer: Pointer);
var
  Buff : PChar;
begin
  if not (State in dsWriteModes) then DatabaseError('Not in write mode');
  if State = dsCalcFields then
    Buff := CalcBuffer
  else
    Buff := ActiveBuffer;
  if Field.FieldNo > 0 then
    begin
      if Assigned (Buffer) and Assigned(Buff) then
        begin
          if Assigned(Buffer) then
            Move (Buffer^, pBufArray(Buff)^[Integer(FieldOffsets[Field.FieldNo-1])], Field.DataSize)
          else if Field.DataType = ftBoolean then
            Move (Buffer^, pBufArray(Buff)^[Integer(FieldOffsets[Field.FieldNo-1])], 1)
          else if Field.DataType = ftDateTime then
            Move (Buffer^, pBufArray(Buff)^[Integer(FieldOffsets[Field.FieldNo-1])], 8)
          else
            ShowMessage ('very bad error in setfield data');
          if not (State in [dsCalcFields, dsFilter, dsNewValue]) then
            DataEvent (deFieldChange, Longint(Field));
        end
      else if not Assigned(Buffer) and Assigned(Buff) then
        begin
          PChar(Buff)[Integer(FieldOffsets[Field.FieldNo-1])] := #255;
        end;
      if not (State in [dsCalcFields, dsFilter, dsNewValue]) then
        DataEvent(deFieldChange, Longint(Field));
     end
  else
    begin
      Inc(Buff, FRecordSize + Field.Offset);
      Boolean(Buff[0]) := LongBool(Buffer);
      if Boolean(Buff[0]) then Move(Buffer^, Buff[1], Field.DataSize);
    end;
end;

// ____________________________________________________________________________
// TTbJetCustomRecordset.InternalHandleException
// default exception handling
procedure TTbJetCustomRecordset.InternalHandleException;
begin
  // standard exception handling
  Application.HandleException(Self);
end;

function TTbJetCustomRecordset.IsBof : Boolean;
begin
  if IsEmpty then
    Result := True
  else
    Result := FBof;
end;

function TTbJetCustomRecordset.IsEof : Boolean;
begin
  if IsEmpty then
    Result := True
  else
    Result := FEof;
end;

procedure TTbJetCustomRecordset.First;
begin
  inherited First;
  refresh;
end;

procedure TTbJetCustomRecordset.Last;
begin
  inherited Last;
  refresh;
end;

{******************************************************************************}
{* Start of Memo Field Support                                                *}
{******************************************************************************}

function TTbJetCustomRecordset.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
begin
  Result := TTbBlobStream.Create(Field as TBlobField, Mode);
  TTbBlobStream(Result).FRecord := ActiveBuffer;
  TTbBlobStream(Result).FDataSet := self;
  TTbBlobStream(Result).FFieldNo := Integer(FieldOffsets[Field.FieldNo-1]);
end;

constructor TTbBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
begin
  FField := Field;
  FMode := Mode;
  FPosition := 0;
end;

function TTbBlobStream.Read(var Buffer; Count: LongInt): LongInt;
var
  Memo : PChar;
begin
  if FDataset is TTbJetTable then
    Memo := PTbBlobDataArray(FRecord + TTbJetTable(FDataSet).FBlobCacheOfs)[FFieldNo*2]
  else
    Memo := PTbBlobDataArray(FRecord + TTbJetRecordset(FDataSet).FBlobCacheOfs)[FFieldNo*2];
  StrLCopy(@Buffer,Memo,Count);
  FPosition := FPosition+Count;
  Result:=Count;
end;

function TTbBlobStream.Write(const Buffer; Count: LongInt): LongInt;
var
  PC:PChar;
  Memo : PChar;
begin
  if FDataset is TTbJetTable then
    Memo := PTbBlobDataArray(FRecord + TTbJetTable(FDataSet).FBlobCacheOfs)[FFieldNo*2]
  else
    Memo := PTbBlobDataArray(FRecord + TTbJetRecordset(FDataSet).FBlobCacheOfs)[FFieldNo*2];
  StrDispose(Memo);
  PC:=StrAlloc(Count+1);
  StrLCopy(PC,@Buffer,Count);
  if FDataset is TTbJetTable then
    PTbBlobDataArray(FRecord + TTbJetTable(FDataSet).FBlobCacheOfs)[FFieldNo*2]:=PC
  else
    PTbBlobDataArray(FRecord + TTbJetRecordset(FDataSet).FBlobCacheOfs)[FFieldNo*2]:=PC;
  Result:=Count;
end;

function TTbBlobStream.Seek(Offset: LongInt; Origin: Word): LongInt;
var
  Memo : PChar;
begin
  if FDataset is TTbJetTable then
    Memo := PTbBlobDataArray(FRecord + TTbJetTable(FDataSet).FBlobCacheOfs)[FFieldNo*2]
  else
    Memo := PTbBlobDataArray(FRecord + TTbJetRecordset(FDataSet).FBlobCacheOfs)[FFieldNo*2];
  case Origin of
       soFromBeginning : FPosition:=0;
       soFromEnd       : FPosition:=StrLen(Memo);
  end;
  FPosition:=FPosition+Offset;
  Result:=FPosition;
end;

{=======================================================}
{ TTbAboutBoxProperty section                           }
{=======================================================}

procedure TTbAboutBoxProperty.Edit;
var
  msg: string;
const
  carriage_return = chr(13);
begin
  if JetVersion <> '' then
    msg := 'TbJet Components v1.00  -  UNREGISTERED  -  Jet Engine v'+JetVersion
  else
    msg := 'TbJet Components v1.00  -  UNREGISTERED  -  Jet Engine Not Installed';
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'Copyright  1998-1999 by Terabyte Software.  All Rights Reserved.');
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'Developed by: Horacio Jamilis');
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'E-Mail: terabyte@iname.com');
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'Home Pages:');
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'http://members.xoom.com/t_byte/');
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'http://www.geocities.com/SiliconValley/Sector/2369/');
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'This component is shareware. Visit one of our pages for registration information.');
  AppendStr(msg, carriage_return);
  ShowMessage(msg);
end;

function TTbAboutBoxProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TTbAboutBoxProperty.GetValue: string;
begin
  Result := 'About TbJet...';
end;

procedure TTbJetDatabase.NagScreen;
const
  carriage_return = chr(13);
  A1 : array[0..12] of char = 'TApplication'#0;
  A2 : array[0..15] of char = 'TAlignPalette'#0;
  A3 : array[0..18] of char = 'TPropertyInspector'#0;
  A4 : array[0..11] of char = 'TAppBuilder'#0;
  D3 : array[0..8] of char = 'Delphi 3'#0;
  D4 : array[0..8] of char = 'Delphi 4'#0;
var
  H1, H2, H3, H4, H5 : Hwnd;
begin
  H1 := FindWindow(A1, D3);
  H2 := FindWindow(A1, D4);
  H3 := FindWindow(A2, nil);
  H4 := FindWindow(A3, nil);
  H5 := FindWindow(A4, nil);
  if ((H1 <> 0) or (H2 <> 0)) and
     (H3 <> 0) and
     (H4 <> 0) and (H5 <> 0) then Exit;
  ShowMessage('This program is using the NON REGISTERED version of'+carriage_return+carriage_return+
              'TbJet Components v1.00'+carriage_return+carriage_return+
              'Copyright  1998-1999 by Terabyte Software.'+carriage_return+carriage_return+
              'E-Mail: terabyte@iname.com'+carriage_return+carriage_return+
              'Home Page:'+carriage_return+carriage_return+
              'http://members.xoom.com/t_byte/'+carriage_return+carriage_return+
              'PLEASE REGISTER THIS COMPONENT - IT IS NOT FREEWARE!');
end;

procedure Register;
begin
  RegisterComponents('TbJet', [TTbJetDatabase]);
  RegisterPropertyEditor(TypeInfo(string), TTbJetDatabase, 'DatabaseType', TTbDatabaseTypeSelectProperty);
  RegisterPropertyEditor(TypeInfo(String), TTbJetDatabase, 'DatabaseName', TTbDatabaseNameProperty);
  RegisterPropertyEditor(TypeInfo(TTbAboutBoxProperty),TTbJetDatabase, 'ABOUT', TTbAboutBoxProperty);
  RegisterComponents('TbJet', [TTbJetQuery]);
  RegisterPropertyEditor(TypeInfo(TTbAboutBoxProperty),TTbJetQuery, 'ABOUT', TTbAboutBoxProperty);
  RegisterComponents('TbJet', [TTbJetRecordset]);
  RegisterPropertyEditor(TypeInfo(string), TTbJetRecordset, 'TableName', TTbTableSelectProperty);
  RegisterPropertyEditor(TypeInfo(TTbAboutBoxProperty),TTbJetRecordset, 'ABOUT', TTbAboutBoxProperty);
  RegisterComponents('TbJet', [TTbJetTable]);
  RegisterPropertyEditor(TypeInfo(string), TTbJetTable, 'TableName', TTbTableSelectProperty);
  RegisterPropertyEditor(TypeInfo(string), TTbJetTable, 'IndexName', TTbIndexSelectProperty);
  RegisterPropertyEditor(TypeInfo(TTbAboutBoxProperty),TTbJetTable, 'ABOUT', TTbAboutBoxProperty);
end;

constructor TTbJetDatabase.Create(AOwner : TComponent);
begin
  NagScreen;
  inherited Create(AOwner);
  try
    Engine := CreateOleObject( 'DAO.DBEngine.35' ); //Look for newest DAO first.  Doesn't work with running complex Access Query!
    if CsDesigning in ComponentState then
      JetVersion := Engine.Version;
  except
    try
      Engine := CreateOleObject( 'DAO.DBEngine' );
      if CsDesigning in ComponentState then
        JetVersion := Engine.Version;
    except
      ShowMessage( 'Unable to instantiate the DAO engine.' + chr(13) +
                   'You must have the Microsoft DAO installed on your machine.' +
                   '  This product is a part of MS Access, MS VB 4.0/5.0, etc.' );
      Application.Terminate;
    end;
  end;
  Tables := TList.Create;
  FDatabaseType := 'Jet/Access (MDB)';
end;

destructor TTbJetDatabase.Destroy;
begin
  if FConnected then
    Close;
//  if WS <> Unassigned then
  try
    WS.Close;
  except
  end;
  Tables.Free;
  inherited Destroy;
end;

procedure TTbJetDatabase.GetTables(List : TStrings);
var
  i : integer;
  S : string;
  OldCon : boolean;
begin
  List.Clear;
  OldCon := FConnected;
  if not FConnected then Open;
  if FConnected then
    begin
      for i := 0 to DB.TableDefs.Count-1 do
        begin
          S := DB.TableDefs.Item[i].Name;
          if Copy(S,1,4)<>'MSys' then
            List.Add(S);
        end;
    end;
  if FConnected and not OldCon then Close;
end;

procedure TTbJetDatabase.Open;
var
  IUserName : string;
begin
  if UserName = '' then
    IUserName := 'Admin'
  else
    IUserName := UserName;
//  if WS <> Unassigned then
  try
    WS.Close;
  except
  end;
  WS := Engine.CreateWorkspace('',IUserName,UserPassword,dbUseJet);
//  if DB <> Unassigned then
  try
    DB.Close;
  except
  end;
  if DatabaseType = 'Jet/Access (MDB)' then
    DB := WS.OpenDatabase(DatabaseName,FExclusive{Options},False{ReadOnly},''{Connect})
  else if DatabaseType = 'Excel 4.0' then
    DB := WS.OpenDatabase(DatabaseName,FExclusive{Options},False{ReadOnly},'Excel 4.0;HDR=NO;'{Connect})
  else if DatabaseType = 'Excel 5.0' then
    DB := WS.OpenDatabase(DatabaseName,FExclusive{Options},False{ReadOnly},'Excel 5.0;HDR=NO;'{Connect})
  else if DatabaseType = 'Excel 7.0' then
    DB := WS.OpenDatabase(DatabaseName,FExclusive{Options},False{ReadOnly},'Excel 5.0;HDR=NO;'{Connect})
  else
    DB := WS.OpenDatabase(DatabaseName,FExclusive{Options},False{ReadOnly},DatabaseType+';'{Connect});
  try
    FConnected := (DB.TableDefs.Count>0);
  except
    FConnected := False;
  end;
end;

procedure TTbJetDatabase.Close;
begin
  While Tables.Count > 0 do
    begin
      if TDataset(Tables[0]).Active then
        TDataset(Tables[0]).Close;
    end;
  Tables.Pack;
 try
  DB.Close;
 except
 end;
  DB := Unassigned;
 try
  FConnected := (DB.TableDefs.Count>0);
 except
  FConnected := False;
 end;
end;

function TTbJetDatabase.OpenTable(Table : TTbJetTable) : Variant;
begin
  if FConnected then
    begin
      OpenTable := DB.OpenRecordSet(Table.TableName,dbOpenTable,dbSeeChanges,dbPessimistic);
      if Tables.IndexOf(Table)=-1 then
        Tables.Add(Table);
    end
  else
    OpenTable := Unassigned;
end;

function TTbJetDatabase.OpenRecordset(Table : TTbJetCustomRecordset; RecordSetType : TRecordSetType) : Variant;
begin
  if FConnected then
    begin
      if RecordSetType = Dynaset then
        OpenRecordset := DB.OpenRecordSet(Table.TableName,dbOpenDynaset,dbSeeChanges,dbPessimistic)
      else if RecordSetType = Snapshot then
        OpenRecordset := DB.OpenRecordSet(Table.TableName,dbOpenSnapshot,dbSeeChanges,dbPessimistic)
      else
        OpenRecordset := DB.OpenRecordSet(Table.TableName,dbOpenForwardOnly,dbSeeChanges,dbPessimistic);
      if Tables.IndexOf(Table)=-1 then
        Tables.Add(Table);
    end
  else
    OpenRecordset := Unassigned;
end;

function TTbJetDatabase.OpenQuery(SQL : string; Table : TDataset; RecordSetType : TRecordSetType) :  Variant;
begin
  if FConnected then
    begin
      if RecordSetType = Dynaset then
        OpenQuery := DB.OpenRecordSet(SQL,dbOpenDynaset,dbSeeChanges,dbPessimistic)
      else if RecordSetType = Snapshot then
        OpenQuery := DB.OpenRecordSet(SQL,dbOpenSnapshot,dbSeeChanges,dbPessimistic)
      else
        OpenQuery := DB.OpenRecordSet(SQL,dbOpenForwardOnly,dbSeeChanges,dbPessimistic);
      if Tables.IndexOf(Table)=-1 then
        Tables.Add(Table);
    end
  else
    OpenQuery := Unassigned;
end;

procedure TTbJetDatabase.SetConnected(State : boolean);
begin
  if State then Open
  else Close;
end;

procedure TTbJetDatabase.SetDatabaseName(Name : string);
begin
  FDatabaseName := Name;
end;

procedure TTbJetDatabase.SetUserName(UserName : string);
begin
  FUserName := UserName;
end;

procedure TTbJetDatabase.SetUserPassword(UserPassword : string);
begin
  FUserPassword := UserPassword;
end;

{=======================================================}
{ TTbDatabaseNameProperty section                       }
{=======================================================}

procedure TTbDatabaseNameProperty.Edit;
var
  FileOpen: TOpenDialog;
begin
  FileOpen := TOpenDialog.Create(Nil);
  FileOpen.Filename := GetValue;
  FileOpen.Filter := 'Jet/Access Files (*.MDB)|*.MDB|All Files (*.*)|*.*';
  FileOpen.Options := FileOpen.Options + [ofCreatePrompt,ofHideReadOnly];
  FileOpen.DefaultExt := 'MDB';
  try
    if FileOpen.Execute then SetValue(FileOpen.Filename);
  finally
    FileOpen.Free;
  end;
end;

function TTbDatabaseNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paRevertable];
end;

{=======================================================}
{ TTbLanguageSelectProperty section                     }
{=======================================================}

function TTbTableSelectProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paMultiSelect];
end;

procedure TTbTableSelectProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure TTbTableSelectProperty.GetValueList(List: TStrings);
var
  TbJetDataset : TDataset;
begin
  TbJetDataset := GetComponent(0) as TDataset;
  if TbJetDataset is TTbJetTable then
    TTbJetTable(TbJetDataset).Database.GetTables(List)
  else
    TTbJetCustomRecordset(TbJetDataset).Database.GetTables(List);
end;

{***********************}
{* TTbJetTable Section *}
{***********************}

procedure TTbJetTable.SetSort(Sort : string);
begin
  FSort := Sort;
  if Active then
    begin
      RS.Index := Sort;
      Refresh;
    end;
end;

Procedure TTbJetTable.ConvertDaoToDelphi(Buffer : PChar);
var
  i,n : integer;
  S : string;
  D : double;
  INT : Integer;
  SINT : smallint;
  B : boolean;
  W : word;
  DT : TDateTimeRec;
  TS : TTimeStamp;
  Memo : PChar;
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('ConvertDaoToDelphi');
  for i := 0 to Fieldcount-1 do
    begin
      if Fields[i].FieldNo < 0 then Continue;
      Case Fields[i].DataType of
        ftString :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                S := RS.Fields.Item[n].Value;
                StrPCopy(@PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],PChar(S));
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                S := '';
                StrPCopy(@PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],PChar(S));
              end;
          end;
        ftCurrency, ftFloat :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    D := RS.Fields.Item[n].Value;
                    Move(D,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],8);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftInteger :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    INT := RS.Fields.Item[n].Value;
                    Move(INT,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],4);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftSmallInt :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    SINT := RS.Fields.Item[n].Value;
                    Move(SINT,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],2);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
              end;
          end;
        ftWord :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    W := RS.Fields.Item[n].Value;
                    Move(W,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],2);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftBoolean :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    B := RS.Fields.Item[n].Value;
                    Move(B,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],2);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
              end;
          end;
        ftDateTime :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if RS.Fields.Item[n].Value = NULL then
                  PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255
                else
                  begin
                    TS := DateTimeToTimeStamp(RS.Fields.Item[n].Value);
                    DT.DateTime := TimeStampToMSecs(TS);
                    Move(DT,PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],8);
                  end;
               except
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
               end;
              end
            else
              begin
                PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] := #255;
              end;
          end;
        ftMemo :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
                S := RS.Fields[n].Value;
                Memo:=StrAlloc(Length(S)+1);
                StrCopy(Memo,PChar(S));
                PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2] := Memo;
                StrCopy(Memo,PChar(S));
                Memo:=StrAlloc(Length(S)+1);
                StrCopy(Memo,PChar(S));
                PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2+1] := Memo;
              end
          end;
      end;
    end;
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('ConvertDaoToDelphi End');
end;

Procedure TTbJetTable.ConvertDelphiToDao(Buffer : PChar);
var
  i,j,n : integer;
  S : string;
  D : double;
  INT : Integer;
  SINT : smallint;
  B : boolean;
  W : word;
  DT : TDateTimeRec;
  TS : TTimeStamp;
  E : integer;
  Memo, MemoOriginal : PChar;
begin
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('ConvertDelphiToDao');
  E := RS.EditMode;
  if E = 0 then Raise EJetError.Create('The Jet table is not in edit or insert mode.');
  for i := 0 to Fieldcount-1 do
    begin
      Case Fields[i].DataType of
        ftString :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                S := '';
                j := 0;
                While (j<Fields[i].Size)and(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])+j] <> #0) do
                  begin
                    S := S + PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])+j];
                    inc(j);
                  end;
                RS.Fields.Item[n].Value := S;
               except
               end;
              end
          end;
        ftCurrency, ftFloat :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],D,8);
                    RS.Fields.Item[n].Value := D;
                  end;
               except
               end;
              end
          end;
        ftInteger :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if (RS.Fields.Item[n].Name = Fields[i].FieldName) and (RS.Fields.Item[n].Attributes and dbAutoIncrField <> dbAutoIncrField) then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],INT,4);
                    RS.Fields.Item[n].Value := INT;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftSmallInt :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],SINT,2);
                    RS.Fields.Item[n].Value := SINT;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftWord :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],W,2);
                    RS.Fields.Item[n].Value := W;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftBoolean :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],B,2);
                    RS.Fields.Item[n].Value := B;
                  end;
               except
                 RS.Fields.Item[n].Value := NULL
               end;
              end
          end;
        ftDateTime :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
               try
                if PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])] = #255 then
                  RS.Fields.Item[n].Value := NULL
                else
                  begin
                    Move(PChar(Buffer)[Integer(FieldOffsets[Fields[i].FieldNo-1])],DT,8);
                    TS := MSecsToTimeStamp(DT.DateTime);
                    RS.Fields.Item[n].Value := TimeStampToDateTime(TS);
                  end;
               except
                 RS.Fields.Item[n].Value := NULL;
               end;
              end
          end;
        ftMemo :
          begin
            n := 0;
            while (n < RS.Fields.Count-1) and (Fields[i].FieldName<>RS.Fields.Item[n].Name) do
              inc(n);
            if RS.Fields.Item[n].Name = Fields[i].FieldName then
              begin
                Memo := PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2];
                MemoOriginal := PTbBlobDataArray(Buffer + FBlobCacheOfs)[Integer(FieldOffsets[Fields[i].FieldNo-1])*2+1];
                if StrComp(Memo,MemoOriginal)<>0 then
                  begin
                    RS.Fields[n].Value := String(Memo);
                  end;
              end;
          end;
      end;
    end;
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('ConvertDelphiToDao End');
end;

/////////////////////////////////////////////////
////// Part I:
////// Initialization, opening, and closing
/////////////////////////////////////////////////

// ____________________________________________________________________________
// TTbJetTable.InternalOpen
// I: open the table/file
procedure TTbJetTable.InternalOpen;
begin
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalOpen');
  try
    if not VarIsEmpty(RS) then
      begin
        RS.Close;
        RS := Unassigned;
        FIsTableOpen := False;
        Database.CloseRecordset(self);
      end;
  except
  end;
  if not Database.Connected then Database.Open;
  RS := Database.OpenTable(self);
  if not RS.BOF and not RS.EOF then
    begin
      RS.Index := FSort;
      RS.MoveFirst;
      RS.MovePrevious;
      FEOF := RS.EOF;
      FBOF := RS.BOF;
    end;
  // sets record position
//  FCurrentRecord := -1;
  // set the bookmark size
  BookmarkSize := SizeOf(TTbBookMark);
  // initialize the field definitions
  // (another virtual abstract method of TDataSet)
  FIsOpening := True;
  InternalInitFieldDefs;
  FIsOpening := False;
  // if there are no persistent field objects,
  // create the fields dynamically
  if DefaultFields then
    CreateFields;
  // connect the TField objects with the actual fields
  BindFields (True);
  FBlobCacheOfs := FRecordSize + CalcFieldsSize;
  FRecordInfoOffset := FBlobCacheOfs + FBlobCount * SizeOf(Pointer) * 2;
  FRecordBufferSize := FRecordInfoOffset + SizeOf(TRecInfo);
  // get the number of records and check size
//  fRecordCount := RS.RecordCount;
  // everything OK: table is now open
  try
    FIsTableOpen := True;
  except
    FIsTableOpen := False;
  end;
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalOpenEnd');
end;

// ____________________________________________________________________________
// TTbJetTable.InternalInitFieldDefs
// I: define the fields
procedure TTbJetTable.InternalInitFieldDefs;
var
  I : Integer;
  Offset : integer;
  N : string;
  R : boolean;
  S : integer;
  IsTableClosed, IsDatabaseClosed : boolean;
begin
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalInitFieldDefs');
  FieldDefs.Clear;
  IsTableClosed := False;
  IsDatabaseClosed := False;
  if (CsDesigning in ComponentState) and not Active then
    begin
      IsTableClosed := True;
      if not Database.Connected then
        begin
          IsTableClosed := True;
          Database.Open;
        end;
      RS := Database.OpenTable(self);
    end;
  Offset := SizeOf(tRecordHeader);
  FBlobCount   := 0;
  FRecordSize := 0;
  FieldOffsets.Clear;
  for I:=0 to RS.Fields.Count -1 do
    begin
      FieldOffsets.Add(Pointer(Offset));
      N := RS.Fields.Item[I].Name;
      R := RS.Fields.Item[I].Required;
      if RS.Fields.Item[I].Type = dbBoolean then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftBoolean, 0, R, I+1);
          inc(Offset,2);
        end
      else if RS.Fields.Item[I].Type = dbByte then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftSmallInt, 0, R, I+1);
          inc(Offset,1);
        end
      else if RS.Fields.Item[I].Type = dbInteger then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftSmallInt, 0, R, I+1);
          inc(Offset,2);
        end
      else if RS.Fields.Item[I].Type = dbLong then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftInteger, 0, R, I+1);
          inc(Offset,4);
        end
      else if RS.Fields.Item[I].Type = dbCurrency then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftCurrency, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbSingle then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,4);
        end
      else if RS.Fields.Item[I].Type = dbDouble then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbDate then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftDateTime, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbText then
        begin
          S := RS.Fields.Item[I].Size + 1;
          TFieldDef.Create(FieldDefs, N,
                           ftString, S, R, I+1);
          inc(Offset,S+1);
        end
      else if RS.Fields.Item[I].Type = dbChar then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftString, 1, R, I+1);
          inc(Offset,1);
        end
      else if RS.Fields.Item[I].Type = dbNumeric then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbDecimal then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftInteger, 0, R, I+1);
          inc(Offset,4);
        end
      else if RS.Fields.Item[I].Type = dbFloat then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftFloat, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbTime then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftDateTime, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbTimeStamp then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftDateTime, 0, R, I+1);
          inc(Offset,8);
        end
      else if RS.Fields.Item[I].Type = dbMemo then
        begin
          TFieldDef.Create(FieldDefs, N,
                           ftMemo, 0, R, I+1);
          FieldOffsets[FieldOffsets.Count-1] := Pointer(FBlobCount);
          inc(FBlobCount);
        end
    end;
  fRecordSize := Offset + SizeOf(tRecordHeader);
  if (CsDesigning in ComponentState) and IsTableClosed and not FIsOpening then
    begin
     try
      if not VarIsEmpty(RS) then
        begin
          RS.Close;
          RS := Unassigned;
        end;
     except
     end;
      Database.CloseRecordset(self);
      if IsDatabaseClosed and Database.Connected then
        Database.Close;
    end;
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalInitFieldDefs End');
end;

// ____________________________________________________________________________
// TTbJetTable.InternalClose
// I: close the table/file
procedure TTbJetTable.InternalClose;
begin
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalClose');
  try
    if not VarIsEmpty(RS) then
      begin
        RS.Close;
        RS := Unassigned;
        FIsTableOpen := False;
        Database.CloseRecordset(Self);
      end;
  except
  end;
  BindFields(False);
  if DefaultFields then DestroyFields;
  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
    ShowMessage('InternalClose End');
end;

// ____________________________________________________________________________
// TTbJetTable.IsCursorOpen
// I: is table open
function TTbJetTable.IsCursorOpen: Boolean;
begin
  Result := FIsTableOpen;
end;

// ____________________________________________________________________________
// TTbJetTable.Create
constructor TTbJetTable.Create(AOwner:tComponent);
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Create');
  inherited create(aOwner);
  FieldOffsets := TList.Create;
  fRecordHeaderSize := SizeOf(tRecordHeader);
  FEof := False;
  FBof := False;
  FCacheBlobs := True;
  RS := Unassigned;
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Create End');
end;

destructor TTbJetTable.Destroy;
begin
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Destroy');
//  if RS <> Unassigned then
  try
    Close;
  except
  end;
  FieldOffsets.Free;
  inherited Destroy;
//  if ((CsDesigning in ComponentState) or (TotalTest)) and Debuging then
//    ShowMessage('Destroy End');
end;

////////////////////////////////////////
////// Part II:
////// Bookmarks management and movement
////////////////////////////////////////

// ____________________________________________________________________________
// TTbJetTable.InternalGotoBookmark
// II: set the requested bookmark as current record
procedure TTbJetTable.InternalGotoBookmark (Bookmark: Pointer);
var
  ReqBookmark: PTbBookMark;
  Ole : OleVariant;
begin
  if RS.EditMode = 0 then
    begin
      ReqBookMark := Bookmark;
     try
      Ole := VarArrayCreate([0,3],varByte);
      Ole[0] := ReqBookMark^[0];
      Ole[1] := ReqBookMark^[1];
      Ole[2] := ReqBookMark^[2];
      Ole[3] := ReqBookMark^[3];
      RS.Bookmark := VarAsType(Ole, varOleStr);
     except
      ShowMessage('Bookmark Error');
     end;
    end;
end;

// ____________________________________________________________________________
// TTbJetTable.InternalSetToRecord
// II: same as above (but passes a buffer)
procedure TTbJetTable.InternalSetToRecord (Buffer: PChar);
var
  ReqBookmark: TTbBookMark;
begin
  Move(PRecInfo(Buffer + FRecordInfoOffset).InternalBookmark,ReqBookmark,4);
  InternalGotoBookmark (@ReqBookmark);
end;

// ____________________________________________________________________________
// TTbJetTable.GetBookmarkFlag
// II: retrieve bookmarks flags from buffer
function TTbJetTable.GetBookmarkFlag (
  Buffer: PChar): TBookmarkFlag;
begin
  Result := PRecInfo(Buffer + FRecordInfoOffset).BookmarkFlag;
end;

// ____________________________________________________________________________
// TTbJetTable.SetBookmarkFlag
// II: change the bookmark flags in the buffer
procedure TTbJetTable.SetBookmarkFlag (Buffer: PChar;
  Value: TBookmarkFlag);
begin
  PRecInfo(Buffer + FRecordInfoOffset).BookmarkFlag := Value;
end;

// ____________________________________________________________________________
// TTbJetTable.GetBookmarkData
// II: read the bookmark data from record buffer
procedure TTbJetTable.GetBookmarkData (
  Buffer: PChar; Data: Pointer);
begin
  PTbBookMark(Data)^ :=
    PRecInfo(Buffer + FRecordInfoOffset).InternalBookmark;
end;

// ____________________________________________________________________________
// TTbJetTable.SetBookmarkData
// II: set the bookmark data in the buffer
procedure TTbJetTable.SetBookmarkData (
  Buffer: PChar; Data: Pointer);
begin
  PRecInfo(Buffer + FRecordInfoOffset).InternalBookmark :=
    PTbBookMark(Data)^;
end;

// ____________________________________________________________________________
// TTbJetTable.InternalFirst
// II: Go to a special position before the first record
procedure TTbJetTable.InternalFirst;
begin
  if not (IsAdding or IsEditing) then
    begin
      RS.MoveFirst;
      RS.MovePrevious;
      FBOF := True;
    end;
end;

// ____________________________________________________________________________
// TTbJetTable.InternalLast
// II: Go to a special position after the last record
procedure TTbJetTable.InternalLast;
begin
  if not (IsAdding or IsEditing) then
    begin
      RS.MoveLast;
      RS.MoveNext;
      FEOF := True;
    end;
end;

//////////////////////////////////////////
////// Part III:
////// Record buffers and field management
//////////////////////////////////////////

// ____________________________________________________________________________
// TTbJetTable.GetRecordSize
/// III: Determine the size of each record buffer in memory
function TTbJetTable.GetRecordSize: Word;
begin
  Result := FRecordSize; // data only
end;

// ____________________________________________________________________________
// TTbJetTable.AllocRecordBuffer
/// III: Allocate a buffer for the record
function TTbJetTable.AllocRecordBuffer: PChar;
begin
  Result := StrAlloc(FRecordBufferSize+1);
//  if FBlobCount > 0 then
//    Initialize(PTbBlobDataArray(Result + FBlobCacheOfs)[0]^, FBlobCount*2);
end;

// ____________________________________________________________________________
// TTbJetTable.InternalInitRecord
// III: Initialize the record (set to zero)
procedure TTbJetTable.InternalInitRecord(Buffer: PChar);
var
  i : integer;
  Memo : pchar;
begin
  FillChar(Buffer^, FRecordBufferSize, 32);
  if FBlobCount>0 then
  for i := 0 to FieldDefs.Count-1 do
    begin
      if (Fields[i] is TMemoField) and (Fields[i].FieldNo > 0) then
        begin
          Memo := StrAlloc(1);
          Memo[0] := #0;
          PTbBlobDataArray(Buffer {+ FBlobCacheOfs})[Integer(FieldOffsets[Fields[i].FieldNo-1])] := Memo;
          Memo := StrAlloc(1);
          Memo[0] := #0;
          PTbBlobDataArray(Buffer {+ FBlobCacheOfs})[Integer(FieldOffsets[Fields[i].FieldNo-1])+4] := Memo;
        end;
    end;
end;

// ____________________________________________________________________________
// TTbJetTable.FreeRecordBuffer
// III: Free the buffer
procedure TTbJetTable.FreeRecordBuffer (var Buffer: PChar);
begin
//  if FBlobCount > 0 then
//    Finalize(PTbBlobDataArray(Buffer + FBlobCacheOfs)[0]^, FBlobCount*2);
  StrDispose(Buffer);
end;

// ____________________________________________________________________________
// TTbJetTable.GetRecord
// III: Retrieve data for current, previous, or next record
// (eventually moving to it) and return the status
function TTbJetTable.GetRecord(Buffer: PChar;
  GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
  Acceptable : Boolean;
  Ole : OleVariant;
begin
  result := grOk;
  if RS.EOF and RS.BOF then
    Result := grEOF
  else
    repeat
      FEof := False;
      FBof := False;
      case GetMode of
        gmCurrent :
          begin
//            RS.Move(0,PRecInfo(Buffer + FRecordInfoOffset).InternalBookmark);
            if RS.EOF and RS.BOF then
              Result := grError;
          end;
        gmNext :
          begin
            if not RS.EOF then
              begin
                if not (IsAdding or IsEditing) then
                  RS.MoveNext;
                if RS.EOF then
                  begin
                    FEof := True;
                    Result := grEOF;
                    if not (IsAdding or IsEditing) then
                      RS.MoveLast;
                  end;
              end
            else
              begin
                if not (IsAdding or IsEditing) then
                  RS.MoveLast;
                Result := grEOF;
                FEof := True;
              end;
          end;
        gmPrior :
          begin
           if not RS.BOF then
             begin
               if not (IsAdding or IsEditing) then
                 RS.MovePrevious;
               if RS.BOF then
                 begin
                   FBof := True;
                   Result := grBOF;
                   if not (IsAdding or IsEditing) then
                     RS.MoveFirst;
                 end;
             end
           else
             begin
               if not (IsAdding or IsEditing) then
                 RS.MoveFirst;
               Result := grBOF;
               FBof := True;
             end;
          end;
      end;
      // fill record data area of buffer
      if Result = grOK then
        begin
          ConvertDaoToDelphi(Buffer);
          ClearCalcFields(Buffer);
          GetCalcFields(Buffer);
          with PRecInfo(Buffer + FRecordInfoOffset)^ do
            begin
              BookmarkFlag := bfCurrent;
              Ole := RS.Bookmark;
              InternalBookMark[0] := Ole[0];
              InternalBookMark[1] := Ole[1];
              InternalBookMark[2] := Ole[2];
              InternalBookMark[3] := Ole[3];
            end;
        end
      else
        if (Result = grError) and DoCheck then
          raise eJetError.Create('GetRecord: Invalid record');
      Acceptable := pRecordHeader(Buffer)^.DeletedFlag <> '*';
      if Filtered or fActiveFilter then
        Acceptable := Acceptable and (_ProcessFilter(Buffer));
      if (GetMode=gmCurrent) and Not Acceptable then
        Result := grError;
    until (Result <> grOK) or Acceptable;
  if ((Result=grEOF)or(Result=grBOF)) and (Filtered or fActiveFilter) and not (_ProcessFilter(Buffer)) then
    Result := grError;
end;

procedure TTbJetTable.InternalEdit;
begin
  if IsAdding or IsEditing then Exit;
  RS.Edit;
  IsEditing := True;
end;

// ____________________________________________________________________________
// TTbJetTable.InternalPost
// III: Write the current data to the file
procedure TTbJetTable.InternalPost;
begin
  CheckActive;
  if (not ReadOnly) then
    begin
      if IsEditing {(State = dsEdit) and (not IsAdding) RS.EditMode = dbEditInProgress} then
        begin
          ConvertDelphiToDao(ActiveBuffer);
          RS.Update;
          IsEditing := False;
        end
      else if IsAdding{(State = dsInsert) or (IsAdding) RS.EditMode = dbEditAdd} then
        begin
          ConvertDelphiToDao(ActiveBuffer);
          RS.Update;
          IsAdding := False;
//          Refresh;
        end;
    end;
end;

// ____________________________________________________________________________
procedure TTbJetTable.InternalCancel;
begin
  CheckActive;
  if (RS.EditMode <> dbEditNone) then
    RS.CancelUpdate
  else
    Exit;
  IsAdding := False;
  IsEditing := False;
//  Refresh;
end;

procedure TTbJetTable.InternalAddRecord(Buffer:Pointer; Append:Boolean);
begin
end;

procedure TTbJetTable.DoAfterInsert;
begin
  RS.AddNew;
  IsAdding := True;
  ConvertDaoToDelphi(ActiveBuffer);
  inherited DoAfterInsert;
end;

// ____________________________________________________________________________
// TTbJetTable.InternalDelete
// III: Delete the current record
procedure TTbJetTable.InternalDelete;
//var
//Ole : OleVariant;
begin
  if IsAdding or IsEditing then Exit;
  if fReadOnly then Exit;
  CheckActive;
  RS.Delete;
  if not RS.EOF then
    RS.MoveNext
  else
    RS.MovePrevious;
  Resync([]);
end;

// ____________________________________________________________________________
// TTbJetTable.GetFieldData
// III: Move data from record buffer to field
function TTbJetTable.GetFieldData(Field:TField; Buffer:Pointer):Boolean;
var
  Buff : PChar;
begin
  Result := False;
  if Filtering then
    Buff := FilterBuffer
  else
    begin
      if State = dsCalcFields then
        Buff := CalcBuffer
      else
        Buff := ActiveBuffer;
      if RS.EOF and RS.BOF then
        begin
          Exit;
        end;
    end;
  if Field.FieldNo > 0 then
    begin
      if RS.EOF and RS.BOF then
        begin
          Result := False;
          Exit;
        end;
      if PChar(Buff)[Integer(FieldOffsets[Field.FieldNo-1])] = #255 then
        begin
          Result := False;
          Exit;
        end;
      if Assigned(Buffer) then
        Move (pBufArray(Buff)[Integer(FieldOffsets[Field.fieldNo-1])], Buffer^, Field.DataSize)
      else if Field.DataType = ftBoolean then
        Move(pBufArray(Buff)[Integer(FieldOffsets[Field.fieldNo-1])], Buffer^, 1)
      else if Field.DataType = ftDateTime then
        Move(pBufArray(Buff)[Integer(FieldOffsets[Field.fieldNo-1])], Buffer^, 8);
//      else
//        ShowMessage ('very bad error in get field data');
      Result := True;
    end
  else
    begin
      if State in [dsBrowse, dsEdit, dsInsert, dsCalcFields] then
        begin
          Inc(Buff, FRecordSize + Field.Offset);
          Result := Boolean(Buff[0]);
          if Result and (Buffer <> nil) then
            Move(Buff[1], Buffer^, Field.DataSize);
        end;
    end;
end;

// ____________________________________________________________________________
// TTbJetTable.SetFieldData
// III: Move data from field to record buffer
procedure TTbJetTable.SetFieldData(Field: TField; Buffer: Pointer);
var
  Buff : PChar;
begin
  if not (State in dsWriteModes) then DatabaseError('Not in write mode');
  if State = dsCalcFields then
    Buff := CalcBuffer
  else
    Buff := ActiveBuffer;
  if Field.FieldNo > 0 then
    begin
      if State = dsCalcFields then DatabaseError('Not in write mode');
      if Assigned(Buffer) and Assigned(Buff) then
        begin
          if Assigned (Buffer) then
            Move (Buffer^, pBufArray(Buff)^[Integer(FieldOffsets[Field.FieldNo-1])], Field.DataSize)
          else if Field.DataType = ftBoolean then
            Move (Buffer^, pBufArray(Buff)^[Integer(FieldOffsets[Field.FieldNo-1])], 1)
          else if Field.DataType = ftDateTime then
            Move (Buffer^, pBufArray(Buff)^[Integer(FieldOffsets[Field.FieldNo-1])], 8)
          else
            ShowMessage ('very bad error in setfield data');
          if not (State in [dsCalcFields, dsFilter, dsNewValue]) then
            DataEvent (deFieldChange, Longint(Field));
        end
      else if not Assigned(Buffer) and Assigned(Buff) then
        begin
          PChar(Buff)[Integer(FieldOffsets[Field.FieldNo-1])] := #255;
        end;
      if not (State in [dsCalcFields, dsFilter, dsNewValue]) then
        DataEvent(deFieldChange, Longint(Field));
    end
  else
    begin
      Inc(Buff, FRecordSize + Field.Offset);
      Boolean(Buff[0]) := LongBool(Buffer);
      if Boolean(Buff[0]) then Move(Buffer^, Buff[1], Field.DataSize);
    end;
end;

// ____________________________________________________________________________
// TTbJetTable.InternalHandleException
// default exception handling
procedure TTbJetTable.InternalHandleException;
begin
  // standard exception handling
  Application.HandleException(Self);
end;

function TTbJetTable.IsBof : Boolean;
begin
  if IsEmpty then
    Result := True
  else
    Result := FBof;
end;

function TTbJetTable.IsEof : Boolean;
begin
  if IsEmpty then
    Result := True
  else
    Result := FEof;
end;

{******************************************************************************}
{* Start of Memo Field Support                                                *}
{******************************************************************************}

function TTbJetTable.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
begin
  Result := TTbBlobStream.Create(Field as TBlobField, Mode);
  TTbBlobStream(Result).FRecord := ActiveBuffer;
  TTbBlobStream(Result).FDataSet := self;
  TTbBlobStream(Result).FFieldNo := Integer(FieldOffsets[Field.FieldNo-1]);
end;

function TTbJetTable.FindKey(
  const FieldValues: array of variant): boolean;
var
  Params : integer;
  Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,
  Par9,Par10,Par11,Par12,Par13 : variant;
  Ole : Variant;
begin
  CheckBrowseMode;
  Params := High(FieldValues);
  Case Params of
    0 : begin
          Result := False;
          Exit;
        end;
    1 : begin
          Par1 := FieldValues[0];
          RS.Seek('=',Par1);
        end;
    2 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          RS.Seek('=',Par1,Par2);
        end;
    3 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          RS.Seek('=',Par1,Par2,Par3);
        end;
    4 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          RS.Seek('=',Par1,Par2,Par3,Par4);
        end;
    5 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5);
        end;
    6 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6);
        end;
    7 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6,Par7);
        end;
    8 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8);
        end;
    9 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9);
        end;
   10 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10);
        end;
   11 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          Par11 := FieldValues[10];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10,Par11);
        end;
   12 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          Par11 := FieldValues[10];
          Par12 := FieldValues[11];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10,Par11,Par12);
        end;
  else
    begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          Par11 := FieldValues[10];
          Par12 := FieldValues[11];
          Par13 := FieldValues[12];
          RS.Seek('=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10,Par11,Par12,Par13);
    end;
  end;
  Result := not RS.NoMatch;
  if not Result then
    begin
      Ole := VarArrayCreate([0,3],varByte);
      Ole[0] := PRecInfo(ActiveBuffer + FRecordInfoOffset).InternalBookMark[0];
      Ole[1] := PRecInfo(ActiveBuffer + FRecordInfoOffset).InternalBookMark[1];
      Ole[2] := PRecInfo(ActiveBuffer + FRecordInfoOffset).InternalBookMark[2];
      Ole[3] := PRecInfo(ActiveBuffer + FRecordInfoOffset).InternalBookMark[3];
      RS.BookMark := VarAsType(Ole, varOleStr);
    end;
//  Resync([rmCenter]);
end;

procedure TTbJetTable.FindNearest(const FieldValues: array of shortstring);
var
  Params : integer;
  Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,
  Par9,Par10,Par11,Par12,Par13 : variant;
begin
  CheckBrowseMode;
  Params := High(FieldValues);
  Case Params of
    0 : begin
          Exit;
        end;
    1 : begin
          Par1 := FieldValues[0];
          RS.Seek('>=',Par1);
        end;
    2 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          RS.Seek('>=',Par1,Par2);
        end;
    3 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          RS.Seek('>=',Par1,Par2,Par3);
        end;
    4 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          RS.Seek('>=',Par1,Par2,Par3,Par4);
        end;
    5 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5);
        end;
    6 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6);
        end;
    7 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6,Par7);
        end;
    8 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8);
        end;
    9 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9);
        end;
   10 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10);
        end;
   11 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          Par11 := FieldValues[10];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10,Par11);
        end;
   12 : begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          Par11 := FieldValues[10];
          Par12 := FieldValues[11];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10,Par11,Par12);
        end;
  else
    begin
          Par1 := FieldValues[0];
          Par2 := FieldValues[1];
          Par3 := FieldValues[2];
          Par4 := FieldValues[3];
          Par5 := FieldValues[4];
          Par6 := FieldValues[5];
          Par7 := FieldValues[6];
          Par8 := FieldValues[7];
          Par9 := FieldValues[8];
          Par10 := FieldValues[9];
          Par11 := FieldValues[10];
          Par12 := FieldValues[11];
          Par13 := FieldValues[12];
          RS.Seek('>=',Par1,Par2,Par3,Par4,Par5,Par6,Par7,Par8,Par9,Par10,Par11,Par12,Par13);
    end;
  end;
  Resync([rmCenter]);
end;

function TTbJetTable.Locate(const KeyFields: string;
  const KeyValues: Variant; Options: TLocateOptions): Boolean;
begin
  DoBeforeScroll;
  Result := LocateRecord(KeyFields, KeyValues, Options, True);
  if Result then
  begin
//    Resync([rmExact, rmCenter]);
    DoAfterScroll;
  end;
end;

function TTbJetTable.GetRecordCount: Integer;
begin
  GetRecordCount := 85;
end;

procedure TTbJetTable.SetRecNo(Value: Integer);
begin
end;

function TTbJetTable.GetRecNo: Integer;
begin
  GetRecNo := RS.PercentPosition;
end;

function TTbJetTable.Lookup(const KeyFields: string;
  const KeyValues: Variant; const ResultFields: string): Variant;
begin
  Result := Unassigned;
  if LocateRecord(KeyFields, KeyValues, [], False) then
  begin
    SetTempState(dsCalcFields);
    try
      CalculateFields(TempBuffer);
      Result := FieldValues[ResultFields];
    finally
      RestoreState(dsBrowse);
    end;
  end;
end;

function TTbJetTable.LocateRecord(const KeyFields: string;
  const KeyValues: Variant; Options: TLocateOptions;
  SyncCursor: Boolean): Boolean;
(*
var
  Field: TList;
  Indexes : TStringList;
  DtsFields : TStringList;
  IndexDesc : TList;
  WasFound : boolean;
  i,j : integer;
  Fls : string;
  BestIndex : integer;
  OldIndex : string;
  OldPos : variant;
  BestIndexNum : integer;
  Values : array of shortstring;
//  OldFilterBuffer : PChar;
//  OldFiltering : boolean;
//  Buf : PChar; *)
begin
(*
//  DisableControls;
  CheckBrowseMode;
  CursorPosChanged;
  Field := TList.Create;
  DtsFields := TStringList.Create;
  Indexes := TStringList.Create;
  IndexDesc := TList.Create;
  WasFound := False;
  Fls := KeyFields;
{  SetTempState(dsFilter); }
  try
    GetFields(DtsFields);
    GetIndexes(Indexes);
    // We must find the fields involved
    While Pos(';',Fls)>0 do
      begin
        if DtsFields.IndexOf(Copy(Fls,1,Pos(';',Fls)-1)) <> -1 then
          Field.Add(FieldByName(Copy(Fls,1,Pos(';',Fls)-1)))
        else
          Field.Add(nil);
        Fls := Copy(Fls,Pos(';',Fls)+1,Length(Fls)-Pos(';',Fls));
      end;
    if DtsFields.IndexOf(Fls) <> -1 then
      Field.Add(FieldByName(Fls))
    else
      Field.Add(nil);
    // I have the list of fields in Field
    // We must find the best index is one exists.
    GetIndexDescs(IndexDesc);
    BestIndex := -1;
    if IndexDesc.Count > 0 then
      begin
        BestIndexNum := -1;
        for i := 0 to IndexDesc.Count-1 do
          begin
            j := 0;
            While (j<Field.Count)and(Field[j]<>nil)and(j<TStringList(IndexDesc[i]).Count)and(TStringList(IndexDesc[i])[j] = TField(Field[j]).FieldName) do
              inc(j);
            if (j > 0) and ((j > BestIndex)or((j=BestIndex)and(TStringList(IndexDesc[i]).Count<TStringList(IndexDesc[BestIndexNum]).Count))) then
              begin
                BestIndex := j;
                BestIndexNum := i;
              end;
          end;
        if BestIndex > -1 then
          begin // We Found one applicable index
            SetLength(Values,TStringList(IndexDesc[BestIndexNum]).Count);
            if VarType(KeyValues) = VarString then
              Values[0] := KeyValues
            else
              for i := 0 to TStringList(IndexDesc[BestIndexNum]).Count - 1 do
                begin
                  Values[i] := KeyValues[i];
                end;
            OldIndex := IndexName;
            OldPos := RS.BookMark;
            IndexName := Indexes[BestIndexNum];
            CursorPosChanged;
            FindNearest(Values);
            WasFound := True;
            ConvertDaoToDelphi(ActiveBuffer);
            Refresh;
{            OldFilterBuffer := FilterBuffer;
            OldFiltering := Filtering;
            FilterBuffer := AllocRecordBuffer;
            ConvertDaoToDelphi(FilterBuffer);
            Filtering := True; }
            i := 0;
            While (i < Field.Count) and WasFound do
              begin
                if (VarType(KeyValues)=VarString)and(Field[i]<>nil)and(TField(Field[i]).Text<>KeyValues) then
                  begin
                    WasFound := False;
                  end
                else if (VarType(KeyValues)<>VarString)and(Field[i]<>nil)and(TField(Field[i]).Text<>KeyValues[i]) then
                  begin
                    WasFound := False
                  end;
                inc(i);
              end;
            IndexName := OldIndex;
            if not WasFound then
              begin
                RS.BookMark := VarAsType(OldPos,varOleStr);
                Refresh;
              end
            else
              begin
{                Buf := ActiveBuffer;
                Move(FilterBuffer^,Buf^,FRecordBufferSize);
                Resync([]); }
                Refresh;
              end;
{            Filtering := OldFiltering;
            FreeRecordBuffer(FilterBuffer);
            FilterBuffer := OldFilterBuffer; }
          end;
      end;
    if BestIndex < 0 then
      begin // There are not index
      end;
  finally
    Field.Free;
    Indexes.Free;
    DtsFields.Free;
    While IndexDesc.Count > 0 do
      begin
        TStringList(IndexDesc[0]).Free;
        IndexDesc.Delete(0);
      end;
    IndexDesc.Free;
{    RestoreState(dsBrowse); }
  end;
//  EnableControls;
  Result := WasFound; *)
  Result := False;
end;

procedure TTbJetTable.GetIndexDescs(Descs : TList);
var
  i,j : integer;
  L : TStringList;
begin
  for i := 0 to RS.Indexes.Count-1 do
    begin
      L := TStringList.Create;
      for j := 0 to RS.Indexes[i].Fields.Count-1 do
        L.Add(RS.Indexes[i].Fields[j].Name);
      Descs.Add(L);
    end;
end;

procedure TTbJetTable.GetIndexes(List : TStrings);
var
  Ind : Variant;
  i : integer;
  TableIsClosed,
  DatabaseIsClosed : boolean;
begin
  TableIsClosed := False;
  DatabaseIsClosed := False;
  List.Clear;
  if not Active and not (CsDesigning in ComponentState) then Exit;
  if not Active then
    begin
      TableIsClosed := True;
      if not Database.Connected then
        begin
          DatabaseIsClosed := True;
          Database.Open;
        end;
      Open;
    end;
  Ind := RS.Indexes;
  for i := 0 to Ind.Count-1 do
    List.Add(Ind.Item[i].Name);
  if TableIsClosed then Close;
  if DatabaseIsClosed then Database.Close;
end;

procedure TTbJetTable.GetFields(List : TStrings);
var
  i : integer;
  TableIsClosed,
  DatabaseIsClosed : boolean;
begin
  TableIsClosed := False;
  DatabaseIsClosed := False;
  List.Clear;
  if not Active and not (CsDesigning in ComponentState) then Exit;
  if not Active then
    begin
      TableIsClosed := True;
      if not Database.Connected then
        begin
          DatabaseIsClosed := True;
          Database.Open;
        end;
      Open;
    end;
  for i := 0 to FieldCount-1 do
    List.Add(Fields[i].FieldName);
  if TableIsClosed then Close;
  if DatabaseIsClosed then Database.Close;
end;

{ TTbIndexSelectProperty }

function TTbIndexSelectProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paMultiSelect];
end;

procedure TTbIndexSelectProperty.GetValueList(List: TStrings);
var
  TbJetTable : TTbJetTable;
begin
  TbJetTable := GetComponent(0) as TTbJetTable;
  TbJetTable.GetIndexes(List);
end;

procedure TTbIndexSelectProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

function TTbJetTable._ProcessFilter(Buffer: PChar): boolean;
var
  FilterExpresion : string;
  PosComp : integer;
  FName : string;
  FieldPos : integer;
  FieldValue : Variant;
  TestValue : Variant;
  Res : boolean;
begin
  FilterBuffer := Buffer;
  FilterExpresion := FFilter;
  PosComp := Pos('<',FilterExpresion);
  if PosComp=0 then
    PosComp := Pos('>',FilterExpresion);
  if PosComp=0 then
    PosComp := Pos('=',FilterExpresion);
  if PosComp=0 then
    begin
      _ProcessFilter := True;
      Exit;
    end;
  FName := Trim(Copy(FilterExpresion,1,PosComp-1));
  FieldPos := FieldDefs.IndexOf(FName);
  if FieldPos < 0 then
    Res := False
  else
    begin
      Filtering := True;
      FieldValue := Fields[FieldPos].Value;
      if FilterExpresion[PosComp+1] in ['<','>','='] then
        begin
          case Fields[FieldPos].DataType of
            ftInteger :
                TestValue := StrToIntDef(Trim(Copy(FilterExpresion,PosComp+2,Length(FilterExpresion)-PosComp-2)),-1);
            ftFloat :
                TestValue := StrToFloat(Trim(Copy(FilterExpresion,PosComp+2,Length(FilterExpresion)-PosComp-2)));
            else
                TestValue := Trim(Copy(FilterExpresion,PosComp+3,Length(FilterExpresion)-PosComp-3));
            end;
        end
      else
        begin
          case Fields[FieldPos].DataType of
            ftInteger :
                TestValue := StrToIntDef(Trim(Copy(FilterExpresion,PosComp+1,Length(FilterExpresion)-PosComp)),-1);
            ftFloat :
                TestValue := StrToFloat(Trim(Copy(FilterExpresion,PosComp+1,Length(FilterExpresion)-PosComp)));
            else
                TestValue := Trim(Copy(FilterExpresion,PosComp+2,Length(FilterExpresion)-PosComp-2));
            end;
        end;
      if FilterExpresion[PosComp]='=' then
        Res := FieldValue=TestValue
      else if FilterExpresion[PosComp]='>' then
        begin
          if FilterExpresion[PosComp+1]='=' then
            Res := FieldValue>=TestValue
          else
            Res := FieldValue>TestValue;
        end
      else if FilterExpresion[PosComp]='<' then
        begin
          if FilterExpresion[PosComp+1]='=' then
            Res := FieldValue<=TestValue
          else if FilterExpresion[PosComp+1]='>' then
            Res := FieldValue<>TestValue
          else
            Res := FieldValue<TestValue;
        end
      else
        Res := False;
      Filtering := False;
    end;
  _ProcessFilter := Res;
end;

function TTbJetTable.FindRecord(Restart, GoForward: Boolean): Boolean;
var
  Status : Boolean;
begin
  CheckBrowseMode;
  DoBeforeScroll;
  UpdateCursorPos;
  CursorPosChanged;
  try
    begin
      if GoForward then
      begin
        if Restart then First;
        if Filtered then fActiveFilter := True;
        Status := GetNextRecord;
      end else
      begin
       if Restart then Last;
       if Filtered then fActiveFilter := True;
       Status := GetPriorRecord;
      end;
    end;
  finally
    if Filtered then fActiveFilter := False;
  end;
  Result := Status;
  if Result then DoAfterScroll;
end;

procedure TTbJetTable.SetFilter(Filter: string);
begin
  FFilter := Filter;
  if Active then
    Refresh;
end;

procedure TTbJetCustomRecordset.SetFilter(Filter: string);
begin
  FFilter := Filter;
  if Active and FActiveFilter then
    RS.Filter := Filter;
end;

procedure TTbJetCustomRecordset.SetActiveFilter(ActiveFilter: boolean);
begin
  FActiveFilter := ActiveFilter;
  if Active and not ActiveFilter then
    RS.Filter := ''
  else if Active and ActiveFilter and (FFilter<>'') then
    RS.Filter := FFilter;
end;

procedure TTbJetDatabase.CloseRecordset(RecordSet: TDataset);
begin
  if Tables.IndexOf(RecordSet) > -1 then
    Tables.Delete(Tables.IndexOf(RecordSet));
  Tables.Pack;
  if FConnected and (Tables.Count = 0) and not KeepConnected then
    Close;
end;

procedure TTbJetDatabase.Commit;
begin
  DB.CommitTrans(dbForceOSFlush);
end;

procedure TTbJetDatabase.RollBack;
begin
  DB.Rollback;
end;

procedure TTbJetDatabase.StartTransaction;
begin
  DB.BeginTrans;
end;

procedure TTbJetCustomRecordset.SetSQL(SQL: TStringList);
begin
  FSQL.Assign(SQL);
end;

procedure TTbJetDatabase.CompactDatabase;
var
  DN : string;
begin
 if Connected then Raise eJetERROR.Create('You can''t comptact a connected database.'+#13+'You must close the connection before compact.');
 DN := DatabaseName+'D';
 try
   Engine.CompactDatabase(DatabaseName,DN);
 except
   DeleteFile(PChar(DN));
 end;
 DeleteFile(PChar(DatabaseName));
 RenameFile(DN,DatabaseName);
end;

procedure TTbJetDatabase.RepairDatabase;
begin
  Engine.RepairDatabase(DatabaseName);
end;

{ TTbDatabaseTypeSelectProperty }

function TTbDatabaseTypeSelectProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paMultiSelect];
end;

procedure TTbDatabaseTypeSelectProperty.GetValueList(List: TStrings);
begin
  List.Clear;
  List.Add('Jet/Access (MDB)');
  List.Add('dBASE III');
  List.Add('dBASE IV');
  List.Add('dBASE 5.0');
  List.Add('FoxPro 2.0');
  List.Add('FoxPro 2.5');
  List.Add('FoxPro 2.6');
  List.Add('FoxPro 3.0');
  List.Add('FoxPro DBC');
  List.Add('Paradox 3.X');
  List.Add('Paradox 4.X');
  List.Add('Paradox 5.X');
  List.Add('Excel 4.0');
  List.Add('Excel 5.0');
  List.Add('Excel 7.0');
  List.Add('LOTUS WKS');
  List.Add('LOTUS WK1');
  List.Add('LOTUS WK3');
  List.Add('LOTUS WK4');
  List.Add('Text');
end;

procedure TTbDatabaseTypeSelectProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

end.
