unit Main;

interface

uses
  Forms, Classes, Dialogs, StdCtrls, DBCtrls, Grids,
  DBGrids, Buttons, ExtCtrls, SysUtils, Windows,
  Controls, ComCtrls, Db, TbDBF;

type
  TDemoForm = class(TForm)
    DS: TDataSource;
    PageControl1: TPageControl;
    Browse: TTabSheet;
    LTabla: TLabel;
    Tabla: TLabel;
    LFilter: TLabel;
    DBGrid1: TDBGrid;
    Abrir: TButton;
    Elegir: TBitBtn;
    DBNavigator1: TDBNavigator;
    Filter: TEdit;
    IsFiltered: TCheckBox;
    Pack: TButton;
    OpenDialog: TOpenDialog;
    Create: TTabSheet;
    Fields: TStringGrid;
    BtnDelField: TButton;
    BtnCreateTable: TButton;
    BtnAddField: TButton;
    BtnEditField: TButton;
    SaveDialog: TSaveDialog;
    TbDBF: TTbDBF;
    procedure AbrirClick(Sender: TObject);
    procedure ElegirClick(Sender: TObject);
    procedure FilterChange(Sender: TObject);
    procedure IsFilteredClick(Sender: TObject);
    procedure PackClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BtnAddFieldClick(Sender: TObject);
    procedure BtnDelFieldClick(Sender: TObject);
    procedure BtnEditFieldClick(Sender: TObject);
    procedure BtnCreateTableClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DemoForm: TDemoForm;

implementation

uses AddField;

{$R *.DFM}

procedure TDemoForm.AbrirClick(Sender: TObject);
begin
  DS.Enabled := False;
  TbDBF.Active := not TbDBF.Active;
  if Abrir.Caption = 'Open' then
    Abrir.Caption := 'Close'
  else
    Abrir.Caption := 'Open';
  DS.Enabled := True;
end;

procedure TDemoForm.ElegirClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    begin
      Tabla.Caption := OpenDialog.FileName;
      if TbDBF.Active then
        begin
          TbDBF.Close;
          Abrir.Caption := 'Open';
        end;
      TbDBF.TableName := OpenDialog.FileName;
    end;
end;

procedure TDemoForm.FilterChange(Sender: TObject);
begin
  TbDBF.Filter := Filter.Text;
  if TbDBF.Active then
    TbDBF.Refresh;
end;

procedure TDemoForm.IsFilteredClick(Sender: TObject);
begin
  if IsFiltered.Checked then
    TbDBF.Filtered := True
  else
    TbDBF.Filtered := False;
  if TbDBF.Active then
    TbDBF.Refresh;
end;

procedure TDemoForm.PackClick(Sender: TObject);
begin
  TbDBF.PackTable;
  MessageDlg('The table was packed.',mtInformation,[mbOk],0);
end;


procedure TDemoForm.FormShow(Sender: TObject);
begin
  Fields.Cells[0,0] := 'Field Name';
  Fields.Cells[1,0] := 'Type';
  Fields.Cells[2,0] := 'Width';
  Fields.Cells[3,0] := 'Decimals';
end;

procedure TDemoForm.BtnAddFieldClick(Sender: TObject);
begin
  NewField.FieldName.Text := '';
  NewField.FieldType.ItemIndex := 0;
  NewField.FieldWidth.Text := '0';
  NewField.FieldDecimals.Text := '0';
  NewField.FieldDecimals.Enabled := False;
  if NewField.ShowModal = mrOk then
    begin
      if (Fields.RowCount > 2) or ((Fields.RowCount=2) and (Fields.Cells[0,1]<>'')) then
        Fields.RowCount := Fields.RowCount+1;
      Fields.Cells[0,Fields.RowCount-1] := NewField.FieldName.Text;
      Fields.Cells[1,Fields.RowCount-1] := NewField.FieldType.Text;
      Fields.Cells[2,Fields.RowCount-1] := NewField.FieldWidth.Text;
      Fields.Cells[3,Fields.RowCount-1] := NewField.FieldDecimals.Text;
    end;
end;

procedure TDemoForm.BtnDelFieldClick(Sender: TObject);
var
  i : integer;
begin
  if Fields.Cells[0,Fields.Row]<>'' then
    begin
      if MessageDlg('Are you sure you don''t want to create this field?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
        begin // confirmed
          for i := Fields.Row to Fields.RowCount-2 do
            begin
              Fields.Cells[0,i] := Fields.Cells[0,i+1];
              Fields.Cells[1,i] := Fields.Cells[1,i+1];
              Fields.Cells[2,i] := Fields.Cells[2,i+1];
              Fields.Cells[3,i] := Fields.Cells[3,i+1];
            end;
          Fields.Cells[0,Fields.RowCount-1] := '';
          Fields.Cells[1,Fields.RowCount-1] := '';
          Fields.Cells[2,Fields.RowCount-1] := '';
          Fields.Cells[3,Fields.RowCount-1] := '';
          if Fields.RowCount>2 then
            Fields.RowCount := Fields.RowCount-1;
        end;
    end;
end;

procedure TDemoForm.BtnEditFieldClick(Sender: TObject);
begin
  if (Fields.Cells[0,Fields.Row]<>'') then
    begin
      NewField.FieldName.Text := Fields.Cells[0,Fields.Row];
      NewField.FieldType.ItemIndex := NewField.FieldType.Items.IndexOf(Fields.Cells[1,Fields.Row]);
      NewField.FieldWidth.Text := Fields.Cells[2,Fields.Row];
      NewField.FieldDecimals.Text := Fields.Cells[3,Fields.Row];
      NewField.FieldDecimals.Enabled := False;
      if (NewField.ShowModal = mrOk) then
        begin
          Fields.Cells[0,Fields.Row] := NewField.FieldName.Text;
          Fields.Cells[1,Fields.Row] := NewField.FieldType.Text;
          Fields.Cells[2,Fields.Row] := NewField.FieldWidth.Text;
          Fields.Cells[3,Fields.Row] := NewField.FieldDecimals.Text;
        end;
    end;
end;

procedure TDemoForm.BtnCreateTableClick(Sender: TObject);
var
  i : integer;
  FieldDfs : TList;
  Field : PDbfField;
begin
  if Fields.Cells[0,1]='' then
    begin
      MessageDlg('You must define the fields for the new table.',mtError,[mbOk],0);
      Exit;
    end;
  if not TbDBF.Active then
    begin
      i := 1;
      FieldDfs := TList.Create;
      While Fields.Cells[0,i]<>'' do
        begin
          New(Field);
          FillChar(Field^,SizeOf(TTbDbfField),#0);
          CharToOem(pchar(Fields.Cells[0,i]),pchar(@Field^.FieldName));
          Field^.FieldType := Fields.Cells[1,i][1];
          Field^.Width := StrToInt(Fields.Cells[2,i]);
          Field^.Decimals := StrToInt(Fields.Cells[3,i]);
          inc(i);
          FieldDfs.Add(Field);
        end;
      if not SaveDialog.Execute then
        Exit;
      TbDBF.CreateTable(SaveDialog.FileName,FieldDfs);
      While FieldDfs.Count > 0 do
        begin
          Field := PDbfField(FieldDfs[0]);
          Dispose(Field);
          FieldDfs.Delete(0);
          FieldDfs.Pack;
        end;
      FieldDfs.Free;
      Tabla.Caption := SaveDialog.FileName;
      TbDBF.TableName := SaveDialog.FileName;
    end;
end;

end.
