unit AddField;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TNewField = class(TForm)
    Box: TGroupBox;
    LName: TLabel;
    FieldName: TEdit;
    LType: TLabel;
    FieldType: TComboBox;
    LWidth: TLabel;
    FieldWidth: TEdit;
    LDecimals: TLabel;
    FieldDecimals: TEdit;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    procedure FormShow(Sender: TObject);
    procedure FieldTypeChange(Sender: TObject);
    procedure FieldWidthKeyPress(Sender: TObject; var Key: Char);
    procedure FieldDecimalsKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  NewField: TNewField;

implementation

{$R *.DFM}

procedure TNewField.FormShow(Sender: TObject);
begin
  FieldName.SetFocus;
end;

procedure TNewField.FieldTypeChange(Sender: TObject);
begin
  if FieldType.ItemIndex = 0 then
    begin // 0 = CHARACTER
      FieldWidth.Enabled := True;
      FieldDecimals.Enabled := False;
      FieldDecimals.Text := '0';
    end
  else if FieldType.ItemIndex = 1 then
    begin // 1 = NUMERIC
      FieldWidth.Enabled := True;
      FieldDecimals.Enabled := True;
    end
  else if FieldType.ItemIndex = 2 then
    begin // 2 = LOGIC
      FieldWidth.Enabled := False;
      FieldWidth.Text := '1';
      FieldDecimals.Enabled := False;
      FieldDecimals.Text := '0';
    end
  else
    begin // 3 = DATE
      FieldWidth.Enabled := False;
      FieldWidth.Text := '8';
      FieldDecimals.Enabled := False;
      FieldDecimals.Text := '0';
    end;
end;

procedure TNewField.FieldWidthKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key>#31)and((Key<'0') or
     (Key>'9')) then
    Key := #0;
end;

procedure TNewField.FieldDecimalsKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key>#31)and((Key<'0') or
     (Key>'9')) then
    Key := #0;
end;

end.
