unit TbMain;

interface

uses
  Windows, SysUtils, Forms,
  TbTable, Grids, Spin, Buttons, ComCtrls, Classes, Controls,
  Dialogs, StdCtrls, Graphics, TbDbase;

type
  TTb = class(TForm)
    Open: TButton;
    Close: TButton;
    FileName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Recs: TEdit;
    Data: TStringGrid;
    Label3: TLabel;
    Current: TSpinEdit;
    OpenDlg: TOpenDialog;
    Select: TButton;
    Prior: TSpeedButton;
    Next: TSpeedButton;
    First: TSpeedButton;
    Last: TSpeedButton;
    Edit: TButton;
    Cancel: TButton;
    Post: TButton;
    Append: TButton;
    Borrados: TButton;
    LEstado: TLabel;
    ESTADO: TLabel;
    Status: TStatusBar;
    Progress: TProgressBar;
    Tb: TTbDbase;
    GroupBox1: TGroupBox;
    FldName: TEdit;
    LCompName: TLabel;
    TbText: TTbText;
    TbEdit: TTbEdit;
    TbMemo: TTbMemo;
    procedure OpenClick(Sender: TObject);
    procedure CloseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CurrentChange(Sender: TObject);
    procedure SelectClick(Sender: TObject);
    procedure PriorClick(Sender: TObject);
    procedure NextClick(Sender: TObject);
    procedure FirstClick(Sender: TObject);
    procedure LastClick(Sender: TObject);
    procedure EditClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure PostClick(Sender: TObject);
    procedure DataDblClick(Sender: TObject);
    procedure AppendClick(Sender: TObject);
    procedure EstadoClick(Sender: TObject);
    procedure BorradosClick(Sender: TObject);
    procedure FldNameChange(Sender: TObject);
  private
    { Private declarations }
    Contando : boolean;
    procedure DataClear;
  public
    { Public declarations }
  end;

var
  Tb: TTb;

implementation

{$R *.DFM}

procedure TTb.DataClear;
var
  i : integer;
begin
  for i := 1 to Data.RowCount-1 do
    begin
      Data.Cells[0,i] := '';
      Data.Cells[1,i] := '';
    end;
  Data.RowCount := 2;
  Current.MaxValue := 1;
  Current.Value := 0;
  Current.Enabled := False;
end;

procedure TTb.OpenClick(Sender: TObject);
var
  i : integer;
  Tmp,Tpe : string;
begin
  if FileExists(FileName.Text) then
    begin
      tb.TableName := FileName.Text;
      if tb.Open = READ_ERR then
        begin
          DataClear;
          MessageDlg('Error: the file couldn''t be opened.',mtInformation,[mbOk],0);
          if Estado.Caption <> 'INACTIVE' then
            begin
              Estado.Caption := 'INACTIVE';
              Estado.Font.Color := clYellow;
            end;
        end
      else
        begin
          DataClear;
          Data.RowCount := Tb.no_col+1;
          Recs.Text := IntToStr(Tb.RecCount);
          for i := 1 to Tb.no_col do
            begin
              with Tb.rstru[i] do
                begin
                  tmp := copy(concat(Tb.rstru[i].name,'          '),1,10);
                  case rtype of
                    'C' :tpe := 'Character';
                    'N' :tpe := 'Numeric  ';
                    'D' :tpe := 'Date     ';
                    'L' :tpe := 'Logical  ';
                    'M' :tpe := 'Memo     ';
                  else tpe := 'Unknown  ';
                  end;
                  Data.Cells[0,i] := (tmp+' '+tpe+' '+FormatFloat('0000',width)+' '+FormatFloat('000',decp)+' '+FormatFloat('0000',Tb.rstru[i].stloc));
                end;  {with}
            end;
          Current.MaxValue := Tb.RecCount;
          Current.Value := 1;
          Current.Enabled := True;
        end;
   end
  else
    MessageDlg('Error: the file doesn''t exist.',mtInformation,[mbOk],0);
end;

procedure TTb.CloseClick(Sender: TObject);
begin
  Tb.Close;
  DataClear;
  Recs.Text := '';
  if Estado.Caption <> 'INACTIVE' then
    begin
      Estado.Caption := 'INACTIVE';
      Estado.Font.Color := clYellow;
    end;
end;

procedure TTb.FormShow(Sender: TObject);
begin
  Data.Cells[0,0] := 'Fields';
  Data.Cells[1,0] := 'Values';
end;

procedure TTb.CurrentChange(Sender: TObject);
var
  i : integer;
begin
  if Current.Text = '' then Exit;
  if Tb.Active then
    begin
      if Current.Value <> 0 then
        begin
          Tb.Position := Current.Value;
          for i := 1 to Tb.no_col do // muestro el contenido del registro actual
            begin
              Data.Cells[1,i] := Tb[i].Text;
            end;
          if Tb.Deleted then
            begin
              if Estado.Caption <> 'DELETED' then
                begin
                  Estado.Caption := 'DELETED';
                  Estado.Font.Color := clRed;
                end;
            end
          else
            begin
              if Estado.Caption <> 'ACTIVE' then
                begin
                  Estado.Caption := 'ACTIVE';
                  Estado.Font.Color := clGreen;
                end;
            end;
        end;
      Current.Value := Tb.Position;
    end
  else
    Current.Text := '0';
end;

procedure TTb.SelectClick(Sender: TObject);
begin
  if OpenDlg.Execute then
    begin
      FileName.Text := OpenDlg.FileName;
      if Tb.Active then
        begin
          CloseClick(sender);
          OpenClick(sender);
        end;
    end;
end;

procedure TTb.PriorClick(Sender: TObject);
begin
  Current.Value := Current.Value-1;
end;

procedure TTb.NextClick(Sender: TObject);
begin
  Current.Value := Current.Value+1;
end;

procedure TTb.FirstClick(Sender: TObject);
begin
  Current.Value := 1;
end;

procedure TTb.LastClick(Sender: TObject);
begin
  Current.Value := Tb.RecCount;
end;

procedure TTb.EditClick(Sender: TObject);
begin
  if Tb.Edit then
    Status.SimpleText := 'Editing'
  else
    Status.SimpleText := 'Not editing';
end;

procedure TTb.CancelClick(Sender: TObject);
var
  i : integer;
begin
  if Tb.Cancel then
    begin
      Status.SimpleText := 'Canceled';
      for i := 1 to Data.RowCount-1 do
        Data.Cells[1,i] := Tb.Field[i].Text;
    end
  else
    Status.SimpleText := 'Not canceled';
end;

procedure TTb.PostClick(Sender: TObject);
var
  i : integer;
begin
  if Tb.Post then
    begin
      Status.SimpleText := 'Updating';
      for i := 1 to Data.RowCount-1 do
        Data.Cells[1,i] := Tb.Field[i].Text;
      Current.MaxValue := Tb.RecCount;
      Recs.Text := IntToStr(Tb.RecCount);
    end
  else
    Status.SimpleText := 'Not updating';
end;

procedure TTb.DataDblClick(Sender: TObject);
var
  V : string;
begin
  if Tb.TableUpdating then
    begin
      V := InputBox('Demo','Input the new value',Data.Cells[1,Data.Row]);
      if V <> Data.Cells[1,Data.Row] then
        begin // se modifico
          Data.Cells[1,Data.Row] := V;
          Tb[Data.Row].Value := V;
        end;
    end;
end;

procedure TTb.AppendClick(Sender: TObject);
var
  i : integer;
begin
  if Tb.Append then
    begin
      Status.SimpleText := 'Appending';
      for i := 1 to Data.RowCount-1 do
        Data.Cells[1,i] := Tb.Field[i].Text;
    end
  else
    Status.SimpleText := 'Not Appending';
end;

procedure TTb.EstadoClick(Sender: TObject);
begin
  if Estado.Caption = 'DELETED' then
    begin
      if Tb.UnDelete then
        begin
          Estado.Caption := 'ACTIVE';
          Estado.Font.Color := clGreen;
        end
    end
  else if Estado.Caption = 'ACTIVE' then
    begin
      if Tb.delete then
        begin
          Estado.Caption := 'DELETED';
          Estado.Font.Color := clRed;
        end;
    end;
end;

procedure TTb.BorradosClick(Sender: TObject);
var
  B : integer;
  PosOld : integer;
begin
  if Contando then
    begin
      Contando := False;
      Application.ProcessMessages;
    end
  else
    begin
      Tb.IsUpdating := True;
      Contando := True;
      Borrados.Caption := 'Stop';
      Application.ProcessMessages;
      PosOld := Tb.Position;
      Tb.First;
      if Tb.Deleted then
        B := 1
      else
        B := 0;
      While (Tb.Position <> Tb.RecCount) and Contando do
        begin
          Progress.Position := Round((Tb.Position/Tb.RecCount)*100);
          Application.ProcessMessages;
          Tb.Next;
          if Tb.Deleted then
            inc(B);
        end;
      Progress.Position := 0;
      Application.ProcessMessages;
      if Contando then
        MessageDlg('Deleted records: '+inttostr(B),mtInformation,[mbOk],0);
      Contando := False;
      Borrados.Caption := 'Count deleted';
      Tb.Position := PosOld;
      Tb.IsUpdating := False;
    end;
end;

procedure TTb.FldNameChange(Sender: TObject);
begin
  TbText.TbField := FldName.Text;
  TbEdit.TbField := FldName.Text;
  TbMemo.TbField := FldName.Text;
  Tb.Refresh;
end;

end.
