unit Uperfmon;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, sysmon, Grids, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    SysMon1: TSysMon;
    Button2: TButton;
    ListBox2: TListBox;
    ListBox3: TListBox;
    StringGrid1: TStringGrid;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    procedure ShowMonitors;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ShowMonitors;
var
 i:integer;
begin
 for i:=1 to stringgrid1.rowcount-1 do
  begin
   stringgrid1.Cells[0,i]:='';
   stringgrid1.Cells[1,i]:='';
  end;
 stringgrid1.cells[0,0]:='Performance data';
 stringgrid1.cells[1,0]:='Value';

 if sysmon1.monitors.count>0 then
  stringgrid1.rowcount:=sysmon1.Monitors.Count+1
 else stringgrid1.rowcount:=2;

 for i:=1 to sysmon1.Monitors.Count do
  begin
   stringgrid1.cells[0,i]:=sysmon1.monitors.Items[i-1].Name;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 if (listbox2.itemindex>=0) and (listbox3.itemindex>=0) then
  begin
   with sysmon1.Monitors.Add do
    begin
      SysObject:=listbox2.items[listbox2.itemindex];
      Counter:=listbox3.items[listbox3.itemindex];
    end;
    ShowMonitors;

  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 if stringgrid1.row<=sysmon1.monitors.Count then
  sysmon1.monitors.Items[stringgrid1.row-1].Free;
 ShowMonitors;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 listbox2.Items.Assign(sysmon1.SysObjects);
 showmonitors;
end;

procedure TForm1.ListBox2Click(Sender: TObject);
begin
 if listbox2.itemindex>=0 then
  begin
   listbox3.items.Assign(sysmon1.Counters(listbox2.items[listbox2.itemindex]));
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
 i:integer;
begin
 for i:=1 to sysmon1.monitors.count do
  begin
   stringgrid1.cells[1,i]:=inttostr(sysmon1.monitors.items[i-1].value);
  end;

end;

end.
