unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  LogBase, LogFile, ExtCtrls, StdCtrls;

type
  TfrmMain = class(TForm)
    lbLog: TListBox;
    pnlToolbar: TPanel;
    SMFileLog: TSMFileLog;
    gbOptions: TGroupBox;
    cbFile: TCheckBox;
    cbFolder: TCheckBox;
    cbAttributes: TCheckBox;
    cbSizes: TCheckBox;
    cbTimes: TCheckBox;
    cbSubFolder: TCheckBox;
    lblFolderName: TLabel;
    edFolderName: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbFileClick(Sender: TObject);
    procedure cbFolderClick(Sender: TObject);
    procedure cbAttributesClick(Sender: TObject);
    procedure cbSizesClick(Sender: TObject);
    procedure cbTimesClick(Sender: TObject);
    procedure cbSubFolderClick(Sender: TObject);
    procedure SMFileLogFileNotification(Sender: TObject;
      Action: TFileNotificationOption);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  SMFileLog.Active := True
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  SMFileLog.Active := False
end;


procedure TfrmMain.cbFileClick(Sender: TObject);
begin
  if cbFile.Checked then
    SMFileLog.Options := SMFileLog.Options + [foFile]
  else
    SMFileLog.Options := SMFileLog.Options - [foFile]
end;

procedure TfrmMain.cbFolderClick(Sender: TObject);
begin
  if cbFolder.Checked then
    SMFileLog.Options := SMFileLog.Options + [foFolder]
  else
    SMFileLog.Options := SMFileLog.Options - [foFolder]
end;

procedure TfrmMain.cbAttributesClick(Sender: TObject);
begin
  if cbAttributes.Checked then
    SMFileLog.Options := SMFileLog.Options + [foAttributes]
  else
    SMFileLog.Options := SMFileLog.Options - [foAttributes]
end;

procedure TfrmMain.cbSizesClick(Sender: TObject);
begin
  if cbSizes.Checked then
    SMFileLog.Options := SMFileLog.Options + [foSize]
  else
    SMFileLog.Options := SMFileLog.Options - [foSize]
end;

procedure TfrmMain.cbTimesClick(Sender: TObject);
begin
  if cbTimes.Checked then
    SMFileLog.Options := SMFileLog.Options + [foTime]
  else
    SMFileLog.Options := SMFileLog.Options - [foTime]
end;

procedure TfrmMain.cbSubFolderClick(Sender: TObject);
begin
  if cbSubFolder.Checked then
    SMFileLog.Options := SMFileLog.Options + [foWatchSubFolders]
  else
    SMFileLog.Options := SMFileLog.Options - [foWatchSubFolders]
end;

procedure TfrmMain.SMFileLogFileNotification(Sender: TObject;
  Action: TFileNotificationOption);
const
  arrFileNotification: array[TFileNotificationOption] of string =
    ('File', 'Folder', 'Attributes', 'Size', 'Time', 'WatchSubFolders');
begin
  lbLog.Items.Add('Action: ' + arrFileNotification[Action] + ' changed');
end;

end.
